/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-11-03 14:45:12 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp2n_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp2n_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp2n_cookieadmin_cookies` (
  `id` int NOT NULL AUTO_INCREMENT,
  `cookie_name` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `category` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `description` varchar(500) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `domain` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT '/',
  `expires` datetime DEFAULT NULL,
  `max_age` int DEFAULT NULL,
  `samesite` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `secure` tinyint(1) NOT NULL DEFAULT '0',
  `httponly` tinyint(1) NOT NULL DEFAULT '0',
  `raw_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `edited` tinyint(1) DEFAULT '0',
  `patterns` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '[]',
  `scan_timestamp` int DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp2n_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp2n_e_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp2n_e_submissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `hash_id` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `main_meta_id` bigint unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint unsigned NOT NULL,
  `referer` varchar(500) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `referer_title` varchar(300) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `element_id` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `form_name` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `campaign_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip` varchar(46) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actions_count` int DEFAULT '0',
  `actions_succeeded_count` int DEFAULT '0',
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `meta` text COLLATE utf8mb4_unicode_520_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp2n_e_submissions_actions_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint unsigned NOT NULL,
  `action_name` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action_label` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log` text COLLATE utf8mb4_unicode_520_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp2n_e_submissions_values` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint unsigned NOT NULL DEFAULT '0',
  `key` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp2n_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp2n_loginizer_logs` (
  `username` varchar(255) NOT NULL DEFAULT '',
  `time` int NOT NULL DEFAULT '0',
  `count` int NOT NULL DEFAULT '0',
  `lockout` int NOT NULL DEFAULT '0',
  `ip` varchar(255) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  UNIQUE KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp2n_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=523 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp2n_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=108 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp2n_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp2n_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp2n_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp2n_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp2n_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp2n_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp2n_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp2n_wfauditevents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `event_time` double(14,4) NOT NULL,
  `request_id` bigint unsigned NOT NULL,
  `state` enum('new','sending','sent') NOT NULL DEFAULT 'new',
  `state_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp2n_wfblockediplog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int unsigned NOT NULL DEFAULT '0',
  `unixday` int unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp2n_wfblocks7` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` int unsigned NOT NULL DEFAULT '0',
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int unsigned DEFAULT '0',
  `blockedHits` int unsigned DEFAULT '0',
  `expiration` bigint unsigned NOT NULL DEFAULT '0',
  `parameters` text,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp2n_wfconfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp2n_wfcrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp2n_wffilechanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp2n_wffilemods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `real_path` text NOT NULL,
  `knownFile` tinyint unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int unsigned NOT NULL DEFAULT '0',
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp2n_wfhits` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint DEFAULT '0',
  `statusCode` int NOT NULL DEFAULT '200',
  `isGoogle` tinyint NOT NULL,
  `userID` int unsigned NOT NULL,
  `newVisit` tinyint unsigned NOT NULL,
  `URL` text,
  `referer` text,
  `UA` text,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text,
  `actionData` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp2n_wfhoover` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `owner` text,
  `host` text,
  `path` text,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp2n_wfissues` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `time` int unsigned NOT NULL,
  `lastUpdated` int unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp2n_wfknownfilelist` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  `wordpress_path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp2n_wflivetraffichuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp2n_wflocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int unsigned NOT NULL,
  `failed` tinyint unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT '0.0000000',
  `lon` float(10,7) DEFAULT '0.0000000',
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp2n_wflogins` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp2n_wfls_2fa_secrets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `secret` tinyblob NOT NULL,
  `recovery` blob NOT NULL,
  `ctime` int unsigned NOT NULL,
  `vtime` int unsigned NOT NULL,
  `mode` enum('authenticator') NOT NULL DEFAULT 'authenticator',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp2n_wfls_role_counts` (
  `serialized_roles` varbinary(255) NOT NULL,
  `two_factor_inactive` tinyint(1) NOT NULL,
  `user_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`serialized_roles`,`two_factor_inactive`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp2n_wfls_settings` (
  `name` varchar(191) NOT NULL DEFAULT '',
  `value` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp2n_wfnotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint unsigned NOT NULL DEFAULT '1',
  `category` varchar(255) NOT NULL,
  `priority` int NOT NULL DEFAULT '1000',
  `ctime` int unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp2n_wfpendingissues` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `time` int unsigned NOT NULL,
  `lastUpdated` int unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp2n_wfreversecache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp2n_wfsecurityevents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `event_time` double(14,4) NOT NULL,
  `state` enum('new','sending','sent') NOT NULL DEFAULT 'new',
  `state_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp2n_wfsnipcache` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int unsigned NOT NULL DEFAULT '0',
  `type` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp2n_wfstatus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp2n_wftrafficrates` (
  `eMin` int unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp2n_wfwaffailures` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `throwable` text NOT NULL,
  `rule_id` int unsigned DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp2n_comments */
INSERT INTO `wp2n_comments` VALUES("1", "1", "A WordPress Commenter", "wapuu@wordpress.example", "https://wordpress.org/", "", "2025-11-03 09:51:31", "2025-11-03 09:51:31", "Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com/\">Gravatar</a>.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: wp2n_duplicator_packages */
INSERT INTO `wp2n_duplicator_packages` VALUES("1", "20251103", "60a4692a62e051ae8068_20251103143732", "20", "2025-11-03 14:45:12", "admin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-11-03 14:37:32\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"8.0.36\";s:10:\"VersionPHP\";s:6:\"8.3.25\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:8:\"20251103\";s:4:\"Hash\";s:35:\"60a4692a62e051ae8068_20251103143732\";s:8:\"NameHash\";s:44:\"20251103_60a4692a62e051ae8068_20251103143732\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:54:\"20251103_60a4692a62e051ae8068_20251103143732_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.9\";s:6:\"WPUser\";s:5:\"admin\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:56:\"20251103_60a4692a62e051ae8068_20251103143732_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:26:\"/home/nfubmbpl/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:3589;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:17488;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-11-03 14:37:32\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"8.0.36\";s:10:\"VersionPHP\";s:6:\"8.3.25\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:8:\"20251103\";s:4:\"Hash\";s:35:\"60a4692a62e051ae8068_20251103143732\";s:8:\"NameHash\";s:44:\"20251103_60a4692a62e051ae8068_20251103143732\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:62:\"20251103_60a4692a62e051ae8068_20251103143732_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:40:\"/home/nfubmbpl/public_html/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:57:\"20251103_60a4692a62e051ae8068_20251103143732_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:116:\"/home/nfubmbpl/public_html/wp-content/backups-dup-lite/tmp/20251103_60a4692a62e051ae8068_20251103143732_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:35:\"/home/nfubmbpl/public_html/wp-admin\";i:1;s:38:\"/home/nfubmbpl/public_html/wp-includes\";i:2;s:47:\"/home/nfubmbpl/public_html/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:26:\"/home/nfubmbpl/public_html\";i:1;s:26:\"/home/nfubmbpl/public_html\";i:2;s:37:\"/home/nfubmbpl/public_html/wp-content\";i:3;s:45:\"/home/nfubmbpl/public_html/wp-content/uploads\";i:4;s:45:\"/home/nfubmbpl/public_html/wp-content/plugins\";i:5;s:48:\"/home/nfubmbpl/public_html/wp-content/mu-plugins\";i:6;s:44:\"/home/nfubmbpl/public_html/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:58:\"/home/nfubmbpl/public_html/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp2n_loginizer_logs */
INSERT INTO `wp2n_loginizer_logs` VALUES("admin", "1762164243", "1", "0", "102.129.152.113", "https://dotmanfreightt.com/wp-login.php");
INSERT INTO `wp2n_loginizer_logs` VALUES("admin", "1762164553", "3", "1", "103.186.30.21", "https://dotmanfreightt.com//wp-login.php");
INSERT INTO `wp2n_loginizer_logs` VALUES("admin", "1762163553", "1", "0", "109.70.100.3", "https://dotmanfreightt.com/wp-login.php");
INSERT INTO `wp2n_loginizer_logs` VALUES("admin", "1762164334", "1", "0", "154.47.29.202", "https://dotmanfreightt.com/wp-login.php");
INSERT INTO `wp2n_loginizer_logs` VALUES("admin", "1762164866", "1", "0", "172.111.183.170", "https://dotmanfreightt.com/wp-login.php");
INSERT INTO `wp2n_loginizer_logs` VALUES("admin", "1762163937", "1", "0", "178.20.55.182", "https://dotmanfreightt.com/wp-login.php");
INSERT INTO `wp2n_loginizer_logs` VALUES("admin", "1762164554", "1", "0", "185.220.101.19", "https://dotmanfreightt.com/wp-login.php");
INSERT INTO `wp2n_loginizer_logs` VALUES("admin", "1762164432", "1", "0", "212.56.54.199", "https://dotmanfreightt.com/wp-login.php");
INSERT INTO `wp2n_loginizer_logs` VALUES("admin", "1762163747", "1", "0", "45.84.107.47", "https://dotmanfreightt.com/wp-login.php");
INSERT INTO `wp2n_loginizer_logs` VALUES("admin", "1762164745", "1", "0", "51.210.104.160", "https://dotmanfreightt.com/wp-login.php");
INSERT INTO `wp2n_loginizer_logs` VALUES("admin", "1762163840", "1", "0", "51.210.104.67", "https://dotmanfreightt.com/wp-login.php");
INSERT INTO `wp2n_loginizer_logs` VALUES("admin", "1762164059", "1", "0", "51.210.105.194", "https://dotmanfreightt.com/wp-login.php");
INSERT INTO `wp2n_loginizer_logs` VALUES("admin", "1762164639", "1", "0", "62.12.118.196", "https://dotmanfreightt.com/wp-login.php");
INSERT INTO `wp2n_loginizer_logs` VALUES("admin", "1762163653", "1", "0", "77.81.142.147", "https://dotmanfreightt.com/wp-login.php");

/* INSERT TABLE DATA: wp2n_options */
INSERT INTO `wp2n_options` VALUES("1", "cron", "a:21:{i:1762181538;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1762182735;a:1:{s:21:\"wordfence_ls_ntp_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1762182871;a:1:{s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1762182897;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1762206691;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1762206738;a:2:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1762206858;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1762208114;a:1:{s:41:\"googlesitekit_cron_update_remote_features\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1762249891;a:2:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1762250056;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1762250058;a:1:{s:18:\"backuply_clean_tmp\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:14:\"backuply_daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1762251077;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1762251271;a:1:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1762251298;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1762251313;a:1:{s:21:\"ai1wm_storage_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1762251668;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1762707533;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1762768893;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1762783200;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1762790400;a:1:{s:31:\"wordfence_email_activity_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp2n_options` VALUES("2", "siteurl", "https://dotmanfreightt.com", "on");
INSERT INTO `wp2n_options` VALUES("3", "home", "https://dotmanfreightt.com", "on");
INSERT INTO `wp2n_options` VALUES("4", "blogname", "", "on");
INSERT INTO `wp2n_options` VALUES("5", "blogdescription", "", "on");
INSERT INTO `wp2n_options` VALUES("6", "users_can_register", "0", "on");
INSERT INTO `wp2n_options` VALUES("7", "admin_email", "3brandsdigital@gmail.com", "on");
INSERT INTO `wp2n_options` VALUES("8", "start_of_week", "1", "on");
INSERT INTO `wp2n_options` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `wp2n_options` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `wp2n_options` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `wp2n_options` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `wp2n_options` VALUES("13", "posts_per_rss", "10", "on");
INSERT INTO `wp2n_options` VALUES("14", "rss_use_excerpt", "0", "on");
INSERT INTO `wp2n_options` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `wp2n_options` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `wp2n_options` VALUES("17", "mailserver_pass", "", "on");
INSERT INTO `wp2n_options` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `wp2n_options` VALUES("19", "default_category", "1", "on");
INSERT INTO `wp2n_options` VALUES("20", "default_comment_status", "open", "on");
INSERT INTO `wp2n_options` VALUES("21", "default_ping_status", "open", "on");
INSERT INTO `wp2n_options` VALUES("22", "default_pingback_flag", "1", "on");
INSERT INTO `wp2n_options` VALUES("23", "posts_per_page", "10", "on");
INSERT INTO `wp2n_options` VALUES("24", "date_format", "F j, Y", "on");
INSERT INTO `wp2n_options` VALUES("25", "time_format", "g:i a", "on");
INSERT INTO `wp2n_options` VALUES("26", "links_updated_date_format", "F j, Y g:i a", "on");
INSERT INTO `wp2n_options` VALUES("27", "comment_moderation", "0", "on");
INSERT INTO `wp2n_options` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `wp2n_options` VALUES("29", "permalink_structure", "/%postname%/", "on");
INSERT INTO `wp2n_options` VALUES("30", "rewrite_rules", "a:149:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:15:\"^sitemaps\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:15:\"^sitemaps\\.xml$\";s:30:\"index.php?sitemap_type=general\";s:12:\"^author.xml$\";s:29:\"index.php?sitemap_type=author\";s:28:\"^media-sitemap([0-9]+)?.xml$\";s:46:\"index.php?sitemap_type=media&paged=$matches[1]\";s:19:\"^news([0-9]+)?.xml$\";s:45:\"index.php?sitemap_type=news&paged=$matches[1]\";s:28:\"^video-sitemap([0-9]+)?.xml$\";s:46:\"index.php?sitemap_type=video&paged=$matches[1]\";s:28:\"^post-sitemap([0-9]+)?\\.xml$\";s:45:\"index.php?sitemap_type=post&paged=$matches[1]\";s:28:\"^page-sitemap([0-9]+)?\\.xml$\";s:45:\"index.php?sitemap_type=page&paged=$matches[1]\";s:32:\"^category-sitemap([0-9]+)?\\.xml$\";s:49:\"index.php?sitemap_type=category&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:46:\"e-floating-buttons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"e-floating-buttons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"e-floating-buttons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"e-floating-buttons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"e-floating-buttons/([^/]+)/embed/?$\";s:51:\"index.php?e-floating-buttons=$matches[1]&embed=true\";s:39:\"e-floating-buttons/([^/]+)/trackback/?$\";s:45:\"index.php?e-floating-buttons=$matches[1]&tb=1\";s:47:\"e-floating-buttons/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&paged=$matches[2]\";s:54:\"e-floating-buttons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&cpage=$matches[2]\";s:43:\"e-floating-buttons/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?e-floating-buttons=$matches[1]&page=$matches[2]\";s:35:\"e-floating-buttons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"e-floating-buttons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"e-floating-buttons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"e-floating-buttons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:45:\"elementskit-content/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"elementskit-content/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"elementskit-content/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"elementskit-content/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"elementskit-content/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"elementskit-content/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"elementskit-content/(.+?)/embed/?$\";s:52:\"index.php?elementskit_content=$matches[1]&embed=true\";s:38:\"elementskit-content/(.+?)/trackback/?$\";s:46:\"index.php?elementskit_content=$matches[1]&tb=1\";s:46:\"elementskit-content/(.+?)/page/?([0-9]{1,})/?$\";s:59:\"index.php?elementskit_content=$matches[1]&paged=$matches[2]\";s:53:\"elementskit-content/(.+?)/comment-page-([0-9]{1,})/?$\";s:59:\"index.php?elementskit_content=$matches[1]&cpage=$matches[2]\";s:42:\"elementskit-content/(.+?)(?:/([0-9]+))?/?$\";s:58:\"index.php?elementskit_content=$matches[1]&page=$matches[2]\";s:40:\"elementor-hf/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"elementor-hf/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"elementor-hf/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"elementor-hf/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"elementor-hf/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"elementor-hf/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"elementor-hf/([^/]+)/embed/?$\";s:45:\"index.php?elementor-hf=$matches[1]&embed=true\";s:33:\"elementor-hf/([^/]+)/trackback/?$\";s:39:\"index.php?elementor-hf=$matches[1]&tb=1\";s:41:\"elementor-hf/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?elementor-hf=$matches[1]&paged=$matches[2]\";s:48:\"elementor-hf/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?elementor-hf=$matches[1]&cpage=$matches[2]\";s:37:\"elementor-hf/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?elementor-hf=$matches[1]&page=$matches[2]\";s:29:\"elementor-hf/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"elementor-hf/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"elementor-hf/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"elementor-hf/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"elementor-hf/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"elementor-hf/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=13&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "on");
INSERT INTO `wp2n_options` VALUES("31", "hack_file", "0", "on");
INSERT INTO `wp2n_options` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `wp2n_options` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `wp2n_options` VALUES("34", "active_plugins", "a:21:{i:0;s:19:\"akismet/akismet.php\";i:2;s:27:\"astra-sites/astra-sites.php\";i:3;s:21:\"backuply/backuply.php\";i:4;s:33:\"classic-editor/classic-editor.php\";i:5;s:36:\"contact-form-7/wp-contact-form-7.php\";i:6;s:27:\"cookieadmin/cookieadmin.php\";i:7;s:25:\"duplicator/duplicator.php\";i:8;s:31:\"elementor-pro/elementor-pro.php\";i:9;s:23:\"elementor/elementor.php\";i:10;s:37:\"elementskit-lite/elementskit-lite.php\";i:11;s:65:\"essential-addons-for-elementor-lite/essential_adons_elementor.php\";i:12;s:35:\"google-site-kit/google-site-kit.php\";i:13;s:17:\"gosmtp/gosmtp.php\";i:14;s:51:\"header-footer-elementor/header-footer-elementor.php\";i:15;s:19:\"jetpack/jetpack.php\";i:16;s:23:\"loginizer/loginizer.php\";i:17;s:23:\"pagelayer/pagelayer.php\";i:18;s:37:\"royal-elementor-addons/wpr-addons.php\";i:19;s:19:\"siteseo/siteseo.php\";i:20;s:27:\"speedycache/speedycache.php\";i:21;s:23:\"wordfence/wordfence.php\";}", "on");
INSERT INTO `wp2n_options` VALUES("35", "category_base", "", "on");
INSERT INTO `wp2n_options` VALUES("36", "ping_sites", "https://rpc.pingomatic.com/", "on");
INSERT INTO `wp2n_options` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `wp2n_options` VALUES("38", "gmt_offset", "0", "on");
INSERT INTO `wp2n_options` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `wp2n_options` VALUES("40", "recently_edited", "", "off");
INSERT INTO `wp2n_options` VALUES("41", "template", "astra", "on");
INSERT INTO `wp2n_options` VALUES("42", "stylesheet", "astra", "on");
INSERT INTO `wp2n_options` VALUES("43", "comment_registration", "0", "on");
INSERT INTO `wp2n_options` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `wp2n_options` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `wp2n_options` VALUES("46", "default_role", "subscriber", "on");
INSERT INTO `wp2n_options` VALUES("47", "db_version", "60421", "on");
INSERT INTO `wp2n_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `wp2n_options` VALUES("49", "upload_path", "", "on");
INSERT INTO `wp2n_options` VALUES("50", "blog_public", "1", "on");
INSERT INTO `wp2n_options` VALUES("51", "default_link_category", "2", "on");
INSERT INTO `wp2n_options` VALUES("52", "show_on_front", "page", "on");
INSERT INTO `wp2n_options` VALUES("53", "tag_base", "", "on");
INSERT INTO `wp2n_options` VALUES("54", "show_avatars", "1", "on");
INSERT INTO `wp2n_options` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `wp2n_options` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `wp2n_options` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `wp2n_options` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `wp2n_options` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `wp2n_options` VALUES("60", "medium_size_w", "300", "on");
INSERT INTO `wp2n_options` VALUES("61", "medium_size_h", "300", "on");
INSERT INTO `wp2n_options` VALUES("62", "avatar_default", "mystery", "on");
INSERT INTO `wp2n_options` VALUES("63", "large_size_w", "1024", "on");
INSERT INTO `wp2n_options` VALUES("64", "large_size_h", "1024", "on");
INSERT INTO `wp2n_options` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `wp2n_options` VALUES("66", "image_default_size", "", "on");
INSERT INTO `wp2n_options` VALUES("67", "image_default_align", "", "on");
INSERT INTO `wp2n_options` VALUES("68", "close_comments_for_old_posts", "0", "on");
INSERT INTO `wp2n_options` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `wp2n_options` VALUES("70", "thread_comments", "1", "on");
INSERT INTO `wp2n_options` VALUES("71", "thread_comments_depth", "5", "on");
INSERT INTO `wp2n_options` VALUES("72", "page_comments", "0", "on");
INSERT INTO `wp2n_options` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `wp2n_options` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `wp2n_options` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `wp2n_options` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `wp2n_options` VALUES("77", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp2n_options` VALUES("78", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp2n_options` VALUES("79", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp2n_options` VALUES("80", "uninstall_plugins", "a:5:{s:23:\"loginizer/loginizer.php\";s:22:\"loginizer_deactivation\";s:19:\"siteseo/siteseo.php\";s:27:\"\\SiteSEO\\Install::uninstall\";s:21:\"backuply/backuply.php\";s:21:\"backuply_deactivation\";s:27:\"speedycache/speedycache.php\";s:31:\"\\SpeedyCache\\Install::uninstall\";s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}}", "off");
INSERT INTO `wp2n_options` VALUES("81", "timezone_string", "", "on");
INSERT INTO `wp2n_options` VALUES("82", "page_for_posts", "31", "on");
INSERT INTO `wp2n_options` VALUES("83", "page_on_front", "13", "on");
INSERT INTO `wp2n_options` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `wp2n_options` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `wp2n_options` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `wp2n_options` VALUES("87", "site_icon", "0", "on");
INSERT INTO `wp2n_options` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `wp2n_options` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `wp2n_options` VALUES("90", "wp_page_for_privacy_policy", "3", "on");
INSERT INTO `wp2n_options` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `wp2n_options` VALUES("92", "admin_email_lifespan", "1777715491", "on");
INSERT INTO `wp2n_options` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `wp2n_options` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `wp2n_options` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `wp2n_options` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `wp2n_options` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `wp2n_options` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `wp2n_options` VALUES("99", "wp_force_deactivated_plugins", "a:0:{}", "on");
INSERT INTO `wp2n_options` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `wp2n_options` VALUES("101", "initial_db_version", "60421", "on");
INSERT INTO `wp2n_options` VALUES("102", "wp2n_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:67:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:14:\"siteseo_manage\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:23:\"manage_zip_ai_assistant\";b:1;s:26:\"manage_ast_block_templates\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:23:\"manage_zip_ai_assistant\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "on");
INSERT INTO `wp2n_options` VALUES("103", "fresh_site", "0", "off");
INSERT INTO `wp2n_options` VALUES("104", "user_count", "1", "off");
INSERT INTO `wp2n_options` VALUES("105", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp2n_options` VALUES("106", "sidebars_widgets", "a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:15:\"footer-widget-1\";a:0:{}s:15:\"footer-widget-2\";a:0:{}s:24:\"advanced-footer-widget-1\";a:0:{}s:24:\"advanced-footer-widget-2\";a:0:{}s:24:\"advanced-footer-widget-3\";a:0:{}s:24:\"advanced-footer-widget-4\";a:0:{}s:13:\"array_version\";i:3;}", "auto");
INSERT INTO `wp2n_options` VALUES("107", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp2n_options` VALUES("108", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp2n_options` VALUES("109", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp2n_options` VALUES("110", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp2n_options` VALUES("111", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp2n_options` VALUES("112", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp2n_options` VALUES("113", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp2n_options` VALUES("114", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp2n_options` VALUES("115", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp2n_options` VALUES("116", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp2n_options` VALUES("117", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp2n_options` VALUES("118", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp2n_options` VALUES("119", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp2n_options` VALUES("120", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp2n_options` VALUES("121", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp2n_options` VALUES("122", "theme_mods_twentytwentyfive", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1762166252;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wp2n_options` VALUES("123", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:5:\"6.8.3\";s:5:\"files\";a:536:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:21:\"button/editor-rtl.css\";i:29;s:25:\"button/editor-rtl.min.css\";i:30;s:17:\"button/editor.css\";i:31;s:21:\"button/editor.min.css\";i:32;s:20:\"button/style-rtl.css\";i:33;s:24:\"button/style-rtl.min.css\";i:34;s:16:\"button/style.css\";i:35;s:20:\"button/style.min.css\";i:36;s:22:\"buttons/editor-rtl.css\";i:37;s:26:\"buttons/editor-rtl.min.css\";i:38;s:18:\"buttons/editor.css\";i:39;s:22:\"buttons/editor.min.css\";i:40;s:21:\"buttons/style-rtl.css\";i:41;s:25:\"buttons/style-rtl.min.css\";i:42;s:17:\"buttons/style.css\";i:43;s:21:\"buttons/style.min.css\";i:44;s:22:\"calendar/style-rtl.css\";i:45;s:26:\"calendar/style-rtl.min.css\";i:46;s:18:\"calendar/style.css\";i:47;s:22:\"calendar/style.min.css\";i:48;s:25:\"categories/editor-rtl.css\";i:49;s:29:\"categories/editor-rtl.min.css\";i:50;s:21:\"categories/editor.css\";i:51;s:25:\"categories/editor.min.css\";i:52;s:24:\"categories/style-rtl.css\";i:53;s:28:\"categories/style-rtl.min.css\";i:54;s:20:\"categories/style.css\";i:55;s:24:\"categories/style.min.css\";i:56;s:19:\"code/editor-rtl.css\";i:57;s:23:\"code/editor-rtl.min.css\";i:58;s:15:\"code/editor.css\";i:59;s:19:\"code/editor.min.css\";i:60;s:18:\"code/style-rtl.css\";i:61;s:22:\"code/style-rtl.min.css\";i:62;s:14:\"code/style.css\";i:63;s:18:\"code/style.min.css\";i:64;s:18:\"code/theme-rtl.css\";i:65;s:22:\"code/theme-rtl.min.css\";i:66;s:14:\"code/theme.css\";i:67;s:18:\"code/theme.min.css\";i:68;s:22:\"columns/editor-rtl.css\";i:69;s:26:\"columns/editor-rtl.min.css\";i:70;s:18:\"columns/editor.css\";i:71;s:22:\"columns/editor.min.css\";i:72;s:21:\"columns/style-rtl.css\";i:73;s:25:\"columns/style-rtl.min.css\";i:74;s:17:\"columns/style.css\";i:75;s:21:\"columns/style.min.css\";i:76;s:33:\"comment-author-name/style-rtl.css\";i:77;s:37:\"comment-author-name/style-rtl.min.css\";i:78;s:29:\"comment-author-name/style.css\";i:79;s:33:\"comment-author-name/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:26:\"comment-date/style-rtl.css\";i:85;s:30:\"comment-date/style-rtl.min.css\";i:86;s:22:\"comment-date/style.css\";i:87;s:26:\"comment-date/style.min.css\";i:88;s:31:\"comment-edit-link/style-rtl.css\";i:89;s:35:\"comment-edit-link/style-rtl.min.css\";i:90;s:27:\"comment-edit-link/style.css\";i:91;s:31:\"comment-edit-link/style.min.css\";i:92;s:32:\"comment-reply-link/style-rtl.css\";i:93;s:36:\"comment-reply-link/style-rtl.min.css\";i:94;s:28:\"comment-reply-link/style.css\";i:95;s:32:\"comment-reply-link/style.min.css\";i:96;s:30:\"comment-template/style-rtl.css\";i:97;s:34:\"comment-template/style-rtl.min.css\";i:98;s:26:\"comment-template/style.css\";i:99;s:30:\"comment-template/style.min.css\";i:100;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:101;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:102;s:38:\"comments-pagination-numbers/editor.css\";i:103;s:42:\"comments-pagination-numbers/editor.min.css\";i:104;s:34:\"comments-pagination/editor-rtl.css\";i:105;s:38:\"comments-pagination/editor-rtl.min.css\";i:106;s:30:\"comments-pagination/editor.css\";i:107;s:34:\"comments-pagination/editor.min.css\";i:108;s:33:\"comments-pagination/style-rtl.css\";i:109;s:37:\"comments-pagination/style-rtl.min.css\";i:110;s:29:\"comments-pagination/style.css\";i:111;s:33:\"comments-pagination/style.min.css\";i:112;s:29:\"comments-title/editor-rtl.css\";i:113;s:33:\"comments-title/editor-rtl.min.css\";i:114;s:25:\"comments-title/editor.css\";i:115;s:29:\"comments-title/editor.min.css\";i:116;s:23:\"comments/editor-rtl.css\";i:117;s:27:\"comments/editor-rtl.min.css\";i:118;s:19:\"comments/editor.css\";i:119;s:23:\"comments/editor.min.css\";i:120;s:22:\"comments/style-rtl.css\";i:121;s:26:\"comments/style-rtl.min.css\";i:122;s:18:\"comments/style.css\";i:123;s:22:\"comments/style.min.css\";i:124;s:20:\"cover/editor-rtl.css\";i:125;s:24:\"cover/editor-rtl.min.css\";i:126;s:16:\"cover/editor.css\";i:127;s:20:\"cover/editor.min.css\";i:128;s:19:\"cover/style-rtl.css\";i:129;s:23:\"cover/style-rtl.min.css\";i:130;s:15:\"cover/style.css\";i:131;s:19:\"cover/style.min.css\";i:132;s:22:\"details/editor-rtl.css\";i:133;s:26:\"details/editor-rtl.min.css\";i:134;s:18:\"details/editor.css\";i:135;s:22:\"details/editor.min.css\";i:136;s:21:\"details/style-rtl.css\";i:137;s:25:\"details/style-rtl.min.css\";i:138;s:17:\"details/style.css\";i:139;s:21:\"details/style.min.css\";i:140;s:20:\"embed/editor-rtl.css\";i:141;s:24:\"embed/editor-rtl.min.css\";i:142;s:16:\"embed/editor.css\";i:143;s:20:\"embed/editor.min.css\";i:144;s:19:\"embed/style-rtl.css\";i:145;s:23:\"embed/style-rtl.min.css\";i:146;s:15:\"embed/style.css\";i:147;s:19:\"embed/style.min.css\";i:148;s:19:\"embed/theme-rtl.css\";i:149;s:23:\"embed/theme-rtl.min.css\";i:150;s:15:\"embed/theme.css\";i:151;s:19:\"embed/theme.min.css\";i:152;s:19:\"file/editor-rtl.css\";i:153;s:23:\"file/editor-rtl.min.css\";i:154;s:15:\"file/editor.css\";i:155;s:19:\"file/editor.min.css\";i:156;s:18:\"file/style-rtl.css\";i:157;s:22:\"file/style-rtl.min.css\";i:158;s:14:\"file/style.css\";i:159;s:18:\"file/style.min.css\";i:160;s:23:\"footnotes/style-rtl.css\";i:161;s:27:\"footnotes/style-rtl.min.css\";i:162;s:19:\"footnotes/style.css\";i:163;s:23:\"footnotes/style.min.css\";i:164;s:23:\"freeform/editor-rtl.css\";i:165;s:27:\"freeform/editor-rtl.min.css\";i:166;s:19:\"freeform/editor.css\";i:167;s:23:\"freeform/editor.min.css\";i:168;s:22:\"gallery/editor-rtl.css\";i:169;s:26:\"gallery/editor-rtl.min.css\";i:170;s:18:\"gallery/editor.css\";i:171;s:22:\"gallery/editor.min.css\";i:172;s:21:\"gallery/style-rtl.css\";i:173;s:25:\"gallery/style-rtl.min.css\";i:174;s:17:\"gallery/style.css\";i:175;s:21:\"gallery/style.min.css\";i:176;s:21:\"gallery/theme-rtl.css\";i:177;s:25:\"gallery/theme-rtl.min.css\";i:178;s:17:\"gallery/theme.css\";i:179;s:21:\"gallery/theme.min.css\";i:180;s:20:\"group/editor-rtl.css\";i:181;s:24:\"group/editor-rtl.min.css\";i:182;s:16:\"group/editor.css\";i:183;s:20:\"group/editor.min.css\";i:184;s:19:\"group/style-rtl.css\";i:185;s:23:\"group/style-rtl.min.css\";i:186;s:15:\"group/style.css\";i:187;s:19:\"group/style.min.css\";i:188;s:19:\"group/theme-rtl.css\";i:189;s:23:\"group/theme-rtl.min.css\";i:190;s:15:\"group/theme.css\";i:191;s:19:\"group/theme.min.css\";i:192;s:21:\"heading/style-rtl.css\";i:193;s:25:\"heading/style-rtl.min.css\";i:194;s:17:\"heading/style.css\";i:195;s:21:\"heading/style.min.css\";i:196;s:19:\"html/editor-rtl.css\";i:197;s:23:\"html/editor-rtl.min.css\";i:198;s:15:\"html/editor.css\";i:199;s:19:\"html/editor.min.css\";i:200;s:20:\"image/editor-rtl.css\";i:201;s:24:\"image/editor-rtl.min.css\";i:202;s:16:\"image/editor.css\";i:203;s:20:\"image/editor.min.css\";i:204;s:19:\"image/style-rtl.css\";i:205;s:23:\"image/style-rtl.min.css\";i:206;s:15:\"image/style.css\";i:207;s:19:\"image/style.min.css\";i:208;s:19:\"image/theme-rtl.css\";i:209;s:23:\"image/theme-rtl.min.css\";i:210;s:15:\"image/theme.css\";i:211;s:19:\"image/theme.min.css\";i:212;s:29:\"latest-comments/style-rtl.css\";i:213;s:33:\"latest-comments/style-rtl.min.css\";i:214;s:25:\"latest-comments/style.css\";i:215;s:29:\"latest-comments/style.min.css\";i:216;s:27:\"latest-posts/editor-rtl.css\";i:217;s:31:\"latest-posts/editor-rtl.min.css\";i:218;s:23:\"latest-posts/editor.css\";i:219;s:27:\"latest-posts/editor.min.css\";i:220;s:26:\"latest-posts/style-rtl.css\";i:221;s:30:\"latest-posts/style-rtl.min.css\";i:222;s:22:\"latest-posts/style.css\";i:223;s:26:\"latest-posts/style.min.css\";i:224;s:18:\"list/style-rtl.css\";i:225;s:22:\"list/style-rtl.min.css\";i:226;s:14:\"list/style.css\";i:227;s:18:\"list/style.min.css\";i:228;s:22:\"loginout/style-rtl.css\";i:229;s:26:\"loginout/style-rtl.min.css\";i:230;s:18:\"loginout/style.css\";i:231;s:22:\"loginout/style.min.css\";i:232;s:25:\"media-text/editor-rtl.css\";i:233;s:29:\"media-text/editor-rtl.min.css\";i:234;s:21:\"media-text/editor.css\";i:235;s:25:\"media-text/editor.min.css\";i:236;s:24:\"media-text/style-rtl.css\";i:237;s:28:\"media-text/style-rtl.min.css\";i:238;s:20:\"media-text/style.css\";i:239;s:24:\"media-text/style.min.css\";i:240;s:19:\"more/editor-rtl.css\";i:241;s:23:\"more/editor-rtl.min.css\";i:242;s:15:\"more/editor.css\";i:243;s:19:\"more/editor.min.css\";i:244;s:30:\"navigation-link/editor-rtl.css\";i:245;s:34:\"navigation-link/editor-rtl.min.css\";i:246;s:26:\"navigation-link/editor.css\";i:247;s:30:\"navigation-link/editor.min.css\";i:248;s:29:\"navigation-link/style-rtl.css\";i:249;s:33:\"navigation-link/style-rtl.min.css\";i:250;s:25:\"navigation-link/style.css\";i:251;s:29:\"navigation-link/style.min.css\";i:252;s:33:\"navigation-submenu/editor-rtl.css\";i:253;s:37:\"navigation-submenu/editor-rtl.min.css\";i:254;s:29:\"navigation-submenu/editor.css\";i:255;s:33:\"navigation-submenu/editor.min.css\";i:256;s:25:\"navigation/editor-rtl.css\";i:257;s:29:\"navigation/editor-rtl.min.css\";i:258;s:21:\"navigation/editor.css\";i:259;s:25:\"navigation/editor.min.css\";i:260;s:24:\"navigation/style-rtl.css\";i:261;s:28:\"navigation/style-rtl.min.css\";i:262;s:20:\"navigation/style.css\";i:263;s:24:\"navigation/style.min.css\";i:264;s:23:\"nextpage/editor-rtl.css\";i:265;s:27:\"nextpage/editor-rtl.min.css\";i:266;s:19:\"nextpage/editor.css\";i:267;s:23:\"nextpage/editor.min.css\";i:268;s:24:\"page-list/editor-rtl.css\";i:269;s:28:\"page-list/editor-rtl.min.css\";i:270;s:20:\"page-list/editor.css\";i:271;s:24:\"page-list/editor.min.css\";i:272;s:23:\"page-list/style-rtl.css\";i:273;s:27:\"page-list/style-rtl.min.css\";i:274;s:19:\"page-list/style.css\";i:275;s:23:\"page-list/style.min.css\";i:276;s:24:\"paragraph/editor-rtl.css\";i:277;s:28:\"paragraph/editor-rtl.min.css\";i:278;s:20:\"paragraph/editor.css\";i:279;s:24:\"paragraph/editor.min.css\";i:280;s:23:\"paragraph/style-rtl.css\";i:281;s:27:\"paragraph/style-rtl.min.css\";i:282;s:19:\"paragraph/style.css\";i:283;s:23:\"paragraph/style.min.css\";i:284;s:35:\"post-author-biography/style-rtl.css\";i:285;s:39:\"post-author-biography/style-rtl.min.css\";i:286;s:31:\"post-author-biography/style.css\";i:287;s:35:\"post-author-biography/style.min.css\";i:288;s:30:\"post-author-name/style-rtl.css\";i:289;s:34:\"post-author-name/style-rtl.min.css\";i:290;s:26:\"post-author-name/style.css\";i:291;s:30:\"post-author-name/style.min.css\";i:292;s:26:\"post-author/editor-rtl.css\";i:293;s:30:\"post-author/editor-rtl.min.css\";i:294;s:22:\"post-author/editor.css\";i:295;s:26:\"post-author/editor.min.css\";i:296;s:25:\"post-author/style-rtl.css\";i:297;s:29:\"post-author/style-rtl.min.css\";i:298;s:21:\"post-author/style.css\";i:299;s:25:\"post-author/style.min.css\";i:300;s:33:\"post-comments-form/editor-rtl.css\";i:301;s:37:\"post-comments-form/editor-rtl.min.css\";i:302;s:29:\"post-comments-form/editor.css\";i:303;s:33:\"post-comments-form/editor.min.css\";i:304;s:32:\"post-comments-form/style-rtl.css\";i:305;s:36:\"post-comments-form/style-rtl.min.css\";i:306;s:28:\"post-comments-form/style.css\";i:307;s:32:\"post-comments-form/style.min.css\";i:308;s:26:\"post-content/style-rtl.css\";i:309;s:30:\"post-content/style-rtl.min.css\";i:310;s:22:\"post-content/style.css\";i:311;s:26:\"post-content/style.min.css\";i:312;s:23:\"post-date/style-rtl.css\";i:313;s:27:\"post-date/style-rtl.min.css\";i:314;s:19:\"post-date/style.css\";i:315;s:23:\"post-date/style.min.css\";i:316;s:27:\"post-excerpt/editor-rtl.css\";i:317;s:31:\"post-excerpt/editor-rtl.min.css\";i:318;s:23:\"post-excerpt/editor.css\";i:319;s:27:\"post-excerpt/editor.min.css\";i:320;s:26:\"post-excerpt/style-rtl.css\";i:321;s:30:\"post-excerpt/style-rtl.min.css\";i:322;s:22:\"post-excerpt/style.css\";i:323;s:26:\"post-excerpt/style.min.css\";i:324;s:34:\"post-featured-image/editor-rtl.css\";i:325;s:38:\"post-featured-image/editor-rtl.min.css\";i:326;s:30:\"post-featured-image/editor.css\";i:327;s:34:\"post-featured-image/editor.min.css\";i:328;s:33:\"post-featured-image/style-rtl.css\";i:329;s:37:\"post-featured-image/style-rtl.min.css\";i:330;s:29:\"post-featured-image/style.css\";i:331;s:33:\"post-featured-image/style.min.css\";i:332;s:34:\"post-navigation-link/style-rtl.css\";i:333;s:38:\"post-navigation-link/style-rtl.min.css\";i:334;s:30:\"post-navigation-link/style.css\";i:335;s:34:\"post-navigation-link/style.min.css\";i:336;s:27:\"post-template/style-rtl.css\";i:337;s:31:\"post-template/style-rtl.min.css\";i:338;s:23:\"post-template/style.css\";i:339;s:27:\"post-template/style.min.css\";i:340;s:24:\"post-terms/style-rtl.css\";i:341;s:28:\"post-terms/style-rtl.min.css\";i:342;s:20:\"post-terms/style.css\";i:343;s:24:\"post-terms/style.min.css\";i:344;s:24:\"post-title/style-rtl.css\";i:345;s:28:\"post-title/style-rtl.min.css\";i:346;s:20:\"post-title/style.css\";i:347;s:24:\"post-title/style.min.css\";i:348;s:26:\"preformatted/style-rtl.css\";i:349;s:30:\"preformatted/style-rtl.min.css\";i:350;s:22:\"preformatted/style.css\";i:351;s:26:\"preformatted/style.min.css\";i:352;s:24:\"pullquote/editor-rtl.css\";i:353;s:28:\"pullquote/editor-rtl.min.css\";i:354;s:20:\"pullquote/editor.css\";i:355;s:24:\"pullquote/editor.min.css\";i:356;s:23:\"pullquote/style-rtl.css\";i:357;s:27:\"pullquote/style-rtl.min.css\";i:358;s:19:\"pullquote/style.css\";i:359;s:23:\"pullquote/style.min.css\";i:360;s:23:\"pullquote/theme-rtl.css\";i:361;s:27:\"pullquote/theme-rtl.min.css\";i:362;s:19:\"pullquote/theme.css\";i:363;s:23:\"pullquote/theme.min.css\";i:364;s:39:\"query-pagination-numbers/editor-rtl.css\";i:365;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:366;s:35:\"query-pagination-numbers/editor.css\";i:367;s:39:\"query-pagination-numbers/editor.min.css\";i:368;s:31:\"query-pagination/editor-rtl.css\";i:369;s:35:\"query-pagination/editor-rtl.min.css\";i:370;s:27:\"query-pagination/editor.css\";i:371;s:31:\"query-pagination/editor.min.css\";i:372;s:30:\"query-pagination/style-rtl.css\";i:373;s:34:\"query-pagination/style-rtl.min.css\";i:374;s:26:\"query-pagination/style.css\";i:375;s:30:\"query-pagination/style.min.css\";i:376;s:25:\"query-title/style-rtl.css\";i:377;s:29:\"query-title/style-rtl.min.css\";i:378;s:21:\"query-title/style.css\";i:379;s:25:\"query-title/style.min.css\";i:380;s:25:\"query-total/style-rtl.css\";i:381;s:29:\"query-total/style-rtl.min.css\";i:382;s:21:\"query-total/style.css\";i:383;s:25:\"query-total/style.min.css\";i:384;s:20:\"query/editor-rtl.css\";i:385;s:24:\"query/editor-rtl.min.css\";i:386;s:16:\"query/editor.css\";i:387;s:20:\"query/editor.min.css\";i:388;s:19:\"quote/style-rtl.css\";i:389;s:23:\"quote/style-rtl.min.css\";i:390;s:15:\"quote/style.css\";i:391;s:19:\"quote/style.min.css\";i:392;s:19:\"quote/theme-rtl.css\";i:393;s:23:\"quote/theme-rtl.min.css\";i:394;s:15:\"quote/theme.css\";i:395;s:19:\"quote/theme.min.css\";i:396;s:23:\"read-more/style-rtl.css\";i:397;s:27:\"read-more/style-rtl.min.css\";i:398;s:19:\"read-more/style.css\";i:399;s:23:\"read-more/style.min.css\";i:400;s:18:\"rss/editor-rtl.css\";i:401;s:22:\"rss/editor-rtl.min.css\";i:402;s:14:\"rss/editor.css\";i:403;s:18:\"rss/editor.min.css\";i:404;s:17:\"rss/style-rtl.css\";i:405;s:21:\"rss/style-rtl.min.css\";i:406;s:13:\"rss/style.css\";i:407;s:17:\"rss/style.min.css\";i:408;s:21:\"search/editor-rtl.css\";i:409;s:25:\"search/editor-rtl.min.css\";i:410;s:17:\"search/editor.css\";i:411;s:21:\"search/editor.min.css\";i:412;s:20:\"search/style-rtl.css\";i:413;s:24:\"search/style-rtl.min.css\";i:414;s:16:\"search/style.css\";i:415;s:20:\"search/style.min.css\";i:416;s:20:\"search/theme-rtl.css\";i:417;s:24:\"search/theme-rtl.min.css\";i:418;s:16:\"search/theme.css\";i:419;s:20:\"search/theme.min.css\";i:420;s:24:\"separator/editor-rtl.css\";i:421;s:28:\"separator/editor-rtl.min.css\";i:422;s:20:\"separator/editor.css\";i:423;s:24:\"separator/editor.min.css\";i:424;s:23:\"separator/style-rtl.css\";i:425;s:27:\"separator/style-rtl.min.css\";i:426;s:19:\"separator/style.css\";i:427;s:23:\"separator/style.min.css\";i:428;s:23:\"separator/theme-rtl.css\";i:429;s:27:\"separator/theme-rtl.min.css\";i:430;s:19:\"separator/theme.css\";i:431;s:23:\"separator/theme.min.css\";i:432;s:24:\"shortcode/editor-rtl.css\";i:433;s:28:\"shortcode/editor-rtl.min.css\";i:434;s:20:\"shortcode/editor.css\";i:435;s:24:\"shortcode/editor.min.css\";i:436;s:24:\"site-logo/editor-rtl.css\";i:437;s:28:\"site-logo/editor-rtl.min.css\";i:438;s:20:\"site-logo/editor.css\";i:439;s:24:\"site-logo/editor.min.css\";i:440;s:23:\"site-logo/style-rtl.css\";i:441;s:27:\"site-logo/style-rtl.min.css\";i:442;s:19:\"site-logo/style.css\";i:443;s:23:\"site-logo/style.min.css\";i:444;s:27:\"site-tagline/editor-rtl.css\";i:445;s:31:\"site-tagline/editor-rtl.min.css\";i:446;s:23:\"site-tagline/editor.css\";i:447;s:27:\"site-tagline/editor.min.css\";i:448;s:26:\"site-tagline/style-rtl.css\";i:449;s:30:\"site-tagline/style-rtl.min.css\";i:450;s:22:\"site-tagline/style.css\";i:451;s:26:\"site-tagline/style.min.css\";i:452;s:25:\"site-title/editor-rtl.css\";i:453;s:29:\"site-title/editor-rtl.min.css\";i:454;s:21:\"site-title/editor.css\";i:455;s:25:\"site-title/editor.min.css\";i:456;s:24:\"site-title/style-rtl.css\";i:457;s:28:\"site-title/style-rtl.min.css\";i:458;s:20:\"site-title/style.css\";i:459;s:24:\"site-title/style.min.css\";i:460;s:26:\"social-link/editor-rtl.css\";i:461;s:30:\"social-link/editor-rtl.min.css\";i:462;s:22:\"social-link/editor.css\";i:463;s:26:\"social-link/editor.min.css\";i:464;s:27:\"social-links/editor-rtl.css\";i:465;s:31:\"social-links/editor-rtl.min.css\";i:466;s:23:\"social-links/editor.css\";i:467;s:27:\"social-links/editor.min.css\";i:468;s:26:\"social-links/style-rtl.css\";i:469;s:30:\"social-links/style-rtl.min.css\";i:470;s:22:\"social-links/style.css\";i:471;s:26:\"social-links/style.min.css\";i:472;s:21:\"spacer/editor-rtl.css\";i:473;s:25:\"spacer/editor-rtl.min.css\";i:474;s:17:\"spacer/editor.css\";i:475;s:21:\"spacer/editor.min.css\";i:476;s:20:\"spacer/style-rtl.css\";i:477;s:24:\"spacer/style-rtl.min.css\";i:478;s:16:\"spacer/style.css\";i:479;s:20:\"spacer/style.min.css\";i:480;s:20:\"table/editor-rtl.css\";i:481;s:24:\"table/editor-rtl.min.css\";i:482;s:16:\"table/editor.css\";i:483;s:20:\"table/editor.min.css\";i:484;s:19:\"table/style-rtl.css\";i:485;s:23:\"table/style-rtl.min.css\";i:486;s:15:\"table/style.css\";i:487;s:19:\"table/style.min.css\";i:488;s:19:\"table/theme-rtl.css\";i:489;s:23:\"table/theme-rtl.min.css\";i:490;s:15:\"table/theme.css\";i:491;s:19:\"table/theme.min.css\";i:492;s:24:\"tag-cloud/editor-rtl.css\";i:493;s:28:\"tag-cloud/editor-rtl.min.css\";i:494;s:20:\"tag-cloud/editor.css\";i:495;s:24:\"tag-cloud/editor.min.css\";i:496;s:23:\"tag-cloud/style-rtl.css\";i:497;s:27:\"tag-cloud/style-rtl.min.css\";i:498;s:19:\"tag-cloud/style.css\";i:499;s:23:\"tag-cloud/style.min.css\";i:500;s:28:\"template-part/editor-rtl.css\";i:501;s:32:\"template-part/editor-rtl.min.css\";i:502;s:24:\"template-part/editor.css\";i:503;s:28:\"template-part/editor.min.css\";i:504;s:27:\"template-part/theme-rtl.css\";i:505;s:31:\"template-part/theme-rtl.min.css\";i:506;s:23:\"template-part/theme.css\";i:507;s:27:\"template-part/theme.min.css\";i:508;s:30:\"term-description/style-rtl.css\";i:509;s:34:\"term-description/style-rtl.min.css\";i:510;s:26:\"term-description/style.css\";i:511;s:30:\"term-description/style.min.css\";i:512;s:27:\"text-columns/editor-rtl.css\";i:513;s:31:\"text-columns/editor-rtl.min.css\";i:514;s:23:\"text-columns/editor.css\";i:515;s:27:\"text-columns/editor.min.css\";i:516;s:26:\"text-columns/style-rtl.css\";i:517;s:30:\"text-columns/style-rtl.min.css\";i:518;s:22:\"text-columns/style.css\";i:519;s:26:\"text-columns/style.min.css\";i:520;s:19:\"verse/style-rtl.css\";i:521;s:23:\"verse/style-rtl.min.css\";i:522;s:15:\"verse/style.css\";i:523;s:19:\"verse/style.min.css\";i:524;s:20:\"video/editor-rtl.css\";i:525;s:24:\"video/editor-rtl.min.css\";i:526;s:16:\"video/editor.css\";i:527;s:20:\"video/editor.min.css\";i:528;s:19:\"video/style-rtl.css\";i:529;s:23:\"video/style-rtl.min.css\";i:530;s:15:\"video/style.css\";i:531;s:19:\"video/style.min.css\";i:532;s:19:\"video/theme-rtl.css\";i:533;s:23:\"video/theme-rtl.min.css\";i:534;s:15:\"video/theme.css\";i:535;s:19:\"video/theme.min.css\";}}", "on");
INSERT INTO `wp2n_options` VALUES("130", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.8.3.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.8.3.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-6.8.3-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-6.8.3-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.8.3\";s:7:\"version\";s:5:\"6.8.3\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1762173855;s:15:\"version_checked\";s:5:\"6.8.3\";s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp2n_options` VALUES("131", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"ee61af87ae652291f9f1e4e22bb12b2f\";s:6:\"blocks\";a:5:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:0:\"\";s:12:\"core/columns\";s:0:\"\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}", "on");
INSERT INTO `wp2n_options` VALUES("134", "loginizer_version", "2.0.3", "auto");
INSERT INTO `wp2n_options` VALUES("135", "loginizer_options", "a:0:{}", "auto");
INSERT INTO `wp2n_options` VALUES("136", "loginizer_last_reset", "1762163549", "auto");
INSERT INTO `wp2n_options` VALUES("137", "loginizer_whitelist", "a:0:{}", "auto");
INSERT INTO `wp2n_options` VALUES("138", "loginizer_blacklist", "a:0:{}", "auto");
INSERT INTO `wp2n_options` VALUES("139", "loginizer_2fa_whitelist", "a:0:{}", "auto");
INSERT INTO `wp2n_options` VALUES("140", "loginizer_softwp_upgrade", "1762163546", "auto");
INSERT INTO `wp2n_options` VALUES("141", "loginizer_ins_time", "1762163549", "auto");
INSERT INTO `wp2n_options` VALUES("142", "siteseo_toggle", "a:6:{s:13:\"toggle-titles\";b:1;s:18:\"toggle-xml-sitemap\";b:1;s:23:\"toggle-instant-indexing\";b:1;s:15:\"toggle-advanced\";b:1;s:13:\"toggle-social\";b:1;s:23:\"toggle-google-analytics\";b:1;}", "auto");
INSERT INTO `wp2n_options` VALUES("143", "siteseo_titles_option_name", "a:13:{s:10:\"titles_sep\";s:1:\"-\";s:22:\"titles_home_site_title\";s:13:\"%%sitetitle%%\";s:21:\"titles_home_site_desc\";s:11:\"%%tagline%%\";s:20:\"titles_single_titles\";a:2:{s:4:\"post\";a:2:{s:5:\"title\";s:36:\"%%post_title%% %%sep%% %%sitetitle%%\";s:11:\"description\";s:17:\"%%post_excerpt%% \";}s:4:\"page\";a:2:{s:5:\"title\";s:36:\"%%post_title%% %%sep%% %%sitetitle%%\";s:11:\"description\";s:17:\"%%post_excerpt%% \";}}s:17:\"titles_tax_titles\";a:3:{s:8:\"category\";a:2:{s:5:\"title\";s:41:\"%%_category_title%% %%sep%% %%sitetitle%%\";s:11:\"description\";s:25:\"%%_category_description%%\";}s:8:\"post_tag\";a:2:{s:5:\"title\";s:41:\"%%_category_title%% %%sep%% %%sitetitle%%\";s:11:\"description\";s:25:\"%%_category_description%%\";}s:11:\"post_format\";a:2:{s:5:\"title\";s:41:\"%%_category_title%% %%sep%% %%sitetitle%%\";s:11:\"description\";s:25:\"%%_category_description%%\";}}s:28:\"titles_archives_author_title\";s:37:\"%%post_author%% %%sep%% %%sitetitle%%\";s:30:\"titles_archives_author_noindex\";b:1;s:26:\"titles_archives_date_title\";s:38:\"%%archive_date%% %%sep%% %%sitetitle%%\";s:28:\"titles_archives_date_noindex\";b:1;s:36:\"titles_archives_search_title_noindex\";b:1;s:27:\"titles_nositelinkssearchbox\";b:1;s:28:\"titles_archives_search_title\";s:41:\"%%search_keywords%% %%sep%% %%sitetitle%%\";s:25:\"titles_archives_404_title\";s:42:\"404 - Page not found %%sep%% %%sitetitle%%\";}", "auto");
INSERT INTO `wp2n_options` VALUES("144", "siteseo_social_option_name", "a:2:{s:19:\"social_twitter_card\";b:1;s:18:\"social_facebook_og\";b:1;}", "auto");
INSERT INTO `wp2n_options` VALUES("145", "siteseo_xml_sitemap_option_name", "a:4:{s:26:\"xml_sitemap_general_enable\";b:1;s:27:\"xml_sitemap_post_types_list\";a:2:{s:4:\"post\";a:1:{s:7:\"include\";b:1;}s:4:\"page\";a:1:{s:7:\"include\";b:1;}}s:27:\"xml_sitemap_taxonomies_list\";a:1:{s:8:\"category\";a:1:{s:7:\"include\";b:1;}}s:22:\"xml_sitemap_img_enable\";b:1;}", "auto");
INSERT INTO `wp2n_options` VALUES("146", "siteseo_advanced_option_name", "a:2:{s:20:\"advanced_attachments\";b:1;s:28:\"appearance_universal_metabox\";b:1;}", "auto");
INSERT INTO `wp2n_options` VALUES("147", "siteseo_version", "1.3.2", "auto");
INSERT INTO `wp2n_options` VALUES("148", "gosmtp_version", "1.1.5", "auto");
INSERT INTO `wp2n_options` VALUES("149", "loginizer_login_attempt_stats", "a:2:{i:1762160400;a:1:{i:0;i:5;}i:1762164000;a:1:{i:0;i:11;}}", "off");
INSERT INTO `wp2n_options` VALUES("150", "backuply_version", "1.5.0", "auto");
INSERT INTO `wp2n_options` VALUES("151", "backuply_config_keys", "a:1:{s:12:\"BACKUPLY_KEY\";s:64:\"551a4caf3f5b274f3ced08cae003943842320bbcec98d129d0ae548ebf324f01\";}", "auto");
INSERT INTO `wp2n_options` VALUES("152", "pagelayer_version", "2.0.5", "auto");
INSERT INTO `wp2n_options` VALUES("153", "pagelayer_options", "a:0:{}", "auto");
INSERT INTO `wp2n_options` VALUES("154", "speedycache_options", "a:3:{s:3:\"lbc\";b:1;s:10:\"minify_css\";b:1;s:4:\"gzip\";b:1;}", "auto");
INSERT INTO `wp2n_options` VALUES("155", "speedycache_version", "1.3.6", "auto");
INSERT INTO `wp2n_options` VALUES("156", "cookieadmin_version", "1.1.3", "auto");
INSERT INTO `wp2n_options` VALUES("161", "_site_transient_timeout_wp_theme_files_patterns-a4b84b58ae70ebd2ec5a0777669b878a", "1762165450", "off");
INSERT INTO `wp2n_options` VALUES("162", "_site_transient_wp_theme_files_patterns-a4b84b58ae70ebd2ec5a0777669b878a", "a:2:{s:7:\"version\";b:0;s:8:\"patterns\";a:0:{}}", "off");
INSERT INTO `wp2n_options` VALUES("163", "pagelayer_promo_time", "1762250053", "auto");
INSERT INTO `wp2n_options` VALUES("164", "loginizer_promo_time", "1762163654", "auto");
INSERT INTO `wp2n_options` VALUES("165", "loginizer_backuply_promo_time", "1762163654", "auto");
INSERT INTO `wp2n_options` VALUES("166", "loginizer_csrf_promo_time", "1762163654", "auto");
INSERT INTO `wp2n_options` VALUES("168", "backuply_hide_trial", "1762163658", "off");
INSERT INTO `wp2n_options` VALUES("169", "backuply_backup_nag", "1761645258", "off");
INSERT INTO `wp2n_options` VALUES("170", "backuply_license_notice", "1762163658", "auto");
INSERT INTO `wp2n_options` VALUES("171", "backuply_hide_holiday", "1762163658", "off");
INSERT INTO `wp2n_options` VALUES("172", "backuply_promo_time", "1762163658", "off");
INSERT INTO `wp2n_options` VALUES("173", "backuply_offer_time", "1762163658", "off");
INSERT INTO `wp2n_options` VALUES("175", "_site_transient_timeout_browser_2204ee63bef2f351470a66ffe1bb020e", "1762768458", "off");
INSERT INTO `wp2n_options` VALUES("176", "_site_transient_browser_2204ee63bef2f351470a66ffe1bb020e", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"141.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `wp2n_options` VALUES("177", "_site_transient_timeout_php_check_bf05629fd259c5e3e696947741738355", "1762768460", "off");
INSERT INTO `wp2n_options` VALUES("178", "_site_transient_php_check_bf05629fd259c5e3e696947741738355", "a:5:{s:19:\"recommended_version\";s:3:\"8.3\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `wp2n_options` VALUES("179", "_site_transient_timeout_community-events-6c0aa957b0ca17ed83a02c1a4180f749", "1762206864", "off");
INSERT INTO `wp2n_options` VALUES("180", "_site_transient_community-events-6c0aa957b0ca17ed83a02c1a4180f749", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:11:\"102.89.40.0\";}s:6:\"events\";a:1:{i:0;a:10:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:27:\"WordCamp Port Harcourt 2026\";s:3:\"url\";s:39:\"https://portharcourt.wordcamp.org/2025/\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2026-02-21 00:00:00\";s:8:\"end_date\";s:19:\"2026-02-21 00:00:00\";s:20:\"start_unix_timestamp\";i:1771628400;s:18:\"end_unix_timestamp\";i:1771628400;s:8:\"location\";a:4:{s:8:\"location\";s:22:\"Port Harcourt, Nigeria\";s:7:\"country\";s:2:\"NG\";s:8:\"latitude\";d:4.81097630000000009431460057385265827178955078125;s:9:\"longitude\";d:7.00295779999999989939851730014197528362274169921875;}}}}", "off");
INSERT INTO `wp2n_options` VALUES("181", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "off");
INSERT INTO `wp2n_options` VALUES("182", "recently_activated", "a:1:{s:51:\"all-in-one-wp-migration/all-in-one-wp-migration.php\";i:1762174027;}", "off");
INSERT INTO `wp2n_options` VALUES("183", "_transient_timeout_feed_9bbd59226dc36b9b26cd43f15694c5c3", "1762206868", "off");
INSERT INTO `wp2n_options` VALUES("184", "_transient_feed_9bbd59226dc36b9b26cd43f15694c5c3", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"The latest news about WordPress and the WordPress community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Oct 2025 15:58:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.9-beta2-61088\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 6.9 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2025/10/wordpress-6-9-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Oct 2025 15:23:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6-9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:7:\"release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19253\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:334:\"WordPress 6.9 Beta 2 is now ready for testing! This beta version of the WordPress software is under development. Please do not install, run, or test this version of WordPress on production or mission-critical websites.&#160; Instead, you should evaluate Beta 2 on a test server and site. You can test WordPress 6.9 Beta 2 in [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Akshaya Rane\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5125:\"\n<p>WordPress 6.9 Beta 2 is now ready for testing!</p>\n\n\n\n<p><strong>This beta version of the WordPress software is under development</strong>. Please do not install, run, or test this version of WordPress on production or mission-critical websites.&nbsp; Instead, you should evaluate Beta 2 on a test server and site.</p>\n\n\n\n<p>You can test WordPress 6.9 Beta 2 in any of the following ways:<br></p>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\"> WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream.)</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href=\"https://wordpress.org/wordpress-6.9-beta2.zip\">Beta 2 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use this<a href=\"https://make.wordpress.org/cli/\"> WP-CLI</a> command: <br><code>wp core update --version=6.9-beta2</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href=\"https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn\">6.9 Beta 2 WordPress Playground instance</a> to test the software directly in your browser.&nbsp; No setup is required–just click and go!&nbsp;</td></tr></tbody></table></figure>\n\n\n\n<p>The scheduled final release date for WordPress 6.9 is <strong>December 2, 2025</strong>. &nbsp;The full <a href=\"https://make.wordpress.org/core/6-9/\">release schedule can be found here</a>. Your help testing Beta and RC versions is vital to making this release as stable and powerful as possible. Do check the<a href=\"https://make.wordpress.org/core/\"> Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-9/\">6.9-related posts</a> in the coming weeks for more information. Thank you to everyone who contributes by testing!&nbsp;</p>\n\n\n\n<p><strong>Catch up on what’s new in WordPress 6.9</strong>: Read the <a href=\"https://make.wordpress.org/core/2025/10/21/wordpress-6-9-beta-1/\">Beta 1 announcement</a> for details and highlights.</p>\n\n\n\n<h2 class=\"wp-block-heading\">How to test this release</h2>\n\n\n\n<p>Your help testing the WordPress 6.9 Beta 2 version is key to ensuring everything in the release is the best it can be. While testing the upgrade process is essential, trying out new features is equally important.&nbsp; This <a href=\"https://make.wordpress.org/test/2025/10/21/help-test-wordpress-6-9/\">detailed guide</a> will walk you through testing features in WordPress 6.9.</p>\n\n\n\n<p>If you encounter an issue, please report it to the<a href=\"https://wordpress.org/support/forum/alphabeta/\"> Alpha/Beta area</a> of the support forums or directly to<a href=\"https://core.trac.wordpress.org/newticket\"> WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of<a href=\"https://core.trac.wordpress.org/tickets/major\"> known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the<a href=\"https://make.wordpress.org/test/\"> testing initiatives in Make Core</a> and join the<a href=\"https://wordpress.slack.com/messages/core-test/\"> #core-test channel</a> on<a href=\"https://wordpress.slack.com/\"> Making WordPress Slack</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Beta 2 updates and highlights</h2>\n\n\n\n<p>WordPress 6.9 Beta 2 contains more than 33 Editor updates and fixes since the Beta 1 release, including 28 tickets for WordPress core.</p>\n\n\n\n<p>Each beta cycle focuses on bug fixes; more are on the way with your help through testing. You can browse the technical details for all issues addressed since Beta 1 using these links:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.9?since=2025-10-22&amp;until=2025-10-28\">GitHub commits for 6.9</a> since October 21, 2025</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=10%2F22%2F2025..10%2F28%2F2025&amp;milestone=6.9&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Closed Trac tickets</a> since October 21, 2025</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">A Beta 2 haiku</h2>\n\n\n\n<p><em>Morning dew returns,</em></p>\n\n\n\n<p><em>Small fixes bloom in silence—</em></p>\n\n\n\n<p><em>Code finds its balance.</em></p>\n\n\n\n<p class=\"has-text-align-right\"><em>Props to <a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a>, <a href=\'https://profiles.wordpress.org/wildworks/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>wildworks</a> , <a href=\'https://profiles.wordpress.org/krupajnanda/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>krupajnanda</a> &amp; <a href=\'https://profiles.wordpress.org/mosescursor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mosescursor</a></em> <em>for proofreading and review.</em></p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19253\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"WordPress 6.8.3 Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/news/2025/09/wordpress-6-8-3-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Sep 2025 19:31:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"minor-releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19204\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:372:\"WordPress 6.8.3 is now available! This is a security release that features two fixes. Because this is a security release, it is recommended that you update your sites immediately. You can download WordPress 6.8.3 from WordPress.org, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”. If you have sites that support automatic [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"John Blackbourn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4937:\"\n<p><strong>WordPress 6.8.3 is now available!</strong></p>\n\n\n\n<p>This is a security release that features two fixes.</p>\n\n\n\n<p>Because this is a security release,<strong> it is recommended that you update your sites immediately</strong>.</p>\n\n\n\n<p>You can <a href=\"https://wordpress.org/wordpress-6.8.3.zip\">download WordPress 6.8.3 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”. If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>The next major release will be <a href=\"https://make.wordpress.org/core/6-9/\">version 6.9</a>, which is planned for December 2nd, 2025.<br>For more information on WordPress 6.8.3, please visit the <a href=\"https://wordpress.org/documentation/wordpress-version/version-6-8-3/\">version page on the HelpHub site</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Security updates included in this release</h2>\n\n\n\n<p>The security team would like to thank the following people for <a href=\"https://hackerone.com/wordpress?type=team\">responsibly reporting vulnerabilities</a>, and allowing them to be fixed in this release:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>A data exposure issue where authenticated users could access some restricted content. Independently reported by <a href=\"https://hackerone.com/mnelson4\">Mike Nelson</a>, <a href=\"https://hackerone.com/hurayraiit\">Abu Hurayra</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a>, and <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>.</li>\n\n\n\n<li>A cross-site scripting (XSS) vulnerability requiring an authenticated user role that affects the nav menus. Reported by <a href=\"https://x.com/Savphill\">Phill Savage</a>.</li>\n</ul>\n\n\n\n<p>As a courtesy, these fixes have also been made available to all branches eligible to receive security fixes (currently through 4.7). As a reminder, <strong>only the most recent version of WordPress is actively supported</strong>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>This release was led by <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>.</p>\n\n\n\n<p>In addition to the security researchers and release squad members mentioned above, WordPress 6.8.3 would not have been possible without the contributions of the following people:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/hurayraiit\">Abu Hurayra</a>, <a href=\"https://profiles.wordpress.org/zieladam\">Adam Zieliński</a>, <a href=\"https://profiles.wordpress.org/xknown\">Alex Concha</a>, <a href=\"https://profiles.wordpress.org/andraganescu%20\">Andrei Draganescu</a>, <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/ehtis\">Ehtisham Siddiqui</a>, <a href=\"https://profiles.wordpress.org/iandunn\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/whyisjake\">Jake Spurlock</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/joehoyle\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/jonsurrell\">Jon Surrell</a>, <a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/mnelson4\">Michael Nelson</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/phillsav\">Phill</a>, <a href=\"https://profiles.wordpress.org/noisysocks\">Robert Anderson</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/vortfu\">vortfu</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac, <a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation in the <a href=\"https://app.slack.com/client/T024MFP4J/C02RQBWTW\">#core</a> Slack channel. Need help? Check out the <a href=\"https://make.wordpress.org/core/handbook/tutorials/faq-for-new-contributors/\">Core Contributor Handbook</a>.</p>\n\n\n\n<p>Props to <a href=\"https://profiles.wordpress.org/ehtis/\">Ehtisham Siddiqui</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a> for reviewing.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19204\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"Portland Welcomes WordCamp US 2025: A Community Gathering\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wordpress.org/news/2025/08/portland-welcomes-wcus-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 30 Aug 2025 03:03:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19074\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:405:\"A full house of attendees gathered in Portland, Oregon, for WordCamp US 2025, with thousands more tuning in online. Over four days, the flagship WordPress event brought together contributors, innovators, and community members for collaboration, inspiration, and discovery. WordPress is so unique because we&#8217;re not just a product; we&#8217;re a movement. Matt Mullenweg, WordPress Cofounder [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:66040:\"\n\n\n<p>A full house of attendees gathered in Portland, Oregon, for WordCamp US 2025, with thousands more tuning in online. Over four days, the flagship WordPress event brought together contributors, innovators, and community members for collaboration, inspiration, and discovery.</p>\n\n\n\n<div class=\"wp-block-group is-nowrap is-layout-flex wp-container-core-group-is-layout-6c531013 wp-block-group-is-layout-flex\">\n<figure class=\"wp-block-pullquote\"><blockquote><p>WordPress is so unique because we&#8217;re not just a product; we&#8217;re a movement.</p><cite>Matt Mullenweg, WordPress Cofounder</cite></blockquote></figure>\n</div>\n\n\n\n<p>The WordPress event began with a dedicated Contributor Day and continued with a Showcase Day and two days of sessions filled with talks, panels, workshops, and community celebrations. WordPress Cofounder Matt Mullenweg joined a diverse lineup of speakers, panelists, and workshop leaders who brought fresh perspectives to the open web from across the globe.</p>\n\n\n\n<p>Set against the vibrant backdrop of Portland — with its iconic bridges, coffee culture, and creative energy — the Sponsor Hall buzzed as companies across the WordPress ecosystem demoed new products, shared insights, and connected with attendees. Each day offered opportunities to refuel with local flavors and international favorites, turning mealtimes into lively hubs of networking and idea-sharing.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A Global Gathering in Portland</h2>\n\n\n\n<p>WordCamp US is the annual gathering point for the WordPress community — where collaboration, creativity, and innovation intersect. This year in Portland, the event delivered an expansive program that reached every corner of the ecosystem.</p>\n\n\n\n<p>Here’s what attendees experienced:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Engaging Sessions Across Tracks</strong> – Keynotes, presentations, and discussions explored the evolving web and the role of open source in shaping it.</li>\n\n\n\n<li><strong>A Global Speaker Lineup</strong> – Voices from across continents brought local stories and global visions to the stage.</li>\n\n\n\n<li><strong>Wide-Ranging Topics</strong> – From AI in WordPress development to accessibility, design systems, content strategy, education, and case studies of WordPress at scale.</li>\n\n\n\n<li><strong>Hands-On Learning Opportunities</strong> – Workshops provided practical takeaways, empowering attendees to apply new skills immediately.</li>\n\n\n\n<li><strong>A Community Built on Collaboration</strong> – Whether contributing code, exploring business strategies, or sharing creative projects, attendees found space to learn, grow, and celebrate open source together.</li>\n</ul>\n\n\n\n<p>New contributors took their first steps into open source, seasoned developers explored cutting-edge AI integrations, and agencies and product teams shared strategies for scaling WordPress to meet modern needs. Beyond the technical, conversations around inclusivity, sustainability, and education underscored WordPress’s role as a tool for empowerment and positive change.</p>\n\n\n\n<p>In hallways, coffee lines, and evening meetups, attendees found the “hallway track” alive and well, spontaneous moments of connection that often became the most memorable part of the experience. Whether reconnecting with longtime collaborators or meeting someone new, these small interactions reinforced the heart of WordCamp US: a community that thrives on openness, generosity, and shared purpose.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Contributor Day: Collaboration at the Core</h2>\n\n\n\n<p>The conference opened on Tuesday, August 26, with a vibrant Contributor Day. Nearly 300 contributors filled the space, including more than 120 first-time participants who were onboarded across 19 teams. Developers, designers, translators, marketers, and community organizers worked side by side, representing WordPress expertise.</p>\n\n\n\n<p>Throughout the day, contributors tackled everything from improving accessibility and performance to refining documentation to enhancing translation tools. Beyond technical contributions, teams like Marketing and Community focused on outreach, mentoring, and shaping future-facing initiatives. Remote participants joined via dedicated channels, reinforcing the inclusive nature of WordPress’s global community. By day’s end, the collective energy was clear: WordPress continues to be built by and for everyone.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped has-black-background-color has-background wp-block-gallery-1 is-layout-flex wp-block-gallery-is-layout-flex\" style=\"border-width:20px;border-radius:2px\">\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;690878cfaa23b&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"690878cfaa23b\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19080\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19080\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;690878cfaa718&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"690878cfaa718\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19081\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19081\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;690878cfaabb9&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"690878cfaabb9\" class=\"wp-block-image size-large wp-lightbox-container\"><img decoding=\"async\" width=\"1707\" height=\"2560\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19087\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?fit=683%2C1024&amp;ssl=1\" alt=\"\" class=\"wp-image-19087\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?w=1707&amp;ssl=1 1707w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=200%2C300&amp;ssl=1 200w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=683%2C1024&amp;ssl=1 683w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=768%2C1152&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=1024%2C1536&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=1365%2C2048&amp;ssl=1 1365w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;690878cfab07d&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"690878cfab07d\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19084\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19084\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;690878cfab4b7&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"690878cfab4b7\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19082\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19082\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;690878cfab8bd&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"690878cfab8bd\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19085\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19085\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;690878cfabcaf&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"690878cfabcaf\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19086\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19086\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;690878cfac0b1&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"690878cfac0b1\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19090\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19090\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;690878cfac4f2&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"690878cfac4f2\" class=\"wp-block-image size-large wp-lightbox-container\"><img loading=\"lazy\" decoding=\"async\" width=\"2560\" height=\"1707\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19089\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?fit=1024%2C683&amp;ssl=1\" alt=\"\" class=\"wp-image-19089\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?w=2560&amp;ssl=1 2560w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;690878cfac94a&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"690878cfac94a\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19092\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19092\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;690878cfacdb0&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"690878cfacdb0\" class=\"wp-block-image size-large wp-lightbox-container\"><img loading=\"lazy\" decoding=\"async\" width=\"2560\" height=\"1707\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19088\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?fit=1024%2C683&amp;ssl=1\" alt=\"\" class=\"wp-image-19088\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?w=2560&amp;ssl=1 2560w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;690878cfad21b&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"690878cfad21b\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19091\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19091\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;690878cfad5df&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"690878cfad5df\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19083\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19083\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n</figure>\n\n\n\n<p>The mix of experience in the room made this year especially notable. First-time contributors were paired with seasoned table leads who guided them through their first steps into open source contribution. Longtime contributors reconnected with their teams and advanced ongoing initiatives, while new voices added fresh perspectives and momentum. The spirit of mentorship was woven throughout, ensuring that Contributor Day was productive and welcoming.</p>\n\n\n\n<p>The results spoke for themselves:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Polyglots</strong> translated more than 12,000 strings, expanding WordPress’s accessibility worldwide.</li>\n\n\n\n<li>The <strong>Community team</strong> celebrated the approval of two brand-new local meetups.</li>\n\n\n\n<li>The <strong>Training team</strong> achieved its objective of updating outdated course thumbnails.</li>\n\n\n\n<li>The <strong>Core team</strong> worked through a live bug scrub, with 9 committers and 16 contributors collaborating on improvements.</li>\n\n\n\n<li>The <strong>Documentation team</strong> completed numerous content updates to keep resources fresh and reliable.</li>\n</ul>\n\n\n\n<p>Momentum carried through every table, with participants reporting measurable progress and a renewed sense of shared purpose. Contributor Day once again highlighted the unique power of collaboration in shaping the open web, proving that every contribution matters through code, translations, training, or community building.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Showcase Day: WordPress in Action</h2>\n\n\n\n<p>Wednesday, August 27, was the popular Showcase Day, spotlighting real-world innovation in WordPress. Initially expected to draw about 250 participants, Showcase Day welcomed more than 800 attendees — a powerful sign of how much energy and curiosity the community brought to Portland. The sessions demonstrated how WordPress powers meaningful work across industries from nonprofits to newsrooms, agencies to global enterprises, while staying true to open source values.</p>\n\n\n\n<p>The day opened with a keynote by Amy Sample Ward: <em>The Tech That Comes Next</em>. Drawing from their co-authored book with Afua Bruce, Amy highlighted the inequities embedded in today’s technologies — from dataset bias to accessibility gaps — and challenged attendees to rethink how tools are funded, built, and deployed. Their talk invited technologists, funders, and community leaders to imagine a more equitable digital future, rooted in collaboration and shared responsibility.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"WordCamp US 2025 - Amy Sample Ward &quot;The Tech That Comes Next&quot;\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/RKnM75GFZxw?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>From there, <a href=\"https://youtu.be/PGvh7fCOUk0\">Joeleen Kennedy</a> of Human Made shared how Full Site Editing (FSE) shapes the refresh of Wikimedia’s ongoing user experience. Her session <em>Modernizing at Scale</em> detailed how FSE is simplifying workflows, improving accessibility, and making the multilingual platform more sustainable for the long term. Attendees gained a behind-the-scenes look at how one of the world’s largest open knowledge platforms is leveraging WordPress innovation.</p>\n\n\n\n<p><a href=\"https://youtu.be/F4NEPcwGRCI\">Josh Bryant</a> took the stage to explore what happens when Gutenberg leaves the WP-Admin dashboard. His talk, <em>Reimagining WordPress Editing</em>, walked through embedding the block editor into a standalone React application to support Dow Jones’s newsroom workflows. From decoupling Gutenberg to managing custom data stores, the session showcased advanced techniques for scaling editorial tools while maintaining the flexibility of the WordPress ecosystem.</p>\n\n\n\n<p>Hands-on learning was a hallmark of Showcase Day, with Jamie Marsland’s workshop leading participants through building and launching their own professional portfolio sites — no coding required. Attendees left with a fully functioning site, demonstrating WordPress’s continued ability to empower anyone, anywhere, to publish online.</p>\n\n\n\n<p>In the afternoon, Jeffrey Paul’s session <em>Scalable, Ethical AI</em> addressed one of the most pressing topics in today’s digital world: how to integrate AI without sacrificing ownership, privacy, or open standards. Walking participants through practical use cases with ClassifAI and local LLMs, Paul emphasized how WordPress can help content creators harness AI while maintaining autonomy over their data.</p>\n\n\n\n<p>The day closed with a forward-looking community highlight: <a href=\"https://events.wordpress.org/campusconnect/\">WordPress Campus Connect</a>. Panelists <a href=\"https://youtu.be/ARqM9U0ESvo\">Destiny Kanno, Andrés Parra, Javier Montes de Blas, Mauricio Barrantes, and Elineth Morera Campos</a> shared how this initiative brings WordPress into classrooms and universities worldwide. Student Andrés Parra received a scholarship to attend WordCamp. During the panel, Elineth also announced that Fidélitas University will begin offering its students a <a href=\"https://wordpress.org/news/2025/07/introducing-wordpress-credits-a-new-contribution-internship-program-for-university-students/\">WordPress Credits</a> program starting in October 2025, making it a mandatory addition sometime in 2026, enabling them to contribute directly to WordPress as part of their studies.</p>\n\n\n\n<p>By connecting students and educators with the open web, Campus Connect is building the next generation of contributors and innovators, ensuring that WordPress remains both a learning tool and a pathway to opportunity.</p>\n\n\n\n<p>Taken together, Showcase Day affirmed that WordPress is more than just a CMS — it is a platform for equitable technology, global collaboration, cutting-edge enterprise solutions, and the future of digital education. WordPress has the power to be both a platform and a community tool for education, equity, and innovation.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Presentation Days: Learning, Inspiration, and Connection</h2>\n\n\n\n<p>The first full day of sessions at WordCamp US 2025 opened with warm remarks from the organizing team, who reminded attendees: <em>“The most important thanks goes to all of you. The mix of new energy and veteran experience is what makes WordCamp so special, so thank you for being here.”</em> That spirit of gratitude and community carried throughout the event.</p>\n\n\n\n<p>The Sponsor Hall became a hub of activity, complete with raffles, the return of Career Corner, and even a Voodoo Donut Truck parked outside. Attendees lined up to test their luck at a claw machine stuffed with plush Wapuus, while others sought guidance at the Happiness Bar — a hands-on help desk for WordPress questions big and small. Between these activities, the steady buzz of conversations made it clear: the “hallway track” remained one of WordCamp’s most valuable experiences.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"WordCamp US - Danny Sullivan &quot;How (and why!) Google Search Keeps Evolving&quot;\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/ZF_sxLdfTbY?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>The program itself set a high bar. Danny Sullivan’s keynote shed light on how search has evolved to meet the needs of new generations, from 24/7 demand and mobile expectations to short-form video and AI. His session gave attendees a deeper understanding of how search intersects with publishing today and sparked conversations about how WordPress can continue adapting in an era where AI shapes discovery and content.</p>\n\n\n\n<p>From there, the schedule unfolded across multiple tracks. The Core AI panel — featuring <a href=\"https://youtu.be/v_0O6dQ4Q4E\">James LePage, Felix Arntz, and Jeffrey Paul</a> — offered a look into how AI tools are woven into WordPress core. Emphasizing ethics, transparency, and user empowerment, the panel painted a roadmap for how WordPress can adopt new technologies without compromising its open-source values.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19103\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?w=1600&amp;ssl=1 1600w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>Hands-on learning played a significant role throughout the conference. Ryan Welcher’s interactive <em>Block Developer Cookbook</em> drew a packed room as participants worked through community-selected code recipes built on the latest WordPress APIs. By the end, attendees left with working examples and practical strategies they could bring back to their projects.</p>\n\n\n\n<p>The program also highlighted diverse technical perspectives. <a href=\"https://youtu.be/vBjNqdacbh4\">Jemima Abu’s</a> session, <em>A PHP Developer’s Guide to ReactJS</em>, bridged the gap between classic and modern web development. At the same time, Adam Gazzaley’s keynote, <em>A New Era of Experiential Medicine – AI and the Brain</em>, invited attendees to consider the human side of technology, exploring how digital tools can advance health and well-being.</p>\n\n\n\n<p>The second day of presentations, Friday, August 29, opened with creativity and imagination. <a href=\"https://youtu.be/O7FPiFpRI3o\">John Maeda’s</a> keynote, <em>Cozy AI Cooking: WordCamp Edition</em>, used the metaphor of a kitchen to demystify AI, blending storytelling with technical insight to show how curiosity and care can guide builders in integrating AI into their work.</p>\n\n\n\n<p>Later in the day, <a href=\"https://youtu.be/ORnJTpjA-4w\">Tammie Lister’s</a> <em>The System is the Strategy</em> illustrated how design systems provide structure and scalability for growing WordPress projects. At the same time, Adam Silverstein’s Unlock Developer Superpowers with AI showcased new ways developers can use emerging tools to speed up workflows and problem-solving.</p>\n\n\n\n<p>Community stories also took center stage. In Creators around a Campfire, Anne McCarthy, Jamie Marsland, Christian Taylor, Mark Szymanski, and Michael Cunningham reflected on how YouTubers and content creators shape the WordPress ecosystem. Their session highlighted the role of storytelling and education in expanding WordPress’s reach to new audiences worldwide.</p>\n\n\n\n<p>The Sponsor Hall remained lively between sessions — with attendees meeting companies, testing demos, and swapping ideas that extended far beyond the conference halls. They also shared moments together at the arcade built for the event and added smiles, hugs, and laughter, which underscored the atmosphere: WordCamp US was as much about connection as code.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Together Into the Future</h2>\n\n\n\n<p>As the event drew to a close, WordPress Cofounder Matt Mullenweg took the stage to share the current state of WordPress and a vision for its future. He highlighted the growth in social media for WordPress with 124,726 new followers since last WCUS — and the WordPress.org website growing over 10% in users along with almost 20% in new users. </p>\n\n\n\n<p>Matt also spotlighted community initiatives shaping the future of open source education and diversity: WordPress Campus Connect, which has already reached 570 students across 11 events. Combined with the growth in overall events (77) which is a 32.76% increase over 2024. Each effort reinforced the message that WordPress is more than software; it is a global movement driven by people.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"WordCamp US 2025 - Ma.tt Mullenweg &quot;Keynote Address &amp; Q&amp;A&quot;\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/45HRzzc0waU?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>He concluded with a live Q&amp;A, fielding questions from the audience on the direction of WordPress, its role in an AI-driven web, and the importance of keeping the project open, inclusive, and adaptable. The final notes of the keynote carried into a closing party in downtown Portland, where attendees capped off the week with music, conversation, and the unmistakable joy of a community coming together.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Closing</h2>\n\n\n\n<p>WordCamp US 2025 once again demonstrated what makes the WordPress ecosystem extraordinary: a community committed to building tools, resources, and opportunities that empower people everywhere.</p>\n\n\n\n<p>This year also marked the debut of the <a href=\"https://airtable.com/appWF6hdXuEOFQMvV/shrV5RZIv0aJjjU00\">Open Horizons Scholarship</a>, which funded six recipients — two organizers, three volunteers, and one speaker — from five countries. A total of $14,670 supported their journeys to WCUS. The scholarship, which also supports participation at WordCamp Asia and WordCamp Europe, is designed to make flagship events more accessible to contributors worldwide.</p>\n\n\n\n<p>A heartfelt thank you goes to the organizers, volunteers, sponsors, and speakers who brought the Portland edition to life — and to every attendee who joined us in person or followed along online. We hope you leave with fresh ideas, meaningful connections, and renewed energy to help shape the future of the open web.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped has-black-background-color has-background wp-block-gallery-2 is-layout-flex wp-block-gallery-is-layout-flex\" style=\"border-width:20px\">\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;690878cfae9f5&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"690878cfae9f5\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"577\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19112\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948.jpg?resize=1024%2C577&#038;ssl=1\" alt=\"\" class=\"wp-image-19112\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=1024%2C577&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=1536%2C865&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=2048%2C1153&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Gale Wallace</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;690878cfaeea9&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"690878cfaeea9\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19124\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997.jpeg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19124\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;690878cfaf2bf&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"690878cfaf2bf\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19122\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014.jpeg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19122\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;690878cfaf72f&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"690878cfaf72f\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"577\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19107\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752.jpg?resize=1024%2C577&#038;ssl=1\" alt=\"\" class=\"wp-image-19107\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=1024%2C577&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=1536%2C865&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=2048%2C1153&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Gale Wallace</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;690878cfafba2&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"690878cfafba2\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"675\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19108\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=1024%2C675&#038;ssl=1\" alt=\"\" class=\"wp-image-19108\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=1024%2C675&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=300%2C198&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=768%2C506&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=1536%2C1012&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?w=1764&amp;ssl=1 1764w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Gale Wallace</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;690878cfb0068&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"690878cfb0068\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19113\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076.jpeg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19113\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;690878cfb04e8&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"690878cfb04e8\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"433\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19106\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809.jpeg?resize=1024%2C433&#038;ssl=1\" alt=\"\" class=\"wp-image-19106\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=1024%2C433&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=300%2C127&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=768%2C325&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=1536%2C650&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=2048%2C866&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;690878cfb095c&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"690878cfb095c\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19110\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19110\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;690878cfb0d82&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"690878cfb0d82\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19119\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827.jpeg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19119\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;690878cfb122b&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"690878cfb122b\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19133\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19133\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n</figure>\n\n\n\n<p>Be sure to mark your calendars for the next global gatherings: <a href=\"https://asia.wordcamp.org/2026/\">WordCamp Asia 2026</a>&nbsp; in Mumbai, India, <a href=\"https://europe.wordcamp.org/2026/\">WordCamp Europe 2026</a>&nbsp; in Kraków, Poland, and WordCamp US 2026 in Phoenix, Arizona. We can’t wait to see you at the next chapter of the WordPress story.</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19074\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"Portland, Are You Ready? The WCUS 2025 Schedule Has Arrived!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://wordpress.org/news/2025/08/portland-are-you-ready-the-wcus-2025-schedule-has-arrived/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 06 Aug 2025 20:03:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:4:\"WCUS\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:9:\"WordCamps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19004\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:402:\"We’re excited to announce that the full schedule for WordCamp US 2025 has been published! From August 26–29 in Portland, Oregon, join web creators, innovators, and community leaders for four days of learning, collaboration, and inspiration. This year’s lineup brings together sessions on everything from cutting-edge AI to hands-on workshops, performance, accessibility, design, and the [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5698:\"\n<p>We’re excited to announce that the full schedule for WordCamp US 2025 has been published! From August 26–29 in Portland, Oregon, join web creators, innovators, and community leaders for four days of learning, collaboration, and inspiration. This year’s lineup brings together sessions on everything from cutting-edge AI to hands-on workshops, performance, accessibility, design, and the future of WordPress.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/ScheduleHeader.png?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19026\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/ScheduleHeader-scaled.png?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/ScheduleHeader-scaled.png?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/ScheduleHeader-scaled.png?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/ScheduleHeader-scaled.png?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/ScheduleHeader-scaled.png?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p class=\"has-text-align-center\" style=\"padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><strong>Check out the full schedule and start planning your WordCamp experience.</strong></p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button is-style-fill\"><a class=\"wp-block-button__link has-blue-1-background-color has-background wp-element-button\" href=\"https://us.wordcamp.org/2025/schedule/\">View The Schedule</a></div>\n</div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2 class=\"wp-block-heading\">Contributor Day — Connect, Collaborate, and Give Back</h2>\n\n\n\n<p>Kicking off the week on Tuesday, August 26 is Contributor Day, it is your chance to roll up your sleeves and make a direct impact on WordPress. Whether you’re a seasoned developer, creative designer, translator, marketer, or simply passionate about open source, there’s a place for you to get involved. Join WordPress teams working on real projects, share your skills, and connect with people across the global community. Contributor Day is also a fantastic place for hiring managers or business owners to meet emerging talent and see contributors in action. Lunch is provided, and both in-person and select remote participation options are available. If you’ve ever wanted to help shape the future of WordPress, this is your moment!<br></p>\n\n\n\n<p>Read more: <a href=\"https://us.wordcamp.org/2025/schedule/#contributor-day\">Start planning your Contributor Day activities &gt;&gt;</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Showcase Day — See WordPress in Action</h2>\n\n\n\n<p>Showcase Day on Wednesday, August 27, shines a spotlight on what&#8217;s possible with WordPress. Get inspired by live demos, case studies, and actionable presentations from experts and innovators using WordPress in creative and impactful ways. You’ll see how changemakers, nonprofits, publishers, and agencies use WordPress to solve real-world problems, build new products, and drive the web forward. Highlights include hands-on workshops, technical talks, and practical sessions covering everything from design systems to modern AI. It’s a full day dedicated to celebrating the talent, creativity, and innovation of the WordPress community.</p>\n\n\n\n<p>Read more: <a href=\"https://us.wordcamp.org/2025/schedule/#showcase-day\">See where these inspirational showcases take you &gt;&gt;</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Conference Days — Learn, Connect, and Level Up</h2>\n\n\n\n<p>The main event days for Thursday and Friday, August 28-29, feature a robust mix of technical deep-dives, product masterclasses, and sessions designed for all experience levels. Whether you’re a developer, designer, business owner, or just starting out, you’ll find plenty to explore—from future-focused discussions on AI and performance to hands-on workshops and networking events that bring the community together.</p>\n\n\n\n<p><strong>Keynote Highlights:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Amy Sample Ward, CEO of NTEN:</strong> The Tech That Comes Next: How Changemakers, Philanthropists, and Technologists Can Build an Equitable World. Featured Wednesday, August 27.</li>\n\n\n\n<li><strong>Danny Sullivan, from Google Search</strong>: Industry leader, featured Thursday, August 28.</li>\n\n\n\n<li><strong>Matt Mullenweg, Co-founder of WordPress:</strong> Featured Friday, August 29.</li>\n\n\n\n<li>More keynotes announcing soon!</li>\n</ul>\n\n\n\n<p>With dozens of sessions across multiple tracks, plus workshops and networking opportunities, WordCamp US is set to be an unforgettable experience. Don’t miss your chance to connect, share ideas, and help shape the future of the web.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center\"><strong>Check out the full schedule and start planning your WordCamp experience.</strong></p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button is-style-fill\"><a class=\"wp-block-button__link has-blue-1-background-color has-background wp-element-button\" href=\"https://us.wordcamp.org/2025/schedule/\">View The Schedule</a></div>\n</div>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19004\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Maintenance Releases for WordPress branches 4.7 to 6.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://wordpress.org/news/2025/08/maintenance-releases-for-wordpress-branches-4-7-to-6-7/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 05 Aug 2025 19:11:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"minor-releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18997\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:374:\"Following on from the WordPress 6.8.2 maintenance release last month, the included update to the root security certificate bundle has been backported to all branches back to 4.7. This ensures that when your site performs server-side HTTP requests, the most up-to-date information about trusted security certificates is used. Further information can be found on the [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"John Blackbourn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2119:\"\n<p>Following on from <a href=\"https://wordpress.org/news/2025/07/wordpress-6-8-2-maintenance-release/\">the WordPress 6.8.2 maintenance release last month</a>, the included update to the root security certificate bundle has been backported to all branches back to 4.7. This ensures that when your site performs server-side HTTP requests, the most up-to-date information about trusted security certificates is used. Further information can be found on <a href=\"https://core.trac.wordpress.org/ticket/62811\">the Core Trac ticket</a>.</p>\n\n\n\n<p>A new maintenance release for each branch from 4.7 to 6.7 is now available. If you have sites on these branches and they support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>The latest and only supported version of WordPress remains as 6.8.2. This is being done as a courtesy for sites still running older versions of WordPress. You can <a href=\"https://wordpress.org/wordpress-6.8.2.zip\">download WordPress 6.8.2 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>Special thanks to <a href=\'https://profiles.wordpress.org/desrosj/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>desrosj</a>, <a href=\'https://profiles.wordpress.org/ocean90/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ocean90</a>, <a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a>, <a href=\'https://profiles.wordpress.org/peterwilsoncc/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>peterwilsoncc</a>, <a href=\'https://profiles.wordpress.org/jorbin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jorbin</a>, <a href=\'https://profiles.wordpress.org/estelaris/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>estelaris</a>, and <a href=\'https://profiles.wordpress.org/johnbillion/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>johnbillion</a> for backporting and releasing this update.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18997\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 6.8.2 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2025/07/wordpress-6-8-2-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Jul 2025 15:41:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"minor-releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18903\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:357:\"WordPress 6.8.2 is now available! This minor release includes fixes for 20 Core tickets and 15 Block Editor issues. For a full list of bug fixes, please refer to the release candidate announcement. WordPress 6.8.2 is a short-cycle maintenance release. More maintenance releases may be made available throughout 2025. If you have sites that support [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10720:\"\n<h2 class=\"wp-block-heading\">WordPress 6.8.2 is now available!</h2>\n\n\n\n<p>This minor release includes fixes for <a href=\"https://core.trac.wordpress.org/query?resolution=fixed&amp;milestone=6.8.2&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">20 Core tickets</a> and <a href=\"https://github.com/WordPress/gutenberg/pull/70557\">15 Block Editor issues</a>. For a full list of bug fixes, please refer to the <a href=\"https://make.wordpress.org/core/2025/07/08/wordpress-6-8-2-rc1-is-now-available/\">release candidate announcement.</a></p>\n\n\n\n<p>WordPress 6.8.2 is a short-cycle maintenance release. More maintenance releases may be made available throughout 2025.</p>\n\n\n\n<p>If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>You can <a href=\"https://wordpress.org/wordpress-6.8.2.zip\">download WordPress 6.8.2 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”. For more information on this release, please <a href=\"https://wordpress.org/support/wordpress-version/version-6-8-2\">visit the HelpHub version page</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Dropping security updates for WordPress versions 4.1 through 4.6</h2>\n\n\n\n<p>This is not directly related to the 6.8.2 maintenance release, but <a href=\"https://wordpress.org/news/2025/06/dropping-security-updates-for-wordpress-versions-4-1-through-4-6/\">branches 4.1 to 4.6 had their final release today</a>. These branches won&#8217;t receive any security update anymore.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>WordPress 6.8.2 was led by <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>,&nbsp;<a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a>&nbsp;and&nbsp;<a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a>.</p>\n\n\n\n<p>Special thanks to <a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a>, <a href=\'https://profiles.wordpress.org/sergeybiryukov/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>sergeybiryukov</a>, <a href=\'https://profiles.wordpress.org/mamaduka/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mamaduka</a>, <a href=\'https://profiles.wordpress.org/wildworks/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>wildworks</a> and <a href=\'https://profiles.wordpress.org/jorbin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jorbin</a> for their help on specific release tasks.</p>\n\n\n\n<p>WordPress 6.8.2 would not have been possible without the contributions of the following 96 people. Their asynchronous coordination to deliver maintenance fixes into a stable release is a testament to the power and capability of the WordPress community.</p>\n\n\n\n<p class=\"is-style-wporg-props-medium has-white-color has-midnight-gradient-background has-text-color has-background has-link-color has-normal-font-size wp-elements-2ad7deb15a87fd29427f001e4c18a1ac\"><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/zieladam\">Adam Zieliński</a>, <a href=\"https://profiles.wordpress.org/wildworks\">Aki Hamano</a>, <a href=\"https://profiles.wordpress.org/alexstine\">Alex Stine</a>, <a href=\"https://profiles.wordpress.org/anatolbroder\">Anatol Broder</a>, <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/ankitkumarshah\">Ankit Kumar Shah</a>, <a href=\"https://profiles.wordpress.org/annezazu\">annezazu</a>, <a href=\"https://profiles.wordpress.org/azharderaiya\">Azhar Deraiya</a>, <a href=\"https://profiles.wordpress.org/benjamingosset\">Benjamin Gosset</a>, <a href=\"https://profiles.wordpress.org/bhubbard\">Brandon Hubbard</a>, <a href=\"https://profiles.wordpress.org/kraftbj\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/brhodes\">brhodes</a>, <a href=\"https://profiles.wordpress.org/poena\">Carolina Nymark</a>, <a href=\"https://profiles.wordpress.org/czarate\">Chris Zarate</a>, <a href=\"https://profiles.wordpress.org/courane01\">Courtney Robertson</a>, <a href=\"https://profiles.wordpress.org/talldanwp\">Daniel Richards</a>, <a href=\"https://profiles.wordpress.org/darshitrajyaguru97\">Darshit Rajyaguru</a>, <a href=\"https://profiles.wordpress.org/davidbaumwald\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/dmsnell\">Dennis Snell</a>, <a href=\"https://profiles.wordpress.org/dhruvang21\">Dhruvang21</a>, <a href=\"https://profiles.wordpress.org/dilipbheda\">Dilip Bheda</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/divinenephron\">divinenephron</a>, <a href=\"https://profiles.wordpress.org/dustintechsmith\">dustintechsmith</a>, <a href=\"https://profiles.wordpress.org/ericlewis\">Eric Andrew Lewis</a>, <a href=\"https://profiles.wordpress.org/im3dabasia1\">Eshaan Dabasiya</a>, <a href=\"https://profiles.wordpress.org/estelaris\">Estela Rueda</a>, <a href=\"https://profiles.wordpress.org/eherman24\">Evan Herman</a>, <a href=\"https://profiles.wordpress.org/fabiankaegy\">Fabian Kägy</a>, <a href=\"https://profiles.wordpress.org/faisalahammad\">Faisal Ahammad</a>, <a href=\"https://profiles.wordpress.org/flixos90\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/guddu1315\">Gaurang Dabhi</a>, <a href=\"https://profiles.wordpress.org/mamaduka\">George Mamadashvili</a>, <a href=\"https://profiles.wordpress.org/gernberg\">gernberg</a>, <a href=\"https://profiles.wordpress.org/gziolo\">Greg Ziółkowski</a>, <a href=\"https://profiles.wordpress.org/harshgajipara\">Harsh Gajipara</a>, <a href=\"https://profiles.wordpress.org/helgatheviking\">HelgaTheViking</a>, <a href=\"https://profiles.wordpress.org/abcd95\">Himanshu Pathak</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/JeffPaul\">Jeffrey Paul</a>, <a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/luminuu\">Jessica Lyschik</a>, <a href=\"https://profiles.wordpress.org/jigarpanchal\">Jigar Panchal</a>, <a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/mindctrl\">John Parris</a>, <a href=\"https://profiles.wordpress.org/jonsurrell\">Jon Surrell</a>, <a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/kausaralm\">Kausar Alam</a>, <a href=\"https://profiles.wordpress.org/kishanjasani\">Kishan Jasani</a>, <a href=\"https://profiles.wordpress.org/tyxla\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/matt\">Matt Mullenweg</a>, <a href=\"https://profiles.wordpress.org/pfefferle\">Matthias Pfefferle</a>, <a href=\"https://profiles.wordpress.org/megane9988\">megane9988</a>, <a href=\"https://profiles.wordpress.org/mosescursor\">Moses Cursor Ssebunya</a>, <a href=\"https://profiles.wordpress.org/mukesh27\">Mukesh Panchal</a>, <a href=\"https://profiles.wordpress.org/mwillman1991\">mwillman1991</a>, <a href=\"https://profiles.wordpress.org/bugnumber9\">Nazar Hotsa</a>, <a href=\"https://profiles.wordpress.org/nidhidhandhukiya\">nidhidhandhukiya</a>, <a href=\"https://profiles.wordpress.org/nikunj8866\">Nikunj Hatkar</a>, <a href=\"https://profiles.wordpress.org/oferlaor\">oferlaor</a>, <a href=\"https://profiles.wordpress.org/oglekler\">Olga Gleckler</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/paulstanos\">paulstanos</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/puggan\">puggan</a>, <a href=\"https://profiles.wordpress.org/ravigadhiyawp\">Ravi Gadhiya</a>, <a href=\"https://profiles.wordpress.org/youknowriad\">Riad Benguella</a>, <a href=\"https://profiles.wordpress.org/rollybueno\">Rolly Bueno</a>, <a href=\"https://profiles.wordpress.org/room34\">room34</a>, <a href=\"https://profiles.wordpress.org/sainathpoojary\">Sainath Poojary</a>, <a href=\"https://profiles.wordpress.org/sajjad67\">Sajjad Hossain Sagor</a>, <a href=\"https://profiles.wordpress.org/Sam_a\">sam_a</a>, <a href=\"https://profiles.wordpress.org/sandeepdahiya\">Sandeep Dahiya</a>, <a href=\"https://profiles.wordpress.org/SergeyBiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/shanemuir\">Shane Muirhead</a>, <a href=\"https://profiles.wordpress.org/siliconforks\">siliconforks</a>, <a href=\"https://profiles.wordpress.org/sirlouen\">SirLouen</a>, <a href=\"https://profiles.wordpress.org/sabernhardt\">Stephen Bernhardt</a>, <a href=\"https://profiles.wordpress.org/sukhendu2002\">Sukhendu Sekhar Guria</a>, <a href=\"https://profiles.wordpress.org/karmatosed\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/TobiasBg\">Tobias Bäthge</a>, <a href=\"https://profiles.wordpress.org/wpsmith\">Travis Smith</a>, <a href=\"https://profiles.wordpress.org/ugyensupport\">Ugyen Dorji</a>, <a href=\"https://profiles.wordpress.org/uxl\">uxl</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/whaze\">whaze</a>, <a href=\"https://profiles.wordpress.org/getsyash\">Yash B</a>, <a href=\"https://profiles.wordpress.org/yogeshbhutkar\">Yogesh Bhutkar</a>, and <a href=\"https://profiles.wordpress.org/zunaid321\">Zunaid Amin</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac, <a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation on Slack, in the <a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a> and <a href=\"https://wordpress.slack.com/archives/C080HLPP2Q6\">#6-8-release-leads</a> channels. Need help? Check out the <a href=\"https://make.wordpress.org/core/handbook/\">Core Contributor Handbook</a>.</p>\n\n\n\n<p class=\"has-text-align-right\"><em>Thanks to <a href=\'https://profiles.wordpress.org/estelaris/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>estelaris</a> and <a href=\'https://profiles.wordpress.org/zunaid321/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>zunaid321</a> for proofreading.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18903\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Celebrating Kim Parsell: 2025 WordCamp US Scholarship Applications Open\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"https://wordpress.org/news/2025/07/kim-parsell-2025-wcus-scholarship-applications-open/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 14 Jul 2025 18:57:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18911\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:364:\"The WordPress Foundation is pleased to announce the return of the Kim Parsell Memorial Scholarship for WordCamp US 2025. Applications are being accepted until July 25, 2025. Remembering Kim Parsell Kim Parsell was a dedicated contributor and a beloved member of the WordPress community. Her passion for open source and her welcoming spirit inspired many, [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6224:\"\n<p>The WordPress Foundation is pleased to announce the return of the <strong>Kim Parsell Memorial Scholarship</strong> for WordCamp US 2025. Applications are being accepted until <strong>July 25, 2025</strong>.</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full has-custom-border\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"604\" height=\"370\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/07/wpdocs-team-1.webp?resize=604%2C370&#038;ssl=1\" alt=\"\" class=\"wp-image-18912\" style=\"border-width:25px;border-radius:40px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/07/wpdocs-team-1.webp?w=604&amp;ssl=1 604w, https://i0.wp.com/wordpress.org/news/files/2025/07/wpdocs-team-1.webp?resize=300%2C184&amp;ssl=1 300w\" sizes=\"auto, (max-width: 604px) 100vw, 604px\" /></figure>\n\n\n\n<div class=\"wp-block-group has-off-white-2-background-color has-background is-layout-constrained wp-container-core-group-is-layout-6cbf45de wp-block-group-is-layout-constrained\" style=\"margin-top:48px;margin-bottom:48px;padding-top:24px;padding-bottom:24px\">\n<div class=\"wp-block-columns is-not-stacked-on-mobile is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:2%\"></div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:96%\">\n<h2 class=\"wp-block-heading\">Remembering Kim Parsell</h2>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:40%\">\n<figure class=\"wp-block-image size-full\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"400\" height=\"400\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/07/Kim-parsell-twitter-image-2.jpeg?resize=400%2C400&#038;ssl=1\" alt=\"\" class=\"wp-image-18956\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/07/Kim-parsell-twitter-image-2.jpeg?w=400&amp;ssl=1 400w, https://i0.wp.com/wordpress.org/news/files/2025/07/Kim-parsell-twitter-image-2.jpeg?resize=300%2C300&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/07/Kim-parsell-twitter-image-2.jpeg?resize=150%2C150&amp;ssl=1 150w\" sizes=\"auto, (max-width: 400px) 100vw, 400px\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:60%\">\n<p>Kim Parsell was a dedicated contributor and a beloved member of the WordPress community. Her passion for open source and her welcoming spirit inspired many, both online and in person. Each year at WordCamp US, the WordPress Foundation celebrates Kim’s legacy by supporting contributors who share her commitment and enthusiasm. The Kim Parsell Memorial Scholarship aims to make it easier for deserving community members to attend WordCamp US, reflecting Kim’s belief in making WordPress accessible and inclusive for all.</p>\n</div>\n</div>\n\n\n\n<p style=\"padding-top:var(--wp--preset--spacing--10);padding-bottom:var(--wp--preset--spacing--10)\">If you’re unfamiliar with Kim’s story or her invaluable role in the community, we encourage you to <a href=\"https://us.wordcamp.org/2019/memories-of-kim-parsell/\">read these heartfelt tributes</a> collected from friends and colleagues.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:2%\"></div>\n</div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Scholarship Eligibility</h2>\n\n\n\n<p>This year, a single scholarship will be awarded. To qualify, applicants must:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Identify as a woman</li>\n\n\n\n<li>Be actively involved as a contributor to WordPress</li>\n\n\n\n<li>Have never attended WordCamp US before</li>\n\n\n\n<li>Demonstrate a need for financial support to attend the event</li>\n</ul>\n\n\n\n<p>If you meet these qualifications, we invite you to apply before the July 25 deadline. All applicants will be notified of the decision by August 7, 2025.</p>\n\n\n\n<p>For additional information, visit the <a href=\"https://wordpressfoundation.org/projects/kim-parsell-memorial-scholarship/\">Kim Parsell Memorial Scholarship page</a> hosted by the WordPress Foundation.</p>\n\n\n\n<div class=\"wp-block-group has-off-white-2-background-color has-background is-layout-constrained wp-container-core-group-is-layout-8503c47b wp-block-group-is-layout-constrained\">\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"has-text-align-center has-large-font-size\"><strong>Ready to Apply?</strong></p>\n\n\n\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-align-center wp-element-button\" href=\"https://wordcampcentral.survey.fm/wcus-2025-kim-parsell-scholarship-application\">Submit Your Application Today</a></div>\n</div>\n\n\n\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n</div>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full has-custom-border\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"500\" height=\"333\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/07/kim-jose.jpeg?resize=500%2C333&#038;ssl=1\" alt=\"\" class=\"wp-image-18917\" style=\"border-width:25px;border-radius:40px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/07/kim-jose.jpeg?w=500&amp;ssl=1 500w, https://i0.wp.com/wordpress.org/news/files/2025/07/kim-jose.jpeg?resize=300%2C200&amp;ssl=1 300w\" sizes=\"auto, (max-width: 500px) 100vw, 500px\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Join the Celebration</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Tickets for WordCamp US 2025 are now available—secure yours soon!</li>\n\n\n\n<li>Volunteer applications are open until July 11, 2025</li>\n\n\n\n<li>Interested in supporting the event? Explore our <a>sponsorship opportunities</a></li>\n</ul>\n\n\n\n<p>Help us spread the word about this opportunity and make WordCamp US 2025 even more special.</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18911\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"Introducing WordPress Credits: A New Contribution Internship Program for University Students\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"https://wordpress.org/news/2025/07/introducing-wordpress-credits-a-new-contribution-internship-program-for-university-students/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Jul 2025 16:56:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:9:\"community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:17:\"WordPress Credits\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18913\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:393:\"The WordPress Foundation is proud to launch WordPress Credits, a contribution-focused internship program that brings university students into the heart of the WordPress open source project. While WordPress thrives on contributions from a global volunteer community, many students and newcomers face barriers to entry, such as a lack of structured guidance or real-world experience in [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Isotta Peira\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4712:\"\n<p>The WordPress Foundation is proud to launch WordPress Credits, a contribution-focused internship program that brings university students into the heart of the WordPress open source project. While WordPress thrives on contributions from a global volunteer community, many students and newcomers face barriers to entry, such as a lack of structured guidance or real-world experience in open source projects. This new program is designed to bridge that gap, nurturing future contributors and ensuring WordPress remains innovative, inclusive, and sustainable for years to come.</p>\n\n\n\n<p>The <a href=\"https://gamma.app/docs/EN-WordPress-Credits-vz0k2vr1ulg91qq?mode=doc\">pilot program</a>, developed in partnership with the University of Pisa, was announced on stage at WordCamp Europe 2025 by Matt Mullenweg and Mary Hubbard. Since then, it has attracted interest from students across various fields of study, including humanities, computer science, and communication. Companies in the WordPress ecosystem have also expressed support and interest in contributing to the project. In response to the growing interest from both community members and academic institutions, we are now inviting more universities to join the initiative.</p>\n\n\n\n<p>Open to students from all fields of study, the program blends structured onboarding with a personalized contribution project. Activities are adapted to each student’s degree program and familiarity with WordPress, aiming to develop transferable skills, academic-related competencies, and active participation in the WordPress community. Internship durations may vary depending on the university or educational institution. Some may align with academic semesters (typically 3–4 months), while others, like the University of Pisa, allow students to sign up year-round with a requirement to complete a set number of contribution hours (e.g. 150 hours). Flexible arrangements can be discussed to meet the specific requirements of each institution.</p>\n\n\n\n<p>Foundational Training includes:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>An introduction to open source principles and the WordPress Foundation</li>\n\n\n\n<li>Getting familiar with community tools (Slack, Make blogs, Learn platform, GitHub)</li>\n\n\n\n<li>Setting up a personal WordPress site and publishing content</li>\n</ul>\n\n\n\n<p>Each student will choose a contribution area and design their own personal project within that area. Examples of possible projects include:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Translating interfaces or documentation</li>\n\n\n\n<li>Creating multilingual subtitles for educational videos</li>\n\n\n\n<li>Contributing code or performing testing</li>\n\n\n\n<li>Supporting product development or design</li>\n\n\n\n<li>Writing or editing content</li>\n\n\n\n<li>Assisting with community event organization</li>\n\n\n\n<li>Developing training materials for Learn WordPress</li>\n\n\n\n<li>Creating open source tools</li>\n\n\n\n<li>And much more…<br></li>\n</ul>\n\n\n\n<p>Interns are guided by an experienced mentor specific to their chosen area and supported by a dedicated WordPress Foundation contact person throughout the program. All student contributions, whether code, translations, documentation, or educational materials, will be publicly visible and integrated into official WordPress projects and resources, directly benefiting the wider community.</p>\n\n\n\n<p><strong>Interested universities and educational institutions</strong> interested in participating can reach out by filling <a href=\"https://airtable.com/appIzQKfwTn5dyPVp/shrYvY0CDNIkILIre\">the interest form</a>.</p>\n\n\n\n<p>We also invite companies in the WordPress ecosystem to support this initiative by sponsoring mentors who will guide and empower the next generation of contributors, or by providing tools and resources that help students succeed in their contribution journey.&nbsp;</p>\n\n\n\n<p><strong>If your company is interested in getting involved</strong>, please visit the <a href=\"https://make.wordpress.org/handbook/wordpress-credits-contribution-internship-program/get-involved-company-guide/\">Company Guide</a> to learn more and <a href=\"https://airtable.com/appIzQKfwTn5dyPVp/shrKDkjeUdw8Fof34\">fill out the form</a> to join the program.</p>\n\n\n\n<p><em>By welcoming students, mentors, sponsors, and volunteers into this initiative, we are building a stronger and more connected WordPress community. Each person who takes part, whether they guide a student, share their experiences, provide sponsorship, or simply help spread the word, helps ensure that open source remains vibrant and accessible for all. Together, we are not just supporting individual contributors; we are shaping the future of WordPress and open source itself.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18913\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"WordCamp US 2025: See You in Portland, Oregon!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://wordpress.org/news/2025/06/wordcamp-us-2025-see-you-in-portland-oregon/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 Jun 2025 18:14:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:4:\"WCUS\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18884\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:383:\"WordCamp US 2025 is heading to vibrant Portland, Oregon, from August 26–29, 2025! Join fellow open source enthusiasts, developers, designers, and WordPress professionals from across the United States and around the world for four days of learning, networking, and collaboration at the Oregon Convention Center. Nestled in the Pacific Northwest, Portland is famous for its [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8274:\"\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us-2025-portland.png?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-18885\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us-2025-portland.png?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us-2025-portland.png?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us-2025-portland.png?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us-2025-portland.png?w=1200&amp;ssl=1 1200w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>WordCamp US 2025 is heading to vibrant Portland, Oregon, from August 26–29, 2025! Join fellow open source enthusiasts, developers, designers, and WordPress professionals from across the United States and around the world for four days of learning, networking, and collaboration at the Oregon Convention Center.</p>\n\n\n\n<p>Nestled in the Pacific Northwest, Portland is famous for its creative spirit, lush green spaces, and riverside trails, making it an inspiring backdrop for this year’s WordCamp. Whether building your first site or leading a digital agency, WordCamp US offers something for everyone, all set against the city’s stunning natural scenery.</p>\n\n\n\n<div class=\"wp-block-group has-off-white-background-color has-background is-layout-constrained wp-container-core-group-is-layout-8503c47b wp-block-group-is-layout-constrained\">\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"has-text-align-center has-large-font-size\"><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Tickets are limited—secure yours today!</strong></p>\n\n\n\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-align-center wp-element-button\" href=\"https://us.wordcamp.org/2025/tickets/\">Get your ticket now</a></div>\n</div>\n\n\n\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">What to Expect</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Contributor Day: August 26</h3>\n\n\n\n<p>Kick off your WordCamp US experience by giving back. Contributor Day welcomes all skill levels to collaborate on teams that help make WordPress better, from code to community to documentation. You can make a difference to the project, and build new friendships or rekindle old ones, perhaps even while enjoying views of Portland’s skyline and tree-lined streets.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Main Conference: August 27–29</h3>\n\n\n\n<h4 class=\"wp-block-heading\">Showcase Day &#8211; August 27</h4>\n\n\n\n<p>As part of the main conference, day one will give us a look at project showcases, discover innovative uses of WordPress, see how people push the platform’s boundaries, and get inspired to try something new.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Session Days + Expo Hall &#8211; August 28-29</h4>\n\n\n\n<p>Experience another two days filled with inspiring keynotes, practical sessions, and deep dives into the latest trends in web development, design, content, accessibility, and more. Hear from some of the brightest minds in the WordPress ecosystem and explore topics that get to the heart of what makes WordPress unique. Also, take some time to explore the main floors of WCUS, like the Sponsors Hall.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Networking and Community</h3>\n\n\n\n<p>Meet WordPress friends new and old, exchange ideas with community leaders, and collaborate with people who share your passion for open source. Enjoy daily lunches and a memorable social event, all included with your ticket. Stroll along the Willamette River or explore nearby parks in between sessions.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Venue &amp; Accommodations</h3>\n\n\n\n<p>This year, we’re gathering at the Oregon Convention Center in the heart of Portland—a city known for its vibrant neighborhoods and abundant green spaces. We’ve secured a special hotel block right across the street at the Hyatt Regency Portland for convenient, comfortable lodging during your stay.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f3e2.png\" alt=\"🏢\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></strong> <strong>Oregon Convention Center<br></strong>777 NE Martin Luther King Jr Blvd<br>Portland, OR 97232<br></li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f6cf.png\" alt=\"🛏\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Hyatt Regency Portland</strong><br>375 NE Holladay Street<br>Portland, OR 97232<br><a href=\"https://www.hyatt.com/en-US/group-booking/PDXRP/G-CAMP\">Book your room!</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Registration and Tickets</h2>\n\n\n\n<p>Registration officially kicked off last month. Secure your spot early; tickets are selling quickly.</p>\n\n\n\n<div class=\"wp-block-group has-off-white-background-color has-background is-layout-constrained wp-container-core-group-is-layout-8503c47b wp-block-group-is-layout-constrained\">\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"has-text-align-center has-large-font-size\"><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Tickets are limited—secure yours today!</strong></p>\n\n\n\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-align-center wp-element-button\" href=\"https://us.wordcamp.org/2025/tickets/\">Get your ticket now</a></div>\n</div>\n\n\n\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Ready to Plan Your WordCamp US Experience?</h2>\n\n\n\n<p>Keep checking the <a href=\"https://us.wordcamp.org/2025/\">WordCamp US site</a> for travel tips, to book accommodations, and to watch for the whole event schedule—coming soon! While here, why not plan to take in some of Portland’s scenic hiking trails, bike-friendly streets, or local food scene?</p>\n\n\n\n<p>Stay tuned for updates and announcements on <a href=\"https://make.wordpress.org/marketing/handbook/social-media/\">WordPress social media channels</a>, and join the conversation.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Help Us Spread the Word!</h3>\n\n\n\n<p>Whether attending in person or following along online, share your experience and help welcome others to the WordPress community. Use the #WCUS and #WordPress hashtags and tell your story on social!</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18898\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>Portland is calling—see you at WordCamp US 2025! <img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f332.png\" alt=\"🌲\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18884\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"Dropping security updates for WordPress versions 4.1 through 4.6\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"https://wordpress.org/news/2025/06/dropping-security-updates-for-wordpress-versions-4-1-through-4-6/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Jun 2025 15:26:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18872\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:331:\"As of July 2025, the WordPress Security Team will no longer provide security updates for WordPress versions 4.1 through 4.6. These versions were first released nine or more years ago and over 99% of WordPress installations run a more recent version. The chances this will affect your site, or sites, is very small. If you [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"John Blackbourn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3132:\"\n<p>As of July 2025, the WordPress Security Team will no longer provide security updates for WordPress versions 4.1 through 4.6.</p>\n\n\n\n<p>These versions were first released nine or more years ago and over 99% of WordPress installations run a more recent version. The chances this will affect your site, or sites, is very small.</p>\n\n\n\n<p>If you are unsure if you are running an up-to-date version of WordPress, please log in to your site’s dashboard. Out of date versions will display a notice that looks like this:</p>\n\n\n\n<figure class=\"wp-block-image size-full has-custom-border\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1048\" height=\"122\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/09/WordPress-681-update-notice.png?resize=1048%2C122&#038;ssl=1\" alt=\"Dashboard notice: &quot;WordPress 6.8.1 is available! Please update now.&quot;\" class=\"has-border-color has-luminous-vivid-amber-border-color wp-image-18873\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/09/WordPress-681-update-notice.png?w=1048&amp;ssl=1 1048w, https://i0.wp.com/wordpress.org/news/files/2022/09/WordPress-681-update-notice.png?resize=300%2C35&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2022/09/WordPress-681-update-notice.png?resize=1024%2C119&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2022/09/WordPress-681-update-notice.png?resize=768%2C89&amp;ssl=1 768w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>The version you are running is displayed in the bottom of the “At a Glance” section of the dashboard.</p>\n\n\n\n<figure class=\"wp-block-image size-large has-custom-border\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"281\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/09/at-a-glance-wp-4141.png?resize=1024%2C281&#038;ssl=1\" alt=\"At a glance widget showing a site running WordPress 4.1.41\" class=\"has-border-color has-cyan-bluish-gray-border-color wp-image-18875\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/09/at-a-glance-wp-4141.png?resize=1024%2C281&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2022/09/at-a-glance-wp-4141.png?resize=300%2C82&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2022/09/at-a-glance-wp-4141.png?resize=768%2C211&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2022/09/at-a-glance-wp-4141.png?resize=1536%2C421&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2022/09/at-a-glance-wp-4141.png?w=1798&amp;ssl=1 1798w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>As a reminder, the only <em>actively</em> supported version of WordPress is the most recent one. Security updates are only backported to older branches as a courtesy.</p>\n\n\n\n<p>The Make WordPress Security blog has further details about <a href=\"https://make.wordpress.org/security/2025/06/18/security-updates-will-cease-for-wordpress-versions-4-1-through-4-6/\" data-type=\"link\" data-id=\"https://make.wordpress.org/security/2025/06/18/security-updates-will-cease-for-wordpress-versions-4-1-through-4-6/\">the process to end support</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18872\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:12:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Mon, 03 Nov 2025 09:55:22 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:37:\"Accept-Encoding, accept, content-type\";s:25:\"strict-transport-security\";s:12:\"max-age=3600\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Tue, 28 Oct 2025 15:58:13 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:2:\"br\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 1\";}}s:5:\"build\";i:1727736620;s:21:\"cache_expiration_time\";i:1762206868;s:23:\"__cache_expiration_time\";i:1762206868;}", "off");
INSERT INTO `wp2n_options` VALUES("185", "_transient_timeout_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3", "1762206868", "off");
INSERT INTO `wp2n_options` VALUES("186", "can_compress_scripts", "1", "on");
INSERT INTO `wp2n_options` VALUES("187", "_transient_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3", "1762163668", "off");
INSERT INTO `wp2n_options` VALUES("188", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1762206869", "off");
INSERT INTO `wp2n_options` VALUES("189", "_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:112:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"Matt: Chop Wood, Carry Water\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150450\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://ma.tt/2025/11/chop-carry/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:461:\"<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Before enlightenment; chop wood, carry water. After enlightenment; chop wood, carry water.</p>\n</blockquote>\n\n\n\n<p><a href=\"https://www.sloww.co/enlightenment-chop-wood-carry-water/\">Kyle Kowalski has an amazing blog post exploring many aspects of this Zen Kōan</a>, including some diversions into David Foster Wallace&#8217;s legendary commencement speech, This is Water.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 02 Nov 2025 20:57:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Matt: Creed Update\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150444\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ma.tt/2025/11/creed-update/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1682:\"<p>This week, the <a href=\"https://automattic.com/creed/\">Automattic Creed</a> received its first-ever update, which I&#8217;ll describe as a minor point upgrade. This is the sentence before and after.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p id=\"p-2\">I am in a marathon, not a sprint, and no matter how far away the goal is, the only way to get there is by putting one foot in front of another every day.</p>\n</blockquote>\n\n\n\n<p>Is now.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p id=\"p-4\">I am in a marathon, not a sprint; no matter how far away the goal is, the only way to get there is to put one foot in front of the other every day.</p>\n</blockquote>\n\n\n\n<p>As I wrote earlier in our internal <a href=\"https://wordpress.com/p2/\">P2s</a>, &#8220;Always great to bury a gerund.&#8221; And now we have a semicolon! It&#8217;s all quite exciting. For the backstory, please read <a href=\"https://ma.tt/2011/09/automattic-creed/\">Why Your Company Should Have a Creed</a>. I said in 2011 &#8220;I’m sure that it will evolve in the future&#8221; but I didn&#8217;t expect it to be 14 years before the first revision. </p>\n\n\n\n<p>Internally at Automattic we&#8217;ve debated updating the Creed in dozens of conversations and blog posts, usually in the context of adding a sentence, which I still hope will happen in a future version. But this is a minor update. We&#8217;ll see when Creed 2.0 happens.</p>\n\n\n\n<p>The private Automattic intranet is one of the most delightful things about working there, <a href=\"https://automattic.com/work-with-us/\">which you may consider as well</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 02 Nov 2025 02:24:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Matt: Wayback Machine Joint\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150430\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://ma.tt/2025/10/wayback/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:893:\"<p><a href=\"https://automattic.com/\">Automattic</a> has been working with the <a href=\"https://archive.org/\">Internet Archive</a> to develop a plugin to combat link rot, <a href=\"https://wordpress.org/plugins/internet-archive-wayback-machine-link-fixer/\">and it&#8217;s a plugin I&#8217;d encourage you to install</a>. As the plugin says:</p>\n\n\n\n<p>When a linked page disappears, the plugin helps preserve your user experience by redirecting visitors to a reliable archived version. It also works proactively by archiving your own posts every time they’re updated, creating a consistent backup of your content’s history.</p>\n\n\n\n<p>I&#8217;ve been doing this manually on my old archives, fixing broken links and tending the garden. But we can make it all automatic. <img alt=\"🙂\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f642.png\" style=\"height: 1em;\" /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 01 Nov 2025 04:33:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"Gutenberg Times: Plugin Security, Divi to Gutenberg, Internet Archive, Gutenberg 21.9 and 22 — Weekend Edition 347\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=42439\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"https://gutenbergtimes.com/plugin-security-divi-to-gutenberg-internet-archive-weekend-edition-347/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:30233:\"<p>Hi there, </p>\n\n\n\n<p>On All Saints Day, November 1st, we honor dear people who passed. I wanted to take the occasion and point you to the <a href=\"https://wordpress.org/remembers/\"><strong>WordPress Remembers</strong></a> page where accomplished contributors who passed have a permanent home.  Their work lives on in every new story, every new website, and every new idea made possible by WordPress<em>.</em></p>\n\n\n\n<p>And it&#8217;s a long newsletter today with lots of great blog posts, videos and tutorials. I also included two ecosystem-related developments that would be normally out of scope for this niche newsletter. They have huge implications for the security and longevity of WordPress, and I definitely thought you shouldn&#8217;t miss. </p>\n\n\n\n<p>Have a lovely weekend,</p>\n\n\n\n<p>Yours, <img alt=\"💕\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f495.png\" style=\"height: 1em;\" /><br /><em>Birgit</em></p>\n\n\n\n<p>PS: Voting for the <a href=\"https://thewpweekly.com/awards/\"><strong>WPAwards</strong></a> already started. Vote for your WordPress favorites, hopefully among them the blog <strong>Gutenberg Times</strong> and the podcast <strong>Gutenberg Changelog. </strong>Hat Tip to Davinder Singh Kainth for putting the WPAwards together every year.</p>\n\n\n<section class=\"wp-block-newsletterglue-group\" style=\"padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;\">\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<nav class=\"wp-block-table-of-contents\"><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/plugin-security-divi-to-gutenberg-internet-archive-weekend-edition-347/#wordpress-ecosystem-updates\">WordPress Ecosystem updates</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/plugin-security-divi-to-gutenberg-internet-archive-weekend-edition-347/#0-word-press-release-information\">Developing Gutenberg and WordPress</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/plugin-security-divi-to-gutenberg-internet-archive-weekend-edition-347/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/plugin-security-divi-to-gutenberg-internet-archive-weekend-edition-347/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/plugin-security-divi-to-gutenberg-internet-archive-weekend-edition-347/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor.</a></li></ol></nav>\n</div></div>\n</section>\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\"></div>\n\n\n<h2 class=\"wp-block-heading\" id=\"wordpress-ecosystem-updates\">WordPress Ecosystem updates</h2>\n\n\n\n<p><a href=\"https://x.com/davidperezmk\"><strong>David Perez</strong></a>, a Hostinger sponsored contributor, posted a new milestone from the Plugins Review team that will have broader impact throughout the WordPress ecosystem: <a href=\"https://make.wordpress.org/plugins/2025/10/29/plugin-check-plugin-now-creates-automatic-security-reports-update/\"><strong>The Plugin Check Plugin now creates automatic security reports after each plugin update</strong></a>. It reports on the update of the Plugin Check plugin that not only screens new plugin submissions but also expands the screening to subsequent versions of plugins for security, compatibility, and compliance. </p>\n\n\n\n<p>Currently, the team evaluates internal information and sends reports to authors as needed. They observe PCP behavior during updates for refinement. After this phase, automated security reports will be emailed to authors right after plugin updates. </p>\n\n\n\n<p>With Plugins accounting for <a href=\"https://www.securityweek.com/8000-new-wordpress-vulnerabilities-reported-in-2024/\">96% of WordPress vulnerabilities in 2024</a>, this increased scrutiny on the WordPress plugins repository submissions will have a huge impact on the health of the whole WordPress ecosystem. And it will make the web a better place. </p>\n\n\n\n<p><strong>Rae Morey</strong>, The Repository, has the details in her report: <a href=\"https://www.therepository.email/wordpress-plugins-team-rolls-out-automatic-security-scans-for-all-plugin-updates\"><strong>WordPress Plugins Team Rolls Out Automatic Security Scans for All Plugin Updates</strong></a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>The second development is a plugin to eliminate link rot on the internet and was brought to you by the <a href=\"https://archive.org/\"><strong>Internet Archive</strong></a>&#8211; <em>&#8220;a non-profit library of millions of free texts, movies, software, music, websites, and more.&#8221;</em> It also runs the <a href=\"https://web.archive.org/web/\">Wayback-Machine</a>, surfacing previous version of websites.  The plugin <a href=\"https://wordpress.org/plugins/internet-archive-wayback-machine-link-fixer/\"><strong>Internet Archive Wayback Machine Link Fixer</strong></a> made its debut in the WordPress repository. It&#8217;s came to pass in a collaboration between the Internet Archive and Automattic&#8217;s Special Projects team. </p>\n\n\n\n<p><strong>Matt Mullenweg</strong> wrote on <a href=\"https://ma.tt/2025/10/wayback/\">his blog</a>, &#8220;When a linked page disappears, the plugin helps preserve your user experience by redirecting visitors to a reliable archived version. It also works proactively by archiving your own posts every time they’re updated, creating a consistent backup of your content’s history.&#8221;</p>\n\n\n\n<p>The plugin is free, you do need a free account on the Internet Archive and obtain API keys to connect your site to the Internet Archive, on step 2 and 3 you&#8217;ll have to make some addtional decision.  </p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img alt=\"\" class=\"wp-image-42572\" height=\"470\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/11/Screenshot-2025-11-01-at-10.53.50.png?resize=575%2C470&#038;ssl=1\" width=\"575\" /></figure>\n\n\n\n<p>As a side note, scrolling through Gutenberg Times history on the Wayback machine is fascinating. I am person you lives solidly in the moment and often forgets what happened in the past. (or it&#8217;s just old age, don&#8217;t say it). I am working on a block theme for the site, and going back to previous versions of the site helps to educate the future. Anyway, back to block editor stuff and more. </p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p><strong>WordPress 6.9 Beta 2 </strong>was released this week. Release coordinator <a href=\"https://x.com/rane_akshaya\"><strong>Akshaya Rane</strong></a> has the details in the <a href=\"https://wordpress.org/news/2025/10/wordpress-6-9-beta-2/\">WordPress news post</a>. A description of what this next version will bring is available in the announcement of <a href=\"https://make.wordpress.org/core/2025/10/21/wordpress-6-9-beta-1/\">the Beta 1 release</a>. </p>\n\n\n\n<p>Release Test co-lead, <strong>Krupa Nanda</strong> posted great instructions on how you can <a href=\"https://make.wordpress.org/test/2025/10/21/help-test-wordpress-6-9/\"><strong>Help test the Beta 1 release of WordPress 6.9 </strong></a>. It’s the best way to learn how to use the new features and report quirks and bugs back to the contributors, so they can be fixed before Release Candidate 1 which is scheduled for November 11. </p>\n\n\n\n<p>The <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v22.0.0-rc.1\"><strong>Gutenberg 22.0 RC 1</strong></a> is now available for testing. It contains 53 Bug fix PRs that are backported to WordPress Core and will make it into WordPress 6.9, too. <br /><a href=\"https://make.wordpress.org/core/2025/10/21/wordpress-6-9-beta-1/\"></a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Hector Prieto </strong>published the release post for Gutenberg 21.9 version. He highlighted: </p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2025/10/28/gutenberg-21-9-october-22/#all-the-blocks\">All the blocks!</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/10/28/gutenberg-21-9-october-22/#direct-drag-and-drop\">Direct drag and drop</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/10/28/gutenberg-21-9-october-22/#dataviews-customization-persistence\">DataViews customization persistence</a></li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"Math block coming to WordPress 6.9 \" class=\"wp-image-42540\" height=\"330\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/11/Screenshot-2025-10-31-at-17.54.27.png?resize=652%2C330&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p><img alt=\"🎙\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f399.png\" style=\"height: 1em;\" /> The latest episode is <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-123-wordpress-6-9-and-gutenberg-21-9/\">Gutenberg Changelog #123 – WordPress 6.9 and Gutenberg 21.9</a> with Isabel Brison, core contributor. </p>\n\n\n\n<figure class=\"wp-block-image size-full is-style-no-vertical-margin\"><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-123-wordpress-6-9-and-gutenberg-21-9/\"><img alt=\"\" class=\"wp-image-42384\" height=\"185\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/Screenshot-2025-10-23-at-17.20.50.png?resize=652%2C185&#038;ssl=1\" width=\"652\" /></a></figure>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-rich is-provider-pocket-casts wp-block-embed-pocket-casts\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div></div></div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>The Editorial Staff at <em>WPBeginner</em> already let you know <a href=\"https://www.wpbeginner.com/news/whats-coming-in-wordpress-6-9-features-and-screenshots/\"><strong>What’s Coming in WordPress 6.9? (Features and Screenshots)</strong></a>. They highlight block-level Notes for collaborative feedback, block visibility controls to hide content from front-end visitors, and improved template management across theme switches. New blocks include Accordion, Terms Query, Math, and Time to Read, alongside enhancements like text-fitting typography and a dashboard-wide Command Palette. Performance gains include on-demand block-style loading, faster emoji detection, and optimized cron execution. The foundation for AI workflows arrives through the Abilities API, enabling machine-readable WordPress capabilities for secure automation.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p><strong>Amadeu Arderiu</strong>, co-founder of Ploogins and explorer of all things AI and WordPress, was interviewed by <strong>Nathan Wrigley</strong> on the WPBuilds podcast episode 443. They discussed <a href=\"https://wpbuilds.com/2025/10/30/443-ai-experiments-in-wordpress-a-plugin-search-engine-customer-support-bots-and-block-editor-integration/\"><strong>AI-powered WordPress projects: a smart plugin search, an AI website chatbot, and AI-driven block editor tools</strong></a>. In the chat they touched on three tools: </p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong><a href=\"https://ploogins.com/\">Ploogins</a></strong> &#8211; a natural language search engine for WordPress plugins. Just tell it the functionality you need and it gives a list of free and premium plugins.</li>\n\n\n\n<li><strong><a href=\"https://join.chat/en/ai/)\">Joinchat</a></strong>, a plugin known for its iconic floating WhatsApp button on countless WordPress sites. This chatbot answers user questions using only the content from your site,  some setting to fine-tune the scope. </li>\n\n\n\n<li><strong><a href=\"https://gutenberg.suggerence.com/\">Suggerence</a></strong>, an experiment that places conversational AI directly into the Gutenberg block editor. A site owner can simply describe a task and the robot executes. Example: &#8220;Create a hero section with a button&#8221;. </li>\n</ul>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-rich is-provider-pocket-casts wp-block-embed-pocket-casts\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>I am going to miss the steady creation of fun blocks via Automattic&#8217;s Telex. This week&#8217;s <strong><a href=\"https://blocktober.fun/\">Blocktober.fun</a></strong> creations are also the last ones on the site.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://blocktober.fun/trick-or-treat/\">Trick or treat</a></li>\n\n\n\n<li><a href=\"https://blocktober.fun/filter-table/\">Filter Table</a></li>\n\n\n\n<li><a href=\"https://blocktober.fun/bar-chart/\">Bar chart</a></li>\n\n\n\n<li><a href=\"https://blocktober.fun/checklist/\">Checklist</a></li>\n\n\n\n<li><a href=\"https://blocktober.fun/blogroll/\">Blogroll</a></li>\n</ul>\n\n\n\n<p><strong>Rae Morey</strong>, The Repository, reported <strong><a href=\"https://www.therepository.email/blocktober-wraps-up-as-telex-inspires-a-wave-of-wordpress-experimentation\">Blocktober Wraps Up as Telex Inspires a Wave of WordPress Experimentation</a>.</strong> Tammie Lister&#8217;s daily block-a-day challenge has become part of a growing wave of Telex-powered creativity, showing how AI can make building in WordPress feel playful again. </p>\n\n\n\n<p><a href=\"https://telex.automattic.ai/\">Telex, Automattic&#8217;s experimental AI tool,</a> enables anyone to build custom Gutenberg blocks using natural language prompts, generating downloadable plugins through a chat-style interface. The tool sparked developer enthusiasm with shared creations ranging from summary generators to specialized calculators.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://www.elegantthemes.com/gallery/divi/\">Divi</a> by Elegant Themes</strong> has been around for ages with roughly a million users. This month I came across two blog posts from agencies about moving from Divi to Gutenberg and the block editor. Two approaches with the same outcome. </p>\n\n\n\n<p><strong>Johanne Courtright</strong> shared her team&#8217;s approach in <a href=\"https://groundworx.dev/blog/why-i-dont-migrate-divi-sites-i-rebuild-them/\"><strong>Why I Don’t Migrate Divi Sites (I Rebuild Them)</strong></a>, arguing that rebuilding Divi sites with Gutenberg is faster and cheaper than migration. Divi&#8217;s proprietary format traps users in technical debt and poor performance. Migration plugins, while available, result in messy conversions that still require manual layout rebuilding. Clean rebuilds uphold content integrity and design patterns, enabling faster site delivery within 3-4 weeks versus 6-8 weeks of migration difficulties.</p>\n\n\n\n<p>In his post <a href=\"https://developress.io/divi-to-gutenberg-migration-2025-step-by-step-guide/\"><strong>Divi to Gutenberg Migration 2025 – Step by Step Guide</strong></a>, <strong>Piotr Kochanowski</strong> at DevelopPress outlines a migration strategy using Divi 5&#8217;s block-like format and WordPress 6.8+&#8217;s features. The guide highlights pre-migration audits, staging environments, and page-by-page transitions through the Divi Layout Block. Key steps include design-system extraction, template rebuilding, and SEO parity verification. Migrations for standard 20–40 page sites typically take 1–3 weeks, while complex projects may require 4–8 weeks.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Cheyne Klein</strong>, Happiness Engineer at Automattic, held an online workshop on <em>Learn WordPress</em> on <a href=\"https://wordpress.tv/2025/10/27/building-top-level-menus-sub-menus/\"><strong>Building top-level menus &amp; sub-menus</strong></a>. You&#8217;ll learn the two main ways to create them in WordPress — the Navigation block and the Classic Menu Editor.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"WordPress TV cover for Building Top-Level Menus &amp; Sub-Menus in WordPress\" class=\"wp-image-42569\" height=\"366\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/11/Screenshot-2025-10-31-at-19.03.02.png?resize=652%2C366&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<p><strong>Benjamin Intal</strong>, Stackable, <a href=\"https://x.com/bfintal/status/1984511469237739592\">announced</a> the new version (1.3.0) of the <a href=\"https://wordpress.org/plugins/interactions/\"><strong>Interactions</strong></a> plugin which gives you controls to add animations and interactions to your site. He lists </p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>54 Pre-made Interactions </li>\n\n\n\n<li>DIY Interaction Builder </li>\n\n\n\n<li>GSAP-level performance </li>\n\n\n\n<li>Hero reveals, parallax images, scroll animations &amp; more</li>\n</ul>\n\n\n\n<p><em>GSAP-level performance&#8221; refers to the high-speed, smooth, and efficient animations of GreenSock Animation Platform (GSAP). </em></p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://wordpress.org/plugins/interactions/\"><img alt=\"Screenshot of the Interactions plugin \" class=\"wp-image-42586\" height=\"409\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/11/Screenshot-2025-11-01-at-11.58.06.png?resize=652%2C409&#038;ssl=1\" width=\"652\" /></a></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p><strong>Justin Tadlock</strong> dives into <a href=\"https://developer.wordpress.org/news/2025/10/styling-accordions-in-wordpress-6-9/\"><strong>Styling accordions in WordPress 6.9</strong></a> with you! This guide is here to help you adapt the design to your or your clients needs. You&#8217;ll learn how to apply styling via theme.json, style variations and patterns. </p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img alt=\"\" class=\"wp-image-42554\" height=\"414\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/11/Screenshot-2025-10-31-at-19.01.18.png?resize=652%2C414&#038;ssl=1\" width=\"652\" /></figure>\n\n\n<div class=\"ng-block-fa6995409634a4bd wp-block-newsletterglue-text ng-block\" style=\"color: #666666;\" width=\"100%\"><div><div><div align=\"none\" class=\"ng-block-td\" style=\"font-size: 16px; font-family: Helvetica; line-height: 1.6; font-weight: normal; padding-top: 8px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; text-align: none; color: #666666;\"><p></p></div></div></div></div>\n\n<section class=\"wp-block-newsletterglue-callout undefined not-color-set\" style=\"border-color: #f9f9e5; border-radius: 22px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f9f9e5;\">\n<p><strong> <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" rel=\"noreferrer noopener\" target=\"_blank\">&#8220;Keeping up with Gutenberg &#8211; Index 2025&#8221;</a> </strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. The previous years are also available: <strong><strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">2020</a> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/\">2021</a></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/\">2022</a></strong></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023\">2023</a></strong> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2024/\"><strong>2024</strong></a></p>\n</section>\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor.</h2>\n\n\n\n<p>On his personal blog, <strong>Riad Benguella</strong>, lead developer on the Gutenberg project, wrote about <a href=\"https://riad.blog/2025/10/25/debugging-wordpress-scripts-and-styles/\"><strong>Debugging WordPress Scripts and Styles</strong></a>. He introduced a <a href=\"https://gist.github.com/youknowriad/e5854d6c602c73dec260d56a2783408a\">vibe-coded tool</a> addressing increased JavaScript and CSS complexity in WordPress admin interfaces and editors. The tool reveals uncompressed file sizes, explicit enqueueing status, ancestor dependencies, and direct parent scripts. Users access it by placing the file in plugins and appending <code>?debug_script=true</code> to page URLs. Benguella recommends <a href=\"https://wordpress.org/plugins/query-monitor/\">Query Monitor</a> by John Blackbourn for comprehensive debugging solutions.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Shani Bannerjee</strong> takes you on the journey to <a href=\"https://developer.woocommerce.com/2025/10/30/understanding-the-interactivity-api-driven-future-for-woocommerce-blocks/\"><strong>Understand the Interactivity API-driven future for WooCommerce Blocks</strong></a>, explaining how this hybrid approach merges server-side PHP robustness with client-side JavaScript responsiveness. The API enables seamless interactions—cart updates, real-time filtering, interactive galleries—while maintaining block editor integrity. Product Collection, Product Filters, Product Gallery, Add to Cart Options, and MiniCart already implement it. Future WooCommerce blocks adopt Interactivity API from inception. Development shifts toward store-based state management and community-driven extensibility patterns.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Earlier this month, <strong>JuanMa Garrido</strong> published the monthly roundup post <a href=\"https://developer.wordpress.org/news/2025/10/whats-new-for-developers-october-2025/\"><strong>What’s new for developers? (October 2025)</strong></a> on the WordPress Developer Blog.  If you missed it or you&#8217;d rather watch a video, Ryan Welcher goes over the post in this latest video <strong><a href=\"https://www.youtube.com/watch?v=0bflhPziNMU&amp;t=12s\">What’s New for WordPress Developers – October 2025</a></strong> on YouTube. In either format it&#8217;s not a post to miss.  </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Tammie Lister</strong> shared in her blog post <strong><a href=\"https://binatethoughts.com/abilities-explorer/\">Abilities Explorer</a></strong>  &#8220;The Abilities API is coming to WordPress 6.9 and I have brewed up a little tool to show what abilities you have on your site loaded in core, themes or plugins. It&#8217;s very freshly brewed so sip cautiously&#8221; she wrote. The experimental plugin visualizes available abilities by origin, enabling testing and detailed inspection. Built rapidly with Claude and Cursor as a learning exercise, it aims to help developers discover and understand WordPress&#8217;s emerging Abilities API registry while surfacing potential gaps in site functionality. The Abilities Explorer lives just on <a href=\"https://github.com/karmatosed/abilitiesexplorer\">GitHub</a>. Check it out. </p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img alt=\"Screenshot of the Abilities Explorer for WordPress\" class=\"wp-image-42548\" height=\"332\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/11/Abilities-Explorer.png?resize=652%2C332&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<p>In this week&#8217;s stream <a href=\"https://www.youtube.com/watch?v=iT3Wjwc5-Po\"><strong>Multitasking with GitHub Copilot,</strong></a> <strong>Jonathan Bossenger</strong> attempts to update two repositories simultaneously. He uses the GitHub Copilot Coding Agent to implement the latest Abilities API and MCP adapter versions. He walks through debugging issues with GitHub Copilot. He covers setting up categories for abilities and testing local environments and tackles real-time coding problems. He leverages AI for documentation and updates. Bossenger also made his <a href=\"https://github.com/jonathanbossenger/wordpress-plugin-copilot-instructions\"><strong>WordPress Plugin GitHub Copilot Instructions</strong></a> publicly available on GitHub to give you a head start. </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<p>In his livestream, <strong>Ryan Welcher</strong> was<strong> <a href=\"https://www.youtube.com/watch?v=YmOrpp8ygbA\" rel=\"noreferrer noopener\" target=\"_blank\">Using every Interactivity API feature in one site</a></strong>. He took a deep dive into the Interactivity API as he wanted to get back up to speed and build something that uses every directive and feature it offers.</p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<p><br /></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n<section class=\"wp-block-newsletterglue-callout undefined not-color-set\" style=\"border-color: #eeeeee; border-radius: 26px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f3efe9;\">\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. </p>\n\n\n\n<p>Now also available via <a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href=\"mailto:pauli@gutenbergtimes.com\">Email me </a>with your experience</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n</section>\n\n\n<p class=\"has-text-align-center has-small-font-size\"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, <br />send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n<section class=\"wp-block-newsletterglue-group\" style=\"padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;\">\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n<form action=\"https://gutenbergtimes.com/feed/\" autocomplete=\"on\" class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\" style=\"margin-bottom: 25px;\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input autocomplete=\"email\" class=\"ngl-form-input-text\" id=\"ngl_email\" name=\"ngl_email\" required=\"required\" style=\"border-radius: 21px;\" type=\"email\" /></div></div><button class=\"ngl-form-button\" style=\"background-color: #005075; border-color: #005075; border-width: 1px; border-style: solid; color: #ffffff; border-radius: 21px;\" type=\"submit\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too, and won&#8217;t give your email address to anyone <br />except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"><svg fill=\"none\" height=\"24\" stroke=\"#fff\" stroke-width=\"2\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><polyline points=\"20 6 9 17 4 12\"></polyline></svg></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input id=\"ngl_list_id\" name=\"ngl_list_id\" type=\"hidden\" value=\"26f81bd8ae\" /><input id=\"ngl_double_optin\" name=\"ngl_double_optin\" type=\"hidden\" value=\"yes\" /></form>\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n</section>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 01 Nov 2025 00:07:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Matt: 50k Bounty\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150420\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://ma.tt/2025/10/50k-bounty/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:198:\"<p>For smart, enterprising hackers <a href=\"https://blog.beeper.com/2025/10/28/build-a-beeper-bridge/\">Beeper is offering bounties of up to $50,000 for people who create open source bridges</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Oct 2025 15:51:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"Open Channels FM: Episode 700 and The Biggest Lesson Learned With a Rebrand\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=111766\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://openchannels.fm/episode-700-and-the-biggest-lesson-learned-with-a-rebrand/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"As we hit 700 episodes, BobWP catches us up on the rebrand.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Oct 2025 12:24:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Tammie Lister: Abilities explorer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://binatethoughts.com/?p=2466\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://binatethoughts.com/abilities-explorer/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3419:\"<p>WordPress 6.9 is coming and with it a few Core AI goodies including the Abilities API. </p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p><a href=\"https://make.wordpress.org/ai/2025/07/17/abilities-api/\" rel=\"noreferrer noopener\" target=\"_blank\">New Abilities API</a>: A unified registry of callable WordPress capabilities with defined inputs and outputs, built for AI integrations and developer automation.</p>\n</blockquote>\n\n\n\n<p>This has a lot of potential for use, however in order to start that exploring, being aware of what plugins, themes and even core abilities exist is useful. That thinking took me on an adventure which saw the creation of the Abilities Explorer.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The what?</h2>\n\n\n\n<p>The Abilities Explorer is a simple plugin that shows the abilities on your site. It loads a page that summaries and splits into where the origin of the ability comes from.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"\" class=\"wp-image-2467\" height=\"521\" src=\"https://binatethoughts.com/wp-content/uploads/2025/10/CleanShot-2025-10-29-at-16.58.34@2x-1024x521.png\" width=\"1024\" /></figure>\n\n\n\n<p>Once you see the abilities you can do a few things with them to discover more:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Test: </strong>Invoke Ability and Validate Input.</li>\n\n\n\n<li><strong>View details</strong>: Description and Output.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"\" class=\"wp-image-2473\" height=\"691\" src=\"https://binatethoughts.com/wp-content/uploads/2025/10/CleanShot-2025-10-29-at-17.25.30@2x-1024x691.png\" width=\"1024\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">The why?</h2>\n\n\n\n<p>Abilities are great, but it’s a new feature and this tool aims to both surface what is available on your site and also allow learning. I am not aiming to have a full on tool at this point, this was created rapidly as part of my own learning process. </p>\n\n\n\n<p>There is no real intention beyond experimentation. Maybe it will help you find out when something isn’t firing, maybe you can be more knowledgeable about what is loading and isn’t. Maybe you just are able to step outside code and discover how simple and cool abilities are.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The how</h2>\n\n\n\n<p>I sat down with Cursor and spent some time learning myself about abilities, working with the prompts of Claude and also iterating. This got me to a rapid v1 which I have today and now I am releasing. I strongly believe in this approach to get ideas out but I am not suggesting this is ready for production, this is an experiment.</p>\n\n\n\n<p>It’s very freshly brewed so there likely are code dragons and things to improve. I will iterate though and already want to work on adding seeing where issues might be and JSON documentation.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The where?</h2>\n\n\n\n<p>The Abilities Explorer lives just on <a href=\"https://github.com/karmatosed/abilitiesexplorer\">GitHub</a>. I have also made it public, so enjoy use as will and if others find it useful that rocks.</p>\n\n\n\n<p>Props for early feedback, encouragement and reviews go to <a href=\"https://jonathanbossenger.com/\">Jonathan Bossenger</a>, <a href=\"https://jonathanwold.com/\">Jonathan Wold</a> and <a href=\"https://sirvelia.com/\">Amadeu Arderiu</a>. Ideas are great but having them checked by humans helps us release them.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Oct 2025 17:16:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"binatethoughts.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Matt: Haiku\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150412\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://ma.tt/2025/10/haiku/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:624:\"<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Live oaks reach branches<br />Sunlight graces every leaf<br />With gentle wisdom</p>\n</blockquote>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"\" class=\"wp-image-150413\" height=\"453\" src=\"https://i0.wp.com/ma.tt/files/2025/10/IMG_0461-1024x768.jpeg?resize=604%2C453&#038;quality=89&#038;ssl=1\" width=\"604\" /></figure>\n\n\n\n<p>Inspired <a href=\"https://x.com/photomatt/status/1983560736464134282\">by the not-haiku on my ITO EN tea</a>. (BTW the <a href=\"https://automattic.com/\">Automattic home page is all haiku since 2009</a>.)</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Oct 2025 16:09:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"WPTavern: #191 – Arnas Donauskas on AI-Powered Troubleshooting for Websites\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=200324\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://wptavern.com/podcast/191-arnas-donauskas-on-ai-powered-troubleshooting-for-websites\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:45496:\"<details>Transcript<div>\n<p>[00:00:19] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case how AI is taking on the burden of troubleshooting website issues, and making suggestions for improvements.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox and use the form there.</p>\n\n\n\n<p>So on the podcast today we have Arnas Donauskas. Arnas is a product manager at Hostinger, with over five years of experience in the web hosting industry. His journey began during college while working on his bachelor&#8217;s degree, when he needed to create a website and discovered WordPress as a beginner.</p>\n\n\n\n<p>His first foray into website building sparked his interest in the industry, eventually leading him to a career where he now develops products that help others launch their own online presence. Recently he&#8217;s been working with a team tasked with delivering tools and improvements to WordPress users to ease their journey on starting and maintaining websites.</p>\n\n\n\n<p>In this episode, Arnas shares insights from his presentation at WordCamp US in Portland, Oregon, where he discussed the future of fixing and optimizing websites with AI. For many WordPress users, managing site performance and troubleshooting errors can be time consuming and complex. Arnas and his team have been developing AI based solutions that not only help onboard new clients by automating website creation, but also proactively monitor and remediate website issues as they happen.</p>\n\n\n\n<p>We get into the details of how Hostinger&#8217;s AI tools identify, and automatically fix, critical website errors such as HTTP response issues, and how they&#8217;re pushing site optimizations through automated performance enhancements.</p>\n\n\n\n<p>Arnas explains the engineering challenges involved, the current state of success with automated fixes, and how user feedback is shaping the roadmap for new features like SEO analysis and accessibility improvements. He provides a behind the scenes look at how Hostinger tests and iterates on AI models, what kind of data is fed to those systems, and how the team balances automation with user control.</p>\n\n\n\n<p>If you are curious about how artificial intelligence is transforming WordPress hosting and site management, and what this means for the future of the web, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Arnas Donauskas.</p>\n\n\n\n<p>I am joined on the podcast by Arnas Donauskas Hello.</p>\n\n\n\n<p>[00:03:41] <strong>Arnas Donauskas:</strong> Hello. Thanks for having me today.</p>\n\n\n\n<p>[00:03:43] <strong>Nathan Wrigley:</strong> You are so welcome. We&#8217;re here at WordCamp US in Portland, Oregon. It is day two of the, kind of the conference, but it&#8217;s the first day of presentations and things like that. You are one of the presenters, and during the presentation you are going to be talking about fixing and optimising websites with AI.</p>\n\n\n\n<p>I wonder if we begin the podcast with an introduction to you. So I&#8217;d love to find out more about what you do, what your role is at Hostinger, and how you&#8217;ve got yourself in the whole AI space.</p>\n\n\n\n<p>[00:04:12] <strong>Arnas Donauskas:</strong> Yeah, would be glad to give a short overview. As Nathan introduced me, I&#8217;m Arnas Donauskas and I&#8217;m a product manager at Hostinger. And the whole web hosting industry, creating a website, I&#8217;ve been for more than five years. Well, I think my first interaction with WordPress was actually in my college when I was writing my bachelor&#8217;s degree. I needed a website at that point of time and I thought, okay, what should I do? What should I use? And I was very green back in the day. Everyone has to start somewhere.</p>\n\n\n\n<p>And the WordPress came in as one of the first results that I searched on Google. I gave it a go. At first there were some challenges, interesting cases, what should I do with it? But then website got up and running. I finished my bachelors degree, so that was nice.</p>\n\n\n\n<p>And at Hostinger I have a team, a squad, where we build various tools for clients who are using WordPress to make their journey smoother, to make their websites management easier, to make a whole, interacting with the online presence easier. So they would have tools that could assist them, you know, on day to day basis, how to get things done and how, you know, to get their first website started and running as fast as possible.</p>\n\n\n\n<p>[00:05:24] <strong>Nathan Wrigley:</strong> So it seems like the hosting space, this is a really perfect fit for AI, because you presumably are onboarding clients and they have no website. I mean, in many cases maybe they have and they&#8217;re migrating something from one place to another. But I imagine a lot of your clients are brand new, they&#8217;re starting a new project, a new business, or whatever it may be, and they want to get a leg up in building something quickly.</p>\n\n\n\n<p>And five years ago, no chance. You had to hire somebody, everything had to be done by a human being. And nowadays we&#8217;re seeing the rise of AI in these kind of onboarding processes where you go through some kind of wizard, and at the end it will spit out some approximation of a website which is suitable for your niche or what have you. And then you go in and you tinker and you make sure it&#8217;s exactly what you want.</p>\n\n\n\n<p>Is that the kind of tooling that you are doing, or are you doing something slightly different to that over at Hostinger?</p>\n\n\n\n<p>[00:06:12] <strong>Arnas Donauskas:</strong> Yes, we do have tools that are able to, and capable of, creating a website with AI prompt. You would tell what your website would like to be, and we have like a WordPress AI website builder that will build you a blog, an e-commerce based on a given prompt. So this is already a really head start of all of the things.</p>\n\n\n\n<p>But also looking from another perspective, it&#8217;s totally understandable to see people who don&#8217;t want to build the website with AI, but would like to get guidance how things get done. From one perspective, you can get guidance, how to build the website itself. From another, do I need to make any DNS zone changes on my website? And at this point of stage, AI can help all the way through. You just simply ask what you would like to do, what are the settings you want to tweak? And AI can give you a really, really detailed step, you know, how to change those things.</p>\n\n\n\n<p>One of the really nice examples I have, at Hostinger we have a Kodee, it&#8217;s a chat interface assistant that helps clients with various questions, and it does have information about the client itself and, you know, what actions it can do. And what trend I started to notice that clients know it&#8217;s an AI, and they start asking specific questions. Like, hey, here&#8217;s bulk text, can you edit that for me? Or can you give me more detailed steps how to do this and this? And the AI just gives those steps and clients just like, thumbs up, thanks. Have a nice day. And they just go on their thing.</p>\n\n\n\n<p>So I see this trend, and it&#8217;s really nice that the users like utilising these tools, because at the end of the day, it helps save time, maybe additional money and, you know, it&#8217;s a win for the user.</p>\n\n\n\n<p>[00:07:44] <strong>Nathan Wrigley:</strong> So I&#8217;ll just read the first sentence of the blurb. So the title of your presentation here is fixing and optimising websites with AI. And then the first sentence goes like this, and it encapsulates exactly what you&#8217;ve just said. This talk explores how AI can be used to automatically fix detected website errors and boost overall site performance.</p>\n\n\n\n<p>So we&#8217;ve got this whole side of AI, which is the onboarding, we&#8217;ll help you build the site. But then it sounds like you&#8217;ve also now got tooling to, okay, you&#8217;ve got a website, let&#8217;s fix it up. Let&#8217;s make the improvements and adjustments along the way.</p>\n\n\n\n<p>So, okay, then if we are allowing AI to crawl our website in some way, how does that actually work? What is going on? What is your platform doing to find the errors? I realise that&#8217;s a very broad question, but I&#8217;m going leave it like that.</p>\n\n\n\n<p>[00:08:31] <strong>Arnas Donauskas:</strong> Yeah. So actually why this idea to create such tool came into the light, it was actually one of the feedback points we gathered from one of the WordCamps. Maybe it was Europe. But then to add up to it, we saw the problem when clients, let&#8217;s say a website starts receiving an error, or it starts to load slowly, they are not sure where to start troubleshooting this. And we have thought, why not make this process automatic and remove this hassle step for the client?</p>\n\n\n\n<p>So how this tool, for troubleshooting the error, how it works. So at all times we are tracking all of our clients&#8217; HTTP status. So basically, if there is no error, it&#8217;s 200, in most of the cases. There can be a permanent redirect HTTP status. But at all times we are tracking if it changed to an error code or no. If it did, then we are promptly informing the client, hey, we found an error on your website. It could be a 403 forbidden access, or 500, or a critical error. And we start informing the client, hey, an error was found, you can use our AI troubleshooter to automatically fix it.</p>\n\n\n\n<p>So when the client lands to the interface itself, we already gathered all of the logs, we removed all of the information that should not land for the AI, that he&#8217;s not using it to troubleshoot the error itself. And then AI has a list of actions it can do, whether it&#8217;s troubleshooting or optimising.</p>\n\n\n\n<p>And then based on the logs and our AI custom given prompt, it determines, this is the most likely action that will fix the site&#8217;s error. Or when it comes to optimising, here are like the listed settings you need to tweak to make that website go faster. And then at the end of the day, the client gets the error fixed or the website optimised.</p>\n\n\n\n<p>[00:10:21] <strong>Nathan Wrigley:</strong> So that&#8217;s really interesting. So here we&#8217;re talking about some sort of critical error. So your tooling is going out, in the same way that an uptime monitor would&#8217;ve done in the past. But the difference here though is that the uptime monitor traditionally just tells you the problem. You might get an email or a phone call or something, but then you&#8217;re kind of on your own. You do the troubleshooting.</p>\n\n\n\n<p>So the difference here is the AI then, it determines there&#8217;s a problem and then it offers suggestions. So you log into your control panel and it&#8217;s saying, okay, this is the most likely cause, here&#8217;s some things that you can do to remediate that problem.</p>\n\n\n\n<p>[00:10:53] <strong>Arnas Donauskas:</strong> Yes, but those suggestions are also being applied automatically because it&#8217;s totally normal, you could just go to ChatGPT, you say, here I have this error, what could I do to fix it? And the AI troubleshooter however, it does not suggest, it gives the action that can be applied on the spot. So if you had a one o&#8217;clock, 403 error, at one o&#8217;clock, five minutes, you could have it resolved without your actual manual input. So the tool itself automatically applies those fixes and does that for you.</p>\n\n\n\n<p>[00:11:26] <strong>Nathan Wrigley:</strong> Okay, that&#8217;s really curious because traditionally, I mean, obviously, I guess website hosting companies have had tooling around uptime monitoring and things like that in the past, but because your identifying piece, and the remediation piece, can access server logs and all of the infrastructure that you&#8217;ve got, it can identify the problem, figure out if that&#8217;s true, and then just crack on and do it.</p>\n\n\n\n<p>So you can implement it, well, without implementing it. You just wake up at eight in the morning, maybe get an email to say, well, at one o&#8217;clock this thing happened and then we did this so you were able to have another seven hours sleep, that&#8217;s fine. Yeah, that&#8217;s really interesting.</p>\n\n\n\n<p>[00:12:02] <strong>Arnas Donauskas:</strong> So one thing that we are also constantly working on is what automatic fixes we are capable to do. Because those are the ones where, you know, our developers work and make them so AI would have more, let&#8217;s call it options to pick from, based on the data it has, what went wrong. And this is, you know, where we have a mini roadmap, what we want to implement further, so we could increase the success rate of the fixed websites automatically.</p>\n\n\n\n<p>Because this is something we also track about. And I will mention this in my speech. So at this point of day, we have 70% success rate on fixing the website. And how it&#8217;s being calculated, that when a first fix was applied, it was an actual success and that error got resolved. So at this point of day it&#8217;s 70%, and roughly, in absolute numbers, we are fixing per month 16,000 of the websites.</p>\n\n\n\n<p>What&#8217;s the nicest part for me is that for 16,000 of websites some time was saved. Clients did not have to dig through a lot of information, and they got the problem resolved on the spot. Because imagine you have like a working business running, or you expect clients to come in and you get an error. What is the first thing you do? Like, it takes time. So this tool, you know, can prevent these problems and shorten the fixing journey.</p>\n\n\n\n<p>[00:13:20] <strong>Nathan Wrigley:</strong> Yeah, not just time, but it presumably stops you losing revenue, and the sort of slightly unquantifiable emotional distress that comes with having a website which isn&#8217;t working. And obviously if that&#8217;s your industry and your business is, I don&#8217;t know, e-commerce or something, it&#8217;s very important that comes up.</p>\n\n\n\n<p>So 70% sounds good, but obviously it means that 30%, there&#8217;s not the ideal outcome. What do you do in those scenarios where the thing was not solved? Do you log that and presumably your team then look at that and figure out over time, okay, how can we get that 30 to 20 to 10 and so on? And do you kind of roll back the remediation so that the thing which didn&#8217;t work, we unpick that and we just go back to where you were when the error occurred?</p>\n\n\n\n<p>[00:14:00] <strong>Arnas Donauskas:</strong> Yeah, so very good follow up question on this. So with the 30% that we do, we still run additional fixes. So when we do the first fix, we tracked what changed, and then the further success rate can happen, that the fact the was fixed either on the third try or like the fourth try, so that 30% lowers.</p>\n\n\n\n<p>But there are cases that none of the fixes helped, and it&#8217;s totally normal. Bigger website could be more complex problems, things like that happen. So then we proactively forward the user to our success specialist team who will assist on the spot. And they have all of the logs, what happened, what was tried, and what fixes were applied on the website on the spot.</p>\n\n\n\n<p>In any case, there are backups that can be reverted without any of the fixes applied. So those 10 to 15% that nothing helped at the end of the day, gets a direct help from our success team so we could still solve, or help solve, the problem for the user.</p>\n\n\n\n<p>[00:15:03] <strong>Nathan Wrigley:</strong> It&#8217;s kind of incredible that if we were to just rewind the clock five years, the stuff that you&#8217;ve just mentioned was nonsense. It could not happen. And yet we&#8217;ve got to the point now where you&#8217;re saying there&#8217;s a 70% success rate. I&#8217;m quite surprised it&#8217;s as high as that, so that&#8217;s amazing. And presumably, the ambition is to drive that up to 80 and 90 and what have you.</p>\n\n\n\n<p>But just the mere fact that it&#8217;s possible is pretty remarkable, that there&#8217;s a technology which, it&#8217;s kind of got your back, it&#8217;s this agent running in the background whose job it is to figure this stuff out and you don&#8217;t have to think about it.</p>\n\n\n\n<p>And I guess for your industry, you know, hosting in general, I presume a lot of the other companies are doing these kind of things. Over time, this will become the norm. It will just become a laundry list, one of the ticket items on the sales page. It&#8217;s, you know, we&#8217;ve got your AI agent monitoring the uptime, remediation is guaranteed. Maybe you&#8217;ll even get to like 99% of fixes or something like that in time. And it just kind of pushes what we&#8217;re going to expect from hosting companies like you. That&#8217;s fascinating. Really interesting.</p>\n\n\n\n<p>[00:16:04] <strong>Arnas Donauskas:</strong> Yeah. And as you&#8217;ve mentioned, five years ago, it could have been a lot of, let&#8217;s say problems or issues making this happen, because at that point of time you need to chew up a lot of information and, you know, do the thinking on that received information. But now when AI does have quite a powerful approach on this, and it&#8217;s able to handle such high amount of information, that&#8217;s when you know the heavy lifting is taken to that part, the end user is now getting the fixes done.</p>\n\n\n\n<p>As per norm on all of this fixing, I really would like to see that happen because it just helps out. You can spend your time on expanding, moving your business further, thinking of the new ideas what you could do, instead of maintaining the website. You know, there&#8217;s like a saying, it&#8217;s more fun to buy new parts to your car than replace the old ones or do the maintenance parts. So this is, I think, the same thing the website itself.</p>\n\n\n\n<p>[00:16:57] <strong>Nathan Wrigley:</strong> Yeah, it really does feel like this is going to be the future. And obviously you&#8217;ve now got these technologies which can make, well, it&#8217;s approximating intelligent decisions. Whereas before it was just sort of, I guess you were going through a binary, is it this? Yes. Okay. Move to the next step. Is it this? No. Okay. Go back to this step. Whereas now there can be this whole load of things that you can throw at it.</p>\n\n\n\n<p>And that brings me to the next question really. So you&#8217;ve just talked about all the critical things, so the website collapsing. So we do something to remediate that. What about the more, I don&#8217;t know, let&#8217;s say soft things.</p>\n\n\n\n<p>So for example, maybe it&#8217;s SEO. You know, we have gone around your website, we&#8217;ve scraped it a little bit like maybe Google Bot might do, and we&#8217;ve identified SEO problems. Or it could be accessibility problems, or it could be, goodness, I don&#8217;t know, you&#8217;ve just used inappropriate language here, we&#8217;ve got a better idea for a UVP at the top of the webpage. Does it stray into that as well? Is it more than just critical failure problems?</p>\n\n\n\n<p>[00:17:50] <strong>Arnas Donauskas:</strong> At this point of day, it&#8217;s more critical problems when the website is just full on down. But like, how I like to view the tools that we are building is whenever you build one tool, you receive clients&#8217; feedback, you receive WordPress community feedback, where you can build more tools on top as a continuation to the first one. This is what I really like about all of this feedback culture.</p>\n\n\n\n<p>This is the upcoming thing, and I think it&#8217;s only a matter of time when our troubleshooter and the optimiser will appear in the WordPress admin panel, where it will be able to tell you, I see an image has disappeared on your website, just upload it to me, I will fix it to you. Or I see some SEO problems. Or like you&#8217;ve mentioned, accessibility problems, or that some of the grammar mistakes were found in some of your posts. Something like that. So this is only a matter of time.</p>\n\n\n\n<p>And why such approach was taken at this point of time is, we want to give users a tool that they could trust and be comfortable on using when it comes to the most critical problem or critical matter with the website related errors. So they know, okay, I can trust and use this tool, and fix my problem right away. And when that&#8217;s put on, then we can move to extensive features to the troubleshooter and optimiser as well.</p>\n\n\n\n<p>[00:19:09] <strong>Nathan Wrigley:</strong> Would it be fair to say that you are developing solutions like that, though? Is that the kind of thing which is on your product roadmap to get those kind of tools, the SEO, the image fixing, the alt text identifier, the I know, the accessibility identifier, those kind of things. They&#8217;re in the background? You are building those? They&#8217;re roadmap items are they?</p>\n\n\n\n<p>[00:19:26] <strong>Arnas Donauskas:</strong> I would say they are currently planned. Right now, what we have in the more recent backlog is how to reach my personal goal on this is 90% fixed rate. If you already have some plans, how it&#8217;ll be done. So a short sneak peek on it. We basically want to build like a way back machine on our AI troubleshooter, so it would know at any given time what happened to each of the file the customer has on their website. And it would be able to tell you, okay, I see that on this specific date, this single file was changed and that&#8217;s what led to a 500 error. I have a safe backup copy for it, I will restore it for you. User confirms. We do the restoration.</p>\n\n\n\n<p>Or AI will be able to determine, I have a fully working website backup of your site, these are the orders that could be potentially missed if that is an e-commerce case. And if you want to, we can go ahead and restore the website to a fully working version and get your site back up and running again.</p>\n\n\n\n<p>[00:20:26] <strong>Nathan Wrigley:</strong> We do live in interesting times, that&#8217;s for sure. You mentioned in the blurb for the talk, and I read the bit at the beginning, but I&#8217;ll just read it again. So your talk explores how AI can be used to automatically fix detected website errors, I think we&#8217;ve covered that, and boost overall site performance.</p>\n\n\n\n<p>Now that&#8217;s a different piece, isn&#8217;t it? So if we&#8217;re now looking at site performance, presumably we&#8217;re talking about from slow to fast. Something wrong to fix. So basically, I&#8217;m asking the exact same series of questions, but from a performance point of view, not the site has collapsed and there&#8217;s an error. What are the things that you&#8217;re looking for there?</p>\n\n\n\n<p>[00:20:59] <strong>Arnas Donauskas:</strong> To be fair with you, everything. So we look at everything when it comes to website performance. So we do like a benchmark result where we have our starting ground when it comes to optimising the website. And we are using Google Page Speed scores. I think it&#8217;s one of the most popular tools to benchmark the website to see what is loading slowly on it, what could be the potential problems with it. And then for each website individually, automatic fixes to images, JS, CSS minification are being applied, and the client then sees the improvement, whether it&#8217;s 10%, 20%.</p>\n\n\n\n<p>So right now what we currently have from the data itself, I believe it&#8217;s been running for two to three months right now, and we&#8217;ve been gathering data, how the websites are being optimised. So on average, mobile page speed score is being increased by 20, and the desktop is by 10%.</p>\n\n\n\n<p>But there&#8217;s a catch to it. These optimisation steps are safe. It means nothing bad will happen to the website after the optimisation steps, and the next step would be introducing risky steps that can affect how the website looks.</p>\n\n\n\n<p>What I have in mind by that is, lazy loading sometimes can mess up one of the images, it appears slowly or after a while. So these things could happen, but this will be like a separate step informing the client, hey, we did the safe part, but we could push this further with some of the risks. No worries, you will be able to revert everything on the spot if something bad happens. So this will be the next step of it, and I&#8217;m really intrigued to see how fast the websites can be.</p>\n\n\n\n<p>[00:22:35] <strong>Nathan Wrigley:</strong> Can you modify your hosting environment to be specific to my website, if you know what I mean? So if my website, for example, is, I don&#8217;t know, a brochure website, I&#8217;ve got five pages, you could cache that entirely. Really easy to do. But, okay, this website over here, a different one that I&#8217;ve got, it&#8217;s a WooCommerce website, there&#8217;s a whole different load of caching that might go on, there&#8217;s a whole different load of optimisations that go on there. Do you take that burden on, or is it more of a, okay, we&#8217;ve got this thing, you tick a box and now we&#8217;re going to do the performance thing? Will it figure all that stuff out, or are there tick boxes where I can go, do this but don&#8217;t do this, do this but don&#8217;t do this? How does it work?</p>\n\n\n\n<p>[00:23:13] <strong>Arnas Donauskas:</strong> So each optimisation step to increase the performance is being applied to each website individually. It checks loading slowly. Right now, there is no possibility to customise the optimisation steps that you can do, but we are planning to integrate logic to the AI, or like past information for each type of website type. What caching should be applied on specific pages if the image is a landing one, or is it like a product image? So to give more extensive knowledge to the AI so it would be able to better determine how to approach different website types. But for now, what we check, still settings are unique to each website, but not to such extensive customisation.</p>\n\n\n\n<p>[00:23:56] <strong>Nathan Wrigley:</strong> You&#8217;ve laid before us a really interesting engineering challenge. These problems exist in terms of performance, we&#8217;ve got to put a bunch of engineers on it, and they&#8217;re going to figure out this AI way of solving that. But how do you communicate the work that the AI is done to the people that want to know it&#8217;s been done?</p>\n\n\n\n<p>Because in a way, I kind of want to know that&#8217;s happened to my website, but at the same time, I kind of don&#8217;t. I don&#8217;t want to be getting six emails a day saying, okay, we updated this image, oh, and then another email, we did x, and we did. But you&#8217;ve got to let me know that that&#8217;s happened. In some way, you have to communicate the value to me that, look at all this fabulous stuff we&#8217;re doing. But I kind of want to know, but I kind of don&#8217;t want to know. So it&#8217;s a difficult tightrope to tread. I&#8217;m just wondering how you manage that.</p>\n\n\n\n<p>[00:24:36] <strong>Arnas Donauskas:</strong> Yeah, yeah. So at the end of each optimisation, client is getting an impacted result, did it increase, and by how much? And they are getting a full log, what was done on the website. And we are also trying to display that log to as most simple things as possible to understand, because some of those settings could sound, you know, very big words. But there&#8217;s actually very simple things that were done on the website. So we&#8217;re communicating that part to the users at the end of each optimisation as well.</p>\n\n\n\n<p>[00:25:05] <strong>Nathan Wrigley:</strong> Okay, so you&#8217;re kind of making it easier to understand basically. You&#8217;re hoping to use normal language to explain something fairly technical. Yeah, okay. And summarising it, not sending an email for every single thing. And presumably over time the email&#8217;s become less and less anyway because, let&#8217;s say I migrate a website to your platform, the AI gets involved, and I&#8217;m imagining there&#8217;s more at the beginning, it&#8217;s front loaded. Oh, look, there&#8217;s this and this and this and this. And then slowly over time, oh, there&#8217;s less. We did it. It&#8217;s done. But, oh, new plugin, new thing. I&#8217;m guessing that you communicate less over time.</p>\n\n\n\n<p>[00:25:37] <strong>Arnas Donauskas:</strong> With such optimisation things, yes, via email. I would say it&#8217;s less via email, more via interface. And I would say that at this point, it&#8217;s enough for a user to grasp the idea of what was done.</p>\n\n\n\n<p>Why I say this? Because the amount of time the clients spend in the interface reviewing the optimisations and how many of them interact with it is quite high. I believe with optimisations it&#8217;s 70% of the users that actually started the migration, completed, you know, all of the interaction with the interface. And they&#8217;re spending approximately like from 10 to 15 minutes with it.</p>\n\n\n\n<p>So I would say these are pretty good numbers. But you gave a very good point for the users&#8217; clients who are more advanced. And perhaps it would be a good improvement point to give them an option to download all extensive logs, what was done, to see just what happened actually in depth, not just rephrased wording for some technical parts.</p>\n\n\n\n<p>[00:26:36] <strong>Nathan Wrigley:</strong> Yeah, I think it&#8217;s a really difficult tightrope to tread because every time that your AI does something and it had a beneficial impact on my website, that&#8217;s good for me, but it&#8217;s also good for you because it builds that relationship, doesn&#8217;t it? You know, oh, look what the platform&#8217;s done. It&#8217;s brilliant. I didn&#8217;t have to lift a finger. Just came as part of the package. Fabulous. I&#8217;m happy with that.</p>\n\n\n\n<p>But you just don&#8217;t want to overdo that communication because at some point it&#8217;s like, oh, you lose sight of it. And then the critical one will arrive where the website&#8217;s collapsed and, yeah, it&#8217;s another one, it just goes in the bin. So I guess there&#8217;s a tightrope to tread, which is kind of interesting.</p>\n\n\n\n<p>How do you actually find these errors then? Do you have something akin to Google Bot, which is going and looking at the front end of the website as a human being would see it, if you like, and sort of scraping around inside the DOM, looking at screenshots and, you know, okay, yeah, we see that image isn&#8217;t, I don&#8217;t know, so just an open-ended question really.</p>\n\n\n\n<p>[00:27:28] <strong>Arnas Donauskas:</strong> Since each of the website that we are troubleshooting are hosted with us, we are able to, you know, detect. Because the primary source that we are using to determine that something bad happened is the HTTP response.</p>\n\n\n\n<p>[00:27:41] <strong>Nathan Wrigley:</strong> Right. That&#8217;s straightforward. Yeah.</p>\n\n\n\n<p>[00:27:42] <strong>Arnas Donauskas:</strong> Yeah. So whenever that changes, we are able to know because each of the website is hosted with us on our infrastructure. So this is the most, the quickest and most straightforward approach we can use to determine that something bad happened. So this is the one we are running with. And quite good accuracy, unless there&#8217;s like a, some CDNs in that case. And this could be sometimes a problem because not always the true error will come out. But yeah, this is the method we are using.</p>\n\n\n\n<p>[00:28:09] <strong>Nathan Wrigley:</strong> But on the performance side, presumably that&#8217;s slightly different because, you know, you mentioned lazy loading images or something, you&#8217;ve got to have some metrics and telemetry to say, we&#8217;ve got lazy loading images, okay, how do we deal with that?</p>\n\n\n\n<p>[00:28:20] <strong>Arnas Donauskas:</strong> So with the performance part, clients are able to, you know, at any given time to initiate the optimisations. We will do the performance test to see if it actually needs an optimisation, because sometimes clients have very perfectly optimised websites, and they&#8217;re working like a speed. But we are occasionally running page speed performance tests, on weekly basis, I believe. And if we detect, okay, this website could be improved, then clients are being informed that, hey, you can do some optimisation steps that are automatic and you can go ahead and start the optimisation process.</p>\n\n\n\n<p>[00:28:53] <strong>Nathan Wrigley:</strong> Okay, got it. Thank you. Curious thing that you are in this game of tennis, I presume, with the AI models. I&#8217;m presuming, I could be wrong, but I&#8217;m presuming that you are using AIs that we are familiar with. So I&#8217;m just going to drop a few names that I know. Things like Gemini, Claude, ChatGPT and things like that. I&#8217;m presuming there&#8217;s some connection that you&#8217;ve got with those. Maybe you have your own, I don&#8217;t know.</p>\n\n\n\n<p>Given that they seem to change at a breathtaking pace, and in some cases the changes that they seem to ship kind of seem to degrade their capacity to do things. We&#8217;ve had a recent ChatGPT 5 update, which I think many people felt perhaps in certain scenarios was a backward step. How do you keep up with this?</p>\n\n\n\n<p>[00:29:33] <strong>Arnas Donauskas:</strong> Testing, straightforward testing, but very good point on the whole different models and the providers on it. We simply do tests with each of the models. We scout around, we see, or it looks very promising, we test how it performs, and there are several points. How fast it can grasp the information and return back to us. So how long the request took time. Some of the models took like 10 seconds, some of them took 5. So we want the client to get the faster result as fast as possible.</p>\n\n\n\n<p>And then there&#8217;s the second part, it&#8217;s the accuracy of the returned information. Because one of the learned lessons I will be sharing in my speech is that, we noticed that when newer models came in, how their accuracy was way better and the time to handle information was very shorter. So since we have like developers who are working on the AI models itself, we just always test to see if there&#8217;s something better that we could ship to our users so they would have better outcome on their end as well.</p>\n\n\n\n<p>[00:30:35] <strong>Nathan Wrigley:</strong> Yeah, it&#8217;s fairly straightforward, isn&#8217;t it? It&#8217;s testing, testing, more testing, and go with the thing which provides the best tested answer. But curiously though, you must have applied a ton of engineering time into this endeavor. So there&#8217;s a load of people on the ground, that must cost Hostinger quite a bit of money. And then presumably there&#8217;s quite a lot of money being sent to these AI agents. But I&#8217;m guessing it&#8217;s hard to justify a price increase to your end users.</p>\n\n\n\n<p>So it must be kind of a fairly difficult business decision. How much of this can you do? Because you could AI forever, you know, and just keep going and going and going and endless cycles. So I&#8217;m guessing from a business point of view, there&#8217;s a, again, another tightrope to tread. How much can you do? Or is this more a case of, is this stuff a premium thing that you offer? Do you have to pay an additional fee to get access to this stuff?</p>\n\n\n\n<p>[00:31:21] <strong>Arnas Donauskas:</strong> No. No additional fee. AI troubleshooter and optimiser is pre included with all of the hosting plans we offer for our clients base. And the price for that did not change because this tool was introduced.</p>\n\n\n\n<p>You&#8217;re right, it took some time to deliver final versions of the products, approximately seven to eight months. But it was all worth it, I think, because clients can now automatically do things and don&#8217;t have to spend time themselves.</p>\n\n\n\n<p>And from a company point of view, we just want to deliver best user experience they could have and, you know, that they could trust us even when the website is down with an error and how we can solve it, and what we can do the quickest or how to, you know, assist user on optimising the site.</p>\n\n\n\n<p>[00:32:08] <strong>Nathan Wrigley:</strong> It&#8217;s the market at work, isn&#8217;t it? Essentially. You&#8217;re trying to make your offering different and unique and offer something which adds value, and so you take the hit, I guess.</p>\n\n\n\n<p>Do you want to get to the point where everything is completely automated? I mean, is that a desirable outcome? Would it be something that you&#8217;d like to see where the human is completely out of the loop? Or do you always want to have an option for a confirm button or a roll, not rollback, we always want the rollback.</p>\n\n\n\n<p>But it always feels like the light at the end of the tunnel here is that the human doesn&#8217;t need to be involved at all. It would be desirable if I could get up and be a hundred percent confident that my website, for all of the things that you did overnight, is better. And I don&#8217;t have to involve myself in that at all. But equally, there&#8217;s a bit of me which always wants the confirm button. I want to be able to see, well, not that one. Yes, that one. We&#8217;ll do that.</p>\n\n\n\n<p>[00:32:56] <strong>Arnas Donauskas:</strong> I think confirmable actions will be there all the time, or most of the time. Because at the end of the day, this is the user&#8217;s website that the changes are being applied to, and the user is in control. Would you like to do those changes, would you not? One of the thoughts, I believe we discussed with our colleagues, what we have 100% fixed rate? Should we give users an option, just run everything, I trust this completely? It could be an option. But still, at the end of the day, this is the user&#8217;s website. It&#8217;s their business, it&#8217;s their blog, and we want to give best suggestions, but the user is the one who&#8217;s saying, yes, I would like to do that, or, no, I don&#8217;t want to see this.</p>\n\n\n\n<p>[00:33:39] <strong>Nathan Wrigley:</strong> I guess you&#8217;re trying to get to the point where the confirmed decision is just really obvious. You want to go in and be entirely confident that, yep, I&#8217;m going to confirm it because I have this trust, but equally, there&#8217;s an option to not confirm it. That seems to be where the whole AI thing is going. The humans are always in the loop somewhere and it&#8217;s always that final confirmation step. And I think if we lose sight of that, we&#8217;re probably in a bit of trouble.</p>\n\n\n\n<p>One of the questions I have as well is about WordPress, obviously, we&#8217;re at WordCamp US, this great big open source thing. And it brings to mind the question about these models, and the fact that they are entirely proprietary, you know, ChatGPT, Gemini, Claude, and all of these things. They&#8217;re having a lot of our data, we&#8217;re allowing them into the backend of our websites, but they, I don&#8217;t know if they have any open source models which are using. Are you shipping data to them? How does it align with the whole open source thing that WordPress is so keen to promote?</p>\n\n\n\n<p>[00:34:31] <strong>Arnas Donauskas:</strong> Oh, very good question I can say. And it&#8217;s true that different models look like different silos. Different companies, they have different approaches what they do. But I really liked one of the comments, I believe I read on the Reddit, on all of the AI stuff. And it applies also on such websites. So for example, you&#8217;re a user who likes to explore things, and you want to try and fix websites with AI and do that automatically. A free model for the ChatGPT or any other AI model will be more than enough to run, as long as you have your prompt.</p>\n\n\n\n<p>It will take some experiment times, that&#8217;s for sure, but everything could be actually run free on this part. So this is more, you know, into the open source area. But of course, when there are paid models and stuff like that, this could be, you know, one day could be tricky.</p>\n\n\n\n<p>Perhaps we will have a fully open source that anyone could be willing to use without any additional charges. Time will show on this. But now, a lot of companies, people are creating tools that they allowed to do free trials or free for some time. So I think this is a matter of question on this as well, yeah.</p>\n\n\n\n<p>[00:35:40] <strong>Nathan Wrigley:</strong> Yeah, I mean it really does seem like a really exciting time, in tech in general, but also WordPress in general. But it&#8217;s kind of really interesting to see the way that WordPress and hosting company&#8217;s interfacing through AI. And it does seem like there&#8217;s a lot of interesting stuff happening on your side.</p>\n\n\n\n<p>Yeah, it&#8217;s been fascinating talking to you today, trying to explore this a little bit more. Where can we find you, Arnas? If we want to reach out and discover more about you or Hostinger, where&#8217;s the best place to go?</p>\n\n\n\n<p>[00:36:05] <strong>Arnas Donauskas:</strong> So if you want to reach out directly to me, I&#8217;m always happy to do that via LinkedIn. I have my full profile set up so we can reach out through there. If you&#8217;re a Hostinger client and you have some feedback, just drop it to our support chat. I&#8217;m the one who always reads them, and I might even get directly in touch with you via one of the forms because I always keep an eye of our client&#8217;s feedback and I try to contact them as often as possible to follow up on some of the feedbacks they share.</p>\n\n\n\n<p>[00:36:32] <strong>Nathan Wrigley:</strong> Well, Arnas, thank you so much for chatting to me today and prizing open this subject. I feel that this conversation is going to get more and more in depth, and more complicated as the years go by. But in 2025, good to know where we&#8217;re at. Thank you.</p>\n\n\n\n<p>[00:36:43] <strong>Arnas Donauskas:</strong> Yeah. Thank you for inviting me. It was an honor.</p>\n</div></details>\n\n\n\n<p>On the podcast today we have <a href=\"https://www.linkedin.com/in/arnas-donauskas/\">Arnas Donauskas</a>.</p>\n\n\n\n<p>Arnas is a product manager at Hostinger, with over five years of experience in the web hosting industry. His journey began during college while working on his bachelor’s degree, when he needed to create a website and discovered WordPress as a beginner. This first foray into website building sparked his interest in the industry, eventually leading him to a career where he now develops products that help others launch their own online presence. Recently he’s been working with a team tasked with delivering tools and improvements to WordPress users to ease their journey on starting, and maintaining websites.</p>\n\n\n\n<p>In this episode, Arnas shares insights from his presentation at WordCamp US in Portland, Oregon, where he discussed the future of fixing and optimising websites with AI. For many WordPress users, managing site performance and troubleshooting errors can be time-consuming and complex. Arnas and his team have been developing AI-based solutions that not only help onboard new clients by automating website creation, but also proactively monitor and remediate website issues as they happen.</p>\n\n\n\n<p>We get into the details of how Hostinger’s AI tools identify, and automatically fix, critical website errors, such as HTTP response issues, and how they’re pushing their site optimisations through automated performance enhancements. Arnas explains the engineering challenges involved, the current rate of success with automated fixes, and how user feedback is shaping the roadmap for new features like SEO analysis and accessibility improvements.</p>\n\n\n\n<p>He provides a behind-the-scenes look at how Hostinger tests and iterates on AI models, what kind of data is fed to these systems, and how the team balances automation with user control.</p>\n\n\n\n<p>If you’re curious about how artificial intelligence is transforming WordPress hosting and site management, and what this means for the future of the web, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://www.hostinger.com\">Hostinger</a></p>\n\n\n\n<p><a href=\"https://www.hostinger.com/blog/kodee\">Kodee by Hostinger</a></p>\n\n\n\n<p><a href=\"https://us.wordcamp.org/2025/session/fixing-and-optimizing-websites-with-ai/\">Fixing and Optimizing websites with AI</a> &#8211; Arnas&#8217; presentation at WordCamp US 2025</p>\n\n\n\n<p><a href=\"https://developers.google.com/speed\">Google&#8217;s PageSpeed tools</a></p>\n\n\n\n<p><a href=\"https://www.linkedin.com/in/arnas-donauskas/\">Arnas on LinkedIn</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Oct 2025 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"Open Channels FM: How a Camping Trip Illustrates the Power of Storytelling in Tech\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=111065\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://openchannels.fm/how-a-camping-trip-illustrates-the-power-of-storytelling-in-tech/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:326:\"Rae Morey, WordPress journalist and podcast host, recently shared a story on Open Channels FM about a camping trip that revealed just how effective storytelling can be in business. After spending a rough night on the ground during a camping trip, Rae realized, “I woke up with a sore back. I’m getting old. And I [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Oct 2025 10:54:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Matt: Grokipedia\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150403\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://ma.tt/2025/10/grokipedia/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2118:\"<p>It&#8217;s very interesting to compare <a href=\"https://en.wikipedia.org/wiki/Matt_Mullenweg\">my Wikipedia article</a> and <a href=\"https://grokipedia.com/page/Matt_Mullenweg\">my Grokipedia article</a>. The Grokipedia version is much, much longer, and does a better job of listing my accomplishments versus some random recent controversy. (Will someone reading about me a hundred years from now care that WordPress briefly had a sustainability team as one of its dozens of teams?) But at least everything on Wikipedia is true! On Grokipedia:</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>WooCommerce, an open-source e-commerce platform integrated with WordPress, enables online stores and has facilitated over $1 trillion in annual commerce as of 2023.</p>\n</blockquote>\n\n\n\n<p>While I actually believe someday, probably around 2037, Woo will facilitate a trillion in commerce annually, that number is off by a couple orders of magnitude right now. <img alt=\"🙂\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f642.png\" style=\"height: 1em;\" /></p>\n\n\n\n<p>As with all software, we shouldn&#8217;t come to conclusions <a href=\"https://ma.tt/2010/11/one-point-oh/\">based on the 1.0</a> but rather look to its vector and speed of iteration, so I&#8217;ll reserve judgment on Grokipedia for now.</p>\n\n\n\n<p>I <em>love</em> Wikipedia. I&#8217;ve been a contributor since it started, and I think it embodies Open Source ideals in a really beautiful way. For a little love letter to Wikipedia check out this article by Jason Koebler, <a href=\"https://www.404media.co/grokipedia-is-the-antithesis-of-everything-that-makes-wikipedia-good-useful-and-human/\">Grokipedia Is the Antithesis of Everything That Makes Wikipedia Good, Useful, and Human</a>. My take: If you think there&#8217;s something wrong with the Wikipedia, the way to fix it is to get involved and contribute. They have a robust community.</p>\n\n\n\n<p>As a bonus, I learned today that the <a href=\"https://wikimediafoundation.org/\">Wikimedia Foundation runs on WordPress</a>! What an honor.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Oct 2025 23:49:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"Jake Spurlock: Introducing Today: An RSS Reader for the Modern Age\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://jakespurlock.com/?p=51811\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://jakespurlock.com/2025/10/introducing-today-an-rss-reader-for-the-modern-age/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4871:\"<p>I&#8217;m thrilled to announce the release of <strong><a href=\"https://apps.apple.com/us/app/today-rss-reader/id6754362337 Today - RSS Reader\">Today</a></strong>, a new RSS reader for iOS that I&#8217;ve been building with a lot of love and a little help from AI.</p>\n\n\n\n<h3 class=\"wp-block-heading\">A Love Letter to RSS</h3>\n\n\n\n<p>I&#8217;ve loved RSS forever. It&#8217;s the open web at its finest—a way to follow the sites and writers you care about without algorithmic interference, without ads dictating what you see, without being locked into a single platform. When Google shut down Google Reader in 2013, it left a hole in my heart that never quite healed. I tried every replacement under the sun, but none of them felt quite right.</p>\n\n\n\n<p>So I decided to build my own.</p>\n\n\n\n<h3 class=\"wp-block-heading\">RSS at Automattic</h3>\n\n\n\n<p>This week, I hit my seven-year anniversary at Automattic, where RSS feeds are part of our daily workflow. We use them to stay on top of news, monitor site updates, track support issues, and keep connected to the broader WordPress community. RSS isn&#8217;t just a nostalgic technology for us—it&#8217;s an essential tool.</p>\n\n\n\n<p>Coincidentally, my seven-year anniversary fell on the same day as Matt Mullenweg&#8217;s twenty-year anniversary of founding WordPress and Automattic. As he <a href=\"https://ma.tt/2025/10/counter-claims/\">reflected on two decades</a> of building in the open, I found myself thinking about what it means to create tools that empower people, that respect the open web, and that put users in control of their own experience.</p>\n\n\n\n<p>That&#8217;s what Today is all about.</p>\n\n\n\n<h3 class=\"wp-block-heading\">From WordPress to Swift: Porting Texturize</h3>\n\n\n\n<p>One of my favorite technical achievements in this project was porting WordPress&#8217;s <code>texturize</code> function to Swift. For those unfamiliar, <code>texturize</code> is the unsung hero that transforms plain ASCII quotes into beautiful curly quotes, fixes dashes, and handles all those typographic niceties that make text look polished and professional.</p>\n\n\n\n<p>WordPress has been perfecting this code for over twenty years, handling edge cases in dozens of languages. Rather than reinvent the wheel, I brought that wisdom into Today. Now your RSS article titles look as good on iOS as they do on the web.</p>\n\n\n\n<h3 class=\"wp-block-heading\">AI, But Just a Little (And All Local)</h3>\n\n\n\n<p>Here&#8217;s where Today gets interesting. I&#8217;ve added AI features—but deliberately kept them minimal, focused, and completely local to your device. No cloud processing, no data collection, no privacy concerns.</p>\n\n\n\n<p>The AI does two things:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Context and summaries:</strong> When you have dozens of unread articles, Today can generate a quick newsletter-style digest with commentary, helping you understand what&#8217;s worth reading right now.</li>\n\n\n\n<li><strong>Surface interesting articles:</strong> Ask the AI what you should read, what&#8217;s trending, or what&#8217;s new, and it&#8217;ll point you to the articles that matter most based on your reading habits.</li>\n</ul>\n\n\n\n<p>It&#8217;s just enough AI to be helpful without being overwhelming. And because it runs entirely on-device using Apple Intelligence, your reading habits stay private.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Built for the Open Web</h3>\n\n\n\n<p>Today is my attempt to bring back what made Google Reader great: a clean, focused reading experience that puts you in control. Import your feeds via OPML, organize them however you like, and enjoy reading without distractions.</p>\n\n\n\n<p>The app supports background sync, so your feeds stay fresh throughout the day. It handles both RSS and Atom feeds. And yes, it works beautifully with WordPress sites—because of course it does.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Download Today</h3>\n\n\n\n<p>Today is available now on the App Store for iOS 18 and later. It&#8217;s free to download, and I&#8217;d love to hear what you think.</p>\n\n\n\n<p>Whether you&#8217;re an RSS veteran who never stopped missing Google Reader, or someone discovering the power of RSS feeds for the first time, I think you&#8217;ll find something to love in Today.</p>\n\n\n\n<p>Here&#8217;s to the open web. Here&#8217;s to reader-controlled algorithms. And here&#8217;s to RSS, still going strong after all these years.</p>\n\n\n\n<p><a href=\"https://apps.apple.com/us/app/today-rss-reader/id6754362337\">Download Today on the App Store →</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p><em>P.S. If you&#8217;re curious about the technical details, I built Today using SwiftUI and SwiftData, with Apple&#8217;s NaturalLanguage framework powering the local AI features. The whole project is a love letter to both RSS and native iOS development.</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Oct 2025 22:56:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jake Spurlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"WordPress.org blog: WordPress 6.9 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19253\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2025/10/wordpress-6-9-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5097:\"<p>WordPress 6.9 Beta 2 is now ready for testing!</p>\n\n\n\n<p><strong>This beta version of the WordPress software is under development</strong>. Please do not install, run, or test this version of WordPress on production or mission-critical websites.  Instead, you should evaluate Beta 2 on a test server and site.</p>\n\n\n\n<p>You can test WordPress 6.9 Beta 2 in any of the following ways:<br /></p>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\"> WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream.)</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href=\"https://wordpress.org/wordpress-6.9-beta2.zip\">Beta 2 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use this<a href=\"https://make.wordpress.org/cli/\"> WP-CLI</a> command: <br /><code>wp core update --version=6.9-beta2</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href=\"https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn\">6.9 Beta 2 WordPress Playground instance</a> to test the software directly in your browser.  No setup is required–just click and go! </td></tr></tbody></table></figure>\n\n\n\n<p>The scheduled final release date for WordPress 6.9 is <strong>December 2, 2025</strong>.  The full <a href=\"https://make.wordpress.org/core/6-9/\">release schedule can be found here</a>. Your help testing Beta and RC versions is vital to making this release as stable and powerful as possible. Do check the<a href=\"https://make.wordpress.org/core/\"> Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-9/\">6.9-related posts</a> in the coming weeks for more information. Thank you to everyone who contributes by testing! </p>\n\n\n\n<p><strong>Catch up on what’s new in WordPress 6.9</strong>: Read the <a href=\"https://make.wordpress.org/core/2025/10/21/wordpress-6-9-beta-1/\">Beta 1 announcement</a> for details and highlights.</p>\n\n\n\n<h2 class=\"wp-block-heading\">How to test this release</h2>\n\n\n\n<p>Your help testing the WordPress 6.9 Beta 2 version is key to ensuring everything in the release is the best it can be. While testing the upgrade process is essential, trying out new features is equally important.  This <a href=\"https://make.wordpress.org/test/2025/10/21/help-test-wordpress-6-9/\">detailed guide</a> will walk you through testing features in WordPress 6.9.</p>\n\n\n\n<p>If you encounter an issue, please report it to the<a href=\"https://wordpress.org/support/forum/alphabeta/\"> Alpha/Beta area</a> of the support forums or directly to<a href=\"https://core.trac.wordpress.org/newticket\"> WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of<a href=\"https://core.trac.wordpress.org/tickets/major\"> known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the<a href=\"https://make.wordpress.org/test/\"> testing initiatives in Make Core</a> and join the<a href=\"https://wordpress.slack.com/messages/core-test/\"> #core-test channel</a> on<a href=\"https://wordpress.slack.com/\"> Making WordPress Slack</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Beta 2 updates and highlights</h2>\n\n\n\n<p>WordPress 6.9 Beta 2 contains more than 33 Editor updates and fixes since the Beta 1 release, including 28 tickets for WordPress core.</p>\n\n\n\n<p>Each beta cycle focuses on bug fixes; more are on the way with your help through testing. You can browse the technical details for all issues addressed since Beta 1 using these links:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.9?since=2025-10-22&amp;until=2025-10-28\">GitHub commits for 6.9</a> since October 21, 2025</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=10%2F22%2F2025..10%2F28%2F2025&amp;milestone=6.9&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Closed Trac tickets</a> since October 21, 2025</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">A Beta 2 haiku</h2>\n\n\n\n<p><em>Morning dew returns,</em></p>\n\n\n\n<p><em>Small fixes bloom in silence—</em></p>\n\n\n\n<p><em>Code finds its balance.</em></p>\n\n\n\n<p class=\"has-text-align-right\"><em>Props to <a class=\"mention\" href=\"https://profiles.wordpress.org/davidbaumwald/\"><span class=\"mentions-prefix\">@</span>davidbaumwald</a>, <a class=\"mention\" href=\"https://profiles.wordpress.org/wildworks/\"><span class=\"mentions-prefix\">@</span>wildworks</a> , <a class=\"mention\" href=\"https://profiles.wordpress.org/krupajnanda/\"><span class=\"mentions-prefix\">@</span>krupajnanda</a> &amp; <a class=\"mention\" href=\"https://profiles.wordpress.org/mosescursor/\"><span class=\"mentions-prefix\">@</span>mosescursor</a></em> <em>for proofreading and review.</em></p>\n\n\n\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Oct 2025 15:23:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Akshaya Rane\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"Open Channels FM: Episode Milestones and Back Behind the Mic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=111796\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://openchannels.fm/episode-milestones-and-back-behind-the-mic/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:135:\"Bob’s gearing up for episode 700. He reflects on milestones, announces the end of solo episodes, and hints at more guest chats ahead.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Oct 2025 13:42:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Matt: AI NYC Event\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150397\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ma.tt/2025/10/ai-nyc-event/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:322:\"<p>On November 5<sup>th</sup> at our Noho office the legendary <a href=\"https://www.borthwick.com/\">John Borthwick</a> (investor in Twitter, Tumblr, Buzzfeed, Digg, Venmo&#8230;) and I will have a conversation on the future of the Open Web and human-centered AI. <a href=\"https://luma.com/fy86k4w5\">Please join us</a>!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Oct 2025 03:00:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"Open Channels FM: The Open Web, A History of an Ideal\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=111756\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://openchannels.fm/the-open-web-a-history-of-an-ideal/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:196:\"The open web is a decentralized, accessible space rooted in collaboration and innovation. From its beginnings with TCP/IP to modern movements, it emphasizes user control over content and identity.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Oct 2025 11:27:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Matt: Time Zones\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150385\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://ma.tt/2025/10/time-zones/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2239:\"<p>If you like rabbit holes, a wonderful way to spend your Sunday is in the <a href=\"https://zachholman.com/posts\">writing of Zach Holman</a>, an early engineer at Github and Gitlab.</p>\n\n\n\n<p>All are good, but a particular favorite of mine is <a href=\"https://zachholman.com/talk/utc-is-enough-for-everyone-right\">UTC is enough for everyone …right?</a> You don&#8217;t need to code to appreciate that time is a construct, that has evolved over time. &#8220;At noon in DC, it was 12:08 in Philly.&#8221; Time zones introduce particular complexity because, besides obvious things like Daylight Saving Time starting and stopping at different times at different places in history and geography. If you do write code, you&#8217;ve probably come across things like <a href=\"https://www.epochconverter.com/\">Epoch Time</a>.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>The <strong>Unix epoch</strong> (or <strong>Unix time</strong> or <strong>POSIX time</strong> or <strong>Unix timestamp</strong>) is the number of seconds that have elapsed since January 1, 1970 (midnight UTC/GMT), not counting leap seconds (in ISO 8601: 1970-01-01T00:00:00Z). Literally speaking, the epoch is Unix time 0 (midnight 1/1/1970), but &#8216;epoch&#8217; is often used as a synonym for Unix time. Some systems store epoch dates as a signed 32-bit integer, which might cause problems on January 19, 2038 (known as the Year 2038 problem or Y2038).</p>\n</blockquote>\n\n\n\n<p>I&#8217;ve spent far too many hours on the <a href=\"https://www.php.net/manual/en/function.date.php\">PHP date manual page</a> and the related comments (now gone! I used to have a few, they probably retired because they were on earlier versions of the language).</p>\n\n\n\n<p>As a bit of lore for Zach he might appreciate, I&#8217;ll share that when writing some of the first logging and data processing systems for <a href=\"https://akismet.com/\">Akismet</a>, I divided the files using <a href=\"https://en.wikipedia.org/wiki/Swatch_Internet_Time\">Swatch Internet Time</a> to give me a consistent balance of dividing a day, but still doing things as real-time as possible. The anti-spam learning system would update about every 86 seconds.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Oct 2025 03:50:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"Akismet: Happy 20th Birthday Akismet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://akismet.com/?p=284642\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://akismet.com/blog/happy-20th-birthday-akismet/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1522:\"<div class=\"wp-block-image\">\n<figure class=\"aligncenter size-large\"><img alt=\"\" class=\"wp-image-284643\" height=\"720\" src=\"https://akismet.com/wp-content/uploads/2025/10/akismet-20.png?w=720\" width=\"720\" /></figure></div>\n\n<p>Akismet was launched 20 years ago today, when Automattic founder<a href=\"https://ma.tt/2005/10/akismet-stops-spam/\"> Matt Mullenweg announced it on his blog</a> in a post describing what Akismet was and what it could become.</p>\n\n<p>The internet has changed a lot in the past 20 years!</p>\n\n<p>In 2005, the internet was primarily a desktop experience, dominated by dial&#8209;up or early broadband connections, and social media was in its infancy with platforms like MySpace just beginning to gain traction.</p>\n\n\n<p>Now in 2025, the internet is woven into the fabric of our lives, no longer a separate experience but an invisible thread connecting us all. We carry it everywhere in our pockets, speak to it in our homes and rely on it for almost everything. High-speed internet keeps us constantly connected and AI quietly shapes much of what we read, watch, and buy.  This has transformed how and where we work as well as making the internet a far more immersive and integral part of daily life than it was two decades ago.</p>\n\n\n<p>However one thing has remained the same &#8211; spammers continue to try and evade site defenses to spread their content and Akismet continues to defeat them. Saving moderation time lets people focus on what really matters: creating, connecting, and sharing.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 26 Oct 2025 23:00:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Peter Westwood\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"Gutenberg Times: Gutenberg Changelog #123 – WordPress 6.9 and Gutenberg 21.9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://gutenbergtimes.com/?post_type=podcast&p=42419\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://gutenbergtimes.com/podcast/gutenberg-changelog-123-wordpress-6-9-and-gutenberg-21-9/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:57887:\"<p>In this episode, Birgit Pauli-Haack and Isabel Brison dive into WordPress 6.9 and Gutenberg 21.9. They discuss major updates such as collaborative block-level comments (notes), expanded template management, the new command palette, and foundational block visibility features. New blocks like the accordion, math, and terms query block are highlighted, alongside enhancements in typography and time-to-read. They explore improvements aimed at editorial teams, workflow flexibility, and agency needs, while also touching on ongoing experiments like PHP-only blocks and global styles APIs. The episode wraps with practical advice for developers and encouragement to test out the latest beta features.</p>\n\n\n\n<p><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-123-wordpress-6-9-and-gutenberg-21-9/#shownotes\">Show Notes</a> / <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-123-wordpress-6-9-and-gutenberg-21-9/#transcript\">Transcript</a></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Editor: <a href=\"https://www.linkedin.com/in/sandy-reed/\">Sandy Reed</a></li>\n\n\n\n<li>Logo: <a href=\"https://markuraine.com/\">Mark Uraine</a></li>\n\n\n\n<li>Production: <a href=\"https://icodeforapurpose.com\">Birgit Pauli-Haack</a></li>\n</ul>\n\n\n\n<p class=\"has-larger-font-size\" id=\"shownotes\"><strong>Show Notes</strong></p>\n\n\n\n<h2 class=\"wp-block-heading\">Special guest: Isabel Brison </h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li>GitHub <a href=\"https://github.com/tellthemachines\">@tellthemachines</a></li>\n\n\n\n<li>WordPress <a href=\"https://profiles.wordpress.org/isabel_brison/\">@isabel_brison</a></li>\n\n\n\n<li>X (former Twitter) <a href=\"https://twitter.com/ijayessbe\">@ijayessbe</a></li>\n</ul>\n\n\n\n<p><strong>Previous episodes: </strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-93-gutenberg-17-1-command-palette-data-views-and-grid-layout/\">Episode #93</a></li>\n\n\n\n<li><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-84-gutenberg-15-9-and-16-0-wordpress-6-3/\">Episode #84</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">WordPress 6.9</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2025/10/21/wordpress-6-9-beta-1/\">WordPress 6.9 Beta 1 </a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2025/10/21/help-test-wordpress-6-9/\">Help Test WordPress 6.9</a></li>\n\n\n\n<li><strong>Developer Blog articles</strong>\n<ul class=\"wp-block-list\">\n<li><a href=\"https://developer.wordpress.org/news/2025/10/styling-accordions-in-wordpress-6-9/\">Styling accordions in WordPress 6.9</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2025/09/border-radius-size-presets-in-wordpress-6-9/\">Border radius size presets in WordPress 6.9</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2025/08/registering-custom-social-icons-in-wordpress-6-9/\">Registering custom social icons in WordPress 6.9</a></li>\n</ul>\n</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Gutenberg </h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/WordPress/gutenberg/releases/tag/v21.9.0\">Gutenberg 21.9</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/10/28/gutenberg-21-9-october-22/\">Gutenberg 21.9 (October 22)</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/72464/\">Styles: Move global styles data logic to a dedicated package #72464</a></li>\n</ul>\n\n\n\n<p class=\"has-large-font-size\">Stay in Touch</p>\n\n\n\n<div class=\"wp-block-group\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<ul class=\"wp-block-list\">\n<li>Did you like this episode? <a href=\"https://lovethepodcast.com/gutenbergchangelog\"><strong>Please write us a review </strong></a></li>\n\n\n\n<li>Ping us on X (formerly known as Twitter) or send DMs with questions. <a href=\"https://twitter.com/gutenbergtimes\">@gutenbergtimes </a>and <a href=\"https://twitter.com/bph\">@bph</a>.</li>\n\n\n\n<li><em>If you have questions or suggestions, or news you want us to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. </em></li>\n\n\n\n<li><em>Please write us a review on iTunes! <a href=\"https://gutenbergtimes.com/itunes/\">(Click here to learn how)</a></em></li>\n</ul>\n</div></div>\n\n\n\n<p class=\"has-large-font-size\" id=\"transcript\"><strong>Transcript</strong></p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> So welcome to our 123rd episode to the Gutenberg Changelog podcast. In today&#8217;s episode, we will talk about WordPress 6.9 and Gutenberg 21.9, unless you cover it already in the release discussion. I&#8217;m your host, Birgit Pauli-Haack, curator at the Gutenberg Times and a full time core contributor for the WordPress open source project sponsored by Automattic. After a long break, Isabel Bryson, JavaScript developed by Automattic and core contributor friend and WordCamp buddy is on the show again. I&#8217;m delighted to have you. Thank you for joining us today. Isabel, how are you?</p>\n\n\n\n<p><em>Isabel Brison: </em>I&#8217;m great, thanks. And thanks for inviting me, Birgit. I always love being here. Thank you.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> You&#8217;re always such a delight and you have so much knowledge about the Gutenberg Project. Yeah, it&#8217;s just amazing. So we are jumping right in. Right. What have you been working on for the last period of time?</p>\n\n\n\n<p><em>Isabel Brison: </em>I&#8217;ve been working on bits and bobs, this and that. I did a fair bit of work on the content only feature formerly titled Write Mode, but unfortunately that didn&#8217;t make it into 6.9. It&#8217;s still. It&#8217;s getting there. I am optimistic that we will have it built shortly, but it just wasn&#8217;t stable enough. There were decisions to be made. There was. UX wasn&#8217;t really perfect so we thought we&#8217;d hold back from adding it to this release.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, I think it was a good decision. But I also love the feature. Yeah. That it kind of. You kind of get your head out of the design stuff and you&#8217;re not distracted by the design stuff and you just can create content once a theme is stable or once a site is stable, you don&#8217;t have to make all those things decisions. Yeah. So I&#8217;m really good, really great that that&#8217;s in the works. But yeah, I understand that it is punted, as we say, to WordPress 7.0. Wow. That&#8217;s a big number too. That&#8217;s next year.</p>\n\n\n\n<p><em>Isabel Brison: </em>All right. That&#8217;ll be exciting.</p>\n\n\n\n<h3 class=\"wp-block-heading\">What’s Released &#8211; WordPress 6.9 Beta 1</h3>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. So last episode we were actually talking with Beth Soderberg and we also kind of talked a little bit. What probably didn&#8217;t make it. And now that we have WordPress 6.9 beta 1 out, we know that especially two blocks that I really was looking forward didn&#8217;t make it into the release. They are also punted to 7.0. That is the breadcrumbs block and it&#8217;s the icon block and maybe no, another one. There were some ambitious new blocks in the works. And they will all come, but not for this release. So what are the main features for 6.9, do you think?</p>\n\n\n\n<p><em>Isabel Brison: </em>There&#8217;s a lot. I don&#8217;t see it as a sort of one of those releases where you have one or two massive features that are just absorbing all the attention, it seems like, I don&#8217;t know, I mean, usually by the time we get to the stable release and folks are preparing the release post and the demos and all that, they&#8217;ll, you know, we do a bit of sort of, I want to say marketing spin, but it kind of is around the features and something will have to emerge in first place. But for me it&#8217;s looking, looking at the list, it&#8217;s looking very balanced. There are very sort of no massive feature, but a lot of small to medium great improvements, quality of life stuff. Things that are going to be incredibly useful, like really practical. So I&#8217;m liking that a lot in this feature list for the release.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, I agree with you. However, I think that the notes feature was previously called the block level comments is actually pretty big for editorial teams. Well, for a blogger like me, I&#8217;m the only one on the site, or maybe two or three others, it has no ramification because I can comment myself just a little bit somewhere else. But if you want to kind of keep a step out of the editorial process like Google Docs, where people asynchronously comment on things, that is definitely a feature that a few people really would like to have on their team. So I&#8217;m liking that very much.</p>\n\n\n\n<p><em>Isabel Brison: </em>Yeah, yeah, that is, it&#8217;s. It&#8217;s a very new one. It&#8217;s not a sort of enhancement to any existing thing. It&#8217;s like, oh, suddenly you can comment on posts and that&#8217;s good. It&#8217;s also exciting because it&#8217;s sort a review of things to come in terms of the collaborative editing phase three, you know, the big. I guess what, what would be the big piece of phase three. So yeah, it is in that sense it&#8217;s. It&#8217;s a cool feature. Definitely.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. And the other part is the. I like, but I&#8217;m not quite sure how the switch will happen. The expanded template management. There have been quite some tests in there. So that&#8217;s a feature where you have now two more items in the menu. One is the customized templates and one is the active templates and then the theme templates. Yeah.</p>\n\n\n\n<p><em>Isabel Brison: </em>So there&#8217;s a few interesting sort of workflow changes around that. One of them is that whereas previously you&#8217;d go into your template section in the site editor and you just click into a template, into one of the theme templates and you just go edit it and whatnot. And then you could revert it if you wanted to. But now if you go into the template editor and you click a theme template, it goes, do you want to duplicate this template? Because this is the theme template and you can make a copy if you want, but you&#8217;re not going to touch the original one. So that&#8217;s a bit of a difference. </p>\n\n\n\n<p>And also in the split between, you know, what are the templates that&#8217;s already there in the theme and templates that you might create yourself and your creator templates appearing in the different list and what is probably the most, I guess, I don&#8217;t know, I find it really hard to judge what might be more because different people, different workflows will find things more useful than others. But the active templates one is also super interesting because it means that you can essentially have multiple of each. Say you could have multiple home templates and you can switch between them because only one of them is active. So you say you have three different home templates and the active one is the one that&#8217;s showing on your website&#8217;s homepage. And then you can just go into the admin and switch the active template if you want to just change your homepage to a different template. So that is super cool. If you&#8217;re doing things like, you know, the landing pages and stuff like that, you know, seasonal things. This is my Halloween homepage sort of thing.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Timely example. Wonderful.</p>\n\n\n\n<p><em>Isabel Brison: </em>Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>And it comes with a few hiccups because that one is if you are accustomed to change your template right there from the theme, getting a notification that it&#8217;s now a duplicate there. And normally duplicates we don&#8217;t like. Yeah. So but it also, the advantage is that you can make your edits without interrupting your front page and then can activate the edited one and leave the theme template as it is. And you can always switch back in, activating and deactivating it. But I think that one step is oh, do you want to duplicate? Yeah, it&#8217;s kind of another decision for the user. But I think it&#8217;s a valuable one to point out that, yeah, you can edit this without interrupting your front page and then. And you can build more than one. </p>\n\n\n\n<p>It&#8217;s also good for plugin developers who want to add or help with templating specific features, then they can actually also provide multiple templates for the feature. If it&#8217;s woocommerce yeah, big, big plugin that has a lot of additional features. Yeah, they can provide multiple templates for the product page or for the archive page for products, and then give the user some choices which one they would like more and add in additional features. So I think that&#8217;s also still an underrated feature coming to WordPress, but it makes the handling of the template so much easier or consistent. I would say there&#8217;s no surprises anymore, so. Oh, I didn&#8217;t know I wanted to do that kind of thing. </p>\n\n\n\n<p>The next one on the list is the ability to hide the blocks. I think we talked about it also with Beth Soderberg and with others because that kind of was in some of the Gutenberg releases before. It&#8217;s more a foundational feature right now it can only do hide or show, but there&#8217;s no condition around it. I think the developers really want to make sure that the foundation of adding, showing and hiding is consistent throughout the interface and the front end and all the different pieces like blocks, like patterns, like sync patterns. You could hide a block within the sync pattern or even templates or template parts before they add conditions to it. And also with the conditions will come the thinking about how can other people, third-party extenders, that&#8217;s plugin developers also add additional conditions to it in the realm of the WordPress ecosystem. So I think the treading lightly on that feature is a good first iteration there.</p>\n\n\n\n<p><em>Isabel Brison: </em>Yeah. And it can be super useful as sort of a complement actually to the active templates idea is that you could potentially have a pattern or a block or something you have a sale on. And so you put the sale block up on your website and then you take it down and it&#8217;s still there. You could just switch it on and off whenever you like. So it&#8217;s going to be pretty useful for that sort of workflow, I reckon.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Definitely.</p>\n\n\n\n<p><em>Isabel Brison: </em>I see with the conditional hiding, there&#8217;s one very obvious thing. This I think has sort of been a feature request that&#8217;s been going around for ages, which is being able to conditionally hide blocks depending on the breakpoint. So in order to have different layouts or different, you know, different content for desktop and mobile, for instance. And so that&#8217;s something. But that&#8217;s everything that involves responsive behaviors is so complicated because once you start thinking about how, how do you define this then what is mobile? You know, what are you going to give people fixed breakpoints? Are you going to give them the ability to define their own breakpoints? What&#8217;s this API going to look like? There&#8217;s a lot of questions there that haven&#8217;t been answered.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah, indeed. And. And I think I&#8217;m coming from expectations that I have been using Nick Diego&#8217;s Block Visibility plugin that he started, I don&#8217;t know, three or four years ago and he kind of provided new features every time when he&#8217;s. He released a new plugin. And you can do the time condition, you can do the coming from Twitter or coming from. So there are a lot of expectations there that have been a little bit damped through this first feature in Core, but I think it&#8217;s a good move to do that in the smallest increments possible to not interrupt things too much. So how do you feel about the command palette? Command palette everywhere?</p>\n\n\n\n<p><em>Isabel Brison:</em> It&#8217;s cool. I mean, it&#8217;s actually pretty nice to be on whatever screen call it up, just start typing name of new screen I want to go to and be able to go. Because it. I think it really saves a lot of clicking around in the admin, a lot of, you know, going click, click link to place. Whereas now it&#8217;s just a keyboard shortcut, type enter. Your hand never needs to leave the keyboard. Yeah, that&#8217;s pretty good.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> That&#8217;s pretty good. Yeah. I like it very much and I haven&#8217;t used it that much as I wanted to, but I also haven&#8217;t had the WordPress 6.9 installed on many of the test sites. But yeah, I like that. Now the pressure is off to surface all the menu items to the top so it&#8217;s easily accessible. That&#8217;s kind of for. For a lot of people, kind of the. The problem with the WP admin with those two to three levels deep and this can really. Yeah, shortcut that, as you said, to the next screen to a different. Add a post. You don&#8217;t have to click through all that. You don&#8217;t have to for changing settings. You don&#8217;t have to find which settings do I want. Yeah, and all that. It&#8217;s really cool and I&#8217;m glad that it&#8217;s now available to the full WP admin. That&#8217;s where it&#8217;s really shining now.</p>\n\n\n\n<p><em>Isabel Brison: </em>Yeah, that&#8217;s it. That&#8217;s the thing. It&#8217;s go from anywhere to anywhere, whatever screen you&#8217;re on. That&#8217;s really cool.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> And plugins can register commands for their own tools. So there&#8217;s that API was in 6.8 already, or even 6.7, I don&#8217;t remember, but it was already in WordPress available for plugins to add comments, but if they are out, if most plugins are outside of the site, Editor. So it didn&#8217;t really register to anybody or wasn&#8217;t particularly useful. So yeah, the next thing is, I&#8217;m not quite sure what to make of that. That&#8217;s the allowed block support I get and the UI for it I don&#8217;t get. So a loud block is. Well, why don&#8217;t you explain it?</p>\n\n\n\n<p><em>Isabel Brison: </em>Yeah, that was actually one of the pieces I reviewed, so I tested it a fair bit. And allowed blocks is something that. So the functionality itself has existed for a while, but in order. So what it does is for some containers that support it, you can define which blocks are allowed inside that container. So it could you say by containers I mean blocks that can contain inner blocks, such as a group or a cover or, you know, the usual suspects columns, stuff like that. And in those blocks you can define which blocks are allowed as children of them. So you could say if you have a columns block, these columns will only have headings and paragraphs and I don&#8217;t want any images, I don&#8217;t want any widgets or any other stuff. It&#8217;s only going to have those two types of blocks. Or conversely, you could say that there is a specific type of block that is not allowed. But I think the more frequent sort of use case would probably be to define like a strictly limited amount of blocks that you could use. And this could be useful if you&#8217;re creating patterns and templates that you want to be used in a certain way to make things easier to just define which blocks are going to be allowed in that container. This was already possible to do, but in order to do it you had to edit the block markup. So you had to go into the, you know, the editor code view and you had to write in the block, you had to like identify the block, which is, it&#8217;s not very user friendly. It&#8217;s mostly, you know, it is something that can be done through the UI. You don&#8217;t need a code editor to do it because you have that handy code view in the editor. So you can edit the code, you can add that metadata in there, but it&#8217;s not nice. And having that as a UI option, it&#8217;s well enough hidden away that it&#8217;s not sort of going to interfere with normal workflows. It&#8217;s not in your face. Right. It&#8217;s just out there in the advanced, if you really want to use it, you know, it&#8217;s there just makes things that little bit easier for. I&#8217;d say this is probably mostly a feature for, you know, website admins, theme pattern builders, that sort of scenario agencies probably find it useful.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, I think agencies find it useful, but they&#8217;re already doing that with code. Yeah. So their patterns already have the block markup in it.</p>\n\n\n\n<p><em>Isabel Brison: </em>Yeah. This just makes it a nicer interaction model because, I mean, if we&#8217;re offering essentially what WordPress has been doing for these, you know, for these past I don&#8217;t know how many years since the block editor came out. Really, you know, eight years. That. Wow, that&#8217;s been a while. But we&#8217;ve been building this system that allows you to do as much as you can, that allows you to build whole websites without ever having to touch the code. And this is just, you know, one more piece of that. It&#8217;s like. No, there&#8217;s a UI for that. You can actually. You don&#8217;t actually have to get your hands dirty.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. So I can. I can see how that works for patterns because it&#8217;s kind of one container that is used over and over, but to set it up, you need to be in the editor. So it&#8217;s normally not used for someone who creates posts and pages and has to do the setting for every container that&#8217;s on the canvas to do that. So it&#8217;s probably not that use case that I was. Because it only makes sense for me to get into template parts or get into the containers in the. In the patterns or in templates. Yeah.</p>\n\n\n\n<p><em>Isabel Brison:</em> So, yeah, I&#8217;d say so, yes. This would be mostly a feature for templates and patterns.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah.</p>\n\n\n\n<p><em>Isabel Brison: </em>Like you wouldn&#8217;t be writing a post and go, oh, I&#8217;m going to put a group block in here that only allows paragraphs like what? You don&#8217;t need to do that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, you can do it right away. Yeah, so, yeah, I think that was what tripped me up. So why is in the post and page editor, but that&#8217;s the same editor. So it&#8217;s more function for blocks of blocks everywhere.</p>\n\n\n\n<p><em>Isabel Brison: </em>I mean, you can add patterns to posts and you can add navigation blocks to posts. This will just give you your whole website navigation right there in the post. It&#8217;s like you can do anything with blocks.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, yeah, yeah, yeah. You can definitely do that. Yeah, absolutely. So I get. Yeah. </p>\n\n\n\n<p>So the same is also happening with block bindings where it had been already in WordPress and being used, but it was not particularly expansive. So now block bindings is kind of going out to all blocks and also have UI where you can see what are the bindings in there. And plugins. Plugins will have not in this release, but in 7.0. I think the possibilities to define their own UI for the block binding so I think that&#8217;s going to be a real winner also for plugins to not have to create custom blocks but just do a block bindings to some data. So now we come to the great part and that&#8217;s the new blocks that are in beta 1 now. We are all pretty excited I think about the accordion block. Finally made it.</p>\n\n\n\n<p><em>Isabel Brison:</em> How good is the accordion block?</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> And it&#8217;s pretty feature rich. And I know that Justin Tadlock is working on a style variation tutorial for it. So you as a theme developer or site builder can learn more how you can then style it and what to look for. And he also is testing it so whatever tutorial comes out it. I&#8217;m sure he has one or two, three bug reports that he said, well that could be better. But that&#8217;s kind of the. It&#8217;s the first version so that&#8217;s expected and wanted.</p>\n\n\n\n<p><em>Isabel Brison:</em> Yeah, totally. Lots of testing will have to be done on all these things.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Isabel Brison:</em> So that it&#8217;s all stable in time for the stable release. There&#8217;s a math block now that is super fancy.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Isabel Brison: </em>Like you can do math stuff in your posts.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. And there&#8217;s one math professor I think from Stanford who has a blog for many, many years and he always kind of said is that possible to do latex and ML markup language and all that? So yeah, he, he might be delighted about that. And for all the teachers that are out there that are in, in STEM fields, that&#8217;s. What is that? Science, technology, Math and science.</p>\n\n\n\n<p><em>Isabel Brison: </em>Technology, Engineering. Engineering and math. Is it math?</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah.</p>\n\n\n\n<p><em>Isabel Brison:</em> Interesting. I always thought of maths as part of science, but.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Well, math is used in all kinds of different science.</p>\n\n\n\n<p>Isabel Brison: </p>\n\n\n\n<p>Yeah, it&#8217;s sort of philosophy adjacent too. It&#8217;s a bit, bit of a weird one. It&#8217;s a weird discipline actually.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Engineering needs math too.</p>\n\n\n\n<p><em>Isabel Brison: </em>Well, engineering things. Engineering is a very practical discipline that uses abstract concepts from other disciplines like maths.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Right. Yeah. So that&#8217;s them. In the US there are some instructors who actually call it Steam and the A that comes in Steam is for art because you also need designers to be kind of really good in building a world. But we are digressing.</p>\n\n\n\n<p><em>Isabel Brison:</em> I like STEAM actually. I think because things are a lot more interconnected because you do have that sort of philosophy poking in and you have ethics and you have history and you have a lot of things. Yeah. A lot of arts related disciplines.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, I totally agree with you. Because you also need to have a creative mind and that is actually most of the time only really taught in art settings to kind of be exploratory and to kind of see where the art. Well, your creativity gets you. And yeah, design is applied art. Yeah. In that matter. So, yeah, it&#8217;s kind of. Yeah.</p>\n\n\n\n<p><em>Isabel Brison: </em>Problem solving when you have lots of constraints, lateral thinking, that sort of thing. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> All right, so the terms query block is a very special block that helps you create like the post query loop, a loop of terms that are on your site and then you can display either with counter or without the counter, with links to the archive pages in one swoop. And it also has some adjacent new blocks. That&#8217;s the term name and the term. No term description was already in. In the editor, so that&#8217;s kind of nice for the creative designers. The paragraph and heading blocks now have a fit text.</p>\n\n\n\n<p><em>Isabel Brison:</em> Oh, yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Typography setting. It came out of the idea that there needs to be a stretchy text block and then by exploring how to figure out how that works, the developers came up with, oh, that might just be a setting for the typography and we don&#8217;t need to create a new block. So I think it&#8217;s a really cool, cool PR to read through to kind of see how that all kind of developed in terms of we have an idea in our head and then we need to figure out how to implement it.</p>\n\n\n\n<p><em>Isabel Brison: </em>Yeah, for sure. I think it makes total sense to have that be a setting or sort of like, I guess it should be under typography. I think it is typography. Yes.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>It&#8217;s enough.</p>\n\n\n\n<p><em>Isabel Brison: </em>To be sort of a block support because then that means that you could potentially, you can add it to headings, you can add to paragraphs. I mean, you could add it to other blocks potentially, but I think those are probably the major two that you&#8217;d want this on.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, yeah, yeah. So what it does is actually you. You start typing, give it a. Your heading, and then when you switch it, it kind of fills the whole space of it and not just the space that the normal letters would take. Yeah, when you write it out, it kind of increases it and then. Or makes it smaller depending on how long it is. But it definitely has a higher attention rate on your website and it fills the whole thing, whatever container it is in.</p>\n\n\n\n<p><em>Isabel Brison:</em> Yeah, it&#8217;s pretty cool to play with. It&#8217;s a bit weird because there&#8217;s a bit of a delay in the resizing. So if you&#8217;re editing something in the editor, it resizes just a bit later, which I guess probably you also don&#8217;t want it to resize as you type. I don&#8217;t know. It&#8217;s like great. I think that in that sort of finer detail of getting the experience exactly right. And if I think that there was a bit of back and forth on that on the PR too.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> It was.</p>\n\n\n\n<p><em>Isabel Brison:</em> So it&#8217;s going to be interesting to see where we land with this one.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. Yeah. And I. I think it&#8217;s a bit weird to see the letters go big and small while typing because it kind of gets you a little bit in a motion sickness kind of way. But it&#8217;s also something like the drop gap in the paragraph. Yeah. You don&#8217;t see it in while you&#8217;re typing the paragraph, but once you get out of the block, it formats it, the first letter to be a larger size. So it&#8217;s probably a similar thing that you can only diminish this.</p>\n\n\n\n<p><em>Isabel Brison:</em> Yeah. No, the drop cap actually disappears if you select the paragraph that has a drop cap. Whereas the fit text. The text stays big. It&#8217;s sort of. It slightly changes size. So you have a paragraph with fit text and if you click into it to type in. Because. I&#8217;m not sure if this is because of the cursor, but for some reason it just sort of shrinks slightly. This might be a bug. I&#8217;m not sure we&#8217;ll figure out test a bit further.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> I&#8217;m sure developers will figure it out or designers to kind of make that a little bit more smoother. Yeah. </p>\n\n\n\n<p>And the last block galaxy that comes in is the time to read block. It has been in Gutenberg for quite a while, but it took some major effort to get it past the accessibility problems that it had. And now it&#8217;s actually because of. We talked on a previous episode about that as well, that the time to read, if it&#8217;s a static number, it kind of is hit and miss for the readers who take longer or take shorter, it&#8217;s kind of not really helpful. But now it displays a time range, so from 15 to 18 minutes or 12 to 18 minutes or something like that. If you want that there&#8217;s a choice for the user and then the time to read. Blog actually also has a word count setting, so it can be used as two blocks. One displays the time to read in your. In your loop or on your single post template. And the other one shows the word count. So it kind of gives two pieces of information about two data sets for the reader to figure out do I want to read it now or later? And then later never happens. But that&#8217;s a different story behavior.</p>\n\n\n\n<p><em>Isabel Brison: </em>Yeah, word count is. I find word count a pretty cool block. But do we. Is this something we ever want our readers to know how many words a post has. Is there anyone. I guess my question is, is there anyone out there who chooses what to read based on how many words it has? If you&#8217;re going to, you know, I, you know, I need, I need a five minute read. Are you going to go like, no, I actually need a thousand-word read. Is that a thing?</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Does anyone. Yeah, well, it depends. Writers know how much, how long it takes to read 3,000 words and can say, okay, I read half of it and not the rest of it or something like that. If it&#8217;s good structure, it has the most important part in the first half and not in the second half. But yeah, I don&#8217;t know. People are so different from me. Yeah. That I really don&#8217;t have a good handle of what&#8217;s good. So I wouldn&#8217;t be a good product manager because I said, okay, well everything in there give options here. But that&#8217;s not the philosophy of WordPress. It&#8217;s kind of decisions and other options and I&#8217;m having a hard time thinking about decisions for millions and millions of people that are only millions and millions of people in other cultures. So I really admire all the people who can make those decisions here. I&#8217;m digressing again. Sorry.</p>\n\n\n\n<p><em>Isabel Brison:</em> That happens. But yeah, I agree.</p>\n\n\n\n<p>I&#8217;d much rather be an engineer than the product manager because those folks have to deal with really tough decisions.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. So the next thing is something for theme developers. Pretty much it&#8217;s the border radius presets for the theme JSON file, which is pretty good. So you don&#8217;t have users that have all kinds of ideas how big the border radius has to be. And there&#8217;s a consistent either small or middle or large kind of border radius that you can give options to your users. Justin Tadlock actually wrote a piece already on the developer blog about that. So go and look for it. And of course I also put it in the show notes.</p>\n\n\n\n<p><em>Isabel Brison: </em>Yeah, it&#8217;s linked to from the test blog.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> That too. Yeah.</p>\n\n\n\n<p><em>Isabel Brison:</em> That&#8217;s good. Justin&#8217;s always on top of everything.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. Yeah. Well, as long as theme. As long as it&#8217;s a theme-related gene station-related design related stuff.</p>\n\n\n\n<p><em>Isabel Brison:</em> But this is. It makes perfect sense because you have font size presets, you, you have standard sizes, you have spacing presets, you have all, all sorts of things. So border ages is just one more of those.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. You could even have shadow presets. Yeah. For your, for the shadow setting. Drop shadow setting. Yeah. </p>\n\n\n\n<p>And the next one is that Social links can now have custom icon not only the icon extensibility, but the whole custom variation extensibility where you can create your own social icons with a plugin and have that display on your website. It&#8217;s fairly easy once you get to get through the documentation, all that to actually create. So I needed it for my theme that I do for the Gutenberg Times. It&#8217;s still in the works, but I talked about it earlier. I needed social icons for the various podcast directories where Gutenberg Changelog is actually listed and I only found two of them in the with Core. One was the Spotify and the other one was the RSS Feedback. Yeah. But there&#8217;s also Pocket Cast and there is. The Pocket Cast embed is in there and maybe there&#8217;s even. Yeah, so there&#8217;s also a pod bean and these kinds of things. So I. I had to create a plugin and just add them to it so I can put them in my template. So it&#8217;s a fairly. If I can do it, everybody can do it. Yeah. Kind of thing.</p>\n\n\n\n<p><em>Isabel Brison:</em> Cool. Do you reckon we&#8217;re going to start seeing plugins like for sort of really, really niche sort of, you know, like social media platforms? I can extension pack or podcast platforms. I can plug in like for like specific things.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, I can see that too. Yeah. And. Or payment. Yeah. Kind of for all the content creators. Yeah. You can. You can see a link to Ko Fi and to buy me a coffee or all this. Or Patreon or PayPal. Yeah. For those. Click here and donate something. Yeah, I can see that. And I don&#8217;t think that. Yeah. As contributors we don&#8217;t have the bandwidth to kind of decide. Same thing. Yeah. Decide what&#8217;s now should be in Core and be maintained or not. Yeah. So have the extensibility in there is a really plus for the ecosystem. Yeah. </p>\n\n\n\n<p>And that&#8217;s kind of some of the features that I&#8217;m kind of thinking of right now. I&#8217;m still working on the Source of Truth with all the. What I haven&#8217;t seen, neither in the release post nor in the call for testing, is the. The list of all the improvements for the other blocks. For the old blocks only. Yeah, Kind of. What happened with the cover block and what happened with some of the comment blocks. There are some additional features in there. We kind of wanted to remind everybody that there are 15 Gutenberg plugin releases in this next version. </p>\n\n\n\n<p><em>Isabel Brison: </em>Yeah. And I mean, there&#8217;d be a huge amount of bug fixes, but unless there were a really scandalous bug that everyone was upset about, you wouldn&#8217;t really announce it in your beta 1 release posts, right?</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> No, no, of course releases are for features. Yeah, right, yeah. But there are updates also for developers. I think almost every API got some love in this release. So there is the Data Views and Data Forms. The team has been working on almost all the 15 Gutenberg releases. There was something in there for the Data Views and Data Forms. Then the Abilities API made it just half an hour before the release into the beta.</p>\n\n\n\n<p><em>Isabel Brison:</em> So we will see that one&#8217;s also. It&#8217;s sort of a cool preview or pointer to what the future may hold in terms of AI integrations for WordPress. So it&#8217;s a good one.  I think it&#8217;s good to have it out there, I guess so that plugins can start because the idea is that plugins can register their abilities, the things that they can do, so an AI agent can go and pick up on those things and do tasks for, for the website owner. But of course it&#8217;s one of those things that it has to. It&#8217;ll only work if, if there&#8217;s adoption. So I guess it&#8217;s good to get it out there early. So maybe plugins will start experimenting with that and then once all the other parts because then you know, there&#8217;s a whole workaround building MCP adapter so that those abilities can be channeled through to AIs. So that&#8217;s, you know, it&#8217;s all a big working process. Pretty exciting.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah, yeah, I feel that too. Yeah. But I, I think the, the MCP, it&#8217;s not yet ready yet. I think. Yeah, people have worked on it, but it wasn&#8217;t near ready to be in Core and be maintained for the future because it&#8217;s the backwards compatibility promise that WordPress has. Might delay a few things to make sure that people are really sure that needs to be in Core or that it doesn&#8217;t change too much in the future. And with all the AI stuff, it&#8217;s probably hard to predict how far, how long it needs to wait or how this all comes together.</p>\n\n\n\n<p><em>Isabel Brison: </em>Yeah, it&#8217;s interesting because the whole of sort of AI-related development is going in this whole like move fast and break Things mode, whereas WordPress is not about moving fast and breaking things. So yeah, no, the MCP I mentioned it because this is something that will, the Abilities API will later be integrated with if all goes well.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. And there&#8217;s a plugin out there. So the AI team, Core AI team has four building blocks. One is the Abilities API, the other one is the MCP adapter and then there is a PHP SDK software development kit. Basically the fourth one is the plugin that kind of pulls it all together and kind of shows what actually could be possible. So people who kind of. Or developers who kind of want to get into that field can gradually skill up on the AI stuff. And I think it&#8217;s really cool. And I know that Jonathan Bosinger, he has done a lot of live streams on all the AI features and has worked with the Abilities API and he&#8217;s preparing also for the developer blog an article to kind of do the introduction there and figure out a use case or a little small plugin that kind of uses it. So, yeah, pretty cool. Cool things to come. Yeah, the interactivity API improvements are more about the router of that.</p>\n\n\n\n<p><em>Isabel Brison: </em>Yeah, I have to say I didn&#8217;t really follow these very closely.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, me neither. It was always so it sounded all like bug fixes, but I know there&#8217;s something in there that people would like to use. I need to get smarter about that, but I haven&#8217;t yet. And then the updates to the block bindings, where block bindings coming to other blocks or to custom blocks in one way or other, and then the updates on the HTML API, those are totally beyond me.</p>\n\n\n\n<p><em>Isabel Brison: </em>Yeah, those are more internal things that you wouldn&#8217;t see any user facing changes with HTML API updates. You might, I mean, potentially in some places it might make the code a bit more performant, it might make the code a bit more stable. It&#8217;s generally, it&#8217;s. They&#8217;re good code quality improvements, but it&#8217;s not something that you can actually point at on the front end of the website and go, hey, this is the.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Thing, the HTML API. Yeah, celebrated.</p>\n\n\n\n<p><em>Isabel Brison: </em>And you don&#8217;t see it in action.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Like visually put fireworks on it. Yeah, I said, why? Yeah, that&#8217;s kind of funny. Yeah. But what I learned is one of the good things about the HTML API is that you could actually parse HTML without using regex and get a better, say, a more consistent outcome on things. If you want to add an attribute or class or something, something like that to certain things, that&#8217;s a good use case for HTML API. But it&#8217;s also. Get a URL link content. Yeah, there are these new functions that, if you had to write them yourself, kind of really complicated. But there&#8217;s an underlying support layer with the HTML API that kind of saves you a lot of work on that.</p>\n\n\n\n<p><em>Isabel Brison:</em> Oh yeah. And things we do a lot, very frequently throughout the code. And yeah, as you say, we were using regexes for things and like had custom solutions here and there to like add a class, remove a class, edit a class, do weird things with bits of markup. And the TAG processor has made a lot of code a lot more readable.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. So I think that&#8217;s for now. The WordPress 6.9 part of our changelog today. We need to get going here. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Gutenberg 21.9</h3>\n\n\n\n<p>So what&#8217;s in 21.9 specifically? </p>\n\n\n\n<h3 class=\"wp-block-heading\">Enhancements</h3>\n\n\n\n<p>We talked about the allow blocks UI and support for more blocks. </p>\n\n\n\n<p>What I like is actually the aspect ratio control for gallery blocks.</p>\n\n\n\n<p><em>Isabel Brison: </em>I was going to mention that. I was just looking at it going, oh, that&#8217;s a cool feature. Yeah, it is, absolutely.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. But all of a sudden you have the pictures that are in your gallery along the same size and all the like. Yeah, it can look really cool. And then in 21.9 there are also features in there that didn&#8217;t make it in 629 like the breadcrumbs block for testing. It&#8217;s all. It&#8217;s still behind the experiments flag but it. It will support the post with terms has some other. It&#8217;s actually added in 21.9 to the Gutenberg plugin.</p>\n\n\n\n<p><em>Isabel Brison:</em> There&#8217;s a cool one here that I wanted to point out in relation to the Data Views package that is actually pretty visible in the front end. So it&#8217;s shipping in 6.9, which is the persistence for your page settings. So when you&#8217;re in the site editor, say you go into the pages view and the default of that view is a list and the site preview and you can change that. Say you can change it to display as a grid or a table and previously you change that and then you&#8217;d navigate to another place and then you&#8217;d get back and it would be reset to the default view. Whereas now it will save your settings, your view settings. When you navigate away and you navigate back, if you&#8217;ve reset the view, you still have the same view that you configured. So I think that&#8217;s just. It&#8217;s just one of those little but really cool quality of life improvements that was chipping in 6.9.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, it&#8217;s kind of upsetting when, when, when it doesn&#8217;t remember. Yeah, because it&#8217;s a bloody computer. It should remember.</p>\n\n\n\n<p><em>Isabel Brison: </em>Yeah, no, I need this view because I really need to look at the featured images or whatever and I need to see them in this size. And then you navigate it and go, no, it&#8217;s all gone back again.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Is this stored in the user preferences or is it more in the browser or.</p>\n\n\n\n<p><em>Isabel Brison: </em>Yeah, so technically I think a new package has been created to store these. There&#8217;s like a new Views package which is being used to store data. Views preferences. It is. I would say it&#8217;s likely to be. It&#8217;s likely to use emitter stored in your browser settings like, you know, local storage.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Okay.</p>\n\n\n\n<p><em>Isabel Brison:</em> But I haven&#8217;t actually dived yet.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>It&#8217;s just a detail that I was kind of. Yeah. If I move away from my computer and go to a different computer if it&#8217;s stored in the browser. I don&#8217;t have that feature persistent here. But anyway, so yeah, we talk pretty much through things because the 21.9 is the last Gutenberg plugin release that has features for WordPress 6.9. After that, only bug fixes and quirkiness removal will make it into the release. So a lot of the things that we talked about actually came in just ahead of the 21.9 release candidate. So the notes are graduated from the experiments here so they can get into the release. </p>\n\n\n\n<p>The switch from block comments to notes in the term of description and how we talk about it to offset the confusion with the other comments that we have on WordPress. Yeah. Which is the user comments, the visitor comments. So that&#8217;s also in this release. We talked about the coordinate block. We talked about block visibility. There&#8217;s a keyboard shortcut actually for the block visibility. So you can. You can highlight a click on a. On a block and then do control or command shift H and then you hide it or H back again. It shows a toggle switch toggle keyboard. So that&#8217;s pretty cool. And there&#8217;s some drag and drop by move quality of life enhancements. When you move the block, it actually moves the block animation. So you kind of know, okay, I&#8217;m still moving this block, I&#8217;m not moving something else.</p>\n\n\n\n<p><em>Isabel Brison:</em> Yeah, the drag and drop. Being able to drag and drop actual blocks is also a really great improvement. Like to actually grab the blocks and drag them somewhere else and see it being dragged.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah.</p>\n\n\n\n<p><em>Isabel Brison: </em>And yeah, yeah, yeah.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Experiments</h3>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>And then there is what is in 6.21.9 are actually experiments that I wanted to point out. I talked with Beth Soderberg about that because in the 20.8 there was a new block API for PHP only blocks. And it&#8217;s definitely not a fully featured thing yet. But it now has auto register the block with the block API version 3, which is important for the Iframe editor. And the other one is to make sure that the editor interactions and block supports are also working correctly with the PHP only blocks. What was In Block Editor, kind of dividing from the get go is that people, some PHP developers, hate JavaScript with a vengeance. They can.</p>\n\n\n\n<p><em>Isabel Brison: </em>I&#8217;m sorry to hear it.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, I know.</p>\n\n\n\n<p><em>Isabel Brison: </em>I kind of understand.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. JavaScript, the good parts, is a very small book. So there is the expectations that not all good things from the JavaScript block handling comes into PHP, but now it&#8217;s much easier to create blocks with just PHP. But it&#8217;s experimental. It is not yet in WordPress 6.9 and I don&#8217;t know the timeline from that, but it&#8217;s just. I just want to point it out that some people can start testing things with the Gutenberg release 21.9.</p>\n\n\n\n<p><em>Isabel Brison: </em>Yeah, yeah, that would be great. That&#8217;s a great thing for extenders to test and give feedback on, I think. Especially while it&#8217;s still experimental, right?</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, absolutely. Especially agency developers and plugin developers who haven&#8217;t made the switch to block things yet. And then. Yeah, go ahead.</p>\n\n\n\n<p><em>Isabel Brison:</em> I was just going to say I was doing a bit of experimenting here just to loop back on the data views preference persistence thing. It appears to be using preferences because it does maintain your preference across browsers.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Okay, cool. Thank you for filling that gap. Knowledge gap. There&#8217;s also an experiment that the navigation block toolbar gets an add navigation or edit navigation in the template part editor, which is definitely helpful because clicking on things, it&#8217;s sometimes hit or miss, but I think it&#8217;s an experiment. I didn&#8217;t see that that made it into 6.9 because that came very late into 21.9.</p>\n\n\n\n<p><em>Isabel Brison: </em>There&#8217;s been a lot. There&#8217;s been a lot of sort of ongoing work on the navigation block. There are no huge pieces. Each one likes just sort of small bits and pieces. There&#8217;s a general improvement to how it works. Which, which one in particular are we looking at?</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>When you go in the rundown further down to the experiments, there&#8217;s one for the block API and then for the block library, it has a navigation block toolbar. And when you click through the PR that at 72008 you see it still has the experimental label there and there&#8217;s also no backport to 6.8. 6.9.</p>\n\n\n\n<p><em>Isabel Brison:</em> Oh, okay.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. So you&#8217;d like that because you like having text in your toolbar, right?</p>\n\n\n\n<p><em>Isabel Brison: </em>Oh, yeah. No, I&#8217;m finding it very interesting that some of these new buttons for new functionality that pops up are actually text buttons. It&#8217;s like, oh, we&#8217;re giving up on icons. Express things with icons as fully as you can with text. Like I&#8217;ve Look, I&#8217;ve always struggled with icons. To be perfectly honest. One of the reasons I worked on. On the text labels setting was because I could not tell the icons apart from each other. If I&#8217;m going to be working on this UI, there has to be a way of switching this off.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. And a lot of people actually are grateful for that as well. With the same reason. Yeah. That I can&#8217;t. Don&#8217;t do it for me. To be sure that I click when I click on it. That I don&#8217;t offset a nuclear bomb or something like that. Yeah, yeah.</p>\n\n\n\n<p><em>Isabel Brison: </em>Was that the one I wanted to click? No, it&#8217;s the other one.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> And what was it again? That I really. Yeah. To kind of remember those icons as well. Well, and then for the block bindings, there is an experiment in 21.9 that extends the UI to the external sources. That&#8217;s something that I mentioned before that it won&#8217;t make by the block bindings. It won&#8217;t make into 6.9, but it is kind of in the works for 7.0 and to extend the UI for the block bindings so plugins and other extenders can work with that and have their custom blocks and all that. And if you&#8217;re interested in a PHP only blocks, there is actually an added. There is some documentation in there now in the block editor. Even if it is now still an experiment. There is already some documentation under the getting started fundamentals registration of block. There is a PHP only block in autoregistration chapter now. </p>\n\n\n\n<h3 class=\"wp-block-heading\">What’s in Active Development or Discussed</h3>\n\n\n\n<p>I think there was all I wanted to point out from the 21.9 release. That is beyond 6.9 features and all that we have also one thing that might be interesting for the theme developers and also for plugin developers who want to tap into global styles. The global styles have been. The data logic has been moved into a dedicated package. So you don&#8217;t have to have three or four packages to kind of deal with your global styles. It&#8217;s just one that you have to include in your plugin. So I think that&#8217;s very good development there.</p>\n\n\n\n<p><em>Isabel Brison: </em>This is still sort of far from its definitive shape yet there was actually that even today there&#8217;s sort of discussion on that PR as like, should it be this package? Should we. I was. I was arguing for some of these things to be in the style engine package. And Riyadh&#8217;s sort of holding back going, no, it might be too early. Let&#8217;s try and figure out the APIs first. One, a very practical reason for this to appear is because there are a bunch of global styles logic that lives in edit site and if we want to use it in the post editor, it&#8217;s not really available. And so global styles should, you know, global styles should be in a place where it&#8217;s not bound to a specific editor and it can be used across the board. So this is sort of it&#8217;s work that&#8217;s going to be helpful for lots of internal purposes too. I think we&#8217;re still not quite close to getting to the point where we start thinking about how useful this is going to be for extenders. However, I have to say if extenders are listening that may be interested in using any of these APIs. Feedback is always very welcome. I mean we can only know what needs to be public and what tools we should offer when people tell us. I need that, you know, this is a thing that would actually be very useful so that any feedback on that count I think would be really good.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, there&#8217;s still a few things that are still in private APIs but I think that&#8217;s the step to kind of move it into a public API as well. Yeah, awesome. Yeah, thanks for diving in there. Yeah, it&#8217;s a lot of commentary there and also with further PRs to fix some of that, but it is merged. It&#8217;s alerting. It&#8217;s however in the milestone for 22.0 and we&#8217;ll see how far that goes when we talk about that in the plugin release of Gutenberg 20.0 which is actually the next one in two weeks so. Well, yeah, yeah, yeah but I think there&#8217;s a lot of activity going to be around 6.9 buck fixes and all that as well. </p>\n\n\n\n<p>So if people want to connect with you, where would they find you? Isabelle, what is the best way to connect with you?</p>\n\n\n\n<p><em>Isabel Brison: </em>I think I&#8217;m. I&#8217;m sort of not really on social media these days, so GitHub I am tell the machines on GitHub you can always come and you know, leave comments on my pull requests and the work that I&#8217;m doing. If it&#8217;s anything you&#8217;re interested in. I am also in the core WordPress slack. I think I&#8217;m also. Yeah, I&#8217;m also told the machines. So that&#8217;s. Yeah, that&#8217;s me.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>That&#8217;s a great handle coming out of the 90s.</p>\n\n\n\n<p><em>Isabel Brison:</em> Yeah I was like ah, talk to computer thing.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Right, right, right. Yeah. Well it&#8217;s such a pleasure to talk with you through All Geek out over the Gutenberg Project and releases. Thank you so much for being here. Dear listeners. Go and test help test WordPress 6.9. The instructions are incredibly detailed and Krupa Nanda and Jonathan Bossingers, who are the test release leads, co-leads, have done a fantastic job to kind of put it all together. Of course, the links will be in the show notes. I will also link the PR we talked about the global styles going into a dedicated package. I will link that as well in the show notes. And as always, the show notes will be published on GutenbergTimes.com podcast this is episode one, two three and like it is my password one two three.</p>\n\n\n\n<p><em>Isabel Brison</em>: I love it.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>And if you have questions or suggestions and news you want us to include, to send them to <a href=\"http://changelogudenburgtimes.com\">changelog@gudenburgtimes.com</a> that&#8217;s an email address and <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a> so thank you all for listening and thank you again, Isabel, for joining us. Bye Bye.</p>\n\n\n\n<p><em>Isabel Brison: </em>Thank you. Bye.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 26 Oct 2025 09:30:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"Matt: November Atlantic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150377\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://ma.tt/2025/10/november-atlantic/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1961:\"<p><a href=\"https://www.theatlantic.com/magazine/toc/2025/11/\">The Atlantic November issue is lovely</a>, focused on the American Revolution. I particularly enjoyed:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://www.theatlantic.com/magazine/archive/2025/11/king-george-iii-british-monarchy-american-revolution/684309/\">The Myth of Mad King George</a>, which gave a different more nuanced view of King George I didn&#8217;t have before or from <a href=\"https://hamiltonmusical.com/new-york/\">the Hamilton musical</a>.</li>\n\n\n\n<li><a href=\"https://www.theatlantic.com/magazine/archive/2025/11/benjamin-franklin-william-political-conflict/684315/\">Why Did Benjamin Franklin’s Son Remain Loyal to the British?</a> I was obsessed with with Ben Franklin&#8217;s Autobiography as a kid, he was an incredible self-made man who came from impossibly hard beginnings and had a profound impact on history. I think I originally read <a href=\"https://www.gutenberg.org/files/20203/20203-h/20203-h.htm\">through Project Gutenberg </a>on my first <a href=\"https://www.pencomputing.com/palm/Reviews/visor1.html\">Handspring Visor</a>. The article shows an entire huge part of his life that is missing from his Autobiography.</li>\n\n\n\n<li><a href=\"https://www.theatlantic.com/magazine/archive/2025/11/the-american-revolution-ken-burns-documentary/684314/\">What We Learned Filming The American Revolution is from Ken Burns</a>, Sarah Botstein, and David Schmidt, who&#8217;ve come together with the challenging task of making a documentary from a time there were no photographs or videos. Ken Burns is one of my favorite documentarians, and the behind the scenes is very interesting.</li>\n</ul>\n\n\n\n<p>So pick up a copy as you pass through an airport or by a newstand. I consider it a very worthwhile subscription. It might be better to read in print or through <a href=\"https://www.apple.com/apple-news/\">Apple News+</a> as their website a bit broken for me right now.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 26 Oct 2025 06:55:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Riad Benguella: Debugging WordPress Scripts and Styles\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://riad.blog/?p=56631\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://riad.blog/2025/10/25/debugging-wordpress-scripts-and-styles/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1654:\"<p>With the move to more JavaScript and Styles in WordPress admin pages and editors, I spend some time debugging what styles and scripts are being loaded on a given page. (Specially important if you&#8217;re working on blocks, or JavaScript rendered admin pages)</p>\n\n\n\n<p>To help with that I use a <a href=\"https://gist.github.com/youknowriad/e5854d6c602c73dec260d56a2783408a\">small vibe-coded tool</a>. It helps understanding why a script or style was enqueued on a given page.</p>\n\n\n\n<p>For each script (or style) it gives:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>The uncompressed size.</li>\n\n\n\n<li>If it was enqueued explicitly.</li>\n\n\n\n<li>Which ancestor script was enqueued explicitly causing the current one to be loaded in the page as well.</li>\n\n\n\n<li>What is the direct parent script.</li>\n</ul>\n\n\n\n<p>And it presents all of that in a digestible list.</p>\n\n\n\n<figure class=\"wp-block-video\"><video controls=\"controls\" src=\"https://riad.blog/wp-content/uploads/2025/10/Screen-Recording-2025-10-20-at-9.26.04-AM.mov\"></video></figure>\n\n\n\n<h2 class=\"wp-block-heading\">How to use it</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Just drop <a href=\"https://gist.github.com/youknowriad/e5854d6c602c73dec260d56a2783408a\">the file</a> in your WordPress plugins folder (or load in another existing plugin)</li>\n\n\n\n<li>Append <code>?debug_script=true</code> to the url of the admin page that you want to debug.</li>\n</ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p>That&#8217;s it, for a more complete debugging solution, consider checking the excellent <a href=\"https://wordpress.org/plugins/query-monitor/\">Query Monitor</a> plugin.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 25 Oct 2025 11:17:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Riad Benguella\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Gutenberg Times: WordPress 6.9 Beta, Gutenberg 21.9, Playground, and Fields API—Weekend Edition 346\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=42361\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://gutenbergtimes.com/wordpress-6-9-beta-weekend-edition-346/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:22687:\"<p>Hi there, </p>\n\n\n\n<p>I am genuinely giddy about WordPress 6.9 and its delightful updates.  Major kudos to all contributors, who push it over the first hurdle of this release cycle. <a href=\"https://make.wordpress.org/core/2025/10/21/wordpress-6-9-beta-1/\">The Beta 1</a> release happened earlier this week. The final release is scheduled for December 2nd, 2025. </p>\n\n\n\n<p>There are lots of different updates for the full range of WordPress users.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Content creators</strong> get a number of new and waited-for Blocks, with Accordion, Time to Read, Term Query and MathML Block, and further refinements to block handling and existing blocks. </li>\n\n\n\n<li><strong>Theme and site builders</strong> get additional tools to style a site via theme.json and majorly improved template management right in the site editor, and </li>\n\n\n\n<li><strong>Developers</strong> can build faster with an enhanced Block Bindings API and Interactivity API, and for the admin side of plugins the component library of DataViews and DataForms has some great updates as well. </li>\n</ul>\n\n\n\n<p>Release Test co-lead, <strong>Krupa Nanda</strong> posted great instructions on how you can <a href=\"https://make.wordpress.org/test/2025/10/21/help-test-wordpress-6-9/\"><strong>Help test the Beta 1 release of WordPress 6.9 </strong></a>. It&#8217;s the best way to learn how to use the new features and report quirks and bugs back to the contributors, so they can be fixed before Release Candidate 1 which is scheduled for November 11. </p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://make.wordpress.org/core/2025/10/21/wordpress-6-9-beta-1/\"><img alt=\"WordPress 6.9 Highlight grid [WIP]\" class=\"wp-image-42382\" height=\"375\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/WordPress-6-9-Highlight-grid-variation-1.png?resize=652%2C375&#038;ssl=1\" width=\"652\" /></a></figure>\n\n\n\n<p>In Europe we will turn back our clocks one hour on Sunday (Oct 26). The US will follow suit next week (Nov 2). This will be the week of &#8220;pick-up meetings&#8221; for me. It&#8217;s what I call the phase where I miss a meeting and instead turn up at someone else&#8217;s meeting and meet new people. Win-win. <img alt=\"🎉\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f389.png\" style=\"height: 1em;\" /> But seriously, if you scheduled a meeting with me next week, you can&#8217;t send too many reminders if you want me to turn up in time. </p>\n\n\n\n<p>Have a splendid weekend ahead, </p>\n\n\n\n<p>Yours, <img alt=\"💕\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f495.png\" style=\"height: 1em;\" /><br /><em>Birgit</em></p>\n\n\n<section class=\"wp-block-newsletterglue-group\" style=\"padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;\">\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<nav class=\"wp-block-table-of-contents\"><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/wordpress-6-9-beta-weekend-edition-346/#0-word-press-release-information\">Developing Gutenberg and WordPress</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/wordpress-6-9-beta-weekend-edition-346/#upcoming-learn-wordpress-online-workshops\">Upcoming Learn WordPress online workshops </a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/wordpress-6-9-beta-weekend-edition-346/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/wordpress-6-9-beta-weekend-edition-346/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/wordpress-6-9-beta-weekend-edition-346/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor.</a></li></ol></nav>\n</div></div>\n</section>\n\n\n<p><strong>This week in WordPress</strong> is a great long-running show by WPbuilds and host <strong>Nathan Wrigley</strong>. A panel of three people chats about last week&#8217;s WordPress news. They comment, explain and present addtional view points. It&#8217;s loosely inspired by &#8220;This week in Google&#8221; an even longer-running show of the <a href=\"https://twit.tv/\">This week in Tech (TWiT) network</a> that was <a href=\"https://www.twit.community/t/this-week-in-google-is-becoming-intelligent-machines/17988\">renamed</a> at the beginning of this year to <a href=\"https://twit.tv/shows/intelligent-machines\"><strong>Intelligent Machines.</strong></a> With Jeff Jarvis, Leo LaPorte and others. It&#8217;s my favorite podcast. But I digress. </p>\n\n\n\n<p>In the latest episode, <a href=\"https://wpbuilds.com/2025/10/21/this-week-in-wordpress-353/\"><strong>This week in WordPress 353</strong></a>, <strong>Michelle Frechette</strong>, <strong>Tim Nash</strong>, <strong>Nathan Wrigley</strong> and yours truly discussed the great Internet outage of 2025 aka AWS outage, the WordFence Security Report, WordPress 6.9 upcoming features, Gutenberg updates, and Tammie Lister&#8217;s fun blocks and so much more. <a href=\"https://www.youtube.com/watch?v=ArFYfbkypA8\">Listen in on YouTube</a> or your favorite Podcast app. </p>\n\n\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p><strong>Rae Morey</strong>, The Repository, reported that <a href=\"https://www.therepository.email/wordpress-6-9-beta-1-now-available-and-ready-for-testing\"><strong>WordPress 6.9 Beta 1 Now Available and Ready for Testing</strong></a> and gives and overview of the features and also what&#8217;s didn&#8217;t make it into the release, a nice recap on the progress of the Admin Redesign.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Besides WordPress 6.9 Beta, the fabulous crew of contributors also <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v21.9.0\"><strong>released Gutenberg 21.9.</strong></a> It brings three new blocks: MathML, Term name and Term Count blocks, the latter two used in the context of the new Term Query block. The <code>allowedBlocks</code> feature has been expanded to all blocks and users can also use the new UI tools to controls allowed blocks for templates and patterns, without writing code or editing raw block markup. Hide/show block features was added also to synced patterns and template parts. It can also be called upon via Command Palette and keyboard shortcut <kbd>cmd/ctrl+shift+H</kbd>. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Isabel Brison</strong>, JavaScript developer at Automattic and core contributor, joined me on the podcast and filled various knowledge gaps about the updates in this release. We also had great fun discussing WordPress 6.9 features, soon coming to your a WordPress instance near you. </p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p><img alt=\"🎙\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f399.png\" style=\"height: 1em;\" /> The latest episode is <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-123-wordpress-6-9-and-gutenberg-21-9/\">Gutenberg Changelog #123 – WordPress 6.9 and Gutenberg 21.9</a> with Isabel Brison, core contributor. </p>\n\n\n\n<figure class=\"wp-block-image size-full is-style-no-vertical-margin\"><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-123-wordpress-6-9-and-gutenberg-21-9/\"><img alt=\"\" class=\"wp-image-42384\" height=\"185\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/Screenshot-2025-10-23-at-17.20.50.png?resize=652%2C185&#038;ssl=1\" width=\"652\" /></a></figure>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-rich is-provider-pocket-casts wp-block-embed-pocket-casts\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div></div></div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"upcoming-learn-wordpress-online-workshops\">Upcoming Learn WordPress online workshops </h2>\n\n\n\n<p>On <strong>Thursday, Oct 30, 10:00 UTC</strong>, <strong>Maruti Mohanty</strong> will hold a workshop and show off  <a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/311670069/\"><strong>WordPress 6.8 Features in Action + 6.9 Sneak Peek: A Hands-On Workshop.</strong></a></p>\n\n\n\n<p>On <strong>Thursday, Oct 30, at 20:00 UTC</strong>, <strong>Velda Christensen</strong>&#8216;s workshop will be about  <strong><a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/311632066\">Landing Pages, Posts, &amp; More: Strategies for a Stronger Site</a></strong> -In this beginner-friendly workshop, we’ll explore simple ways to organize your WordPress content so visitors can easily find what they need and take the next step.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p><strong>Brian Coords</strong> has the details on the latest release of WooCommerce 10.3. in his release post. <a href=\"https://developer.woocommerce.com/2025/10/22/woocommerce-10-3-cogs-comes-to-core-and-mcp-beta/\"><strong>WooCommerce 10.3: COGS comes to core and MCP beta</strong></a> he highlights: </p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://developer.woocommerce.com/2025/10/22/woocommerce-10-3-cogs-comes-to-core-and-mcp-beta/#h-address-autocomplete-for-checkout-blocks-and-shortcode\">Address autocomplete for Checkout blocks and shortcode</a></li>\n\n\n\n<li><a href=\"https://developer.woocommerce.com/2025/10/22/woocommerce-10-3-cogs-comes-to-core-and-mcp-beta/#h-product-collection-editor-improvements\">Product Collection Editor improvements</a></li>\n\n\n\n<li><a href=\"https://developer.woocommerce.com/2025/10/22/woocommerce-10-3-cogs-comes-to-core-and-mcp-beta/#h-cost-of-goods-sold-cogs-is-here\">Cost of Goods Sold (COGS) is here</a></li>\n\n\n\n<li><a href=\"https://developer.woocommerce.com/2025/10/22/woocommerce-10-3-cogs-comes-to-core-and-mcp-beta/#h-woocommerce-mcp-is-available-for-testing-in-beta\">WooCommerce MCP is available for testing in beta.</a></li>\n\n\n\n<li><a href=\"https://developer.woocommerce.com/2025/10/22/woocommerce-10-3-cogs-comes-to-core-and-mcp-beta/#h-more-new-features-and-updates\">More new features and updates</a></li>\n\n\n\n<li><a href=\"https://developer.woocommerce.com/2025/10/22/woocommerce-10-3-cogs-comes-to-core-and-mcp-beta/#h-api-updates\">API Updates</a></li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://developer.woocommerce.com/2025/10/22/woocommerce-10-3-cogs-comes-to-core-and-mcp-beta/\"><img alt=\"Product Collection editor improvements in Woo 10.3 \" class=\"wp-image-42365\" height=\"320\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/Product-collections-improvments-Woo-10.3.webp?resize=652%2C320&#038;ssl=1\" width=\"652\" /></a></figure>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Blocktober Fun</strong>, the October challenge to build a block a day with Automattic&#8217;s Telex, is almost over. This week, <strong>Tammie Lister</strong> prompted the Block building AI tool for another set of fun blocks: </p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://blocktober.fun/sketch-image/\">Sketch Image</a> </li>\n\n\n\n<li><a href=\"https://blocktober.fun/ripple-text/\">Ripple Text </a></li>\n\n\n\n<li><a href=\"https://blocktober.fun/vhs-glitch/\">VHS glitch</a></li>\n\n\n\n<li><a href=\"https://blocktober.fun/flip-card/\">Flip Card</a></li>\n\n\n\n<li><a href=\"https://blocktober.fun/emoji-voting/\">Emoji voting</a></li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-full\"><img alt=\"\" class=\"wp-image-42370\" height=\"220\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/Screenshot-2025-10-23-at-10.33.01.png?resize=652%2C220&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>A new fun plugin arrived at the WordPress plugin repository: It&#8217;s called  <a href=\"https://wordpress.org/plugins/throwable/\"><strong>Throwable</strong></a> by <a href=\"https://x.com/qarayahya\"><strong>Qara Yahya</strong></a>, founder of BlockLayouts. Using it you can place buttons, paragraphs or image into the Throwable block. The adjust Gravity aka speed items fall and Bounce setting, and have some nice animation on your site.  </p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"\" class=\"wp-image-42369\" height=\"477\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/throwable.png?resize=652%2C477&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://x.com/justintadlock\">Justin Tadlock</a></strong> released <a href=\"https://wordpress.org/plugins/x3p0-breadcrumbs/\"><strong>Breadcrumbs Block v. 3.0</strong>.</a> The update includes support for the built-in Layout and Block Gap (Spacing) features in WordPress. &#8220;There are quite a few other changes and some notable bug fixes, particularly if you extend the block with custom code. Be sure to check out the changelog&#8221; he <a href=\"https://x.com/justintadlock/status/1971721876306382889\">wrote on X.</a></p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img alt=\"\" class=\"wp-image-42377\" height=\"350\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/Screenshot-2025-10-23-at-13.25.01.png?resize=652%2C350&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p><strong>Sid Sharma</strong>, content creator from Nepal, demonstrates <a href=\"https://www.youtube.com/watch?v=sul4r-KjfAc\"><strong>how to create a transparently floating sticky header in WordPress</strong></a>, all in the Site Editor for Block Themes.</p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n<section class=\"wp-block-newsletterglue-callout undefined not-color-set\" style=\"border-color: #f9f9e5; border-radius: 22px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f9f9e5;\">\n<p><strong> <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" rel=\"noreferrer noopener\" target=\"_blank\">&#8220;Keeping up with Gutenberg &#8211; Index 2025&#8221;</a> </strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. The previous years are also available: <strong><strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">2020</a> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/\">2021</a></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/\">2022</a></strong></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023\">2023</a></strong> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2024/\"><strong>2024</strong></a></p>\n</section>\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor.</h2>\n\n\n\n<p><strong>Seth Rubenstein</strong>, lead developer at the Pew Research Center and speaker at WordCamp US, chatted with <strong>Nathan Wrigley</strong> on the Jukebox podcast about  <a href=\"https://wptavern.com/podcast/190-seth-rubenstein-on-block-composability-in-wordpress-future\"><strong>Block Composability in WordPress’ Future</strong></a>. Rubinstein &#8220;shares fascinating stories from the work h e’s recently been doing. He breaks down what block composability really means, the ability to build modular, reusable, and even interactive blocks that work seamlessly together, empowering both developers and end users to create sophisticated web applications within the familiar WordPress block editor.&#8221; wrote Wrigley in his podcast show notes. </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-rich is-provider-pocket-casts wp-block-embed-pocket-casts\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://x.com/fellyph\">Fellyph Cintra</a></strong>, developer advocate working for Automattic, published <a href=\"https://make.wordpress.org/playground/2025/10/23/things-you-might-have-missed-about-the-playground-project-over-the-past-few-months/\"><strong>Things you might have missed about the Playground project over the past few months</strong></a>. It&#8217;s a great roundup post about the amazing work of the team. He mentions the PHP-Wasm changes, updates to the Playground CLI, the JavaScript API,  how to use Playground with Playwright and the performance improvements with OPCache enabled by default. He also addresses rumors about missing features compared to traditional WordPress installs, noting that this gap is becoming less significant.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p>In preparation for the WordPress 6.9 Field Guide, <strong>André Maneiro</strong> just posted an update about the <a href=\"https://github.com/WordPress/gutenberg/issues/70936#issuecomment-3437790150\"><strong>Fields API</strong></a>, that has been worked on for many Gutenberg releases. It lists functions and options with code examples. Updates on DataViews and DataForm are still to come. </p>\n\n\n<section class=\"wp-block-newsletterglue-callout undefined not-color-set\" style=\"border-color: #eeeeee; border-radius: 26px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f3efe9;\">\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. </p>\n\n\n\n<p>Now also available via <a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href=\"mailto:pauli@gutenbergtimes.com\">Email me </a>with your experience</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n</section>\n\n\n<p class=\"has-text-align-center has-small-font-size\"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, <br />send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n<section class=\"wp-block-newsletterglue-group\" style=\"padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;\">\n<p>Featured Image: Naples Beach photo by Birgit Pauli-Haack</p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n<form action=\"https://gutenbergtimes.com/feed/\" autocomplete=\"on\" class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\" style=\"margin-bottom: 25px;\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input autocomplete=\"email\" class=\"ngl-form-input-text\" id=\"ngl_email\" name=\"ngl_email\" required=\"required\" style=\"border-radius: 21px;\" type=\"email\" /></div></div><button class=\"ngl-form-button\" style=\"background-color: #005075; border-color: #005075; border-width: 1px; border-style: solid; color: #ffffff; border-radius: 21px;\" type=\"submit\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too, and won&#8217;t give your email address to anyone <br />except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"><svg fill=\"none\" height=\"24\" stroke=\"#fff\" stroke-width=\"2\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><polyline points=\"20 6 9 17 4 12\"></polyline></svg></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input id=\"ngl_list_id\" name=\"ngl_list_id\" type=\"hidden\" value=\"26f81bd8ae\" /><input id=\"ngl_double_optin\" name=\"ngl_double_optin\" type=\"hidden\" value=\"yes\" /></form>\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n</section>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 25 Oct 2025 02:53:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"Matt: Automattic 20 &amp;amp; Counter-claims\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150355\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"https://ma.tt/2025/10/counter-claims/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2299:\"<p>It&#8217;s a bit of <a href=\"https://automattic.com/\">Automattic</a> lore, but although I founded the company in June 2005, <a href=\"https://www.cnet.com/\">CNET</a> asked me to stay on for a few more months to finish out some projects, which I did. Our HR systems have me as the second employee, after <a href=\"https://odd.blog/\">Donncha O Caoimh</a> (still at the company!) So today is my 20<sup>th</sup> anniversary at Automattic! It&#8217;s 20 years since I started hacking on <a href=\"https://akismet.com/\">Akismet</a>, our first product, and on <a href=\"https://wordpress.com/\">WordPress.com</a>.</p>\n\n\n\n<figure class=\"wp-block-image alignwide size-large\"><img alt=\"\" class=\"wp-image-150359\" height=\"453\" src=\"https://i0.wp.com/ma.tt/files/2025/10/IMG_0435-1024x768.jpeg?resize=604%2C453&#038;quality=89&#038;ssl=1\" width=\"604\" /></figure>\n\n\n\n<p>The team gave me a sweet surprise! I&#8217;ve been fighting for the open web for 20 years, and hope to do it for at least 20 more. There&#8217;s a lot of exciting behind-the-scenes stuff happening inside Automattic that also made this day special, but one significant thing is public.</p>\n\n\n\n<p>Automattic has finally had its first chance to file its counterclaims that spell out the bad actions of <a href=\"https://wpengine.com/\">WP Engine</a> and <a href=\"https://www.silverlake.com/\">Silver Lake</a>, <a href=\"https://techcrunch.com/2025/10/24/automattic-files-counterclaims-against-wp-engine-in-wordpress-lawsuit-alleging-trademark-misuse/\">as reported here by TechCrunch</a>. You may recall that last month, <a href=\"https://ma.tt/2025/09/legal-win/\">the court dismissed several of their most serious claims</a>, and they responded by filing an amended complaint. In our dogged defense of the free, open, and thriving WordPress ecosystem, Automattic responded today with a comprehensive counter-filing, <a href=\"https://automattic.com/wp-content/uploads/2025/10/automattic-counterclaims.pdf\">which you can read in a 162-page PDF here about all the things WP Engine/Heather Brunner and Silver Lake did wrong</a>.</p>\n\n\n\n<p>We&#8217;ve got receipts!</p>\n\n\n\n<p>I don&#8217;t think WP Engine employees or investors were aware of the gaslighting they did, hopefully some of this is enlightening. And there&#8217;s a lot more discovery to go!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 25 Oct 2025 02:14:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WordCamp Central: Bhopal Hosts WP Build Tour 2025: Empowering 1700+ Students Across Central India\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://central.wordcamp.org/?p=12042668\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:120:\"https://central.wordcamp.org/news/2025/10/bhopal-hosts-wp-build-tour-2025-empowering-1700-students-across-central-india/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:21792:\"<p>WordPress Bhopal has been at the forefront when it comes to igniting young minds, empowering them with knowledge, generating new ways to achieve optimal and maximum value, and sparking a positive social impact— kind of feels like a motto. </p>\n\n\n\n<p>We love doing all of it!</p>\n\n\n\n<p>And as <a href=\"https://wpbhopal.org/\">we</a> proudly complete our <strong>10th year of formation</strong> (Oct. 2nd), this year in particular, we’ve been targeting ways to amplify our impact. A special highlight was EmpowerWP Bhopal (Women’s Day event), where we hosted women in different stages &amp; walks of their lives and demonstrated how WordPress &amp; the community can support them in achieving/expanding their potential. The response was heartwarming.</p>\n\n\n\n<p><a href=\"https://central.wordcamp.org/news/2025/04/empowerwp-bhopal-2025-a-journey-of-inclusion-and-impact/\">Read more about EmpowerWP Bhopal 2025</a></p>\n\n\n\n<p>Post this event’s success, and that of last year’s <a href=\"https://asthajain.in/my-experience-as-pm-at-do_action-bhopal-2024/\">do_action</a>, where we empowered NGOs by building their websites, it felt only natural that the next chapter in our mission of <em>empowering the social community</em> should focus on the students. </p>\n\n\n\n<p>And honestly, why we feel more drawn towards the student community can be traced back to the fact that the genesis of the WP Bhopal community itself was by a second-year college student back in 2015. Ever since, we’ve been taking workshops in colleges of our city, but this year, it was more about formalising it and making it more impactful &amp; grander than ever.</p>\n\n\n\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-3061\" src=\"https://asthajain.in/wp-content/uploads/2025/09/WhatsApp-Image-2025-09-13-at-6.36.08-PM-1024x576.jpeg\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n\n\n\n<p class=\"has-white-color has-blue-background-color has-text-color has-background has-link-color wp-elements-54e8d22bf0aa76571dde8c4451ca6aec\">Being the only active chapter in the State of Madhya Pradesh—a state with 55 districts and over 400 cities—there was always a little nudge to take our initiative beyond our home, Bhopal.</p>\n\n\n\n<p>I still vividly remember while pitching sponsors for <a href=\"https://bhopal.wordcamp.org/2023/cheers-to-the-success-of-wordcamp-bhopal-2023-a-heartfelt-thank-you/\">WordCamp Bhopal 2023</a>, the idea kept resurfacing: <em>the student community must benefit from this</em>. The lack of exposure and the gap between theory &amp; practical skills is profusely felt. <a href=\"https://profiles.wordpress.org/ethicaladitya/\">Aditya</a> often mentions that when he started with WordPress, it was purely out of his own interest, not something taught or exposed to him in his institute. For him, building websites was uncommon among his batchmates. And the truth is, the situation hasn&#8217;t changed, and we still need revitalisation to help the youth realise their potential. This became the agenda of this initiative.</p>\n\n\n\n<p>Too much foundation-building&#8230; now’s the time to reveal what I’ve so heartily been tucking in…</p>\n\n\n\n<h3 class=\"wp-block-heading has-text-align-center has-black-color has-white-background-color has-text-color has-background has-link-color wp-elements-8ce23c0821326885e4daea60f27a6275\"><em><strong>WE ARE SO PROUD &amp; DELIGHTED to share that possibly the largest event of its kind, so far—the WP Build Tour 2025—has been successfully organised, impacting and empowering more than 1700 students across Madhya Pradesh in one go!</strong></em></h3>\n\n\n\n<h2 class=\"wp-block-heading\">What&#8217;s in the Name? And Why This Matters.</h2>\n\n\n\n<p>The name came after much thought. We wanted it to reflect the core idea: <em><strong>Tour</strong></em> to capture the essence of a tour bus going around the State, empowering students (especially first-timers) to <em><strong>Build</strong></em> their very first WordPress websites, apart from expanding their technical confidence.</p>\n\n\n\n<p>The mission was rooted in our identity as the only active WP chapter in Madhya Pradesh:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Expanding our reach to more students across the State.</li>\n\n\n\n<li>Spreading WordPress awareness to inspire new local chapters</li>\n\n\n\n<li>Giving students confidence to bring their ideas online</li>\n</ul>\n\n\n\n<p>This plan was a win-win for us personally, for the community, and for the social cause we stand for.</p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-9d6595d7 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\"></div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-full is-resized\" id=\"logo\"><img alt=\"\" class=\"wp-image-3073\" src=\"https://asthajain.in/wp-content/uploads/2025/09/120a9bb6-03ab-4991-9ad3-644d5bb8677e.jpg\" style=\"width: 623px; height: auto;\" /><figcaption class=\"wp-element-caption\">WordPress Bhopal x WP Build Tour</figcaption></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\"></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">The Planning Phase: How Did We Pull This Off?</h2>\n\n\n\n<p>The initial plan was to cover colleges in major cities. Ties with GDG (Google Developer Groups) communities and college clubs helped spread the word and support with arrangements that differed from college to college.</p>\n\n\n\n<p>Interests were called in from colleges. Once we had a number, like the location, student profiles, number of students, etc, we initiated the process. We designated volunteers from each college to be a bridge, because, of course, they know the best way in there. Each college had around 120-600 students in one sitting.</p>\n\n\n\n<p><em>Thanks to their support, we were able to pull this off smoothly. Special shout-outs to: SIRT Student Body (Bhopal), Advance Studies Club- Medicaps Indore, GDG Indore &amp; E-Cell, SATI Vidisha.</em></p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-9d6595d7 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-3058\" src=\"https://asthajain.in/wp-content/uploads/2025/09/IMG_5148-1024x768.jpg\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img alt=\"\" class=\"wp-image-3060\" src=\"https://asthajain.in/wp-content/uploads/2025/09/IMG_6283-1024x768.jpg\" /></figure>\n</div>\n</div>\n\n\n\n<p>Sessions were designed for all levels, no matter the technical background. We were conscious of common hurdles &amp; from day zero of planning, we decided to remove those barriers at first instance. In this regard, at preliminary registration itself, students were guided to apply for the <strong>GitHub Education Pack</strong>, so by the event day, they have access to <span style=\"text-decoration: underline;\">free domains &amp; developer tools</span>. For hosting, we relied on <strong>InfinityFree</strong> and <strong>FreeHosting.com</strong>. Sometimes, a challenge was GitHub taking too long to approve the account(s), so the backup was to manage through <em><strong>subdomains</strong></em> from InfinityFree and additional free hosting setups.</p>\n\n\n\n<p>The setup also included swags and refreshments to keep up with the momentum. Thought was put into keeping those as relevant as possible. Participants were provided with <a href=\"https://central.wordcamp.org/feed/#cleaning-kit\">mini cleaning kits</a> to take home. For refreshments, we relied on the quick &amp; easy- Pizzas &amp; Burgers along with beverages.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Building Website in a Day: The Possibility</h2>\n\n\n\n<p>Now that&#8217;s a given, building your own website (properly) takes time— planning, ideation, resources, so what&#8217;s the catch? No catch, really. Here, with a 4–5 hour workshop, we wanted students to experience the spark of: <em>“I can actually do this.”</em> The pressure wasn&#8217;t to build the whole of it in one day but to cover all the basics then &amp; there. So the next time they open it, it&#8217;s only to further mould it as per their requirements.</p>\n\n\n\n<p>From purchasing a domain, to pointing DNS records, to watching DNS propagation happen live—and finally installing WordPress—it was a crash course in turning abstract concepts into real, working websites.</p>\n\n\n\n<p>And the output? A portfolio, a blog, a project showcase, even startup ideas. The pride was real. Social media lit up with links saying, <em>“We built this.”</em></p>\n\n\n\n<p>Honestly, we were a little sceptical at times—like when there weren’t many doubts, or when lunch was announced and students walked out. We wondered, <em>“Will they even come back?”</em> Because this wasn’t meant to be just another attendance exercise; we wanted it to be voluntary, something they <em>chose</em> to be part of.</p>\n\n\n\n<p>But there was consensus in the team that even if just one kid shows up, we’ll keep going. And guess what? Not only did they come back, but they jumped in with full energy. Doubts, queries, ideas, thoughts—their enthusiasm blew us away. It’s hard to put into words how fascinating it was to see the effort actually paying off.</p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-9d6595d7 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img alt=\"\" class=\"wp-image-3047\" src=\"https://asthajain.in/wp-content/uploads/2025/09/51d60eb2-eaf0-4611-aa65-b7965d8ebf04-1024x768.jpg\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large is-resized\"><img alt=\"\" class=\"wp-image-3064\" src=\"https://asthajain.in/wp-content/uploads/2025/09/IMG_4180-1215x2160-1-edited.jpeg\" style=\"width: 348px; height: auto;\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-3052\" src=\"https://asthajain.in/wp-content/uploads/2025/09/b9791e02-3291-4c7e-a633-82b4f964c873-2-768x1024.jpg\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n</div>\n</div>\n\n\n\n<p>By the end, every participant had not just knowledge but something concrete: a live website, <em><strong>their website</strong></em>! Photos, reels, and hashtags like #WPBuildTourBPL amplified the energy far beyond the classrooms.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Beyond the Website</h3>\n\n\n\n<p>Though the primary goal was to help students build their own websites from scratch, the sessions were also designed to introduce them to the WordPress community. They covered career opportunities, ways to get involved, and the benefits the community offers. Students were given an overview of how to contribute, how chapters operate, and how they can become a part of the ecosystem. The aim was to make the experience not just hands-on but also empowering—equipping them to pave their own path, with community connection as a strong starting point. This also supports our broader goal of fostering new chapters across the state.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The Route We Took</h2>\n\n\n\n<p><em>We’re very thankful to the college administrations of each institute we took the Tour to for their trust and support throughout. This post would be failing in its agenda without giving them due credit for opening their doors and believing in the vision of the WP Build Tour.</em> </p>\n\n\n\n<p>Here’s where the Tour travelled:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Sagar Institute of Research &amp; Technology, Bhopal<br /></li>\n\n\n\n<li>Oriental Institute of Science &amp; Technology, Bhopal<br /></li>\n\n\n\n<li>Samrat Ashok Technological Institute, Vidisha<br /></li>\n\n\n\n<li>Acropolis Institute of Technology &amp; Research, Indore<br /></li>\n\n\n\n<li>Medicaps University, Indore<br /></li>\n\n\n\n<li>Oriental College of Technology, Bhopal</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-3067\" src=\"https://asthajain.in/wp-content/uploads/2025/09/IMG_6666-1024x410.jpg\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n\n\n\n<p><br />Each stop added its own flavour and warmth. If we could’ve squeezed in more, we surely would have, but even with the stretch, it was worth it.</p>\n\n\n\n<p>The social media was our backbone—announcements, posts, designs, keeping the buzz alive. Big thanks to <em><a href=\"https://www.linkedin.com/in/mansi-chaturvedi-298832259/?original_referer=https%3A%2F%2Fwww%2Egoogle%2Ecom%2F&amp;originalSubdomain=in\">Mansi</a></em> (also our go-to content person), along with <em>Md. <a href=\"https://www.linkedin.com/in/md-farid-1aa563291/\">Farid</a></em>, <em><a href=\"https://www.linkedin.com/in/amit-vishwakarma-b46380193/\">Amit</a></em> &amp; <em><a href=\"https://www.linkedin.com/in/riddhima-singh-b3b860274?utm_source=share&amp;utm_campaign=share_via&amp;utm_content=profile&amp;utm_medium=android_app\">Riddhima</a></em>. And yep, that cool <a href=\"https://central.wordcamp.org/feed/#logo\">Build Tour logo </a>you see up there? Amit designed it.</p>\n\n\n\n<p>On the ground, <a href=\"https://www.linkedin.com/in/shashank-jain1\">Shashank</a>, <a href=\"https://www.kapilarya.com\">Kapil</a>, and <a href=\"https://www.linkedin.com/in/shivammishra-styx\">Shivam</a> held things together—guiding students through technicalities, taking charge of arrangements, managing logistics, and even stepping in as resource persons when needed. Shashank went the extra mile, balancing all this while also supporting social media.</p>\n\n\n\n<p><em><a href=\"http://adityashah.dev\">Aditya</a></em>, <em><a href=\"https://guneet.in\">Guneet</a></em>, and <a href=\"http://kripeshadwani.com\">Kripesh</a> led as resource persons, bringing not only their WordPress expertise but also their effortless way of connecting with students. (Classic engineers with their own fanbase, haha!)<br /><br />Mayur, Anshika, Pooja, Malay, Ninay, Roshini, and Prabal each <a href=\"https://events.wordpress.org/bhopal/2025/wpbuildtour/organizers/\">contributed</a> in various roles, adding strength to the endeavour.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The Sponsors who made this Possible</h2>\n\n\n\n<p>This tour wouldn’t have been possible the way it happened without our incredible sponsors. Gold Sponsors <strong>Jetpack, Bluehost, Woo, Hosting.com, Kinsta, StellarWP, </strong>and<strong> </strong>our Bronze Sponsor, <strong>ForthFocus</strong>. </p>\n\n\n\n<p>Their support helped us take the Tour across campuses in the best way possible, provide refreshments and swags, and equip students with the right resources.</p>\n\n\n\n<p>And of course, a big thanks to the global WordPress community for having our back throughout!</p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-9d6595d7 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large is-resized wp-lightbox-container\"><img alt=\"\" class=\"wp-image-3054\" src=\"https://asthajain.in/wp-content/uploads/2025/09/e236d14a-79a5-4a3a-80d1-ae65a8c11499-768x1024.jpg\" style=\"width: 146px; height: auto;\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Giveaway winner</figcaption></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-3048\" src=\"https://asthajain.in/wp-content/uploads/2025/09/930f22b9-d597-4749-b328-7d6b8c5a37fa-2-1024x592.jpg\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\" id=\"cleaning-kit\"><img alt=\"\" class=\"wp-image-3074\" src=\"https://asthajain.in/wp-content/uploads/2025/09/IMG_6671-795x1024.jpg\" /><figcaption class=\"wp-element-caption\">Swags</figcaption></figure>\n</div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Moments beyond: In our Hearts</h2>\n\n\n\n<p>Some moments will stay with us forever:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>The warmth of teamwork, swag, and refreshments turns workshops into mini-celebrations</li>\n\n\n\n<li>The collective gasp when a site went live</li>\n\n\n\n<li>Proud social media posts </li>\n\n\n\n<li>Smiles of giveaway winners walking away with specially curated kits.</li>\n</ul>\n\n\n\n<p>Because at its heart, the WP Build Tour 2025 was never just about code or content. It was about confidence. About potential realised. About futures being built—one student, one website, one breakthrough at a time.</p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-9d6595d7 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-3062\" src=\"https://asthajain.in/wp-content/uploads/2025/09/WhatsApp-Image-2025-09-15-at-7.17.55-PM-501x1024.jpeg\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-3066\" src=\"https://asthajain.in/wp-content/uploads/2025/09/32bf637e-10fc-492f-b1c3-3171f6ffadab-edited.jpg\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">We were featured in local newspapers</figcaption></figure>\n</div>\n</div>\n\n\n\n<figure class=\"wp-block-pullquote has-black-color has-text-color has-link-color wp-elements-542803687f2e82ce724dbba5a67a7e9f\"><blockquote><p>Organising events is one thing, and adding purpose to them takes it to another level. For us in Bhopal, organising events has never been just about the “event.” It’s about going a step further and sparking change, no matter how small. Thankfully, the WordPress community has always been open and kind enough to welcome such ideas and encourage us to push boundaries. And for that, we&#8217;re so grateful!</p></blockquote></figure>\n\n\n\n<p><em>The WP Build Tour 2025 wasn’t the end but rather the beginning of a movement. And as we now look forward to <a href=\"https://bhopal.wordcamp.org/2025/\">WordCamp Bhopal 2025</a> this December, we carry with us 1,700 sparks of possibility, ready to light up the future of WordPress and beyond.</em></p>\n\n\n\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 24 Oct 2025 19:36:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Astha Jain\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"Matt: Under the Weather\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150347\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://ma.tt/2025/10/under-the-weather/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:638:\"<p>I don&#8217;t get sick very often, but when it catches up to me it hits like a freight train. Just trying to keep all the plates spinning while operating at 10% capacity, been sleeping a ton. Today was in some ways better, some ways worse than yesterday. I try to avoid hospitals and emergency care, as you wind up in their system, so I&#8217;m trying to ride this one out at home. Had to cancel a bunch of travel and conferences and meetings I was looking forward to this week. Really makes you appreciate and be grateful for good health — it&#8217;s a baseline for everything else and I&#8217;m blessed with it 99% of the time.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 24 Oct 2025 03:14:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Matt: New Woo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150338\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://ma.tt/2025/10/new-woo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:902:\"<p><a href=\"https://developer.woocommerce.com/2025/10/22/woocommerce-10-3-cogs-comes-to-core-and-mcp-beta/\">WooCommerce 10.3 is out</a>, just in time for Black Friday / Cyber Monday, with some nice improvements to the checkout experience, tracking cost of goods sold, and a new beta MCP server, &#8220;This new feature enables AI assistants like Claude, Cursor, VS Code, or any other MCP-compatible client to interact directly with WooCommerce stores through a standardized protocol, opening up new possibilities for AI-assisted store management and development workflows.&#8221; <a href=\"https://make.wordpress.org/test/2025/10/21/help-test-wordpress-6-9/\">You can also help out in testing WordPress 6.9</a>, which comes out on December 2<sup>nd</sup>.</p>\n\n\n\n<p>If I&#8217;m slow on anything right now, I apologize. I&#8217;ve got some flu/Covid thing, so I&#8217;m operating at reduced capacity.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Oct 2025 06:54:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"Open Channels FM: The Power of Customer Support and Building Relationships in SaaS\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=110952\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://openchannels.fm/the-power-of-customer-support-and-building-relationships-in-saas/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:162:\"Strong customer support is key for SaaS success. Building relationships with users and hosting providers boosts satisfaction and can be a powerful marketing tool.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Oct 2025 12:56:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Matt: To Cut A Pineapple\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=99215\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"https://ma.tt/2025/10/to-cut-a-pineapple/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:567:\"<p>Google has turned 25, which is wow, and they made a cute video about it:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n\n\n\n<p>Of course I tried to visit the original howtocutapineapple.com site, and unfortunately saw a database error connection. <a href=\"https://web.archive.org/web/20221206055636/http://howtocutapineapple.com/\">From Archive.org</a> it looks like whoever had that domain made a nice WordPress site.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Oct 2025 06:20:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"WPTavern: #190 – Seth Rubenstein on Block Composability in WordPress’ Future\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=200244\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://wptavern.com/podcast/190-seth-rubenstein-on-block-composability-in-wordpress-future\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:59361:\"<details>Transcript<div>\n<p>[00:00:19] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, block composability, what it is and how it&#8217;s shaping WordPress&#8217;s future.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox and use the form there.</p>\n\n\n\n<p>So on the podcast today we have Seth Rubenstein. Seth is the head engineer at the Pew Research Center, where he leads a team of developers managing the organization&#8217;s WordPress based publishing platform for its news site. Passionate about open source, Seth ensures that everything his team builds not only meets the Pew Research Center&#8217;s needs, but also benefits the wider community. By actively contributing to the Gutenberg project, he strives to share their solutions, always asking how their work can be given back to help others in the WordPress ecosystem.</p>\n\n\n\n<p>Seth shares fascinating stories from the work he&#8217;s been doing recently. He breaks down what block composability means, the ability to build modular, reusable, and even interactive blocks that work seamlessly together, empowering both developers and end users to create sophisticated web applications within the familiar WordPress block editor.</p>\n\n\n\n<p>The conversation gets into some of WordPress&#8217;s newest, and most promising, features including the Block Bindings API, Block Bits, which is still very much in development, and the Interactivity API. Seth explains how these tools open a world of possibilities, like building interactive quizzes, dynamically updating content, or even prefetching data, all using blocks, without having to rely on custom React front ends, or heavy server side processing.</p>\n\n\n\n<p>Seth also talks about the path forward for democratizing these advanced capabilities, discussing current limitations, the potential for new UI tools, and what&#8217;s still missing in the quest for truly responsive device contextual blocks.</p>\n\n\n\n<p>Throughout the episode, Seth makes a compelling case for why now is a golden opportunity for developers and plugin builders to start experimenting, get involved, and shape the next evolution of WordPress as a cutting edge web application platform.</p>\n\n\n\n<p>Whether you&#8217;re a developer curious about the future of Gutenberg, or an editor dreaming of more drag and drop web app power, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Seth Rubenstein.</p>\n\n\n\n<p>I am joined on the podcast by Seth Rubenstein. How are you doing, Seth?</p>\n\n\n\n<p>[00:03:40] <strong>Seth Rubenstein:</strong> Very good. How about you?</p>\n\n\n\n<p>[00:03:41] <strong>Nathan Wrigley:</strong> Yeah, good. Nice to have you back.</p>\n\n\n\n<p>[00:03:42] <strong>Seth Rubenstein:</strong> Yeah, second time.</p>\n\n\n\n<p>[00:03:43] <strong>Nathan Wrigley:</strong> This doesn&#8217;t happen too many times. I&#8217;ve got to be perfectly honest with you, the audience, I&#8217;ve already said this to Seth. Each time I come to WordCamp US, I&#8217;m always confounded by how remarkably clever people are, and the depth of the content is sometimes beyond me. I think this is one of those examples.</p>\n\n\n\n<p>I think there&#8217;s a high chance that you are going to have to shepherd me. There&#8217;s probably going to be a lot of editing, when I pause and you explain what you are talking about. So let&#8217;s get into it. First of all, tell us a little bit about you, where you work, what you do in the WordPress space.</p>\n\n\n\n<p>[00:04:10] <strong>Seth Rubenstein:</strong> Sure. So I work for Pew Research Center. I&#8217;m the head of engineering there. I manage a team of four other developers, and I like to tell people that we work with and on WordPress every day.</p>\n\n\n\n<p>We manage a publishing platform for a small news site in the US, Pew Research, but we also contribute to Gutenberg. Everything that we do, everything that we build day in and day out, we try to do from a perspective of how can we open source this? How can we contribute this back to Gutenberg in some way? What can we build to fulfill our needs that would also fulfill other people&#8217;s needs?</p>\n\n\n\n<p>[00:04:39] <strong>Nathan Wrigley:</strong> You said a small organisation, the Pew Research Center. I don&#8217;t actually know what they do.</p>\n\n\n\n<p>[00:04:44] <strong>Seth Rubenstein:</strong> We are a nonprofit, call ourselves a fact tank. What we do is we survey the American public on a variety of issues. Where are they on things like abortion, or religion, or crime, or the economy, or the use of AI, whatever. And we like to kind of say we hold up a mirror to the American public to tell them what they believe back to them.</p>\n\n\n\n<p>[00:05:04] <strong>Nathan Wrigley:</strong> And so is the WordPress website that you have with them, is that a mechanism to distribute that data back to the public?</p>\n\n\n\n<p>[00:05:09] <strong>Seth Rubenstein:</strong> Yes, yes.</p>\n\n\n\n<p>[00:05:10] <strong>Nathan Wrigley:</strong> Okay, that&#8217;s interesting. So it&#8217;s a data heavy industry that you are dealing with.</p>\n\n\n\n<p>[00:05:13] <strong>Seth Rubenstein:</strong> It is. It is. We&#8217;re very, a kind of academic research institution, but we publish in kind of a news oriented way.</p>\n\n\n\n<p>[00:05:21] <strong>Nathan Wrigley:</strong> Okay. So we figured out a little bit about you, however you are here at WordCamp US to do a presentation. I actually don&#8217;t know if you&#8217;ve done it</p>\n\n\n\n<p>[00:05:28] <strong>Seth Rubenstein:</strong> I have, yeah. I did it the other day.</p>\n\n\n\n<p>[00:05:29] <strong>Nathan Wrigley:</strong> How did it go?</p>\n\n\n\n<p>[00:05:29] <strong>Seth Rubenstein:</strong> It went okay. I had a problem with my speaker notes, so I had to ad lib a good bit of it. So it might not be as coherent, or clear as it should have been.</p>\n\n\n\n<p>[00:05:41] <strong>Nathan Wrigley:</strong> Well we&#8217;re here to fix that. You can ad lib all you like here. So it was called, and forgive the pronunciation if I get this wrong, Block Composability: The Past and The Future. I&#8217;m actually just going to read the blurb into the record. And I&#8217;ll also make sure that there&#8217;s a link in the show notes to the page at the WordCamp US website where you can find out about the content. And also if by the time this comes out a WordPress TV episode with your presentation has landed, then I&#8217;ll mention that as well.</p>\n\n\n\n<p>Gutenberg excels at crafting beautiful static content, but what if you could empower anyone to build dynamic, interactive web experiences directly within the Block Editor? This session dives into block composability, a powerful concept that enables the creation of rich, interactive content using blocks, making advanced web development accessible to even less technically inclined users, which begs the question, what is block composability?</p>\n\n\n\n<p>[00:06:31] <strong>Seth Rubenstein:</strong> Block composability, I guess let&#8217;s define composability first. Composability in computer science and in software development is the idea that you can create and assemble web applications with reusable components in a modular way. That&#8217;s really all that means.</p>\n\n\n\n<p>If you&#8217;ve ever used React, if you&#8217;ve ever written in React, it means React Component, really. It&#8217;s a self-contained modular unit that can act on its own, but when plugged in with other units, it becomes something new, or extend its functionality or changes its functionality in some way.</p>\n\n\n\n<p>[00:07:01] <strong>Nathan Wrigley:</strong> When Gutenberg dropped, I had this notion that we were going to see mini apps inside of a block. So for example, I had this notion that right off the bat, so I&#8217;m going back to 2018 or something, when Gutenberg was still a, so prior to when it was in Core, let&#8217;s go with that. And I had this notion that you would drop in, let&#8217;s say a real estate block, and that block would encapsulate all the information about this particular house. And you would drop in the block and it would ask you a bunch of questions about the house and out would come a house custom post type, if you like.</p>\n\n\n\n<p>However, what happened was we got paragraph blocks, and we got an image block, and we got these fairly, well, useful, but they do one thing. They do a paragraph. They do an image, and that seems to be kind of where it ended. Are you trying to draw a line in the sand where it&#8217;s possible to go beyond that simple, does one thing, paragraph, image, to more the, we have a real estate block with loads of different facets and capabilities?</p>\n\n\n\n<p>[00:07:57] <strong>Seth Rubenstein:</strong> That&#8217;s right, yeah. I think where we&#8217;re at now is we&#8217;ve reached a point where the block editor, Gutenberg, in both its block editor and site editor kind of flavors, is you can build web applications. Blocks can do something now. They&#8217;re not just presenting text or an image and they&#8217;re kind of static and, you know, maybe you can style them differently from one post to another, but now they can actually do something.</p>\n\n\n\n<p>And more importantly, they can communicate with one another. You know, one block is adjacent to another. It can tell that block what to do when you click on it. If it&#8217;s inside of it, it can change its functionality accordingly. So you might imagine, we have a quiz builder. That&#8217;s actually one of our, probably our most technical product.</p>\n\n\n\n<p>And the way it works is there&#8217;s a results block where you can build out your results page for your quiz, but if you were to drop in a special block for, we have a special quiz that does scoring a very specific way, well, it changes the scoring functionality in the quiz builder. It doesn&#8217;t overwrite that. If you take that block out, the scoring functionality returns back to normal.</p>\n\n\n\n<p>So now we&#8217;re at a point where it&#8217;s very much possible to build web applications in the block editor with blocks.</p>\n\n\n\n<p>[00:09:00] <strong>Nathan Wrigley:</strong> So this little quiz block that you&#8217;ve described, if I was using, so ignore the developer experience and everything that you have built, the technicalities of all that. If I was somebody that was working for the Pew Research Center and I was, I don&#8217;t know, an editor and I needed to create a quiz, would that be my process? I drop in the quiz block, and boom, I have a quiz.</p>\n\n\n\n<p>[00:09:20] <strong>Seth Rubenstein:</strong> It&#8217;s really simple. You would go into, we do kind of store it all in a nice post type. So there&#8217;s a quiz post type. And then you open that up, you say, I want to go make a new quiz. And by default, there&#8217;s a quiz, we call it the quiz controller block that&#8217;s there first. And we have a few templated things in there for you. So like a start page and a question, an answer, and all of those things are block. So a question is a block, and inside of that question goes the answers for that question. That&#8217;s a block.</p>\n\n\n\n<p>Go further than that, we also have these kind of bindings. So you drop an answer in, well, there&#8217;s text for the answer, right? What if you want an image in there? What if you want a chart? What if you want a video? What if you want some other interactive piece of content to be corresponding to that answer? Well, you can drop that in too. And you can kind of freely move all these things within an answer, while still having that text bound to the answer block.</p>\n\n\n\n<p>So it&#8217;s a highly technical product, but for the editors, for the designers, it is literally just drag, drop, drag, drop, drag, drop. Create a page, create a question, type in your answer.</p>\n\n\n\n<p>[00:10:16] <strong>Nathan Wrigley:</strong> So in the world of 2018 that I alluded to a moment ago when the block editor launched, it feels like there were big missing pieces that prevented what you&#8217;ve just described. And maybe they&#8217;re APIs. I think possibly in some scenarios they are. What are the bits more recently, I don&#8217;t even know if it&#8217;s more recently in all honesty, but what are the bits that have enabled the features that you&#8217;ve just described?</p>\n\n\n\n<p>[00:10:38] <strong>Seth Rubenstein:</strong> Sure. So I think it&#8217;s funny that you bring back to 2018 because we built Quiz Builder in 2019. I think I&#8217;ll go on the record here and say, I think it might be the first kind of product in Gutenberg that was drag and drop building web applications. So I think we kind of pushed really early on the idea of composability inside of Gutenberg.</p>\n\n\n\n<p>And I see it as, there are kind of three waves in Gutenberg. First was, okay, Gutenberg is a CSS generator. That&#8217;s how I first kind of imagined it. You&#8217;re creating content and you have a style system and that outputs some CSS for your site.</p>\n\n\n\n<p>And then we got, I think the kind of HTML part of that a few years later. With the site editor and the theming inside of the block editor and things like that.</p>\n\n\n\n<p>And now we&#8217;ve gotten to the JavaScript part of Gutenberg. Where WordPress has the Inactivity API. And so this is a WordPress native JavaScript framework, so blocks can do something on the front end. And I think that is really the key innovation that&#8217;s really opened this up in just the last 12, 16 months.</p>\n\n\n\n<p>[00:11:35] <strong>Nathan Wrigley:</strong> Are there any APIs that have enabled you to short circuit? So again, in 2018, I would imagine there was quite a lot of heavy lifting that you needed to do order to pull that off, to innovate in that way. Are there any things which have fallen, I think quite recently actually, that have enabled it to be more available to developers who don&#8217;t have the time available that you did?</p>\n\n\n\n<p>[00:11:56] <strong>Seth Rubenstein:</strong> Yeah, I mean, so in 2019 when we did this, you know, all we really had was this ability to kind of scaffolded out these quizzes. The were pretty static in their layout. You drop a question and there were the answers in there, and you could type them in and that was it. No images inside the quiz, nothing like that.</p>\n\n\n\n<p>Now, thanks to things like block bindings, block bits, which we can go into in a little bit.</p>\n\n\n\n<p>[00:12:18] <strong>Nathan Wrigley:</strong> Yeah, we&#8217;d need to I think.</p>\n\n\n\n<p>[00:12:19] <strong>Seth Rubenstein:</strong> And the Interactivity API, you know, it is, everything is less static. Everything is less set in stone now. With things like the HTML Tag Processor, you can say, oh, this answer has this flag on it so we&#8217;re going to change out some of the HTML in it, in kind of real time before it gets to the front end for users. That just really wasn&#8217;t possible before, without a lot of work. It wasn&#8217;t very performant.</p>\n\n\n\n<p>Now all those things are in place for developers to really tap into. And the documentation and examples are there too, because that was the problem before, I think, is that a lot of people had to figure out how to do this, and now there are real world examples out there.</p>\n\n\n\n<p>[00:12:52] <strong>Nathan Wrigley:</strong> So you mentioned, quickly skirted over three things there. So there was Block Bits, Block Bindings, which I think the full title would be Block Bindings API, and the Interactivity API, which I think is like a child of the HTML API. I&#8217;m not entirely sure about that, but.</p>\n\n\n\n<p>[00:13:07] <strong>Seth Rubenstein:</strong> It utilises the HTML components.</p>\n\n\n\n<p>[00:13:10] <strong>Nathan Wrigley:</strong> Okay. Let&#8217;s just go through what those three things are in whatever order suits the purposes of this podcast best, because I don&#8217;t know which one you&#8217;d start on.</p>\n\n\n\n<p>[00:13:16] <strong>Seth Rubenstein:</strong> Let&#8217;s start with Block Bindings API. I would actually imagine a good number of people are familiar with this. This has come up a lot in the last year in the Gutenberg project. What that really lets you do is use Core blocks more effectively.</p>\n\n\n\n<p>For example, before, if you wanted to have a button and you wanted to do a very specific thing and look a very specific way, well, good luck. You had to make your own button. Sure there was the Core button and you could style it to some degree, but what it did was it went to a link.</p>\n\n\n\n<p>Now with things like Block Bindings, you can say, okay, well, I have my Core button and I&#8217;m going to style it however I want, but the interior text, you know, what it says, what it does, well, that can be done kind of programmatically on the backend. That&#8217;s where the Block Bindings API comes in. It lets you use Core blocks and change them, well, not Core blocks, any blocks, really, and change them to fit your needs.</p>\n\n\n\n<p>[00:14:07] <strong>Nathan Wrigley:</strong> Can you give us a concrete example of that? So you&#8217;ve just talked about the button, you mentioned a sort of, I was struggling to grasp what you were meaning about changing the text programmatically. How would you do that? What would be an example?</p>\n\n\n\n<p>[00:14:18] <strong>Seth Rubenstein:</strong> Let me give you an example of that, Core paragraph. Very useful with block bindings. And I mentioned answers. So we have this answer block, right? And before it just had a text field in it. You would type in the answer and that was it. That was all you saw. And that meant that you couldn&#8217;t do anything inside of the answer. You couldn&#8217;t provide any other content inside there, because that would then get rolled up as the answer.</p>\n\n\n\n<p>So now with Block Bindings, what we have is we have this core paragraph binding that you can drop into the answer, and it is a text field still. You can type into it. It&#8217;s storing that on the answer block and then you can put other stuff inside the answer block because we&#8217;re not reading what&#8217;s in there as the content.</p>\n\n\n\n<p>What that meant for us is that we didn&#8217;t have to go make another block called answer text. We have hundreds of these kind of scenarios in our system where, yeah, we need a very specific use case, and it&#8217;s usually just some text, right, somewhere. Why would I make another block that&#8217;s just a paragraph block, really?</p>\n\n\n\n<p>So bindings, it makes blocks way more extensible. So one block can perform multiple functions if you need it to.</p>\n\n\n\n<p>[00:15:19] <strong>Nathan Wrigley:</strong> So my takeaway from that, it may be ignorant, it kind of adds a layer where you can add more features into any block, Core or otherwise. So in the example of paragraph, it&#8217;s like paragraph plus. It&#8217;s extended paragraph if you like, and you then get to decide. And that is the binding bit. You bind things to the block.</p>\n\n\n\n<p>[00:15:39] <strong>Seth Rubenstein:</strong> You bind attributes in a block.</p>\n\n\n\n<p>[00:15:40] <strong>Nathan Wrigley:</strong> Attributes.</p>\n\n\n\n<p>[00:15:41] <strong>Seth Rubenstein:</strong> That&#8217;s what it really effectively comes down to, is you bind attributes. So you could say that the text, the content attribute, in Core paragraph, well, that&#8217;s not coming from whatever you typed in there. It&#8217;s coming from some other programmatic interface somewhere in your system, your plugin, whatever.</p>\n\n\n\n<p>So that lets you use Core paragraph as a layout element, put it wherever you&#8217;d like, but then what&#8217;s inside of it, and perhaps even what happens when you click on it, well, that&#8217;s decided elsewhere.</p>\n\n\n\n<p>What&#8217;s nice about that is it lessens the number of controls that you need to present to the end user, to the designer, to the editor. For them, they just drop the block in there. The plugin handles the bindings. The plugin handles, okay, the text for this paragraph inside this answer should come from here. They don&#8217;t have to think about all that. So it&#8217;s less settings for them actually. It&#8217;s more just drop blocks in.</p>\n\n\n\n<p>[00:16:27] <strong>Nathan Wrigley:</strong> You are very much in the weeds of all this, so I suspect the fact that you&#8217;ve done this and done this over and over again renders it fairly straightforward. How available is this? Is the documentation there?</p>\n\n\n\n<p>[00:16:38] <strong>Seth Rubenstein:</strong> Oh yeah. The documentation is there. The WordPress Dev Blog has a number of tutorials on Block Bindings. And I think once you get started with it, it&#8217;s extremely easy to work with really.</p>\n\n\n\n<p>[00:16:47] <strong>Nathan Wrigley:</strong> Okay, so that was Block Bindings. Next one was Block Bits. Now I&#8217;ve only heard this phrase a couple of times, so you&#8217;re going to have to go 101 on this.</p>\n\n\n\n<p>[00:16:54] <strong>Seth Rubenstein:</strong> Sure. So Block Bits is, this is an API that is very much in development. It&#8217;s a concept more than anything else right now. So with Block Bindings, we can kind of take over a whole paragraph block and change it all out. Well, what if you just need to change one word inside that paragraph? That&#8217;s where Block Bits comes into being.</p>\n\n\n\n<p>So this could be you have typed out your sentence, and maybe there&#8217;s a name in the sentence. And you need to change that name dynamically based on whatever the user&#8217;s choosing in this front end interface. Well, Block Bits, you just select the text, you go to the toolbar, you say, I&#8217;m going to bind, quote unquote, this to this thing.</p>\n\n\n\n<p>And Block Bits, the concept is, okay, we&#8217;re going to look inside of a block, down to a bit, maybe just a character and do something with that. Change it, make it a button, whatever. That&#8217;s really all it is. It&#8217;s a fancy name for taking Block Bindings to the next level, which is kind of inside a string of text.</p>\n\n\n\n<p>[00:17:50] <strong>Nathan Wrigley:</strong> Okay. So it is, again, forgive me if I&#8217;ve parsed it incorrectly, but a Block Bit is a binding inside of some other thing. So in the example you gave, swap out this string for a different string, or it could be swap out this image dynamically for a different image, or, I don&#8217;t know, insert a dollar sign here instead of a pound sign or.</p>\n\n\n\n<p>[00:18:15] <strong>Seth Rubenstein:</strong> Well beyond that, beyond just the switching things out, the other kind of powerful part of the concept, and that&#8217;s where I think the API part is really still in development, and this will take a little bit further is, one of the examples used in the Gutenberg project is things like ISBN numbers.</p>\n\n\n\n<p>So you can imagine that, you know, maybe you&#8217;re running some sort of library like site, you type in an ISBN number. Well, what you want to happen on the front end is maybe a little bit more complex than that. So you type in your ISBN number and the block bit could see that that is an ISBN formatted number, and maybe on the front end it becomes a link with a little popup that goes to the Library of Congress, point to that thing, right?</p>\n\n\n\n<p>So it&#8217;s very analogous to Block Bindings, but it&#8217;s very much very specific small string inside of a larger string. So they give it as sub block bindings. Maybe that&#8217;s even a better term for it. Maybe that&#8217;s what would be called in the future. But I really think of it as sub block binding.</p>\n\n\n\n<p>[00:19:10] <strong>Nathan Wrigley:</strong> And presumably then you can just chain these together inside, well, let&#8217;s go with a paragraph. You could just have a one sentence just full of these block bits. So one followed by another, followed by another. Okay, that&#8217;s really interesting. So you could have a whole sentence, for example, just made up of bits from all over the place.</p>\n\n\n\n<p>[00:19:28] <strong>Seth Rubenstein:</strong> Well, and you could imagine that, beyond just like pulling information, it could be really useful when what we&#8217;re using it for currently is templating, right? So you want this string, this sentence to have these parameters. Maybe it&#8217;s got the format of your post type, and then maybe it&#8217;s got the title in there, and then maybe the date. But maybe that&#8217;s all on one line and not three different blocks.</p>\n\n\n\n<p>One of the things that drives me crazy right now is, let&#8217;s say I want to do a post date, post type, kind of above the post title. I insert a row block, and then I insert my date block, and then I insert my meta block. That&#8217;s like a lot of divs, that&#8217;s a lot of markup for that. It&#8217;s like, why isn&#8217;t that just one paragraph line with that bit of information in there? That&#8217;s where block bits comes into play.</p>\n\n\n\n<p>[00:20:08] <strong>Nathan Wrigley:</strong> So it feels like, again, forgive me, it feels like the kind of thing that we would&#8217;ve used custom fields for in past. And we would&#8217;ve had, I don&#8217;t know, dozens of custom fields, each containing their own discreet bit of data, and we would&#8217;ve had to have figured out a way to drop those into this paragraph. Now this is all handled natively.</p>\n\n\n\n<p>[00:20:25] <strong>Seth Rubenstein:</strong> Yeah, and visually in the editor.</p>\n\n\n\n<p>[00:20:26] <strong>Nathan Wrigley:</strong> Visually in the editor. And so it could be anything. It could be markup, it could be text, it could be an image, it could be, I don&#8217;t know, XML, anything you like. That&#8217;s really powerful.</p>\n\n\n\n<p>[00:20:36] <strong>Seth Rubenstein:</strong> It&#8217;s exciting. It&#8217;s very powerful, and it&#8217;s the API that I am most looking forward to seeing completed. I think it will really, without getting too technical, you go a little bit further, Block Bits, Block Bindings. These things I think are kind of critical for responsive blocks. If we&#8217;re going to change attributes at kind of a micro level based on certain conditions, like those are the kind of frameworks that we need to be able to do that.</p>\n\n\n\n<p>So beyond just like the content and templating stuff, there are deep technical reasons that these APIs continue to be developed out.</p>\n\n\n\n<p>[00:21:07] <strong>Nathan Wrigley:</strong> Okay, I think I&#8217;ve grasped what that is. Just running the clock back a couple of minutes, you imply, no, I think you said that this is in development more so than Block Bindings. So the block bits is ready to use.</p>\n\n\n\n<p>[00:21:20] <strong>Seth Rubenstein:</strong> No. There&#8217;s very much in a conceptual phase, and I think there&#8217;s a lot of other technologies that need to be finished out. There are work on the HTML APIs, even though they&#8217;re really well advanced now over the last couple years, there&#8217;s more work being done on those. I think those things are kind of blockers to keep pushing forward with the Block Bits. But you can start doing Block Bits today. And I do go over that in the presentation.</p>\n\n\n\n<p>What it really comes down to, fundamentally today is, it&#8217;s a rich text custom format, which you can do today. You can go in and make your own kind of custom formats inside the rich text component. You know, that might be bold or italic, a custom format. So it&#8217;s really simple as like, okay, well, I have a custom format that adds a class name to something, and then the HTML tag processor, I look for that class name and I change it out. Bingo, bango. So simple.</p>\n\n\n\n<p>But of course, like I said, Block Bits is much bigger than that. There&#8217;s an idea of kind of like a library of bits and, you know, you can plug it into different data sources and post meta and this and that and the other thing. But right now at least, you can start to experiment with this idea, with templating and kind of getting dynamic bits of content into a string.</p>\n\n\n\n<p>[00:22:28] <strong>Nathan Wrigley:</strong> This feels very much to me, like the kind of thing that needs more eyeballs.</p>\n\n\n\n<p>[00:22:31] <strong>Seth Rubenstein:</strong> It does.</p>\n\n\n\n<p>[00:22:31] <strong>Nathan Wrigley:</strong> It&#8217;s one of those things where you let loose a thousand developers and suddenly some curious thing that nobody thought of occurred and it was like, oh, it does that.</p>\n\n\n\n<p>[00:22:40] <strong>Seth Rubenstein:</strong> Yeah. I really want to get people to experiment with this concept further, because I think we need to push it further because it&#8217;s just so powerful.</p>\n\n\n\n<p>[00:22:48] <strong>Nathan Wrigley:</strong> Yeah, really interesting. Okay, so we did Block Bits. We did Block Bindings. I think the final one that we mentioned was the Interactivity API.</p>\n\n\n\n<p>[00:22:55] <strong>Seth Rubenstein:</strong> Yeah. So the Interactivity API, that is about, it&#8217;s probably about two years old, I think, at this point. I won&#8217;t go into all the history of that, but it is effectively a WordPress native, Preact framework. It&#8217;s really easy to work with. You kind of just write basic HTML and the JavaScript is very easy to get into.</p>\n\n\n\n<p>And what that allows you to do is really add interactions at an atomic level to blocks. You can write all sorts of functions. So you might imagine you have a form block, and it has an on submit action. Not every form does the same thing, right? So maybe you have another block, could be send to Firebase. You drop that in there and it changes, it can actually hoist up its own on submit function into that blocks interactivity. And so it makes it really easy to kind of swap JavaScript functionality in and out, and extend functionality across all your blocks.</p>\n\n\n\n<p>[00:23:47] <strong>Nathan Wrigley:</strong> So it, I guess the easiest way that I parse this was it enables you to have things doing things to other things. That was profound. Things doing things to other things in the same interface.</p>\n\n\n\n<p>[00:23:59] <strong>Seth Rubenstein:</strong> Yeah.</p>\n\n\n\n<p>[00:23:59] <strong>Nathan Wrigley:</strong> You click a button and, I don&#8217;t know, the cart increments by one or something like that. So this kind of thing that really, in the year 2025, given that we&#8217;ve had mobile phones in our hands for decades, this sort of stuff feels like it should have been in websites for decades, but it wasn&#8217;t.</p>\n\n\n\n<p>[00:24:12] <strong>Seth Rubenstein:</strong> Yeah. And the other exciting thing about it is it&#8217;s not just about telling blocks what to do. I find it very interesting that it can communicate data across blocks. So I&#8217;ll come back to Quiz Builder as a really good example. We just rebuilt that with all of these things, Block Bits, Block Bindings, Interactivity API. That just got completely revamped in the last couple months. Before that, what we were doing is we were building out a custom React front end for every single quiz.</p>\n\n\n\n<p>So the users would go in, they would drag and drop, you know, build up these quizzes. And then on top of that, we were recreating all that for a new front end interface. And we had all this service side processing to kind of build up a data model for the quiz and then score the quiz, and we made a performant as we could be, but it wasn&#8217;t.</p>\n\n\n\n<p>[00:24:55] <strong>Nathan Wrigley:</strong> It&#8217;s a lot.</p>\n\n\n\n<p>[00:24:55] <strong>Seth Rubenstein:</strong> Yeah, it&#8217;s a lot. And it&#8217;s a lot of like duplicative work and you&#8217;re like, what for? With this, it&#8217;s now the Interactivity API. Those blocks actually, you know, the answer block just hoists its answer into this larger data model using the Interactivity API.</p>\n\n\n\n<p>So now all that happens client side. So now all these things that we were doing server side, we can do client side with the Interactivity API, and that saves us money, that saves us performance. It yields a better experience for the end user.</p>\n\n\n\n<p>[00:25:19] <strong>Nathan Wrigley:</strong> So over the last 10 minutes or so, we kind of atomised these three things, Block Bits, Block Bindings, Interactivity. We kind of talked about them as separate things, which I guess they are. But from your experience, I&#8217;m guessing that they work in concert really well. In other words, if you understand, if you get into the weeds of those three things, and maybe some other things, you prize open capabilities in WordPress which are pretty profound.</p>\n\n\n\n<p>[00:25:43] <strong>Seth Rubenstein:</strong> Yeah, well, obviously one of the things that I love most about WordPress is it&#8217;s flexibility. Let&#8217;s use Block Bits as an example. This kind of pseudo block bits I&#8217;ve just described, where you register a custom format and then you use the HTML Tag Processor to switch that out. Well, the way that we&#8217;re switching it out is using the Interactivity API.</p>\n\n\n\n<p>So all we do is we say, okay, we look for that class name, we use the HTML Tag Processor, and we add the Interactivity API bits that we need to it. We just say, well, the text value should be this, state dot button text, right? That&#8217;s really easy. But you could do it with block context too.</p>\n\n\n\n<p>So there are all these tools in WordPress, all these different APIs related to blocks that once you start to connect them together, you get composability. I mean, that&#8217;s what it really comes down to. This ability for developers to build blocks that can be, one, reusable, that&#8217;s really important concept for composability, two, stand on their own, right? A button block should do something if it&#8217;s on its own. It should go to a link or something. But if that button block is dropped into another block, it&#8217;s nestable, well its configuration changes. Now it submits for the form, right? It doesn&#8217;t go to a link.</p>\n\n\n\n<p>We&#8217;re at this place where just, there&#8217;s all these tools available to you when you start plugging them all together, really powerful stuff happens.</p>\n\n\n\n<p>[00:26:53] <strong>Nathan Wrigley:</strong> Yeah. And I guess it&#8217;s like anything, once you&#8217;ve made those connections in your own head and done the hard work to understand them all, suddenly ideas begin occurring to you that maybe in a podcast like this, you get to the very edge of that, but you don&#8217;t get into the weeds of that. But once you&#8217;ve peeled it back and understood it, suddenly, aha, I didn&#8217;t realise WordPress could do all of this.</p>\n\n\n\n<p>One of the things that I&#8217;m curious about, because I&#8217;m no developer, I kind of have a desire for this stuff to become available to non-developers. And at the minute it feels like you would really need to be a developer to build this stuff. Obviously you can surface it in a way that a non-developer can access. So your quiz, for example, I&#8217;m guessing I could interact with that almost immediately and understand it. Would there be any utility in building a UI for this so that these kind of things can be accessed?</p>\n\n\n\n<p>[00:27:36] <strong>Seth Rubenstein:</strong> I think so. We have our own UI for this. We have an Interactivity API panel that we actually have on all of our blocks that have interactivity enabled. And what it does is it does allow us some interesting things for end users that they don&#8217;t have to know about.</p>\n\n\n\n<p>So one of those things is you can drop a block into a block that supports interactivity. And the panel shows you all the blocks in the hierarchy that you can connect to. And so you might say, okay, well I want to connect to this, and then I want to pull this action from that interactivity store for this block.</p>\n\n\n\n<p>So now we&#8217;ve enabled it so that it&#8217;s not the developers making all the Interactivity API connections. You know, this does this when it&#8217;s in this block. Actually, you can go in there and decide that for yourself if you want.</p>\n\n\n\n<p>Now obviously that does still require a developer to hook that all up, but what you already see today with Block Bindings is a very similar panel. When you go use a Block Binding today, there&#8217;s a little panel called attributes. You click it, it shows you all the attributes you can connect up to a binding. That&#8217;s part of Gutenberg and WordPress Core right now.</p>\n\n\n\n<p>So I think that interface is already there, and I think as more Block Bindings and plugins start to utilise that, the interface is already there for really people to kind of make these interactivity connections themselves.</p>\n\n\n\n<p>[00:28:50] <strong>Nathan Wrigley:</strong> I suppose I&#8217;m kind of thinking back to the day when WordPress shipped for the first time, custom post types. I presume lots of people made use of them. It might be analogous to where we are at now with this, you know, people who are experienced can use it. But then somebody, some bright spark, came up with the idea of a custom post type plugin with a UI, and this way of just making it visually appealing and straightforward.</p>\n\n\n\n<p>And when you were talking about this sort of, it felt almost like a flow chart that you were building there, where you&#8217;ve got, here&#8217;s the options, just sort of clicking on them with a mouse and dragging it so this feature now goes to this feature, and I&#8217;m binding this to this, that&#8217;s what I was imagining. You know, something really straightforward. Drop dead simple, non developery.</p>\n\n\n\n<p>[00:29:29] <strong>Seth Rubenstein:</strong> Well, I will give a plug for my friends at Automattic. Part of my session was also sharing a product that we&#8217;ve built called Remote Pivot Table, which lets you kind of make really quick pivot tables out of Google Sheets so the data&#8217;s not living inside of WordPress, so that our researchers can really quickly update these data sets, and we don&#8217;t have to do a thing to get the updates. Well, that&#8217;s built on Automattic&#8217;s new Remote Data Blocks. And it actually does exactly what you&#8217;re saying.</p>\n\n\n\n<p>You go in there, you tell it what your data sources are. Airtable, Google Sheets, Shopify, Custom HTTP endpoints if you want, and it will go create the blocks for you. It will create the bindings for you, and it&#8217;ll create the interface for you so that you can select, okay, well, when I&#8217;m building out my interface, you know, this text goes to this binding. It should pull from this value from that Google sheet. So that&#8217;s actually already out in the wild right now.</p>\n\n\n\n<p>[00:30:18] <strong>Nathan Wrigley:</strong> What was it called?</p>\n\n\n\n<p>[00:30:18] <strong>Seth Rubenstein:</strong> Remote Data Blocks.</p>\n\n\n\n<p>[00:30:19] <strong>Nathan Wrigley:</strong> Okay.</p>\n\n\n\n<p>[00:30:20] <strong>Seth Rubenstein:</strong> It&#8217;s on the WordPress plugin repo. I think they just published it this week.</p>\n\n\n\n<p>[00:30:23] <strong>Nathan Wrigley:</strong> I&#8217;ll remember to put that into the show notes. I will dig that out and make sure that that gets into the show notes.</p>\n\n\n\n<p>Yeah, I kind of feel like, even if we were to build the perfect UI, I still feel for most people this may end up being the domain of, get the developer to do it.</p>\n\n\n\n<p>[00:30:38] <strong>Seth Rubenstein:</strong> Yeah, it is very much in the domain of the developer. These are all developer APIs for them to build out tools for others. And I think ultimately what these APIs allow is for developers to make products that are easier to use for the end user. Like I said, less settings, less controls, less all these sidebar panels and stuff, and more just, you drag and drop the block in and in the background, through the Interactivity API, through Block Bindings, through Block Bits, you&#8217;re configuring how that application should work. So it&#8217;s more of just drag and drop for the end user.</p>\n\n\n\n<p>[00:31:09] <strong>Nathan Wrigley:</strong> The features exist, you&#8217;d need to sort of go and figure out how to make it work. I guess we&#8217;ve got all these Block Bindings, we&#8217;ve got all these Block Bits, we&#8217;ve got this enormous complexity that we could get into. How performant is all of this?</p>\n\n\n\n<p>[00:31:22] <strong>Seth Rubenstein:</strong> Extremely.</p>\n\n\n\n<p>[00:31:23] <strong>Nathan Wrigley:</strong> So my fear is you just get carried away and you bind everything to every other thing, and where a bit is available, you make a Block Bit. I can&#8217;t summon up an example, but you get the point. You just get totally carried away. The performance, I would assume there is some hit, but it sounds like not so much.</p>\n\n\n\n<p>[00:31:40] <strong>Seth Rubenstein:</strong> I don&#8217;t think so. I think the performance is actually better for a lot of these things. All of our Interactivity API projects, like technical performance is substantially better than if we had just built out a React frontend ourself.</p>\n\n\n\n<p>Because think about the weight of that. I mean, React is pretty heavy, one. Preact on the other hand, which the Interactivity API is built on is very lightweight. But additionally you have this, I guess the other element which we really kind of haven&#8217;t defined is the HTML Tag Processor. That is what underpins all of these things, all of these APIs, even the Interactivity API, even though that&#8217;s JavaScript,</p>\n\n\n\n<p>When you are writing in the Interactivity API, you can write state and context and all these values in HTML, the HTML tag processor that&#8217;s reading that, that&#8217;s processing it. And it does it so extremely fast. You know, if you&#8217;ve worked with a PHP DOM document, it&#8217;s slow, it&#8217;s very bad. This is not that. This is extraordinarily fast.</p>\n\n\n\n<p>In addition, on the technical performance, when you&#8217;re using the Interactivity API, you get speed on the front end as well, because what you can do is you can pre hydrate information into your JavaScript application before it even loads, on the server side, which is really exciting.</p>\n\n\n\n<p>You can see this today actually. Core query, the query loop, and the pagination. Those use an Interactivity API. When you hover over the two or the next page, what&#8217;s happening is there&#8217;s an Interactivity API function for prefetch. So you&#8217;re prefetching the next page of results. So for the user, boom. They click on it, boom. The results are already there. You go a little bit, further, you can cache that information. So now the user has pre fetched the next page and they&#8217;ve cached it for the next person to come to this page. That just really wasn&#8217;t possible before.</p>\n\n\n\n<p>[00:33:18] <strong>Nathan Wrigley:</strong> No. Is that kind of leaning into sort of core browser technologies as well?</p>\n\n\n\n<p>[00:33:22] <strong>Seth Rubenstein:</strong> Oh yes.</p>\n\n\n\n<p>[00:33:22] <strong>Nathan Wrigley:</strong> Yeah, I&#8217;m just thinking of things like.</p>\n\n\n\n<p>[00:33:25] <strong>Seth Rubenstein:</strong> Well, the prefetch thing is part of the browser technology. I&#8217;ll give you an example. We have this very large religious census we do every decade called the Religious Landscape Study. It&#8217;s extremely complex database with a lot of querying, and a lot of SQL logic. If we were to, you go to a page on this database and there&#8217;s maybe like 12 charts. Well, if we were to load all those 12 charts on page load, like it would take a couple minutes to load the page. The site would probably crash.</p>\n\n\n\n<p>But what we do is, as a user hovers over a chart before they click on it, we prefetch, it and we cache it. So for them, they click it, it&#8217;s instantaneous. But also we&#8217;ve now done the extra work of waiting for the next person, that&#8217;s already waiting there ready for the next person. I cannot state how important this innovation has been for the performance of our site and the Interactivity API.</p>\n\n\n\n<p>[00:34:12] <strong>Nathan Wrigley:</strong> That is actually fairly profound, isn&#8217;t it? Yeah. Sometimes when you are explaining these things, the penny kind of half drops. And then a moment later, the penny drops fully and that one&#8217;s just hit. That&#8217;s actually really profound, isn&#8217;t it? Especially on a high traffic site where you don&#8217;t really want to be doing that thing a thousand times a second, just do it once, more or less.</p>\n\n\n\n<p>[00:34:34] <strong>Seth Rubenstein:</strong> I have a philosophy of if I can offload it to the end user, I&#8217;m going to. You know, I&#8217;m going to use your computer if I can.</p>\n\n\n\n<p>[00:34:41] <strong>Nathan Wrigley:</strong> That&#8217;s fascinating. Okay, so pivot slightly. Do you think there&#8217;s a opportunity here? I expect there&#8217;s a bunch of developers listening to this who either haven&#8217;t experienced this before, haven&#8217;t played with it, and are thinking, okay, I want to wrap a UI around that. I want to build a plugin to make this stuff available. We kind of alluded to this a minute ago. Do you think that there is an opportunity there for developers to kind of neaten this interface up?</p>\n\n\n\n<p>[00:35:02] <strong>Seth Rubenstein:</strong> Oh, yeah. Oh, yeah, absolutely. I would be very excited to see where the future of this lands for the WordPress ecosystem. You think of plugins like Advanced Custom Fields and what that did for WordPress, right? It was obviously possible to register post meta and all this stuff before, but what a hassle. It just was. And it really opened up WordPress as a content management system in a way that no other plugin had really done before.</p>\n\n\n\n<p>So some very smart person, some enterprising person out there, there is an opportunity here to kind of build out something that would do that for the Interactivity API and empower less technically inclined people and maybe just not technical people at all to use this.</p>\n\n\n\n<p>[00:35:39] <strong>Nathan Wrigley:</strong> Yeah. Because despite the fact that you&#8217;ve explained it really clearly, and I&#8217;ve got a grip on it, I suspect that I wouldn&#8217;t want to go through all of the weeds to connect all of those pieces. And I don&#8217;t want to open up a code editor. I want everything to be point, click, type, inside of WordPress, in a really straightforward, well-designed, beautifully thought through interface. Kind of like gold rush territory I think. Maybe there&#8217;s an opportunity here for someone, maybe multiple people.</p>\n\n\n\n<p>Yeah, and it&#8217;s what you said before about these kind of custom post type plugins, there&#8217;s many of them and I think without them, nobody would&#8217;ve been using custom post types, well, not nobody, but a tiny proportion of the people would&#8217;ve started to use them. And I feel the same a bit here. I feel like the things that you&#8217;ve described, they&#8217;re fabulous, technically, conceptually brilliant, but if somebody was to come up with a UI that made them not just conceptually brilliant, but drop dead easy to use, we&#8217;ve got something really incredible.</p>\n\n\n\n<p>[00:36:35] <strong>Seth Rubenstein:</strong> Yeah, absolutely. Yeah, I mean, look, when I first started in WordPress, I didn&#8217;t know how to do custom fields, custom post types. You know, ACF helped me out there. And I do them all by hand now, right? I register all my post types and my post meta by hand. But those sort of plugins that make it easier for, well, not even if you&#8217;re less technically inclined, you&#8217;re busy, you don&#8217;t have the time to learn all these new APIs, it really does help out adoption down the road.</p>\n\n\n\n<p>[00:37:00] <strong>Nathan Wrigley:</strong> And also you can imagine scenarios where people build out pre-configured versions of a thing. So that you might have templates for, I&#8217;m struggling to conceptualise that but, you know, you download this plugin, whatever it may be, and they&#8217;ve pre-configured useful scenarios that are repeatable. And you just, okay, click a button, that gets me 90% of what I want to do and then I go from there, kind of thing. Yeah, that&#8217;s interesting.</p>\n\n\n\n<p>In terms of the bits and pieces that you&#8217;ve described, is there anything which you think might be missing? I know that&#8217;s a difficult question to answer because I&#8217;m asking you to stare into a crystal ball and come up with the future. But is there any kind of concept in here that you&#8217;ve thought, you know what, it&#8217;d be really handy to have that?</p>\n\n\n\n<p>[00:37:37] <strong>Seth Rubenstein:</strong> I think it&#8217;s responsive. Responsive blocks, responsive attributes.</p>\n\n\n\n<p>[00:37:41] <strong>Nathan Wrigley:</strong> Describe what that is because in my head, as soon as I hear responsive, I think viewport width.</p>\n\n\n\n<p>[00:37:45] <strong>Seth Rubenstein:</strong> Yeah, and I think that&#8217;s exactly what I&#8217;m talking about. You know, I think all of the APIs are here. All the bits are in place to make that happen, the work just needs to be done. There&#8217;s actually a function in the Gutenberg source code for, I think it&#8217;s called update attribute on screen size or something like that, where you can kind of, desktop, tablet, mobile changes attribute to match for that viewport size.</p>\n\n\n\n<p>I think this has been the Achilles heel for Gutenberg. It&#8217;s the constant complaint that I hear out of people. And I think that is really the missing link, the, last thing that would really make Gutenberg perfect.</p>\n\n\n\n<p>[00:38:19] <strong>Nathan Wrigley:</strong> So scenarios where you could literally change anything based upon, I don&#8217;t know, we&#8217;re on a tablet now, so what we had on a desktop is no longer appropriate. Again, I&#8217;m struggling to conceptualise what that might be, but again, the same on mobile.</p>\n\n\n\n<p>[00:38:32] <strong>Seth Rubenstein:</strong> I&#8217;ll give you a good example. We have our own grid block, columns block. We made our own grid block because we do this responsive attribute stuff. You might have three columns that are x width on desktop, and then on tablet, well, you might want that middle column actually to move to the first position to be 100% width, right? That&#8217;s a really easy example, but doing that right now is next impossible without having a developer build out that system for you. That&#8217;s just one thing I can think of, but there are a myriad of instances like that.</p>\n\n\n\n<p>[00:39:01] <strong>Nathan Wrigley:</strong> Yeah, the domino fell a bit there. I understand what you mean. So yeah, it could be width, it could be background colour, it could be font size or content, anything.</p>\n\n\n\n<p>[00:39:09] <strong>Seth Rubenstein:</strong> A number of things, yeah. Well, it could be also in the Interactivity API. It could be that, you know, on tablet, actually I want, when you click on this thing, I want it to do something else entirely.</p>\n\n\n\n<p>[00:39:16] <strong>Nathan Wrigley:</strong> The button does a different thing.</p>\n\n\n\n<p>[00:39:17] <strong>Seth Rubenstein:</strong> Yeah.</p>\n\n\n\n<p>[00:39:17] <strong>Nathan Wrigley:</strong> Yeah, okay. That&#8217;s really interesting.</p>\n\n\n\n<p>[00:39:18] <strong>Seth Rubenstein:</strong> Well, I&#8217;ll give you another example. We do that. Well, not to that degree, but Core social links. We wrap that in another block called Navigator Share Link. So when you&#8217;re on mobile and you click on the Facebook button, we&#8217;re not taking you to the Facebook share little window. We just open up the little native browser share thing. You just send it off to your app or whatever, friends, your iMessage, whatever you want to do.</p>\n\n\n\n<p>So I think that kind of device contextuality is one area where there&#8217;s not a lot of guidance or APIs or anything, and that is kind of entirely on the developers to figure out themselves. But I think that&#8217;s probably what&#8217;s missing most from Gutenberg, is that kind of idea of screen or device contextuality.</p>\n\n\n\n<p>[00:40:01] <strong>Nathan Wrigley:</strong> I just think this is all so fascinating. Essentially, during the last 40 minutes or so, you&#8217;ve prized open, I think a really different future for WordPress than I had previously thought. I knew all these things existed. I hadn&#8217;t really connected the dots. And it feels to me as if suddenly you go from building a bunch of websites to anything. Literally anything. If it&#8217;s possible to put in a browser.</p>\n\n\n\n<p>[00:40:27] <strong>Seth Rubenstein:</strong> It&#8217;s a web application framework.</p>\n\n\n\n<p>[00:40:28] <strong>Nathan Wrigley:</strong> Right. There you go. Yeah. A web application. Build anything inside of WordPress, which is not something that I was all that familiar with. Gosh, the future is bright.</p>\n\n\n\n<p>[00:40:37] <strong>Seth Rubenstein:</strong> I mean, we have blocks where people are, you know, drag and drop them together and they&#8217;re building out little calculators. You know, one of our more popular content types is like, put in your income and where you live, and then we&#8217;ll tell you some information about you, you know, about your area or whatever. That&#8217;s a web application. That&#8217;s not a blog post. That&#8217;s not content. That&#8217;s a web application that someone just drag and drop built.</p>\n\n\n\n<p>Yeah, we&#8217;re at a place, you know, the content management stuff of WordPress, man, that&#8217;s rock hard. That&#8217;s settled. Now we&#8217;re going into another era, a new direction where WordPress is this web development framework, first and foremost. For you, the developer, but also your end users to build web applications with, inside of.</p>\n\n\n\n<p>[00:41:19] <strong>Nathan Wrigley:</strong> Yeah, absolutely fascinating. So my intuition that I alluded to at the beginning of this podcast, in 2018 or whatever it is, that promise has now become reality. The year 2025, we got there. And now it just needs a bunch of developers, hopefully, dear listener, if you&#8217;re listening to this, get on board and try to figure this out and make it straightforward so people like me can use it.</p>\n\n\n\n<p>Seth, I think that&#8217;s probably the sweet spot to end it. That&#8217;s a very optimistic future you&#8217;ve painted there. Where do we find you, if somebody&#8217;s listening? I would imagine that there&#8217;s a bunch of people listening to this thinking, I need to speak to Seth.</p>\n\n\n\n<p>[00:41:51] <strong>Seth Rubenstein:</strong> You can find me at sethrubenstein.info. And you can find me on Twitter or Bluesky. Please find me on Bluesky, though, I hate Twitter.</p>\n\n\n\n<p>[00:41:57] <strong>Nathan Wrigley:</strong> We will drop the links into the show notes. So if you head to wptavern.com, search for the episode with Seth Rubenstein, that&#8217;s S-T-E-I-N, search for that and then the links will be there for Seth&#8217;s socials, plus anything to do with the talk that we&#8217;ve been mentioning as well. Seth Rubenstein, thank you so much for chatting to me today.</p>\n\n\n\n<p>[00:42:15] <strong>Seth Rubenstein:</strong> Thank you for having me.</p>\n</div></details>\n\n\n\n<p>On the podcast today we have <a href=\"https://sethrubenstein.info\">Seth Rubenstein</a>.</p>\n\n\n\n<p>Seth is the head of engineering at the Pew Research Center, where he leads a team of developers managing the organisation’s WordPress-based publishing platform for its news site. Passionate about open source, Seth ensures that everything his team builds not only meets the Pew Research Center’s needs, but also benefits the wider community. By actively contributing to the Gutenberg project, he strives to share their solutions, always asking how their work can be given back to help others in the WordPress ecosystem.</p>\n\n\n\n<p>Seth shares fascinating stories from the work h   e’s recently been doing. He breaks down what block composability really means, the ability to build modular, reusable, and even interactive blocks that work seamlessly together, empowering both developers and end users to create sophisticated web applications within the familiar WordPress block editor.</p>\n\n\n\n<p>The conversation gets into some of WordPress’s newest and most promising features, including the Block Bindings API, Block Bits (still very much in development), and the Interactivity API. Seth explains how these tools open a world of possibilities, like building interactive quizzes, dynamically updating content, or even prefetching data, all using blocks, without having to rely on custom React front-ends or heavy server-side processing.</p>\n\n\n\n<p>Seth also talks about the path forward for democratising these advanced capabilities, discussing current limitations, the potential for new UI tools, and what’s still missing in the quest for truly responsive, device-contextual blocks.</p>\n\n\n\n<p>Throughout the episode, Seth makes a compelling case for why now is a golden opportunity for developers and plugin builders to start experimenting, get involved, and shape the next evolution of WordPress as a cutting-edge web application platform.</p>\n\n\n\n<p>Whether you’re a developer curious about the future of Gutenberg or an editor dreaming of more drag-and-drop web app power, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://www.pewresearch.org\"> Pew Research Center</a></p>\n\n\n\n<p>Seth and Max Schmeling&#8217;s presentation at WordCamp US 2025 &#8211;  <a href=\"https://us.wordcamp.org/2025/session/block-composability-the-past-and-the-future/\">Block Composability: The Past and The Future</a></p>\n\n\n\n<p><a href=\"https://developer.wordpress.org/block-editor/reference-guides/interactivity-api/\">Interactivity API</a></p>\n\n\n\n<p>Block Bits &#8211; <a href=\"https://make.wordpress.org/core/2024/06/08/proposal-bits-as-dynamic-tokens/\">Proposal: Bits as dynamic tokens</a></p>\n\n\n\n<p><a href=\"https://developer.wordpress.org/block-editor/reference-guides/block-api/\">Block Bindings API</a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2023/03/07/introducing-the-html-api-in-wordpress-6-2/\">HTML API</a></p>\n\n\n\n<p><a href=\"https://preactjs.com\"> Preact framework</a></p>\n\n\n\n<p><a href=\"https://github.com/Automattic/remote-data-blocks\"> Automattic&#8217;s new Remote Data Blocks</a></p>\n\n\n\n<p><a href=\"https://www.pewresearch.org/religious-landscape-study/\"> Religious Landscape Study</a></p>\n\n\n\n<p><a href=\"https://sethrubenstein.info\">Seth&#8217;s website</a></p>\n\n\n\n<p><a href=\"https://bsky.app/profile/sethrubenstein.info\">Seth on Bluesky</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 Oct 2025 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Open Channels FM: Transforming Website Analytics for WordPress Users with a Privacy-First Approach\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=111275\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"https://openchannels.fm/transforming-website-analytics-for-wordpress-users-with-a-privacy-first-approach/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:222:\"In this episode, Adam chats with the creators of Independent Analytics, a WordPress plugin focusing on user-friendly, privacy-oriented website stats. They highlight its benefits over Google Analytics and upcoming features.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 Oct 2025 12:45:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"Open Channels FM: From Identica to ActivityPub: How Open Social Protocols Are Shaping the Future of the Web\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=110909\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"https://openchannels.fm/from-identica-to-activitypub-how-open-social-protocols-are-shaping-the-webs-future/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:262:\"The Fediverse, shaped by pioneers like Evan Prodromou, evolved from Identica to ActivityPub, fostering decentralization and user control. It contrasts corporate social networks by promoting openness, privacy, and collaborative development for online communities.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 Oct 2025 09:03:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt: Simplify\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150316\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://ma.tt/2025/10/simplify/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:826:\"<p>I have some &#8220;grand theories&#8221; of software engineering: I think there are two tribes of engineers that complexify things or simplify things, and they are in eternal conflict. </p>\n\n\n\n<p><strong>Complexify:</strong> <a href=\"https://jamstack.org/\">Jamstack</a>, headless, Contentstack, Contentful, <a href=\"https://www.acquia.com/blog/what-digital-experience-platform-dxp\">DXP</a>, <a href=\"https://business.adobe.com/blog/basics/digital-asset-management\">DAM</a>, micro-services. </p>\n\n\n\n<p><strong>Simplify:</strong> WordPress, Simplenote, Day One, <a href=\"https://en.wikipedia.org/wiki/Djbdns\">djbdns</a>, <a href=\"https://sqlite.org/\">SQLite</a>. </p>\n\n\n\n<p>Not enough engineers have studied under the code of <a href=\"https://en.wikipedia.org/wiki/Daniel_J._Bernstein\">Daniel J. Bernstein</a>.</p>\n\n\n\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 Oct 2025 04:59:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Matt: Make No Little Plans\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150274\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://ma.tt/2025/10/make-no-little-plans/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:928:\"<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Make no little plans. They have no magic to stir men’s blood and probably themselves will not be realized. Make big plans; aim high in hope and work, remembering that a noble, logical diagram once recorded will never die, but long after we are gone will be a living thing, asserting itself with ever-growing insistency. Remember that our sons and grandsons are going to do things that would stagger us. Let your watchword be order and your beacon beauty. Think big.</p>\n</blockquote>\n\n\n\n<p>— <a href=\"http://en.wikipedia.org/wiki/Daniel_Burnham\">Daniel Burnham</a>, Chicago architect (1864–1912) (Hat tip: <a href=\"https://intenseminimalism.com/2010/make-no-little-plans/\">Erin</a>, and the <a href=\"https://summit.co/make-no-small-plans\">Summit folks</a>.) (It&#8217;s an old quote but update in your head to include the ladies too.)</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 19 Oct 2025 20:19:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Matt: Albumin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150261\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://ma.tt/2025/10/albumin/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1026:\"<p>Since reading the <a href=\"https://fourhourworkweek.com/\">Four Hour Workweek</a> and <a href=\"https://tim.blog/\">Tim Ferriss</a> I&#8217;ve been a bit of a bio-hacker, always trying weird and new stuff. Today was a new one! I did therapeutic plasma exchange (TPE), also known as plasmapheresis, which supposedly gives you all the <a href=\"https://en.wikipedia.org/wiki/Young_blood_transfusion\">benefits of parabiosis</a> without, you know, needing to be a vampire or <a href=\"https://www.youtube.com/watch?v=hBA0AH-LSbo\">having a blood boy</a>. So with the awesome folks at <a href=\"https://extension.health/\">Extension Health</a> I had my blood filtered and put back in, which took a few hours. My plasma <a href=\"https://x.com/bryan_johnson/status/1845950287032492378\">was not as clear as Bryan Johnson&#8217;s</a>, with 41 years of microplastics and mold and who knows what else in there. The process took a few hours, and afterward I got some chicken on rice from a Halal cart on Broadway so maybe it all evens out.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 19 Oct 2025 00:42:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"Gutenberg Times: Abilities API, Block Accessibility Check, Gutenberg Framework, AI creating Blocks and themes—Weekend Edition 345\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=42268\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"https://gutenbergtimes.com/abilities-api-block-accessibility-check-gutenberg-framework-ai-creating-blocks-and-themes-weekend-edition-345/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:20660:\"<p>Hi there, </p>\n\n\n\n<p>A release party is coming up on <strong>Tuesday, October 21, at 15:00 UTC for WordPress 6.9 Beta 1.</strong> It&#8217;s the first time for this release squad. Good luck! </p>\n\n\n\n<p>Will you start testing WordPress 6.9 next week?  You can use the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">Beta Tester plugin</a> by <strong>Andy Fragen</strong> and install it on your test site. I am using <a href=\"https://developer.wordpress.com/studio/\">WordPress Studio</a> on my computer for systematic testing and prep work for the <em>Source of Truth</em> post to come out in a few weeks.</p>\n\n\n\n<p>The WordPress Test team already published a few pre-beta calls for testing, you can work through, and they are preparing a comprehensive post for all of WordPress 6.9 testing for next week. </p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/test/2025/10/03/help-test-changes-to-template-management/\"><strong>Help test changes to template management</strong></a> </li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2025/10/04/call-for-testing-ability-to-hide-blocks/\"><strong>Call for Testing: Ability to Hide Blocks</strong></a> </li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2025/10/06/call-for-testing-accordion-block/\"><strong>Call for Testing: Accordion Block</strong></a> </li>\n</ul>\n\n\n\n<p>WordPress 6.9 is a big focus of my work now. As always, I&#8217;ll keep you updated. </p>\n\n\n\n<p>Have a fantastic weekend! </p>\n\n\n\n<p>Yours, <img alt=\"💕\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f495.png\" style=\"height: 1em;\" /><br /><em>Birgit</em></p>\n\n\n\n<p>PS:  On Monday, October 20th, I will be on the 353rd episode of <a href=\"https://wpbuilds.com/news-archive/\"><strong>This week in WordPress</strong></a> show together with Michelle Frechette, Tim Nash, and the brilliant host Nathan Wrigley. <a href=\"https://wpbuilds.com/live/\">You can join us live! </a><img alt=\"📺\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f4fa.png\" style=\"height: 1em;\" /></p>\n\n\n\n<p>PPS: This week, I celebrated the <a href=\"https://icodeforapurpose.com/five-year-anniversary-of-the-gutenberg-nightly/\">five-year anniversary of Gutenberg Nightly. </a><img alt=\"🎉\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f389.png\" style=\"height: 1em;\" /> </p>\n\n\n<section class=\"wp-block-newsletterglue-callout undefined not-color-set\" style=\"border-color: #eeeeee; border-radius: 26px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f3efe9;\">\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. </p>\n\n\n\n<p>Now also available via <a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href=\"mailto:pauli@gutenbergtimes.com\">Email me </a>with your experience</p>\n</section>\n\n\n<div class=\"wp-block-spacer\" style=\"height: 21px;\"></div>\n\n\n<section class=\"wp-block-newsletterglue-group\" style=\"padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;\">\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<nav class=\"wp-block-table-of-contents\"><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/abilities-api-block-accessibility-check-gutenberg-framework-ai-creating-blocks-and-themes-weekend-edition-345/#0-word-press-release-information\">Developing Gutenberg and WordPress</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/abilities-api-block-accessibility-check-gutenberg-framework-ai-creating-blocks-and-themes-weekend-edition-345/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owner</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/abilities-api-block-accessibility-check-gutenberg-framework-ai-creating-blocks-and-themes-weekend-edition-345/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/abilities-api-block-accessibility-check-gutenberg-framework-ai-creating-blocks-and-themes-weekend-edition-345/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor</a></li></ol></nav>\n</div></div>\n</section>\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\"></div>\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p>Yesterday, <strong>Matt Mullenweg</strong> talked briefly at <strong>WordCamp Canada</strong>, gave a demo, and then answered questions from the  the audience. The wizards behind the scenes already posted the recording of the session to YouTube. <a href=\"https://www.youtube.com/watch?v=RL-XccK30sY\"><strong>WordCamp Canada 2025—Ma.tt Mullenweg &#8220;Town Hall/AMA&#8221;</strong></a>. If you rather read about the talk on Mullenweg&#8217;s blog, <a href=\"https://ma.tt/2025/10/wordcamp-canada/\">WordCamp Canada Talk</a>. He also added the Q &amp; A transcript as well. </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\"></div>\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p><img alt=\"🎙\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f399.png\" style=\"height: 1em;\" /> The latest episode is <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-123-wordpress-6-9-and-gutenberg-21-9/\">Gutenberg Changelog #123 – WordPress 6.9 and Gutenberg 21.9</a> with Isabel Brison, core contributor. </p>\n\n\n\n<figure class=\"wp-block-image size-full is-style-no-vertical-margin\"><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-123-wordpress-6-9-and-gutenberg-21-9/\"><img alt=\"\" class=\"wp-image-42384\" height=\"185\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/Screenshot-2025-10-23-at-17.20.50.png?resize=652%2C185&#038;ssl=1\" width=\"652\" /></a></figure>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-rich is-provider-pocket-casts wp-block-embed-pocket-casts\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div></div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owner</h2>\n\n\n\n<p>In his video <a href=\"https://www.youtube.com/watch?v=iCtjWwWi5sQ\"><strong>AI Builds WordPress Blocks</strong></a> , <strong>Jamie Marsland</strong> introduced <em><a href=\"https://telex.automattic.ai/\">Automattic Telex</a></em> and showed off about ten blocks he and other people built with it, like animated text, a countdown counter, and mermaid diagram and more. Check it out; it&#8217;s not only amazing, it borders on voodoo or magic. </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Tammie Lister</strong> continues her October Challenge on the <strong>Blocktober.fun</strong> site. The latest blocks are <a href=\"https://blocktober.fun/flip-card/\">Flip Card</a>, <a href=\"https://blocktober.fun/emoji-voting/\">Emoji Voting</a>, <a href=\"https://blocktober.fun/highlighter/\">Highlighter</a>, <a href=\"https://blocktober.fun/story-generator/\">Story Generator,</a>  <a href=\"https://blocktober.fun/watermark/\">Watermark</a> and <a href=\"https://blocktober.fun/make-the-logo-bigger/\">Make the logo bigger</a>. You not only can try them all out on Telex and remix them with your own ideas. Lister also shares here elaborate prompts you can study and learn how to skill up your AI work. </p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"\" class=\"wp-image-42310\" height=\"460\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/Screenshot-2025-10-18-at-14.04.11.png?resize=652%2C460&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Troy Chaplin</strong> released <strong><a href=\"https://wordpress.org/plugins/block-accessibility-checks/\">Block Accessibility Check v2.2</a></strong>! It introduces Heading structure validation,  alt-text pattern detection and provides an upgraded URL checks with real TLD validation + dev environment support&#8221;Along with the new release comes a <a href=\"https://blockaccessibilitychecks.com/\">new dedicated website</a> featuring improved docs, feature overviews, and developer API guide&#8221;. Chaplin wrote. The site is focused to assist content creators and developers alike. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Anne Katzeff</strong> shared how she created <a href=\"https://www.askdesign.biz/blog/2025/10/overlapping-columns-with-the-media-text-block/#google_vignette\"><strong>overlapping Columns with the Media &amp; Text Block</strong></a> and little Additional CSS. The step-by-step instructions show you how you can build some dynamic layouts with the core block features. </p>\n\n\n\n<figure class=\"wp-block-image\"><img alt=\"\" src=\"blob:https://gutenbergtimes.com/44a2bf47-9c14-481b-bbe1-29e1c6fe25d0\" /></figure>\n\n\n\n<p><strong>Katzeff</strong> also posted a video of her process on YouTube. <a href=\"https://www.youtube.com/watch?v=kNwkwlwKB4I\"><strong>Overlapping Columns With the Media &amp; Text Block</strong></a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Michael Manuel</strong>, WordPress VIP, posted a four-part series of short video: <a href=\"https://wpvip.com/blog/behind-the-build-modernize-publishing/\"><strong>Behind the Build: How Christianity Today Modernized its Publishing Experience</strong></a> and how the team of <em>WebDevStudios</em> helped transform editorial workflows, infrastructure, and content operations for one of America’s most trusted media brands.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Part 1: <strong>Editorial empowerment &amp; workflow efficiency</strong></li>\n\n\n\n<li>Part 2: <strong>Performance &amp; platform modernization</strong></li>\n\n\n\n<li>Part 3: <strong>Homepage &amp; design system overhaul</strong></li>\n\n\n\n<li>Part 4: <strong>Content migration &amp; CMS modernization</strong></li>\n</ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Brad Salomons</strong>, 8r4d Consulting, Ltd, created the <a href=\"https://wordpress.org/plugins/panoramic-slider-block/\"><strong>Panoramic Slider Block</strong></a> to scratch an itch. With this block you can post your Pano photos from your phone camera as it provides horizontal sliding controls.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"Brad Salomons - screenshot of the Panoramic Slider Block in the editor. \" class=\"wp-image-42308\" height=\"312\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/screenshot-1-1.png?resize=652%2C312&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p>On the WordPress Developer Blog, <strong>Nick Diego </strong>published a Snippet on <a href=\"https://developer.wordpress.org/news/snippets/how-to-add-custom-blocks-to-navigation-menus/\"><strong>How to add custom blocks to navigation menus</strong></a>. It shows how to use  the <code>blocks.registerBlockType</code> filter to extend the navigation block’s <code>allowedBlocks</code> array.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Elliott Richmond</strong> demonstrated <a href=\"https://www.youtube.com/watch?v=6sgJNNm5EOU\"><strong>how to create a block theme using Claude Code</strong></a> on YouTube. He built a theme from scratch with Claude Code, providing clear structure and Markdown tips for the AI tool. You&#8217;ll discover how to set up a CLAUDE.md file for AI-assisted theme development and how Claude works with the WordPress Block Theme structure.</p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n<section class=\"wp-block-newsletterglue-callout undefined not-color-set\" style=\"border-color: #f9f9e5; border-radius: 22px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f9f9e5;\">\n<p><strong> <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" rel=\"noreferrer noopener\" target=\"_blank\">&#8220;Keeping up with Gutenberg &#8211; Index 2025&#8221;</a> </strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. The earlier years are also available: <strong><strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">2020</a> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/\">2021</a></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/\">2022</a></strong></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023\">2023</a></strong> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2024/\"><strong>2024</strong></a></p>\n</section>\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor</h2>\n\n\n\n<p><br /><strong><a href=\"https://x.com/muhsinlk\">Muhammad Muhsin</a> </strong>senior engineer at Fueled gave a talk on <a href=\"https://wordsesh.com/speakers/muhammad-muhsin\">Building a Web App with the Gutenberg Framework at WordSesh</a> earlier this year. <a href=\"https://wordpress.org/gutenberg-framework/\">What is Gutenberg as a Framework?</a> It&#8217;s a way to use the block editor in a JavaScript application outside of WordPress. Muhsin &#8220;built CareerVision.io using Gutenberg outside WordPress—a standalone React framework for block-based apps&#8221;. You can watch the <a href=\"https://www.youtube.com/watch?v=0JXbtZWA3zI\">presentation on YouTube</a> now.</p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Ryan Welcher</strong> was the <a href=\"https://www.youtube.com/watch?v=T7kLXWvywww\"><strong>Pro WordPress Developer Watches AI Build a Custom Block… and is Blown Away!</strong></a> He put <a href=\"https://telex.automattic.ai/\">Automattic&#8217;s Telex</a> to the test,  to build a live audio visualizer block inspired by the classic iTunes music visualizer. The AI writes the React code, handles audio input, and even makes the block respond to live microphone sound, all in about 15 minutes. It’s an impressive look at how Telex could reshape the way developers build custom blocks for WordPress. </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>JuanMa Garrido</strong>, developer advocate at Automattic,  livestreamed his ongoing discovery of the <a href=\"https://www.youtube.com/watch?v=m19VM2yIbHU\"><strong>Abilities API</strong></a>.  He explored how to register custom abilities, expose them to AI models, and understand how this fits into WordPress’ broader AI architecture alongside the MCP Adapter and PHP AI API. The recording is now available on YouTube.</p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<p></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, <br />send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n<section class=\"wp-block-newsletterglue-group\" style=\"padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;\">\n<p>Featured Image: Photo by MRFE MRFE on <a href=\"https://www.pexels.com/photo/vibrant-geometric-abstract-3d-blocks-design-34268918/\">Pexels.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n<form action=\"https://gutenbergtimes.com/feed/\" autocomplete=\"on\" class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\" style=\"margin-bottom: 25px;\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input autocomplete=\"email\" class=\"ngl-form-input-text\" id=\"ngl_email\" name=\"ngl_email\" required=\"required\" style=\"border-radius: 21px;\" type=\"email\" /></div></div><button class=\"ngl-form-button\" style=\"background-color: #005075; border-color: #005075; border-width: 1px; border-style: solid; color: #ffffff; border-radius: 21px;\" type=\"submit\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too, and won&#8217;t give your email address to anyone <br />except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"><svg fill=\"none\" height=\"24\" stroke=\"#fff\" stroke-width=\"2\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><polyline points=\"20 6 9 17 4 12\"></polyline></svg></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input id=\"ngl_list_id\" name=\"ngl_list_id\" type=\"hidden\" value=\"26f81bd8ae\" /><input id=\"ngl_double_optin\" name=\"ngl_double_optin\" type=\"hidden\" value=\"yes\" /></form>\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n</section>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Oct 2025 22:14:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Matt: WordCamp Canada Talk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150251\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://ma.tt/2025/10/wordcamp-canada/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:46239:\"<p>Howdy and bonjour! First, thank you so much, merci beaucoup, for having me at your WordCamp. I love the spirit of local communities gathering and helping each other learn and grow together. I wasn&#8217;t actually planning to speak or even do a Q &amp; A; I was just going to attend this WordCamp. But since the organizers have given me a bit of your time, I will try to make the best of it. </p>\n\n\n\n<p>I love Canada. I first came here for <a href=\"https://en.wikipedia.org/wiki/Northern_Voice\">the Northern Voice conference</a> in 2006. Was anyone at that one? I think Dave Winer was actually there. It was a pretty awesome one. What&#8217;s that?</p>\n\n\n\n<p>[Here I think Dave said he wasn’t at that one, but a different conference, but can’t remember.]</p>\n\n\n\n<p>Well, that&#8217;s why we blog. My memory is not that good. [laughs] By the way, I think this week is your anniversary, right? </p>\n\n\n\n<p><strong>Dave Winer:</strong> It was actually a couple of weeks ago—31 years.</p>\n\n\n\n<p><strong>MM: </strong>Oh, wow. Thirty-one years. Round of applause! I think why I thought it was your anniversary is that on my blog’s related posts, it showed a post from 2014 that was congratulating you on your 20th because I think <em>The Register</em> or someone did a nice article. </p>\n\n\n\n<p>So yeah, I&#8217;ve since been back dozens of times, including several summers in Montreal, at the jazz festival there—they also do <a href=\"https://haitienfolie.com/\">Le Festival Haïti en Folie</a>, and <a href=\"https://montreal.hahaha.com/home/\">Just For Laughs</a>—and a few times here in Ottawa, where I&#8217;m on the board of a cybersecurity company called Field Effect. We might even have some Field Effect people here—oh, hi! Thanks for coming. </p>\n\n\n\n<p>Let me give a little update on what I’ve been up to. My life’s mission is to democratize publishing, commerce, and messaging. So I have some projects in each of those areas. In publishing, my main work is WordPress, the core software available to everyone. We host it on <a href=\"http://wordpress.com\">WordPress.com</a> and <a href=\"https://pressable.com/\">Pressable</a>, and allow others to host it with <a href=\"https://wpcloud.com/\">WP Cloud</a>—a cool product—and we use <a href=\"https://jetpack.com/\">Jetpack</a> to bring all the best cloud features to every WordPress, wherever it is running. And, of course, running the main community hubs at <a href=\"http://wordpress.org\">WordPress.org</a>, <a href=\"http://wordpress.tv\">WordPress.tv</a>, WordCamps, <a href=\"http://wordpress.net\">WordPress.net</a>, which probably some of y&#8217;all haven&#8217;t heard of, et cetera, et cetera. </p>\n\n\n\n<p>On the social side of publishing, I have <a href=\"https://tumblr.com/\">Tumblr</a>, which is a microblogging social network, but right now it&#8217;s on a different technical stack. I need to switch it over to WordPress, but it&#8217;s a big lift. It&#8217;s over 500 million blogs, actually, and as a business, it&#8217;s costing so much more to run than it generates in revenue. We&#8217;ve had to prioritize other projects to make it sustainable. It&#8217;s probably my biggest failure or missed opportunity right now, but we&#8217;re still working on it. </p>\n\n\n\n<p>I&#8217;m really excited about the personal publishing side of our products: <a href=\"https://dayoneapp.com\">Day One</a> and <a href=\"https://developer.wordpress.com/studio/\">WordPress.com Studio</a> and <a href=\"https://wordpress.org/playground/\">WordPress Playground</a>. Day One is a fully encrypted, shared, and synchronized blogging and journaling app that runs on every device and on the web. You can also have shared encrypted journals with others. It uses the same encryption as one password. It&#8217;s the first place I go to draft an idea—for example, to write this talk. Its editor is not as good as Gutenberg yet, but it&#8217;s pretty decent at allowing multimodal input—which means you can record voice notes, draw things, etc.—and capturing it all. It&#8217;s mostly replaced Evernote, Simplenote, and even private P2s for me. It has some fun features, like when you make a new entry it records, the location, what music you&#8217;re listening to on Apple Music, how many steps you&#8217;ve taken, the weather. Honestly, some features that would be nice to get into WordPress, at least as a plugin. Right now, I just copy and paste it in the WC admin or the Jetpack app if I want to publish something; that could also be made smoother in the future. </p>\n\n\n\n<p>So WordPress.com Studio is built on an open source project called Playground that we created to allow you to spin up WordPress in a WASM container in about 30 seconds, right inside your browser. Who’s tried Playground or Studio? It&#8217;s kind of wild, right? You know how hard it&#8217;s been to set up servers and databases and everything like that, and so to see a WordPress virtual machine spin up in like 30 seconds just blows my mind. There&#8217;s so much you can do with it. It&#8217;s the most sci-fi thing happening inside of WordPress right now, and we&#8217;ve just barely begun to take advantage of the massive technical and architectural shift it allows. For example, my colleague <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella</a> builds an iOS app called <a href=\"https://wordpress.org/playground/wordpress-for-native-ios-apps/\">Blocknotes</a>. It’s a lot like Simplenote, but it uses a Gutenberg editor, and it&#8217;s entirely a WordPress playground instance—the entire iOS app. </p>\n\n\n\n<p>Part of the evolution of WordPress has been going from a blogging system to a CMS to a full development platform. So what Dave talked about yesterday, and now that you can build entire mobile apps—which, by the way, can run on every platform, cross-platform, and run the same thing on the web—it&#8217;s kind of like a promise from back in the day of Java or other things, React, Native. It&#8217;s now very possible with this WordPress WASM stuff. WASM stands for <a href=\"https://webassembly.org/\">web assembly</a>. </p>\n\n\n\n<p>The main distractions and things holding back WordPress right now are the legal attacks from WP Engine and Silver Lake—I  can&#8217;t comment on that, but stay tuned for some major updates soon. </p>\n\n\n\n<p>I forgot to put this in my post—WooCommerce! On the commerce side, there&#8217;s, of course, WooCommerce, which is very, very exciting. You can think of it like an open-source Shopify, our enablers here in Ottawa. It now processes over $30 billion of GMV (gross merchant volume) per year, and you can customize it to do pretty much anything: subscriptions, digital, physical goods, everything. And of course, it&#8217;s fully open source and built on WordPress. It&#8217;s actually a WordPress plugin, so pretty exciting. WooCommerce is now on about 8% of all websites in the world—WordPress is 40, so it&#8217;s running on about a quarter of all WordPress sites. It&#8217;s been a big part of the growth of WordPress, actually, the past few years. </p>\n\n\n\n<p>In messaging, we have this product called Beeper. Anyone tried out Beeper yet? We got a Beeper super-user here, actually, in Robert. So Beeper basically takes all the different messaging apps—WhatsApp, Telegram, Instagram DMs, LinkedIn DMs, did you ever check those?—and it brings it all into one app, one interface, kind of like a Superhuman for messaging, and gives you cool features across all of them. Now this is obviously a pretty hard technical challenge, because we have to reverse engineer all the different networks for everything. But check it out, it&#8217;s a pretty fun little app. It&#8217;s, free for up to a couple accounts, and paid after that. </p>\n\n\n\n<p>There&#8217;s also an open source component of that as well. We&#8217;re going to make it easier for people to build bridges and connections to different networks, because there&#8217;s a lot that we don&#8217;t support yet that we get demand for, like <a href=\"https://kakaotalk.en.softonic.com/mac\">KakaoTalk</a> in Asia. People also want to do dating apps, which I guess have messaging platforms. So it’d be pretty fun to have everything all in one. </p>\n\n\n\n<p>I&#8217;ve been in the public a lot, doing lots of talks and actually blogging every single day now for 28 days, which will be 29 when we all hit the publish button at the end of this! So I&#8217;ve been blogging a lot. It&#8217;s a lot to keep up with. Actually been going every day since <a href=\"https://us.wordcamp.org/2025/\">WordCamp US</a>, with one missed day in there. I got very, very inspired at WordCamp US. It was a fantastic event. I got to hang out a lot and go to a bunch of sessions, and it inspired me to blog a lot more. If you run Jetpack, there&#8217;s actually a pretty cool feature where the notifications will tell you what kind of streak you&#8217;re on. So whenever I post, I get this nice little notification, like 28 days. And it has little easter eggs when you get certain number of days in a row, which is fun. So I&#8217;m gonna have to add some of this to the post later—I riffed a little bit. We&#8217;ll get the recording. So now that this is all done, we can push the publish button together. </p>\n\n\n\n<p>This is a cool device called a Daylight computer. So cool. It’s from a startup I&#8217;m invested in through <a href=\"https://audrey.co/\">Audrey Capital</a> and Automattic. Think of it like a cross between a Kindle and an iPad. It works in the daylight, hence the name—it doesn&#8217;t emit any blue light. It&#8217;s great for kids. You can order it on <a href=\"http://daylightcomputer.com\">DaylightComputer.com</a>. It runs Android, so it&#8217;s super hackable. You can have apps like Beeper, Day One, WordPress, Jetpack, WooCommerce on it. Very, very neat device. I actually have WP Admin loaded right here; you can see you can scroll like super, super fast. Soon the wifi is going to work—it&#8217;s a wifi-only device. </p>\n\n\n\n<p>Later I&#8217;ll update this post with an mp3 recording enclosed an RSS in honor of Dave Winer, who spoke here, who invented podcasting and RSS. And actually, if you go way back in my RSS feeds, I have some mp3 enclosures from 2004 and 2005, some very funny early podcasts. Also, whenever they post this video to WordPress TV or YouTube, I&#8217;ll share that too, and I&#8217;ll add some links. Thank you. Merci beaucoup! If you want to follow more. Please check out my blog at <a href=\"https://ma.tt\">ma.tt</a>. No WWW, no .com. Just ma.tt. I cross post to ma.tt on Bluesky and Mastodon and on Tumblr, Instagram and Twitter/X at @photomatt. </p>\n\n\n\n<p>And now we&#8217;re going to push the button together. Y&#8217;all ready? Murphy willing, are you ready to publish? think I need to add a category and stuff, but I&#8217;ll do that later.</p>\n\n\n\n<span id=\"more-150251\"></span>\n\n\n\n<p><strong>Q: </strong>Hi, I’m Michelle Frechette, and I drove up from Rochester, New York on Wednesday, so it&#8217;s good to be here. [Applause] I love that our open source extends beyond just publishing websites and words, and that we have, for now several years, the photo directory, which is available to people—and we are closing in on 30,000 published photos, which I think is phenomenal. </p>\n\n\n\n<p><strong>MM: </strong>And all of those are, I think, <a href=\"https://creativecommons.org/public-domain/cc0/\">CC0</a>, Creative Commons Zero-licensed. So it&#8217;s compatible with GPL, embedded in WordPress themes. You can use it on your site. It&#8217;s very cool.</p>\n\n\n\n<p><strong>Q: </strong>Yeah, you don&#8217;t have to give attribution to anybody. You can just use the photos that are there, which I think is good. What are we going to do so that more people know that it exists, besides the 10,000 people who have submitted photos, because I think it&#8217;s still, it&#8217;s it&#8217;s growing. It&#8217;s huge. There&#8217;s a million beautiful there&#8217;s almost 30,000 beautiful photos in there, but I don&#8217;t think enough people know that it exists yet. So how can we get the word out, to get more people to use it?</p>\n\n\n\n<p><strong>MM: </strong>Well, I think first we should ask questions about it at WordCamps. </p>\n\n\n\n<p><strong>Q: </strong>I&#8217;m on it. </p>\n\n\n\n<p><strong>MM: </strong>So check. We&#8217;re actually just kind of on like a Version One of that whole idea. So in my mind, for things that we should do, is 1: I think we need to better integrate finding those photos in the media library, because right now, it&#8217;s kind of like you have to click a few buttons to get to it. 2: I would like, for every single WP admin when you upload a photo, for you to be able to set the licensing to it. And if it is licensed as CC0, we can submit it to the directory. And of course, the directory has some extra rules, right? Some of these rules, I think we might be able to re-examine now. So for example, right now, in the directory, we don&#8217;t allow anything that shows someone&#8217;s face, right? And the reason for this is, even if something&#8217;s CC0-licensed, to have someone&#8217;s face, you need a model release form. There&#8217;s different laws for that in different countries and things like that make sense, right? You wouldn&#8217;t want someone to take your photo at a WordCamp, and now they think it&#8217;s CC0, and you start seeing them running ads for, you know, some sort of new medicine or Viagra or something; it could be very embarrassing. However, when AI creates a face, there&#8217;s no such restrictions there. So something that we could actually start to do, because right now I think we have some anti-AI rules in the photo directory, I think we should probably start to look at evolving that. So, for example, you can take a picture of me right now, change my face with AI to a face that has never existed, and that could be CC0-licensed and anyone in the world could use it. So I think there&#8217;s some possibilities there. </p>\n\n\n\n<p>Because right now, the laws for AI-generated stuff vary from country to country. I think right now in America, it can&#8217;t be copywritten, at least in the same way. At least if it&#8217;s fully created; when a human starts to modify it, it can be. Sometimes I&#8217;m not familiar with the laws here yet, but I&#8217;m sure I&#8217;ll look them up later. So I think that would be a pretty interesting way to open it up right now, because in theory, we should have way more than 30,000 photos. Actually, I have 30,000 photos on my site, which are mostly GPL-licensed. So how can we—yeah, I do need to submit them. Some of them are already in WordPress Core. So remember <a href=\"https://wordpress.org/themes/twentyten/\">the Twenty Ten theme</a>, which has like the little sheep. People really love those sheep. So all those photos I GPL-licensed a long time ago—in my copious free time, yes. </p>\n\n\n\n<p>So I think those are some of the ideas for it. And also think about another project we do that people aren&#8217;t as familiar with, Openverse search. Has anyone used Openverse yet? It&#8217;s pretty cool. So actually, Creative Commons, the nonprofit, used to have a search engine that indexed the entire web and would allow you to find different types of Creative Commons content, including that requires attribution or other things. The foundation actually was shutting this down, and we took it over, and we now run it on WordPress.org We renamed it to Openverse instead of Creative Commons, but they still index the entire web, including audio files, video files, images, all sorts of stuff. So it&#8217;s a very, very cool project. It is embedded in WP Admin a bit, but again, we probably should combine that with a photo search and other things. </p>\n\n\n\n<p>I also think there&#8217;s some opportunities to use AI analysis of all the photos to give a better semantic understanding and a better search that we currently offer, which right now is typically monollingual, I don&#8217;t think it translates well into the, you know, 60-plus languages that WordPress supports, and it&#8217;s manual tagging. So there might be things to do, like a more automated understanding, which, of course, gets better over time. You know, we started to incorporate some of the AI models like Gemini and other things on WordPress.org to make us way more efficient on things like plug-in submissions and some code scanning. I actually think we&#8217;re very much in chapter one of where this is going to be. It can sort of massively [grow]—because WordPress.org relies on volunteers, basically. Some people are sponsored, but most are not. And we&#8217;re over 60,000 plugins now, or 10,000 themes, and actually, the rate of plugin submission, I think, has basically doubled since last year, and the team has gotten it down where before they had a six-month queue, they&#8217;ve got it down to basically under a week. So you know, we can definitely automate more and more and more and be vastly more efficient and support way more developers and more users, way more everything, and probably improve the code quality. So that&#8217;s another thing I&#8217;m pretty excited about. </p>\n\n\n\n<p><strong>Q: </strong>I love it. <a href=\"http://wordpress.org/photos\">WordPress.org/photos</a>, if you want to look at it. </p>\n\n\n\n<p><strong>MM: </strong>Thank you, Michelle! </p>\n\n\n\n<p><strong>Q: </strong>Hey, Matt. Courtney Robertson. Kind of related to Michelle&#8217;s question: This week, I saw <a href=\"https://iconick.io/\">Nick Hamze</a> recounting how when you go to submit a theme, the image that&#8217;s in the preview for the theme, if it is AI-generated that that&#8217;s getting rejected and the nuances Dion dug into—Dion is one of our long time core commiters, core leads, etc, in the project. A hidden gem. If you haven&#8217;t encountered Dion yet, please find Dion and meet him. So Nick is learning the legal ramifications of having an AI-generated image as part of the theme directory, like what we have to do in the theme directory. Because if the image that&#8217;s in the theme is generated by AI, there&#8217;s a lot of legal stuff about, can we do it? Can we not? And we would all like to just be like, “Yeah, whatever. Move on.” But then there&#8217;s some other ramifications. Is that on your radar? I know we&#8217;ve looked at criteria of what could go into the theme repo and some of those deals.  I don&#8217;t know if. I mean, once we get into legal stuff, that&#8217;s maybe beyond you and I.</p>\n\n\n\n<p><strong>MM: </strong>Well, unfortunately, I&#8217;m getting really good at legal stuff. [Laughter] It wasn&#8217;t on my roadmap for the past year or two, but yeah. So this is very much an evolving area, and the laws from country to country do vary a lot. However, there&#8217;s also some common sense things you can apply, and I think that there is a sort of rapidly—we&#8217;re not putting the genie back in the bottle with AI stuff. One,  just the companies; like, OpenAI is just too big to fail now. The entire economy and growth is based on these systems. The infrastructure buildouts, massive data centers, everything. It&#8217;s kind of incredible. Not to mention the usage, like it&#8217;s really transforming translation, code, so much. </p>\n\n\n\n<p>Now, WordPress.org, particularly, because a lot of this is volunteers, those folks aren&#8217;t comfortable making big policy decisions like this that could have ramifications. They already put a lot on the line. I kind of shield everyone from a legal point of view and everything like that, but in theory, people could go after them, and we have had instances where some of these folks can get oppressed by someone who gets something rejected, or banned from the forums for spamming or stuff like that. So we do try to provide some shelter. </p>\n\n\n\n<p>Now, on this issue, in particular, Nick is someone I talk to almost every day. He&#8217;s doing some very, very cool stuff across WordPress and some innovative things with themes. I like that he pushes the boundaries. So for example, right now, the theme directory is fairly conservative in for example, with the intention that we want the demo to look like the theme when you install it, or we don&#8217;t want it to rely on a plugin. And part of the intention there is that for WordPress, we want you to be able to switch between themes really easily. So one of the beauties of it is that you can take your entire blog site, click a button, and you have a brand new design. Now themes, as they start to incorporate more advanced functionality—which is pretty cool—those sorts of things aren&#8217;t allowed. In fact, one of my favorite examples of something that was in the theme directory a long time ago and is not allowed on the current guidelines, that I think we&#8217;ve made an exception, is the Command Line theme. Has anyone seen this? You load it up, it&#8217;s like a blinking terminal, and you interact with it by typing in commands, like “list,” “post,” and you can type “help,” and it gives you all the things. This is so cool! By the way, I don&#8217;t think it complies with, like, any of our standards. [laughter] Like accessibility, it probably breaks some rules there, all sorts of things. </p>\n\n\n\n<p>So I think part of it is, you know, how can we move? And I think Nick even did a post about this, like rules versus guardrails. So I think part of the way we can do this is as a marketplace. Right now, there&#8217;s certain things that we don&#8217;t allow, and in fact, those rules creep up and get bigger every time, right? Because each sub-team comes in and says, “Oh, I need my rules to be requirements.” Actually, accessibility is a great, great example of that. Now, I think what&#8217;s interesting in a marketplace is we can move these things from being rules to being like tags. So for example, if you were a university, you only want to see themes that were WCAG 2.0 or higher compliant—which are by the way, some pretty strict requirements that don&#8217;t apply to many websites, for good reasons, but that was a requirement. You should be able to do that as a search. Or if you want to see themes that are orange, or all these sorts of things: I feel like those should just be tags in the marketplace, and use the rating system as well to open up what we can host, but then give better tools for people to search and choose what they want. </p>\n\n\n\n<p><strong>Q: </strong>Thanks. Just a shout out. Please let Nick know that a lot of us are reading what he&#8217;s putting forward, and I forget his exact website domain. It&#8217;s <a href=\"https://iconick.io/\">Iconick</a>.</p>\n\n\n\n<p><strong>MM: </strong>It&#8217;s spelled in an interesting way. </p>\n\n\n\n<p><strong>Q: </strong>Yeah, it has his name in it. I wonder where he got that idea. [Laughter]</p>\n\n\n\n<p><strong>MM: </strong>Yeah. So it reads as “iconick.” Nick Hamze, H-A-M-Z-E. Google him. He&#8217;s got some really cool themes. He&#8217;s done a lot of cool projects, <a href=\"https://iconick.io/wapuu-slaps/\">a bunch of Wapuus</a>. Actually, I&#8217;m talking to them about how we can upgrade all the Wapuu stuff. By the way, y&#8217;all have some awesome ones at this event. I got the little swag pack with all the stickers and everything. All the sponsors have different ones. You have like, four or five of them. I&#8217;m actually gonna put this sticker on my laptop later, probably that WCF one, so keep an eye out for that.</p>\n\n\n\n<p><strong>Q: </strong>Paul Bearne. I want to talk about <a href=\"https://wordpress.org/plugins/hello-dolly/\">Hello Dolly</a>, the plugin, which shipped with Core.</p>\n\n\n\n<p><strong>MM: </strong>Which, by the way, people tried to get rid of because of copyright issues. Yeah, there&#8217;s actually some interesting things we did to get around that and make it fair use.</p>\n\n\n\n<p><strong>Q: </strong>Should it be removed?</p>\n\n\n\n<p><strong>MM: </strong>You&#8217;re asking the wrong guy.</p>\n\n\n\n<p><strong>Q: </strong>Well, it’s there because nobody wants to ask you to come and remove it.</p>\n\n\n\n<p><strong>MM: </strong>No, they ask me like once a year. [Laughter]</p>\n\n\n\n<p><strong>Q: </strong>If it stays, perhaps we could redo the description to indicate that it&#8217;s historic—it was the first plugin, it was the proof of concept—but please don&#8217;t copy it. It&#8217;s no longer good code.</p>\n\n\n\n<p><strong>MM: </strong>I completely disagree with that. Tell me why it&#8217;s not good code. Because it doesn&#8217;t use classes or object orientation? Why is it bad code?</p>\n\n\n\n<p><strong>Q:</strong> It’s not accessible, it’s not translatable. </p>\n\n\n\n<p><strong>MM: </strong>It is translatable. It actually goes through the translation functions.</p>\n\n\n\n<p><strong>Q:</strong> There’s no translation around the strings. </p>\n\n\n\n<p><strong>MM: </strong>That&#8217;s not true. </p>\n\n\n\n<p><strong>Q: ’</strong>Tis true. [Laughter]</p>\n\n\n\n<p><strong>MM: </strong>Then it was removed because it was one of the first things we did the underscore for. Well, let&#8217;s look it up later today, but it&#8217;s not true that no one&#8217;s ever asked me. It does get asked about once a year. There&#8217;s lots of issues on the bug tracker about it. And if there&#8217;s ways to improve it, like make it translatable, I think that&#8217;s great, and I know people have actually used that before to also just change the lyrics to, like, put different songs in there, different things they want to</p>\n\n\n\n<p>say. </p>\n\n\n\n<p><strong>Q: </strong>When it becomes translatable, the [inaudible] can have more fun with the translation strings.</p>\n\n\n\n<p><strong>MM: </strong>Yeah, but they don&#8217;t have to, right? That&#8217;s the fun thing.</p>\n\n\n\n<p><strong>Q: </strong>Then I look forward to some patches. </p>\n\n\n\n<p><strong>MM: </strong>What I don&#8217;t want to do is, I don&#8217;t want to make it super-complicated. I know we did some things, like we moved it to a sub-directory. It actually just used to be a single file, so there have been some minor upgrades there. But the whole idea is to show how easy it is to use the actions and filter system inside of WordPress. </p>\n\n\n\n<p><strong>Q: </strong>There are no actions or filters in that plugin.</p>\n\n\n\n<p><strong>MM: </strong>Yeah, that&#8217;s how it looks in the WP Admin.</p>\n\n\n\n<p><strong>Q: </strong>There&#8217;s no filter on the string</p>\n\n\n\n<p><strong>MM: </strong>Well. we can add a filter on the string. And maybe it&#8217;s, it&#8217;s actually a filter and not translation, might be actually better, because, like you said, like maybe the pot system is not appropriate for that. Although, why not? Like, I&#8217;m sure you can translate those lyrics to French and other things, they would be meaningful. And also the connection to jazz musicians. It was one of the first famous jazz songs by one of my idols, Louis Armstrong, and you know, since then, we&#8217;ve named every release of WordPress in honor of a jazz musician. So that&#8217;s one of the cool things about WordPress versus other software is it has soul. You know, it&#8217;s true. Code is poetry. You know, we honor musicians and artists. You know, one of the first blocks we did in Gutenberg was actually a poetry block, a prose block. Has anyone used this one? It&#8217;s one of these things people are always like, “we should remove this.” [Laughter] </p>\n\n\n\n<p>Actually, I did it because I took a writing poetry course, and the author, a famous poet, was complaining how, when she posted to WordPress she couldn&#8217;t have the formatting correctly—you know how a lot of poetry will use interesting formatting where the white space has significance? Or spacing that has kind of unusual things? So the behavior of the editor, which takes multiple line breaks and combines into one, and other things, all that was being collapsed. And so I said, “Oh!” I think it&#8217;s called the Prose block, but it&#8217;s basically a block inside Gutenberg that preserves white space, kind of like a “pre” tag, and it&#8217;s used by some of the poets out there. So sometimes we do these really niche features for like, very high-end users. So for example, I think three or four of the living Fields Medalists use WordPress—actually, WordPress.com. </p>\n\n\n\n<p>Does anyone know about the <a href=\"https://www.mathunion.org/imu-awards/fields-medal\">Fields Medal</a>? A couple people. So it&#8217;s a math award. It&#8217;s more prestigious than a Nobel Prize. They give away a Nobel Prize every year. This happens only every four years, and some of the smartest people in the world have it, like <a href=\"https://terrytao.wordpress.com/\">Terence Tao</a>, who is, if you don&#8217;t know about him, look him up. He is probably one of the top five smartest people in the world, amazing, brilliant mathematician—he actually just got defunded, but the <a href=\"https://www.simonsfoundation.org/\">Simons Foundation</a> is now sponsoring all his work, which is very exciting. If you don&#8217;t know Jim Simons, he&#8217;s the founder of <a href=\"https://www.rentec.com/Home.action?index=true\">Renaissance Technologies</a>. Has anyone heard of Renaissance Tech? RenTec? One or two people? Oh, I&#8217;m telling you all sorts of cool stuff now. </p>\n\n\n\n<p>So Renaissance Technologies is the most successful hedge fund ever in history. They show, I think, annualized returns of over 40% over 35 years. It&#8217;s actually physicists and mathematicians that came together. Jim Simons was one of them, he went out of business or bankrupt or something, and was like, “gosh, I need to make some money. Maybe I&#8217;ll check out the stocks and trading thing.” And they started out, and they actually did really well, but then in the 80s, it all crashed. Jiim’s big, big innovation was that he invented algorithmic trading. So he basically said, we have humans making decisions. One, they&#8217;re too slow. And two, we don&#8217;t know why it&#8217;s working. And so there must be some fundamental sort of physics or rules of the trading markets and the business systems. And so RenTec started to gather the most data of anyone in the world. The next hedge fund to do this well was Bridgewater, but basically they started getting data sets, like shipping back to the 1400s, like really obscure things. They go get stuff out of books and develop all this priority training data, use it to map the economy and essentially create these models that the mathematicians would come up with. You can only be an investor in this fund if you work for the company, which is pretty interesting. And of course, everyone there is like a decamillionaire and everything. I forget how many employees—200 or 150 or something. Really, really small. So legendary. And he passed away a few years ago, but his foundation funds a ton of fundamental research and physics and math and so he&#8217;s someone I really look up to and admire. I <a href=\"https://ma.tt/2024/07/jim-simons-rip/\">blogged about him</a> earlier last year. He reminds me a lot of my dad, just the way he looks and talks. My dad passed away in 2016, so I really like watching Jim Simon’s stuff. </p>\n\n\n\n<p>Oh, I forgot to say, the point of the Fields Medalists. The reason the Fields Medalists use WordPress is we support a LaTeX plugin. LaTeX is basically like a markup language for doing advanced math formulas. We&#8217;re actually working on an update to this to be a bit more user-friendly. We added support for it in 2005 because Terence Tao started a free WordPress.com account, and he was complaining about this and embedding these images. I followed his blog, and I was like, “oh, we should make a block for this kind of shortcode.” And this shortcode is actually built into Jetpack, so anyone who runs Jetpack has access to this, and it&#8217;s now a Gutenberg block as well. So we&#8217;re adding diversity. So maybe tell the math department here. It’d be awesome to get some more mathematicians and folks on WordPress.</p>\n\n\n\n<p><strong>Q: </strong>Matt, just want to give you a heads up. We’ve got about five minutes left. </p>\n\n\n\n<p><strong>MM: </strong>All right, rapid fire. Should I do some fast ones? I just need to talk a little less.</p>\n\n\n\n<p><strong>Q: </strong>I&#8217;m Chris, I work for Pantheon. As you obviously know, Pantheon does Drupal stuff. So I know WordPress, but I have been watching, particularly, the evolution of their development work in AI, specifically integration in the Drupal admin, and also how the Drupal CMS is onboarding new users to Drupal, and the <a href=\"https://www.drupal.org/project/experience_builder\">Experience Builder</a> that they&#8217;re building. As we gather here today, probably most WordPressers might not be aware that there&#8217;s actually DrupalCon Europe happening in Vienna right now, and there&#8217;s lots of things that are happening out of that. And there&#8217;s a lot of really interesting and exciting things happening in that Drupal space. I know you&#8217;ve had conversations with Dries, because at least Dries <em>says</em> that you&#8217;ve had conversations.</p>\n\n\n\n<p><strong>MM: </strong>We talk semi-regularly. You know, there&#8217;s only there&#8217;s like a dozen people in the world who, like their whole life, is creating CMSes, Dave&#8217;s actually one of them in the room. We&#8217;re just going to do it the rest of our lives. And Dries is one of them, so I have incredible respect. We actually did a talk together with Mike Little, the co-founder of WordPress. So if you look up Dries, Mullenweg, Mike Little, you&#8217;ll you&#8217;ll find this. It&#8217;s pretty cool talk. Actually, we got to talk about the history and everything. </p>\n\n\n\n<p><strong>Q: </strong>So the question here is: To what degree are you looking at or thinking about the types of developments that are happening in Drupal but other CMSes as well, and what can we, as WordPress, learn from those other ecosystems?</p>\n\n\n\n<p><strong>MM: </strong>Oh, it&#8217;s a great question. I’ve got to look up the user ID. I think I was one of the first couple hudnred people registered on drop.org, which is the predecessor to <a href=\"http://drupal.org\">drupal.org</a>. Dries was actually at that Northern Voice conference in 2006; he has a post about it on his blog with some photos. So yeah, I keep in pretty close contact with a number of the other CMSes. Well, I won&#8217;t say close contact, but usually about once a year we&#8217;ll get together with Anthony from Squarespace, Tobi from Shopify, with Dries, whenever we&#8217;re in the same country, or I&#8217;m over in Europe or Boston. I try to look them up, and I test out things pretty regularly. </p>\n\n\n\n<p>So I haven&#8217;t seen the very, very latest stuff for Drupal. I think I checked out one of the last iterations they did. I love that with companies like Pantheon now doing both WordPress and Drupal, we&#8217;re getting a lot of overlap between the communities. So I would say, please bring this stuff over. I mean, we&#8217;re both PHP, we&#8217;re both GPL. It&#8217;s one of the reasons I&#8217;ve always really supported Drupal, even though we&#8217;re kind of mutually exclusive solutions. I&#8217;m always going to be supportive with other open source projects. So yeah, for those people who overlap, like yourself, please make some suggestions. You know, start a P2  post, or do a blog post about it. We&#8217;ll get it in the newsletter, or maybe even if there&#8217;s something specific that we could bring over code wise, we can start to get that incentive into <a href=\"https://core.trac.wordpress.org/\">Trac</a> and everything. Cool. </p>\n\n\n\n<p>I think Drupal also has a plugin to use Gutenberg, right? Yeah, which is pretty cool. It was one of the reasons we designed Gutenberg to actually be portable to other CMSes, and why we&#8217;ve been putting it under license, dual-licensing it so to be embedded even more places, not just GPL.</p>\n\n\n\n<p><strong>Q: </strong>Forgive the AI translation of my words, but it&#8217;ll help me be concise. But here&#8217;s the question. Really, really simple—no, it’s not. WordPress has always thrived because of its open, community-driven ethos, but as the ecosystem grows, we&#8217;re seeing more like large, profit-driven players who don&#8217;t necessarily share the values. How can individual contributors and agencies like ours actively help protect WordPress and uphold the values and ethics that have sustained it from bad actors and people who might try to exploit the community? And do you see room for something more formal, like a certification for individuals and agencies that define what being a good actor is, to help educate clients and even the market, to help protect in a more proactive way from those sorts of bad actors?</p>\n\n\n\n<p><strong>MM: </strong>Well, that&#8217;s a big question. I&#8217;ll try to answer quickly. So first I will say, I don&#8217;t want to say that there&#8217;s bad actors. I think there might be bad actions sometimes, and just temporarily bad actors who hopefully will be good in the future. You know, every saint has a past, every sinner has a future. I never want to define any company or any person as permanently good or bad. Let&#8217;s talk about actions. </p>\n\n\n\n<p>Second, I think with these actions, we can start to create incentive systems, and it&#8217;s part of what we&#8217;re doing with Five for the Future, which is basically saying, you contribute back—which also implies that you&#8217;re not violating the GPL, or something like that. So we&#8217;ve got the hard stuff, like, if you violate the GPL, you&#8217;re gonna get a letter. Violate the trademark. You know, that was more of a legal thing. But also the gentle stuff, like, how can we encourage good behavior by giving people higher rankings in the directory or in the showcase, for example? </p>\n\n\n\n<p>Then finally, I&#8217;ll just say, vote with your wallet. Each one of you here has the ability to strongly influence these companies. If they&#8217;re commercially motivated, great, let&#8217;s commercially motivate them to do the right thing by giving more business to the good companies and less business to the other companies. This has actually been happening a lot the past year. I think I can say this: There&#8217;s a site called <a href=\"https://wordpressenginetracker.com/\">WordPress Engine Tracker</a> which is currently tracking a number of sites that have left a certain host. It&#8217;s about to cross 100,000 that have switched to others host. And 74,000 have gone offline since September of last year. We actually used to make all this data public. The whole list was on there. They got a court order so the data could be fact-checked by press or other people. There was actually a court order that made us that down. So again, trying to muzzle free speech and transparency. But you know, we&#8217;re allowed to keep that site up, so check it out while you can. </p>\n\n\n\n<p>Do we have time for one more. Is this last one?</p>\n\n\n\n<p><strong>Q: </strong>Okay, I don&#8217;t think this qualifies as rapid fire, but it&#8217;s a softball. First of all, I came to WordPress as an open source advocate. I became a b2 user. That&#8217;s how I got to WordPress. So my all-time favorite WordPress release is 1.5, because it has what I consider a killer feature. It&#8217;s not the one you&#8217;re thinking. It’s pages.</p>\n\n\n\n<p><strong>MM: </strong>1.5 right? Yeah, I remember introducing that. Originally. I had a different CMS I was going to release called ContentPress. Or Multipattern. I wasn&#8217;t sure what to call it, and so I had this whole other CMS. And I was like, man, we should just build this into WordPress, even though it&#8217;s a blogging system. I think having this pages feature put us ahead of Movable Type and others. So yeah, glad we did. I think we introduced themes and that I released him. </p>\n\n\n\n<p><strong>Q: </strong>Yes, themes was the was kind of the obvious big feature for it, but pages is the point at which I would say that WordPress went from blogging engine to CMS. So that&#8217;s my favorite. But what I was going to ask is—</p>\n\n\n\n<p><strong>MM: </strong>So it&#8217;s all been downhill since then? </p>\n\n\n\n<p>[Laughter]</p>\n\n\n\n<p><strong>Q: </strong>No, it was such a pivotal moment that helped with WordPress&#8217;s meteoric adoption rates. And for me, personally, at that time, it allowed me to take a whole bunch of static HTML and bring it into WordPress so I could manage it so much more easily. So my question was: can you tell us a story, or give us some fun facts about that? Softball question, unless it really taxes your memory.</p>\n\n\n\n<p><strong>MM: </strong>Well, luckily I blog. I&#8217;ll say that two of my favorites ever in history are 1.2 and 1.5—which actually came out right after each other, because we skipped a few releases; it was a time when we actually got pretty delayed. So 1.2 introduced the hooks and filter system, which was pretty revolutionary, I think still, as a unique programming paradigm. But before that, to modify WordPress, you&#8217;d actually open up files and change lines. I used to publish these, we called them hacks, and they were. At one point we introduced the hacks file, which made it a little bit better. But then our plugin hook system allowed a separation between the core and the add-ons, but you could go really deep to modify things. Then 1.5 was themes, I believe. So 1.2 was plugins, 1.5 was themes. And then the other big one—I think it was 2 or 2 point something, was when we introduced WYSIWYG for the first time. Which, by the way, was so controversial; people did <em>not</em> want basic WYSIWYG in WordPress, which was funny, like 10 years later, when they&#8217;re like, “Okay, this Gutenberg thing&#8217;s even worse.” I was like, “Ah, I’ve been through <em>this</em> before.” </p>\n\n\n\n<p>So I think that those are kind of the fun stories around there. Again, some of this stuff was pretty slow to be adopted at first. I wasn&#8217;t certain that this should be rolled into WordPress or there should be separate software, but I&#8217;m glad we did. You know, Movable Type was a dominant thing at the time, and their static page functionality wasn&#8217;t very robust. And so the other thing that WordPress did around this time that I thought was pretty awesome is really clean URLs. So where, prior, you know, people would have crufty URLs, like they’d have an ID in the number, or you&#8217;d have for WordPress,—the default’s still there, actually—is like “?p=123,” so creating the mapping system where we map dates, a hierarchy, and these clean slugs to the pages in the back, in the browsing system, essentially, I think was really crucial. And I love that URLs from 20-something years ago still work or redirect to proper things today. So I think that&#8217;s really, really important. Thank you. All right. Last one,</p>\n\n\n\n<p><strong>Q: </strong>Hey, Matt. I&#8217;m Raquel, and I love kitties and surprises. Just some facts. I have a another question around the community. I want to know how do you feel, what are your raw thoughts, on independent WordPress events that are happening in our space now?</p>\n\n\n\n<p><strong>MM: </strong>And do you want to disclose anything there?</p>\n\n\n\n<p><strong>Q: </strong>I mean, I am the one responsible for <a href=\"https://pressconf.events/\">PressConf</a>, so independent WordPress event. So, yeah, how do you feel? I’m just curious as to how we can all get better together, which tends to be my motto.</p>\n\n\n\n<p><strong>MM: </strong>I&#8217;m very much like a “let a thousand flowers bloom” kind of guy. So thank you. I know it&#8217;s a huge labor of love doing something like PressConf. That’s something that’s been very active in WordCamps and other things in the past, and hopefully with WordCamp US going to Phoenix, we’ll have an opportunity to do some work together there. </p>\n\n\n\n<p>So I think that&#8217;s my fundamental, you know, raw thoughts. You know, I do think about, you know, what do we want to encourage in the world as well? So I would just encourage you as an independent organizer. You know, there&#8217;s some beauty there that you don&#8217;t have to follow the rules or guidelines necessarily. And it&#8217;s commercial events. Well, like the tickets cost more than WordCamp and stuff, right? How much is a ticket?</p>\n\n\n\n<p><strong>Q: </strong>Depending on early bird to total, $700 average.</p>\n\n\n\n<p><strong>MM: </strong>And so that’s a bit of a smaller event, right? That&#8217;s part of what people like about it. So the ticket price actually becomes like a little bit of a barrier to entry. It&#8217;s more intimate. You get some really awesome attendees and talks there, as I think about this as well, just like, you know, what do we want to see more of in the world? And, you know, trying to focus time, particularly my time, to those types of things. So that&#8217;s why I came to WordCamp Canada. You know, this is not the biggest WordCamp in the world, but man, this spirit here, and the people and the everything, and like you know, what you’ve all put together, as it’s come together over the past few months, the incredible work of the organizers,the social media team&#8217;s been doing a great job getting some awesome speakers like Jill and Dave and like, I was like, man! That&#8217;s why I was just planning to come and attend. You know, just to check it out, because I was very interested in the content and everything y&#8217;all put together. So again, I guess we&#8217;re out of time. So I just want to say thank you. Thank you. Thank you. I&#8217;m going to run to the restroom, but then I&#8217;ll be right back out in the lobby. I&#8217;m going to take pictures, shake hands, kiss babies. </p>\n\n\n\n<p>[Laughter]</p>\n\n\n\n<p>I can shake the hand of a baby too. It&#8217;s whatever. I’m open-minded. But hey, thank you. I appreciate it.</p>\n\n\n\n<p><strong>Update:</strong> The video is up, it&#8217;s pretty bad I think the audio is pulling from a DJI thing not the microphones, <a href=\"https://www.youtube.com/watch?v=RL-XccK30sY\">but here it is</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Oct 2025 14:24:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"Matt: On Money Stuff\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150241\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://ma.tt/2025/10/money-stuff/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1862:\"<p>There are a few writers who I follow religiously, and one is <a href=\"https://www.bloomberg.com/opinion/authors/ARbTQlRLRjE/matthew-s-levine\">Matt Levine of Bloomberg&#8217;s Money Stuff</a>. For business and finance it&#8217;s one of the smartest and funniest things you can read. Yesterday, I think for the first time, <a href=\"https://www.bloomberg.com/opinion/newsletters/2025-10-15/openai-has-a-business-plan\">he mentioned WordPress</a>! In the context of his quote on this <a href=\"https://x.com/FhantomBets/status/1977410624343965999\">great X thread about how the Polymarket insider predicted the Nobel peace prize winner</a>.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>This trader apparently <em>didn’t </em>have inside information, in the traditional bad sense of like bribing a Nobel committee staffer. Instead, web scraping:</p>\n\n\n\n<p>&#8220;The Nobel site runs on WordPress. Like many WordPress setups, it has an XML sitemap that lists every indexable page, even ones not yet public. If someone were monitoring this sitemap, they could easily notice a new page appear, something like &#8220;http://nobelprize.org/prizes/peace/2025/machado/facts/&#8221;</p>\n</blockquote>\n\n\n\n<p>If you run a WordPress site and want the best advice in the world for how to avoid this sort of thing, I <a href=\"https://wpvip.com/\">highly recommend our enterprise WordPress VIP service</a>! They help run some of the largest and most secure WordPress sites in the world, and could easily help navigate avoiding something like this from happening. WordPress is easy and cheap to run everywhere, <a href=\"https://projects.raspberrypi.org/en/projects/lamp-web-server-with-wordpress\">even on a Raspberry Pi</a>, but you get what you pay for, and any serious organization or mission-critical website should be on VIP.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Oct 2025 04:25:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Matt: The Curse of the Muse\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150237\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"https://ma.tt/2025/10/muse/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2443:\"<p>Some days, like this morning when I almost missed <a href=\"https://ma.tt/2025/10/in-canada/\">my flight to WordCamp Canada in Ottawa</a>, I’m so overwhelmed with the maelstrom of ideas and sparks of creation that it feels like waves crashing against a dam. There are so many ways I can imagine new software, new products, new ways for the world to be.</p>\n\n\n\n<p>This is a beautiful process, but it&#8217;s also painful! The anguish and agony arise as you attempt to distill the ideas and sparks; the creativity dims, and the beauty and perfection of the original inspiration fade, as I try to translate it into something that can become real and be legible to others. That’s why I have to drop everything when inspiration strikes, because if I try to return to it later, I find the muse has left and I can’t bottle that energy anymore. (There&#8217;s a reason <a href=\"https://meyerweb.com/\">Eric</a>, <a href=\"https://tantek.com/\">Tantek</a>, and I put &#8220;muse&#8221; <a href=\"https://gmpg.org/xfn/background\">into the XFN standard</a>!)</p>\n\n\n\n<p>To the extent I’ve been successful at all in my life, it is because I’m able to contain this tornado and break it down into plans, business models, people, and teams.  <em>I’ve never done anything useful on my own</em>; it’s always been in conversation and partnership with others. </p>\n\n\n\n<p>I&#8217;m grateful to everyone I work with across <a href=\"https://automattic.com/\">Automattic</a>, WordPress, <a href=\"https://audrey.co/\">Audrey</a>, <a href=\"https://tinkertendo.com/\">TinkerTendo</a>, <a href=\"https://keysjazzbistro.com/\">Keys</a>, <a href=\"https://www.theinstitute.com/\">The Institute</a>, <a href=\"https://illuminate.org/\">Illuminate</a>, <a href=\"https://ecoamerica.org/\">EcoAmerica</a>, <a href=\"https://fieldeffect.com/\">Field Effect</a> (in Ottawa!), as well as all my <a href=\"https://www.facebook.com/saxmatt\">friends</a> and <a href=\"https://www.linkedin.com/in/mattm/\">professional connections</a>. They are the ones that help me shape this energy into things that actually have an impact in the world and aren’t just fever dreams.</p>\n\n\n\n<p>This essay itself had <a href=\"https://quoteinvestigator.com/2012/04/28/shorter-letter/\">hundreds more words</a>, but I have to <a href=\"https://www.amazon.com/dp/0060891548?tag=photomatt08-20\">edit</a>, <a href=\"https://www.youtube.com/watch?v=aStHTTPxlis\">delete delete delete</a>, trim things down.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 16 Oct 2025 00:01:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: #189 – Weston Ruter on Unlocking WordPress Performance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=200138\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://wptavern.com/podcast/189-weston-ruter-on-unlocking-wordpress-performance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:60131:\"<details>Transcript<div>\n<p>[00:00:19] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case how WordPress Core continues to strive to unlock greater performance.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Weston Ruter. Weston is a longtime WordPress user and contributor. He has been a core committer for 10 years, and he co-led the WordPress 4.9 release. He worked in the WordPress agency space, and has also been sponsored to work on the Core Performance Team. He lives in Portland, which as you will hear, was quite handy for this interview.</p>\n\n\n\n<p>We start the conversation by getting into the big picture, why website speed matters more now than ever, and how WordPress performs out of the box. Weston shares details about measuring true performance. Revealing, for example, that achieving a perfect Lighthouse score isn&#8217;t the end game, and that real user experience metrics like Core Web Vitals and Largest Contentful Paint should shape how developers and site owners think about optimization.</p>\n\n\n\n<p>Throughout the episode, you&#8217;ll learn about the advances made by the WordPress Performance Team, from lazy loading and new image formats, to speculative loading that shaves precious milliseconds off page transitions. Weston explains how many performance improvements are designed to work automatically, democratizing speed, so that even casual WordPress users benefit without needing to be technical experts.</p>\n\n\n\n<p>The conversation also touches on the balance between adding features and avoiding plugin bloat. The hidden impact of browser and device differences, and how large companies, like Google, are working hand in hand with WordPress to raise the bar on speed and usability.</p>\n\n\n\n<p>Weston offers practical tips, deep technical wisdom, and a glimpse of where WordPress performance is heading next, and it&#8217;s sure to inspire you to think differently about how your sites load, how your users engage, and how you can squeeze out every last drop of speed from the platform you love.</p>\n\n\n\n<p>Whether you&#8217;re a developer, designer, site owner, or just someone curious about what keeps the web running smoothly. This episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Weston Ruter.</p>\n\n\n\n<p>I am joined on the podcast by Weston Ruter. Hello.</p>\n\n\n\n<p>[00:03:28] <strong>Weston Ruter:</strong> Thank you for having me.</p>\n\n\n\n<p>[00:03:29] <strong>Nathan Wrigley:</strong> You are very welcome. I&#8217;m quite jealous of Weston because we&#8217;re in Portland, Oregon at WordCamp US. I had to get on a plane, which was no hardship really in the grand scheme of things. Nevertheless, it was a lengthy plane journey. You, on the other hand, had to get on some public transport to get here because you live in Portland. That must be nice</p>\n\n\n\n<p>[00:03:45] <strong>Weston Ruter:</strong> I live about five miles to the east of here, and so I jumped on the bus and I got off and walked to coffee shop and over to the conference center.</p>\n\n\n\n<p>[00:03:53] <strong>Nathan Wrigley:</strong> And twice, two years in a row as well. You&#8217;re very, very lucky.</p>\n\n\n\n<p>[00:03:56] <strong>Weston Ruter:</strong> I was very happy when I found out.</p>\n\n\n\n<p>[00:03:57] <strong>Nathan Wrigley:</strong> Yeah. So Weston&#8217;s here today because of a presentation that he&#8217;s giving at WordCamp US. I will read into the record the title of the presentation that you&#8217;re giving, The Site Speed Frontier with Performance Lab and Beyond. So it&#8217;s all about performance, this episode essentially.</p>\n\n\n\n<p>This is one of those subjects where I feel you have to tell us your credentials so that we understand that what you are saying is true. Because I think there&#8217;s a lot of snake oil, certainly from my point of view, quite a lot of ignorance. I don&#8217;t really understand this topic inside and out. So would you mind, a minute or something like that? Just tell us about you and your history with, well, WordPress, but also performance and so on.</p>\n\n\n\n<p>[00:04:32] <strong>Weston Ruter:</strong> Yeah, sure. I have been a WordPress Core committer for 10 years. And I was in the agency space working at XWP, working on enterprise WordPress sites. And then I joined Google and I was a software engineer working on developer programs engineer, then develop a relations engineer working on the AMP project, which is all about making webpages faster using the AMP framework. And from there I transitioned into working on the Core Performance Team for the past couple years. And we are focused on making WordPress fast for everybody.</p>\n\n\n\n<p>[00:05:15] <strong>Nathan Wrigley:</strong> Okay, great. Thank you so much. So the topic at hand then is going to be about performance. Why are you interested in this? I know obviously there&#8217;s a career in it and what have you. Is this something that you lie awake at night thinking about? Do you obsess about this kind of stuff?</p>\n\n\n\n<p>[00:05:28] <strong>Weston Ruter:</strong> Yeah, it&#8217;s a passion of mine because who likes a slow webpage, right? So it&#8217;s fun to eke every bit of performance out of the loading of something. There&#8217;s a lot of little technical details and things to know and best practices to observe. And so it&#8217;s a fun challenge to be as fast as possible and there&#8217;s always room for improvement.</p>\n\n\n\n<p>[00:05:52] <strong>Nathan Wrigley:</strong> And it kind of feels as if the mantra over many, many years has basically been that, you know, if you can make your website faster, it will be successful. People will visit it, people are getting weary of page load time or what have you. And so maybe we&#8217;ll get into the weeds of all of that.</p>\n\n\n\n<p>How does WordPress, if I was just to go, okay, ignore the hosting that it&#8217;s on. Let&#8217;s just imagine we&#8217;ve got a good host, we&#8217;ll just use that term. If I was to download a vanilla version of WordPress and use the default theme, currently 2025, and do nothing else with it, I&#8217;ve written a few blog posts, maybe that&#8217;s it. How does it do out of the box like that?</p>\n\n\n\n<p>[00:06:25] <strong>Weston Ruter:</strong> Yeah, it turns out my talk is exactly about this, and it uses the 2025 theme as a test case to show how the performance of WordPress fares out of the box. And if you were to load up a site running 2025, the theme and nothing else, and you run it through Lighthouse, the performance testing tool from Google, you&#8217;ll most likely get a 100 score, performance score. And you would think, I&#8217;m done, there&#8217;s nothing else to do. But if you dig into it, just because you get a good score, that doesn&#8217;t mean there&#8217;s still not room for improvement. And there&#8217;s still head room even after 100.</p>\n\n\n\n<p>But yeah, WordPress Core does great out of the box, but there are still many opportunities to make it even faster. And as you had Felix on previously to talk about speculative loading, that&#8217;s one example where the performance is improved yet further. And in the performance lab plugin, which the performance team maintains, we have different performance feature plugins that implement additional optimisations that address different scenarios and use cases that WordPress doesn&#8217;t do well out of the box.</p>\n\n\n\n<p>[00:07:40] <strong>Nathan Wrigley:</strong> It&#8217;s kind of interesting, and I&#8217;ve never heard it framed that way. I&#8217;ve never heard that there was a ceiling above 100. It kind of feels as if that is the ceiling. If you score 100, all bets are off, game over, you&#8217;ve succeeded, hooray, have a party, kind of thing. But no, there&#8217;s still room to be squeezing a little bit out here and there.</p>\n\n\n\n<p>[00:07:57] <strong>Weston Ruter:</strong> Yeah, if you look at a Lighthouse audit, Lighthouse is an example of a lab metric. It simulates a page load for a user, but it&#8217;s not an actual page load for an actual user. It&#8217;s just a simulation. And if you really want to know how your site is actually performing, you need to measure those visits from actual users.</p>\n\n\n\n<p>And if you load up a popular site in Google&#8217;s page speed insights tool, you&#8217;ll see there&#8217;s two different sections on the page. At the top, you&#8217;ll see what users are experiencing, and then at the bottom you&#8217;ll see lab data. And the top is coming from actual site visitors through what&#8217;s called the Chrome User Experience Report. And that tells you how the site is performing in terms of the Core Web Vitals that Google has spearheaded.</p>\n\n\n\n<p>And one of those is called the Largest Contentful Paint or LCP, and that measures the time it takes for the largest element that is most likely going to be the main content of the page to be rendered, from the time you start navigating to the page and that element finishes rendering.</p>\n\n\n\n<p>And a good LCP value is considered from 0 to 2.5 seconds. And so you can have, within 2.5 seconds there&#8217;s a big range in the user experience. So if it&#8217;s just under 2.5 seconds, it&#8217;s considered good, but that doesn&#8217;t mean a 1.5 second page load is actually way better, and a 0.5 second page load is even better yet, and a 0.05 second page load is great, is perfect. That would be the perfection. And that is what we&#8217;re working on.</p>\n\n\n\n<p>[00:09:36] <strong>Nathan Wrigley:</strong> There&#8217;s gradations of it, okay. So within that 100 there may be room to do, aspects of the 100 can be improved. And in this case, by taking the LCP time down.</p>\n\n\n\n<p>We&#8217;re at a conference event. There&#8217;s over a thousand people. There must be designers, developers, SEO people here. There&#8217;s everybody. There&#8217;s the whole gamut of people that use WordPress, probably some people that are new to the whole platform as well. Do you think that performance is something that everybody needs to worry about or are you happy to be one of the few that obsess about it? Is it basically better to leave an expert like yourself to worry about it, or is this something that we can all have a little dabble at and be successful about?</p>\n\n\n\n<p>[00:10:14] <strong>Weston Ruter:</strong> Well, that&#8217;s what we&#8217;re concerned about with the Core Performance Team is making it so that the regular WordPress user doesn&#8217;t have to worry about this, because nobody&#8217;s got time to spend learning like, what is LCP? What is time to first bite? What are these different metrics? And nobody has time to worry about optimising for all these. So WordPress Core should do all this out of the box, and the WordPress ecosystem should implement best practices so that users don&#8217;t have to worry about it.</p>\n\n\n\n<p>[00:10:44] <strong>Nathan Wrigley:</strong> It&#8217;s kind of interesting. I remember, I&#8217;m thinking it was about six years ago, but I don&#8217;t really remember the date. But Google kind of informed everybody that in a period of time, a year&#8217;s time or what have you, these metrics, LCP and, Core Web Vitals basically were going to come in.</p>\n\n\n\n<p>And it felt like everybody in our industry was running around like a headless chicken, trying to understand something that they knew, there was this sword of Damocles moment, this date in the calendar where the SERPs were going to change. It didn&#8217;t feel like a comfortable time. In some senses, it felt like Google was kind of poisoning the water a bit because they were alienating developers who suddenly had to learn this new thing, because they realised their client websites were going to probably tumble in the SERPs.</p>\n\n\n\n<p>And so they had to upskill in this thing that probably they didn&#8217;t want to be involved with. So it was a curious time, but the dust seems to have settled. I don&#8217;t know too much about, you know, whether they were penalties that really were paid by people because they didn&#8217;t have these fabulous Core Web Vital scores. But it definitely put the cat amongst the pigeons for a while anyway.</p>\n\n\n\n<p>[00:11:38] <strong>Weston Ruter:</strong> The factors that go into ranking pages and Google search are, I never knew what they are, so the knowledge I have is that the performance of a page contributes to the ranking in some way. And basically, as I understand it, all things being equal, you have two sites with the same content and same relevance to the user, and one has better performance, then in theory that would rank higher.</p>\n\n\n\n<p>How much value you get in terms of your ranking is debatable or unknown. I don&#8217;t know. But what is important is the user experience and the benefits that you get for your users. And if they have a good experience on your site, then they&#8217;re more likely to come back. More likely to result in a conversion or a purchase, or whatever you&#8217;re looking to get out of your site. So that&#8217;s where I would focus the concerns.</p>\n\n\n\n<p>[00:12:34] <strong>Nathan Wrigley:</strong> If this were the Squarespace or Wix podcast, which of course it isn&#8217;t, it would be much more straightforward to have a conversation about why your site was quick because, you know, it&#8217;s this proprietary platform. There&#8217;s constraints about what you can do on that platform, and they run the whole thing, you know, they&#8217;ve got their arms around everything.</p>\n\n\n\n<p>WordPress, you download it from .org in most cases, and start to pile things on top of it. And very quickly we get the problems developing I guess, you know, the more things that you throw into it, the more plugins and what have you. Would your advice simply be circumspect about what you throw in, or can you, for want of a better phrase, can you concentrate on additional tech to mask over any problems that you have?</p>\n\n\n\n<p>You know, with the best one in the world, if you&#8217;ve got an LMS, it&#8217;s probably going to slow your website down because it&#8217;s doing a lot. If you&#8217;ve got WooCommerce, it&#8217;s probably going to slow yourself, the website, down from the vanilla install with using the 2025 theme that you just mentioned.</p>\n\n\n\n<p>But there&#8217;s this whole marketplace of hosting companies and performance companies who are selling you things that kind of undo the, and I&#8217;m doing air quotes, the damage that you did by putting the plugins in.</p>\n\n\n\n<p>So I don&#8217;t know if you&#8217;ve got anything to say to that. You know, the whole thing about bloating the website, slowing it down, unpicking it with different tech.</p>\n\n\n\n<p>[00:13:49] <strong>Weston Ruter:</strong> Yeah, well, the WordPress ecosystem has a problem with the kitchen sink issue and a plugin that has more features is somehow valued more highly than a plugin that does one thing and does it really well.</p>\n\n\n\n<p>And so in the Performance Lab plugin in our suite of plugins that we feature, we have the goal that a plugin should do one thing and do it really well. And if you don&#8217;t like what the plugin is doing, you deactivate it and switch to another one that is doing that one issue and doing it well.</p>\n\n\n\n<p>But if you have plugins that do so many things, then you&#8217;re really kind of, your hands are tied and it&#8217;s difficult to switch. And maybe that&#8217;s a strategy by some plugins to lock you in to their ecosystem, but it&#8217;s a difficult problem, yeah.</p>\n\n\n\n<p>[00:14:39] <strong>Nathan Wrigley:</strong> And we also have a, you know, we have plugins which are performance plugins. I mean, there&#8217;s dozens of them. I&#8217;m sure we could rattle off, whose job is to fix the problems that you may have created elsewhere in the website. If you&#8217;re in the weeds of it, like you are, you&#8217;ve probably got some vague understanding about it. You understand whether something is snake oil or not, but for the rest of us, that is a Pandora&#8217;s box, and there&#8217;s only chaos in there.</p>\n\n\n\n<p>I don&#8217;t know what will slow my website down. If I download, I&#8217;m going to use LMS again, if I download an LMS platform, I&#8217;m going to hope that the work has been done successfully. But I&#8217;m probably also going to be thinking about, okay, now do I need to talk to my host, get a different hosting environment, get it set up so it&#8217;s perfect for that? Do I need a performance plugin? Caching layers, putting things on the edge.</p>\n\n\n\n<p>And on and on it goes. It makes WordPress a difficult thing for many, many people to use. And so this idea of democratising publishing sort of goes out the window a little bit because it&#8217;s really extraordinarily hard to use.</p>\n\n\n\n<p>[00:15:34] <strong>Weston Ruter:</strong> Yeah. And I think that in addition to democratising publishing, WordPress should also be as part of that democratising performance. And again, making it so that users don&#8217;t have to worry about that.</p>\n\n\n\n<p>And what we&#8217;re doing in Core, we&#8217;re doing exactly that where as one of WordPress&#8217;s core philosophies is decisions, not options, and things should work out of the box.</p>\n\n\n\n<p>But when it comes to the ecosystem, it&#8217;s a open source environment and there&#8217;s no top down control over what a plugin does. So I think there&#8217;s opportunities with projects like the Plugin Check plugin to do more analysis on the performance, in addition to the security and the best practices for being accepted into the directory.</p>\n\n\n\n<p>But if there&#8217;s also a surfacing of performance issues or additional audits that are done on the impact of installing a plugin, that could be really valuable for site owners to get a sense of, this may cause problems if you install it.</p>\n\n\n\n<p>[00:16:37] <strong>Nathan Wrigley:</strong> How long has the Performance Team been a thing? I feel like three years or something like that, but I could be really wrong.</p>\n\n\n\n<p>[00:16:43] <strong>Weston Ruter:</strong> About four years I think.</p>\n\n\n\n<p>[00:16:45] <strong>Nathan Wrigley:</strong> Okay, yeah. And could you just run over the history of that? I was going to say organisation, but let&#8217;s go with team. Could you run us through the history of that team and what you&#8217;ve been able to do?</p>\n\n\n\n<p>Each of the little steps, some of them are quite profound. Some of them feel less profound, but very important. But over those four years, a lot of really incredible work has been done actually. Certainly from my perspective, it does seem that without that team we&#8217;d be in a very, very different place.</p>\n\n\n\n<p>[00:17:15] <strong>Weston Ruter:</strong> I hope that&#8217;s true. I think it is. Yeah, well, it started out focusing on, I think lazy loading of images was one of the first things to land through this team. And with that we also then uncovered that actually lazy loading everything, which while great for reducing the weight of a page, because you&#8217;re not downloading images that aren&#8217;t actually shown. If you lazy load images that are in the initial viewport, that actually hurts the Largest Contentful Paint metric because the browser wastes to start downloading those images until it knows that they&#8217;re in the viewport.</p>\n\n\n\n<p>So out of that came work to not lazy load images that are in the initial view port, and then also moving on to this attribute called fetch priority, which you can have the value of high, for example. So if you add fetch priority high to an image, then the browser&#8217;s going to prioritise loading that first. And so a lot of work was done to add sensible defaults in WordPress Core so that, for example, the featured image of a post gets fetch priority high, so that it gets loaded sooner over images that are not going to be the Largest Contentful Paint, most likely.</p>\n\n\n\n<p>So there&#8217;s that. And then there was also an issue with like emoji in posts where, on every page load there&#8217;s some JavaScript that runs in the head of the page, and it computes whether the browser supports the emoji, like all the emoji. And if the browser doesn&#8217;t support all the emoji, then it loads the Twitter emoji library to render them. And that JavaScript was causing a long task in lower performing browsers, or devices, that was hurting the largest contentful paint as well. So that was fixed as well.</p>\n\n\n\n<p>And then work has been done to add support for new image formats, like AVIF and WebP so that site owners can upload those image formats instead of JPEGs, which take longer to download.</p>\n\n\n\n<p>We talked about speculative loading, and you talked about that with Felix. So that landed in 6.8, which by default will start prefetching the HTML for a page when you mouse down or tap or click, pointer down on a link to give the browser a bit of a headstart. But then the API allows you to be more aggressive about starting that process, just when you hover over the link, for example, and then not just to prefetch the HTML, but to actually render the whole page.</p>\n\n\n\n<p>And so in my talk, which I gave earlier today, I showed the difference between no speculative loading, speculative loading as in WordPress Core right now, the default, and then moderate prefetch. And then lastly, moderate pre-render.</p>\n\n\n\n<p>[00:19:57] <strong>Nathan Wrigley:</strong> Is that done with the plugin? Well, I guess you could do that with code, but there&#8217;s an option to, if you download the plugin, you&#8217;ve got a UI for that as well.</p>\n\n\n\n<p>[00:20:04] <strong>Weston Ruter:</strong> Exactly. There&#8217;s a UI in the plugin that allows you to opt into moderate eagerness, or to use pre-render instead of prefetch. And in the example I showed, let&#8217;s say your time to first bite is a second. Then in the initial example, like on a slow, or on a fast 4G connection, you&#8217;re going to get like 2.27 seconds to load the page. But then with conservative prefetch, that shaves off like 50 milliseconds because the amount of time it takes to mouse down and mouse up is just a little bit of time that it can shave off that&#8217;s just a little bit to the loading of the page.</p>\n\n\n\n<p>But then when you go to moderate prefetch, then the browser can load the page fully in the background. And so then the time to first bite in that case becomes zero because the whole page is already in the browser&#8217;s cache. And that can reduce it to like one second because you totally eliminated the time to first bite.</p>\n\n\n\n<p>And then with the moderate pre rendering, then when you&#8217;re hovered over that link, the browser not only downloads the HTML, but also all the images, builds out the layout, runs the JavaScript. And so then when you click on that link, the page can load instantaneously.</p>\n\n\n\n<p>[00:21:12] <strong>Nathan Wrigley:</strong> So literally instantaneous.</p>\n\n\n\n<p>[00:21:14] <strong>Weston Ruter:</strong> 0.05 seconds.</p>\n\n\n\n<p>[00:21:16] <strong>Nathan Wrigley:</strong> Yeah. It&#8217;s instantaneous. I mean that&#8217;s pretty incredible. All of that is available inside of WordPress, but just to rewind, probably about 50 seconds, the default is not aggressive. The default in WordPress in order to satisfy the kind of 80 20 rule and what have you, the default is to make it so that there has to be some interaction. The mouse has to be invoked. There&#8217;s a click involved.</p>\n\n\n\n<p>That&#8217;s fascinating. So if you really want to get into the weeds of that, you can basically make the next page load almost instantaneously, should you wish to do that.</p>\n\n\n\n<p>One thing that I did get into with, I believe it was Adam Silverstein not that long ago when I had a podcast episode with him. And I don&#8217;t mean to go deeply into this, but there&#8217;s a curious balancing act here, I think with the environment and all of this speculative loading. Because it wouldn&#8217;t be desirable to load, I don&#8217;t know, there&#8217;s 12 navigation links and the mouse happens to go across all of them. And suddenly 12 unnecessary pages were entirely pre-rendered and what have you. So yeah. I don&#8217;t know if you&#8217;ve got any thoughts on that, whether there&#8217;s a balancing act between performance and environmental concerns.</p>\n\n\n\n<p>[00:22:23] <strong>Weston Ruter:</strong> Yeah. By default, speculative loading only operates on pages when you&#8217;re not logged in. And so when you&#8217;re not logged into WordPress, that is most of the time when you&#8217;re going to have a page cache that can serve it from the cache. And so as long as you have page caching in place, then the server isn&#8217;t going to be overly taxed by those requests.</p>\n\n\n\n<p>In the newest version of the Speculative Loading plugin, it has an opt in to speculative loading for logged in users as well. But there&#8217;s a warning that shows up if you don&#8217;t have a persistent object cache active, for example. So, yeah, it&#8217;s important to have good caching in place, good best practices for scaling.</p>\n\n\n\n<p>However, in addition to pre rendering, which the speculative loading plugin enables, there&#8217;s a much older technology for instant page loads that browsers all support, and that is the back forward cache.</p>\n\n\n\n<p>And WordPress sites, by default when you&#8217;re logged out, will benefit from this most of the time. But as soon as you login or if you&#8217;re navigating to like a shopping cart page, or an account page, or checkout page in an e-commerce site. Oftentimes the plugin will invoke this no cash headers function that tells the browser, primarily tells the page cache, hey, don&#8217;t hold onto this response because you don&#8217;t want to cache the shopping cart for one user and then serve it to another user, because then you would be seeing something embarrassing potentially.</p>\n\n\n\n<p>And so that is one of the benefits of sending that header. But it also has the effect of preventing the browser from holding onto that page as well. So if you navigate back and forward from the shopping cart, then you&#8217;ll notice that it doesn&#8217;t load very fast. It loads slow, because the browser has to re-fetch it all from the server, and has to rebuild everything from scratch.</p>\n\n\n\n<p>And so there&#8217;s a effort underway for 6.9 to stop doing that. To allow the browser to hold onto that in memory. And then to address, one of the issues that turned this off to begin with, allowing the browser to store the pages in the cache. Is if you aren&#8217;t logged in, for example, into WordPress. You&#8217;re on some sensitive page maybe putting some API key in or something, and you go to log out, with this back, forward cache, you could hit the back button to go back into the WordPress admin as another person, maybe on a shared computer and look at that page, even though the user had logged out.</p>\n\n\n\n<p>[00:24:50] <strong>Nathan Wrigley:</strong> Yeah, really not good.</p>\n\n\n\n<p>[00:24:51] <strong>Weston Ruter:</strong> Not good. So there&#8217;s a ticket for 6.9 which would solve that problem by invalidating those pages from bfcache so that that privacy concern isn&#8217;t there. And this issue is not just about, well, these back, forward navigations are very common. So the Chrome team found that one in 10 navigations on desktop are these back, forward navigations?</p>\n\n\n\n<p>[00:25:15] <strong>Nathan Wrigley:</strong> A tenth?</p>\n\n\n\n<p>[00:25:16] <strong>Weston Ruter:</strong> Yeah. And on mobile, I think it&#8217;s one in five. So 20% of the time on mobile, you&#8217;re going back and forward using a gesture instead of hitting a link.</p>\n\n\n\n<p>[00:25:25] <strong>Nathan Wrigley:</strong> That maps to my life, but I hadn&#8217;t thought about it.</p>\n\n\n\n<p>[00:25:28] <strong>Weston Ruter:</strong> But the benefit here is not just in that you get a faster page load, but also bfcache, this back, forward cache will preserve the entire state of the page. So in my talk, I showed an example where you, if you have BuddyPress installed, you start typing in an update, a status update, and then you click away to a separate tab, and then if you hit the back button to go back to that initial tab, then you&#8217;ll find without this back, forward cache that your update&#8217;s gone because that input field was constructed with JavaScript. And when you don&#8217;t have back, forward cache, then the entire document object model has to be rebuilt. All the JavaScript has to re-execute. This is also an issue for the block editor. If you navigated away from a page and you didn&#8217;t save a draft, then everything gets lost without this back, forward cache.</p>\n\n\n\n<p>So back, forward cache not only improves performance, giving you the possibility of these instant page loads, but it also preserves that important state on a page that could be lost otherwise.</p>\n\n\n\n<p>[00:26:25] <strong>Nathan Wrigley:</strong> You have a plugin if memory serves, recently in the repo.</p>\n\n\n\n<p>[00:26:30] <strong>Weston Ruter:</strong> Yes. And I got some feedback that it&#8217;s a terrible name, which I agree.</p>\n\n\n\n<p>[00:26:32] <strong>Nathan Wrigley:</strong> What&#8217;s the name? I&#8217;ve forgotten.</p>\n\n\n\n<p>[00:26:33] <strong>Weston Ruter:</strong> It&#8217;s called no cache, bfcache.</p>\n\n\n\n<p>[00:26:36] <strong>Nathan Wrigley:</strong> That was it, yeah.</p>\n\n\n\n<p>[00:26:37] <strong>Weston Ruter:</strong> But if I were to rename it, which I probably will now, it would probably be called Instant Back Forward Navigations or something. It&#8217;s not so short, but.</p>\n\n\n\n<p>[00:26:43] <strong>Nathan Wrigley:</strong> So is the intention to take, are you spearheading that basically? is the intention to roll the learnings from that plugin into Core?</p>\n\n\n\n<p>[00:26:50] <strong>Weston Ruter:</strong> Yeah.</p>\n\n\n\n<p>[00:26:50] <strong>Nathan Wrigley:</strong> And I&#8217;m just going to read this into the record so that everybody understands. You are talking about backwards and forwards by using the buttons, which I guess typically live at the top left of a browser. Those buttons, the arrows that point backwards and forwards.</p>\n\n\n\n<p>[00:27:03] <strong>Weston Ruter:</strong> That&#8217;s right, or the navigation in like the gesture on Android to go back.</p>\n\n\n\n<p>[00:27:07] <strong>Nathan Wrigley:</strong> Yeah, so swipe typically and swipe right. okay. Yeah, that&#8217;s really interesting because I do that all the time. It really hadn&#8217;t occurred to me that was something that could be cached. And if, as you say it&#8217;s 20% on mobile, or 10% on, that&#8217;s a lot of time that you&#8217;re saving.</p>\n\n\n\n<p>Because you do, it&#8217;s a journey, isn&#8217;t it? And sometimes you get to a dead end, and so you just back three times, because you know that you wanted to go back to that product that you saw a minute ago, but you kind of got lost along the way. So that&#8217;s kind of almost like a roadmap item. That&#8217;s 6.9, hopefully. Are there any other things coming in 6.9 that are interesting?</p>\n\n\n\n<p>[00:27:39] <strong>Weston Ruter:</strong> Well, one of the new features in WordPress Core is this Interactivity API.</p>\n\n\n\n<p>[00:27:44] <strong>Nathan Wrigley:</strong> Oh, so nice.</p>\n\n\n\n<p>[00:27:46] <strong>Weston Ruter:</strong> And one of the great things about the Interactivity API is one of its key design principles is server side rendering. So let&#8217;s say you have a navigation block, or you have an image block with a lightbox. All of the HTML and the CSS needed to render those blocks are output on the server. There&#8217;s no need for JavaScript to construct the user interface.</p>\n\n\n\n<p>Nevertheless, there&#8217;s JavaScript needed because there&#8217;s interactivity involved in these interactive blocks. And so with each of these interactive blocks, there&#8217;s a script module that gets added to the page, and it&#8217;s added in the head of the page. And browsers download those script modules with a high priority. And the impact of that is, well, the browser doesn&#8217;t know that these aren&#8217;t important. It could be important, it could not be important.</p>\n\n\n\n<p>But by loading them with a high priority, they compete with loading of more important critical resources like the Largest Contentful Paint image, for example. So by having these modules in the head, then they cause the LCP metric to degrade. And so there&#8217;s a ticket to add fetch priority low to these script tags, which causes the browser to bump them down in priority so that the Largest Contentful Paint image has a chance to load sooner.</p>\n\n\n\n<p>[00:29:04] <strong>Nathan Wrigley:</strong> Yeah. It seems like a game of tennis, this whole thing. For example, the Interactivity API, what a fabulous thing that is, but smuggled into that with something, it sounds unexpected that nobody foresaw that one and okay, need to address that. And here we are, 6.9, that gets addressed.</p>\n\n\n\n<p>[00:29:21] <strong>Weston Ruter:</strong> Yeah, and one of the great things about the Interactivity API as well is that it has really pushed forward the new Script Modules API in WordPress, where what are also called ESM modules or scripts. And these are a new way of writing JavaScript and they are, by default they don&#8217;t block the rendering of the page.</p>\n\n\n\n<p>Whereas if you have a classic script like jQuery in the head of your page, as you start loading the page, the browser has to stop parsing the HTML, it has to fetch the JavaScript, it has to execute the JavaScript, and then because that JavaScript may be doing something like document.write, where it like adds HTML to the page as it&#8217;s executing. Then only after that&#8217;s all finished then the parser can continue and continue laying out the page. So it&#8217;s very bad for performance to have any external, or even inline sometimes, JavaScript in the head.</p>\n\n\n\n<p>And so one way to solve that issue is to slap a defer attribute on that script tag, or an async attribute, and that causes the script to then not block rendering, and it will be executed once the page has finished loading.</p>\n\n\n\n<p>And a nice feature of script modules is that they&#8217;re deferred by default. You can&#8217;t have a blocking script. And so the thinking was, oh, they don&#8217;t block rendering, so we can just put them in the head. But it turns out that they do impact the network, because there&#8217;s other things on the network than just the scripts. And we need to make sure that the critical resources are prioritised, like the LCP image and not just load everything with high priority.</p>\n\n\n\n<p>[00:30:55] <strong>Nathan Wrigley:</strong> It&#8217;s kind of curious because the past of WordPress has been about, you know, you click on links and you generate, I don&#8217;t know a post, a page or something, but you&#8217;ve got this static piece of content, largely. You know, there may be some JavaScript or something, which is doing something fun.</p>\n\n\n\n<p>But the interactivity, API suddenly presents a page which, I don&#8217;t know, you might be stuck on that page for quite a while doing other things. I don&#8217;t know how that leans into the whole performance thing. I don&#8217;t know we could search and filter a bunch of houses or real estate or what have you, and update things. And we are on this one URL but everything&#8217;s getting changed in front of our eyes. So I don&#8217;t know how that whole LCP thing gets bundled into that. It suddenly becomes a much more difficult problem to identify and solve, I guess.</p>\n\n\n\n<p>[00:31:35] <strong>Weston Ruter:</strong> Yeah. So with LCP, it is for that initial page load. So as soon as you interact with the page, then whatever is the largest element then going to be.</p>\n\n\n\n<p>[00:31:47] <strong>Nathan Wrigley:</strong> Oh, that ceases there does it?</p>\n\n\n\n<p>[00:31:48] <strong>Weston Ruter:</strong> Yeah, it stops at that point. However, there are other problems with performance that can arise after that Largest Contentful Paint. So one of the newer Core Web Vital metrics is the Interaction to Next Paint, and that is this INP value. And that is all about how much JavaScript is executing on the page. And JavaScript functions can do a lot of work, so much work that they cause the user interface to appear to halt.</p>\n\n\n\n<p>[00:32:19] <strong>Nathan Wrigley:</strong> Hang.</p>\n\n\n\n<p>[00:32:20] <strong>Weston Ruter:</strong> Yeah, hang. And so that&#8217;s called jank. And it can cause animations to stutter, it can cause a user interface to be sluggish, and you click a button and then nothing happens and then all of a sudden it opens up. And so that&#8217;s an example of a metric that is still very relevant with the Interactivity API. And there&#8217;s been work to establish best practices to make sure that the event handlers for these interactive blocks are using the best practices. Like, it&#8217;s called scheduler.yield, and it allows you to break up a long running task to give the browser a chance to catch its breath so that it doesn&#8217;t cause those long tasks.</p>\n\n\n\n<p>And then another important metric, which continues to matter even after the page is loaded is called the Cumulative Layout Shift or CLS. And that is a very common issue with, where you have ads or something that will just expand as you&#8217;re scrolling down and you lose your place in the page and that hurts your cumulative layout, that CLS score.</p>\n\n\n\n<p>[00:33:19] <strong>Nathan Wrigley:</strong> Yeah. You end up with your finger in entirely the wrong place just as you&#8217;re about to click on things.</p>\n\n\n\n<p>[00:33:23] <strong>Weston Ruter:</strong> That&#8217;s exactly right.</p>\n\n\n\n<p>[00:33:24] <strong>Nathan Wrigley:</strong> Old TechCrunch website. I don&#8217;t know if you&#8217;ve ever came across that one. That was a WordPress one, I believe. And I don&#8217;t know how many times I click entirely the wrong article because it just shifted just at the moment that my finger was descending.</p>\n\n\n\n<p>[00:33:33] <strong>Weston Ruter:</strong> Very aggravating yeah.</p>\n\n\n\n<p>[00:33:34] <strong>Nathan Wrigley:</strong> Yeah, really annoying. We&#8217;re really in the weeds here and what&#8217;s kind of fascinating, obviously you understand it all, I&#8217;m just holding on for dear life here. But it feels as if there&#8217;s a dance between what we&#8217;re expecting the browser to be able to do, and what it actually can do. And I don&#8217;t know if that&#8217;s the case.</p>\n\n\n\n<p>You know, I don&#8217;t know if the fact that I&#8217;ve got a shiny new Mac means that my experience of the web in the future will be better than my 8-year-old Mac over there. That never used to be something that I worried about. It took time to boot that machine, but once it was up and running, that machine was probably just as good at displaying the web as the shiny new one. But now it feels as if that&#8217;s maybe not the case.</p>\n\n\n\n<p>[00:34:13] <strong>Weston Ruter:</strong> It&#8217;s funny you say that because this emoji issue that I described earlier where it was causing this long task as the page was loading, I only discovered that as a problem because I was using a Chromebook as development device.</p>\n\n\n\n<p>[00:34:25] <strong>Nathan Wrigley:</strong> Yeah, notoriously low on specs.</p>\n\n\n\n<p>[00:34:27] <strong>Weston Ruter:</strong> Relatively, that one was even a fast one. But yes, much slower than one of the newer Macs. And so it&#8217;s important to always be testing in an average device, and not always just use the latest and greatest. Because you&#8217;re going to miss performance issues that are probably impacting a lot of users.</p>\n\n\n\n<p>And one of the issues with emojis is, going back to what I described earlier with this long script in the head, now there&#8217;s just an inline script, and even with an inline script, there is still a performance impact where it will stop, because the browser has to stop parsing the page, execute the JavaScript, and then keep going.</p>\n\n\n\n<p>And so I used my new Mac to analyse the performance of that and I didn&#8217;t see a problem. But then I tried the CPU throttling in Chrome Dev Tools where you can emulate low end, low tier device. And in that case, then all of a sudden I saw this 100 millisecond long task pop up, I can&#8217;t remember how long exactly, but it negatively impacted the LCP because it had to spend that time with this underpowered device.</p>\n\n\n\n<p>So, yeah, there&#8217;s many opportunities for optimising things that, if you&#8217;re using devices that people are actually using.</p>\n\n\n\n<p>[00:35:41] <strong>Nathan Wrigley:</strong> I don&#8217;t really know what the expectation is from WordPress over the next decade, but it doesn&#8217;t feel like it&#8217;s going to be limiting itself to websites. It feels like that&#8217;s a portion of it, but Matt Mullenweg often has talked about it being almost like the operating system for the web. Whether or not that will transpire, I don&#8217;t know.</p>\n\n\n\n<p>But certainly for me, a lot of the things that I used to associate with a downloaded app that would run on MacOS or Windows or what have you, I&#8217;m now fully expecting that to be in a browser. And so I expect that the same would be true of our websites. We&#8217;re going to be doing more with them. They&#8217;re going to be requiring more grunt in the background, you know, more interactivity, more filtering, more searching, more database queries. And yeah, I guess WordPress has got to try and keep up with all that.</p>\n\n\n\n<p>[00:36:29] <strong>Weston Ruter:</strong> In improving web performance, it&#8217;s a top down and a bottom up problem. Browsers are working to get faster. They&#8217;re competing with each other, trying to be as fast as possible for all the bragging rights, right? But oftentimes it&#8217;s impossible for the browser to know, even if it&#8217;s as smart as possible, what to prioritise when loading a page.</p>\n\n\n\n<p>So that&#8217;s why when I was working at Google, we were prioritising improving the web at scale through WordPress to implement best practices in how WordPress builds pages so that Chrome doesn&#8217;t have to figure out everything because it&#8217;s impossible for Chrome to figure that out from the top down.</p>\n\n\n\n<p>So if you look at the, over time these Core Vital Metrics, they all consistently are going up and improving, even if a CMS isn&#8217;t necessarily focused on a performance. They all are inching upward. And that&#8217;s because the browser is getting better at performance as well. But when a CMS like WordPress also invests in improving performance, then you can start to see it edging out other CMSs in terms of the relative improvement in performance.</p>\n\n\n\n<p>[00:37:35] <strong>Nathan Wrigley:</strong> Yeah, okay. Let me just parse that. So whether WordPress is at the top or the browser is at the top, you&#8217;ve got this top bottom thing, and it&#8217;s kind of inching in from the top, coming down. Maybe that&#8217;s the browser, and then WordPress at the bottom inching up, if they happily meet in the middle.</p>\n\n\n\n<p>So what you&#8217;re saying is that even if no performance work was done by a Performance Team in WordPress, there would have been in recent years a performance improvement, But the fact that there&#8217;s those two things in symphony with each other means that there&#8217;s a greater performance improvement.</p>\n\n\n\n<p>Given that WordPress, I don&#8217;t know what the number is right now, but the statistic of 43% was always banded around. So it&#8217;s a huge proportion of the internet. Does WordPress have a voice toward Mozilla and Chrome? Does it get to say what the future of browsers might look like? It feels like with that market share, It ought to have a big voice, but I don&#8217;t know if it does.</p>\n\n\n\n<p>[00:38:26] <strong>Weston Ruter:</strong> Well, I remember back when responsive images became a thing, and as I recall that it was WordPress implementing these responsive images that caused browsers to say, okay, we&#8217;re going to implement these now as well. So I think Chrome, I can&#8217;t remember which browser did at first, but it was kind of a catalyst that caused everything to get going.</p>\n\n\n\n<p>And similarly, recently with the speculative loading, it being adopted by WordPress has, I think, caused other browsers to say, okay, we&#8217;re going to implement this as well.</p>\n\n\n\n<p>And yeah, I know that when I was working at Google, and still I&#8217;m in contact with people at Google who work on web standards work, there are initiatives that they&#8217;re working on that they want feedback from WordPress developers to know like, is this going to work for WordPress? And if WordPress can leverage this, and going back and forth between what works for WordPress and what works for browsers and there&#8217;s ongoing conversations, yeah.</p>\n\n\n\n<p>[00:39:25] <strong>Nathan Wrigley:</strong> Yeah, it is kind of interesting. I was talking to somebody from Google, from the Site Kit team, they obviously put up quite a lot of money to be marquee sponsors, if you like. I don&#8217;t know what the word is, you know like a top tier sponsor often at these events. I don&#8217;t know if they&#8217;re sponsoring this one, but there does seem to be some interest from Google.</p>\n\n\n\n<p>I know that Mozilla doesn&#8217;t have the deep pocket, so we&#8217;re not really expecting that. But it&#8217;s nice to hear that, even if it&#8217;s kind of back channels, and it may not be that WordPress gets asked all the time, that there is some sort of symbiosis there. That&#8217;s nice to know.</p>\n\n\n\n<p>[00:39:55] <strong>Weston Ruter:</strong> Well, I remember also seeing recently that Site Kit was voted one of the most trusted WordPress plugins.</p>\n\n\n\n<p>[00:40:01] <strong>Nathan Wrigley:</strong> Yeah, 5 Million plus installs in under five years. And I was kind of surprised by that actually. when I did that interview, I didn&#8217;t realise the numbers were so big. And then after the interview I went out and asked a bunch of random people whether they&#8217;d used it, and a hundred percent of the random selection of 10 people that I asked used it on everything.</p>\n\n\n\n<p>[00:40:20] <strong>Weston Ruter:</strong> Yeah. I use it for sure.</p>\n\n\n\n<p>[00:40:22] <strong>Nathan Wrigley:</strong> Yeah, yeah. It&#8217;s kind of amazing. So just sort of rounding it off a little bit, I&#8217;m guessing that if you were to have your performance hat on, I could be wrong about this. You would be advising people to step away from the classic way of doing things in WordPress with, you know, the classic editor, the classic themes and things. I genuinely don&#8217;t know if there&#8217;s a performance improvement in full site editing, block-based themes, and what have you. Over to you really, it&#8217;s an open ended question.</p>\n\n\n\n<p>[00:40:46] <strong>Weston Ruter:</strong> Yeah, there definitely is a performance benefit to using block themes, and that is because the way that classic themes load, they load progressively where they will print out the head, head tag in the page and then before they render any of the template, they basically locked in the scripts and styles that the page is going to need even though that doesn&#8217;t actually know what&#8217;s going to be in the page for sure. It can make some guesses, but it doesn&#8217;t know for sure.</p>\n\n\n\n<p>And so for classic themes, you&#8217;ll have these massive style sheets that are printed in the head, you&#8217;ll have a whole bunch of scripts that you may or may not use. And as we said before, those scripts may be blocking the rendering and causing all kinds of problems in performance.</p>\n\n\n\n<p>But with block themes, the way that a template is rendered is completely different, where it actually will render all of the blocks in the content first before it goes about rendering the head, the links, the style sheets and the scripts that go in the head of the HTML. And so because of that, a block theme is able to selectively load just the styles and just the scripts that are relevant to the blocks on that specific page. And so the amount of CSS and JavaScript that&#8217;s on a page can be greatly reduced, which greatly improves performance.</p>\n\n\n\n<p>And also, one of the initiatives that we&#8217;ve been working on in the Core Performance Team is related to these responsive images that we were talking about. Where a responsive image, it has all of the different intermediate image sizes that are available. When you upload an image, it&#8217;ll reference all those different image sizes in the source set attribute. And then there&#8217;s the sizes attribute that says which of those intermediate image sizes should be loaded for that image in the page. But because WordPress doesn&#8217;t know classically, in the classic themes, how big an element is going to be, it uses by default the image that is the width of the view port.</p>\n\n\n\n<p>And so on a mobile device, that&#8217;s often fine because images are often the full width of the content. But on a desktop you often have a center column with margins on either side, and maybe the image is going to be in a column or floated to the right. And so oftentimes on desktop, you&#8217;re going to download a much larger image than is relevant to that container on the page.</p>\n\n\n\n<p>And so there&#8217;s a, one of the plugins in Performance Lab is called Enhanced Responsive Images. And what it does is it leverages the block structure in block themes to be able to figure out what the width is for the container of a given image. And then it can craft that sizes attribute to be much more accurate compared to the default sizes attribute. And in my talk, I showed that the performance gains from that enhancement alone are one of the largest that you can have, much more than just using AVIF or a modern image format.</p>\n\n\n\n<p>[00:43:51] <strong>Nathan Wrigley:</strong> Really?</p>\n\n\n\n<p>[00:43:51] <strong>Weston Ruter:</strong> Yeah because, for example, in my test page, I had a jpeg and then I tried it again with an AVIF and the AVIF was 20% smaller, so maybe I could compress it even further. But the Largest Contentful Paint improvement for that was only 2%. But with the Enhanced Responsive Images plugin active, it was able to use a much smaller image size, which is much fewer bites, even as a jpeg compared to the AVIF. And that improved the LCP by I think 45%. So a magnitude and a half higher.</p>\n\n\n\n<p>[00:44:28] <strong>Nathan Wrigley:</strong> It feels like this work is never, ever going to come to an end. There&#8217;s always going to be little things to tweak and squeeze out here, there and everywhere. And there was a really good example just there.</p>\n\n\n\n<p>I think somebody listening to this podcast, if they&#8217;ve got to this point, it&#8217;s kind of really fascinating that most of this stuff would go under the radar for most people.</p>\n\n\n\n<p>I&#8217;m sure almost everything that you&#8217;ve mentioned, for the casual WordPress user, they would never know that that happened. Not many people are going to read the change log or delve into the weeds of what the Performance Team are doing. And yet there it all is, laid out in front of us over the last 40 minutes or so. Yeah, absolutely loads and loads of work. and never ending. You&#8217;ll be here this time next with new things to say.</p>\n\n\n\n<p>[00:45:06] <strong>Weston Ruter:</strong> Hopefully. I don&#8217;t want to work myself out of a job.</p>\n\n\n\n<p>[00:45:07] <strong>Nathan Wrigley:</strong> That&#8217;s absolutely true. Where do you go to find information about this? You know, who are the scholars, or the YouTubers, or the blog post authors? Who are the people that are pushing the boundaries here?</p>\n\n\n\n<p>[00:45:20] <strong>Weston Ruter:</strong> Well, I have recently been loving the WordPress newsletters that go out, like the Repository and Remkus de Vries, his WP, I forget the name.</p>\n\n\n\n<p>[00:45:32] <strong>Nathan Wrigley:</strong> It&#8217;s okay.</p>\n\n\n\n<p>[00:45:33] <strong>Weston Ruter:</strong> It&#8217;s something in, WP in the name. I think, Within WP, but don&#8217;t quote me on that.</p>\n\n\n\n<p>[00:45:36] <strong>Nathan Wrigley:</strong> Oh, it is, Yeah Remkus, Within WP, you&#8217;re right.</p>\n\n\n\n<p>[00:45:39] <strong>Weston Ruter:</strong> Yes. So I subscribe to his performance blog. So Jono Alderson, Jono or Jono?</p>\n\n\n\n<p>[00:45:46] <strong>Nathan Wrigley:</strong> I think Jono. Yeah, we&#8217;ll go with that. And apologies if it&#8217;s not.</p>\n\n\n\n<p>[00:45:49] <strong>Weston Ruter:</strong> Yes. And so all of his posts are brilliant, so yeah. And then, yeah, following just the newsletters, because I don&#8217;t have time to keep up on social media anymore, but I really am thankful for those newsletters because it really saves me a lot of time. It gets me what I need to know.</p>\n\n\n\n<p>[00:46:05] <strong>Nathan Wrigley:</strong> Yeah, I will, link to the ones, the three that you&#8217;ve just mentioned.</p>\n\n\n\n<p>Yeah, that&#8217;s amazing. Thank you. Honestly, it seems a bit trite, but I&#8217;ve been following what the Performance Team have done for the last four years now, from the capacity that I have to understand it, which is pretty low in all honesty. You know, most of what you&#8217;re saying, I can get a purchase on the overarching idea, but as soon as you were to draw back, if you were to show me what you were doing, the code and so on, I would immediately lose my purchase.</p>\n\n\n\n<p>I&#8217;d just like to express how profoundly happy I am that people like you are taking the time to do it. I don&#8217;t know how much thanks you get for stuff like this, but for my part, thank you.</p>\n\n\n\n<p>[00:46:42] <strong>Weston Ruter:</strong> Well, thank you, but no thanks are required because I enjoy doing it, so.</p>\n\n\n\n<p>[00:46:45] <strong>Nathan Wrigley:</strong> Yeah, great. Well thank you. anyway.</p>\n\n\n\n<p>[00:46:46] <strong>Weston Ruter:</strong> I&#8217;ll do it anyway.</p>\n\n\n\n<p>[00:46:47] <strong>Nathan Wrigley:</strong> Yeah, well Weston Ruter thank you so much for chatting to me today. It&#8217;s been a pleasure.</p>\n\n\n\n<p>[00:46:51] <strong>Weston Ruter:</strong> Thank you very much.</p>\n</div></details>\n\n\n\n<p>On the podcast today we have <a href=\"https://weston.ruter.net/\">Weston Ruter</a>.</p>\n\n\n\n<p>Weston Ruter is a long-time WordPress user and contributor. He has been a core committer for 10 years and he co-led the WordPress 4.9 release. He worked in the WordPress agency space and has also been sponsored to work on the Core Performance Team. He lives in Portland, which, as you will hear, was quite handy for this interview.</p>\n\n\n\n<p>We start the conversation by getting into the big picture: why website speed matters more now than ever, and how WordPress performs out of the box. Weston shares details about measuring true performance, revealing, for example, that achieving a perfect Lighthouse score isn’t the end game, and that real user experience metrics like Core Web Vitals and Largest Contentful Paint (LCP) should shape how developers and site owners think about optimisation.</p>\n\n\n\n<p>Throughout the episode, you’ll learn about the advances made by the WordPress Performance Team, from lazy loading and new image formats, to speculative loading that shaves precious milliseconds off page transitions. Weston explains how many performance improvements are designed to work automatically, democratising speed so even casual WordPress users benefit without needing to be technical experts. The conversation also touches on the balance between adding features and avoiding plugin bloat, the hidden impact of browser and device differences, and how large companies like Google are working hand-in-hand with WordPress to raise the bar on speed and usability.</p>\n\n\n\n<p>Weston offers practical tips, deep technical wisdom, and a glimpse of where WordPress performance is heading next, and it’s sure to inspire you to think differently about how your sites load, how your users engage, and how you can squeeze out every last drop of speed from the platform you love.</p>\n\n\n\n<p>Whether you’re a developer, designer, site owner, or just someone curious about what keeps the web running smoothly, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://us.wordcamp.org/2025/session/the-site-speed-frontier-with-performance-lab-and-beyond/\">The Site Speed Frontier with Performance Lab and Beyond</a> &#8211; Weston&#8217;s presentation at WordCamp US 2025</p>\n\n\n\n<p>A post about the presentation (above) on <a href=\"https://weston.ruter.net/2025/08/27/the-site-speed-frontier-with-performance-lab-and-beyond/\">Weston&#8217;s own website</a></p>\n\n\n\n<p><a href=\"https://en.wikipedia.org/wiki/Accelerated_Mobile_Pages\">Accelerated Mobile Pages (AMP)</a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/performance/\">WordPress Core Performance Team</a></p>\n\n\n\n<p><a href=\"https://developer.chrome.com/docs/lighthouse/\">Lighthouse</a></p>\n\n\n\n<p>Podcast &#8211; <a href=\"https://wptavern.com/forums/topic/171-felix-arntz-on-how-speculative-loading-is-speeding-up-your-wordpress-website\">Felix Arntz on How Speculative Loading Is Speeding Up Your WordPress Website</a></p>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/performance-lab/\">Performance Lab plugin</a></p>\n\n\n\n<p><a href=\"https://developer.chrome.com/docs/crux\">CrUX</a> &#8211; Chrome User Experience Report</p>\n\n\n\n<p><a href=\"https://web.dev/articles/lcp\">Largest Contentful Paint (LCP)</a></p>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/plugin-check/\">Plugin Check (PCP)</a></p>\n\n\n\n<p><a href=\"https://web.dev/articles/fetch-priority\">Optimize resource loading with the Fetch Priority API</a></p>\n\n\n\n<p>Podcast &#8211; <a href=\"https://wptavern.com/podcast/178-adam-silverstein-explores-transformative-browser-features-impacting-wordpress-sites\">Adam Silverstein Explores Transformative Browser Features Impacting WordPress Sites</a></p>\n\n\n\n<p><a href=\"https://web.dev/articles/bfcache\">Back/forward cache</a></p>\n\n\n\n<p>Weston&#8217;s <a href=\"https://wordpress.org/plugins/nocache-bfcache/\">Instant Back/Forward plugin</a> (mentioned in the podcast with an older name)</p>\n\n\n\n<p><a href=\"https://developer.wordpress.org/block-editor/reference-guides/interactivity-api/\">Interactivity API Reference</a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2024/03/04/script-modules-in-6-5/\">Script Modules API</a></p>\n\n\n\n<p><a href=\"https://web.dev/articles/inp\">Interaction to Next Paint (INP)</a></p>\n\n\n\n<p><a href=\"https://developer.chrome.com/blog/introducing-scheduler-yield-origin-trial/\">Introducing the scheduler.yield origin trial</a></p>\n\n\n\n<p><a href=\"https://web.dev/articles/cls\">Cumulative Layout Shift (CLS)</a></p>\n\n\n\n<p><a href=\"https://sitekit.withgoogle.com/\">Site Kit plugin</a></p>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/auto-sizes/\">Enhanced Responsive Images plugin</a></p>\n\n\n\n<p><a href=\"https://withinwp.com/\">Within WordPress</a></p>\n\n\n\n<p><a href=\"https://www.jonoalderson.com/\">Jono Alderson&#8217;s website</a></p>\n\n\n\n<p><a href=\"https://www.therepository.email/\">The Repository</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 15 Oct 2025 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"Matt: D’Angelo &amp;amp; Diane\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150230\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://ma.tt/2025/10/dangelo-diane/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1141:\"<p>Just last night I was re-watching <a href=\"https://en.wikipedia.org/wiki/Annie_Hall\">Annie Hall</a> to remember and <a href=\"https://www.newyorker.com/culture/postscript/diane-keatons-shadows-and-light\">honor Diane Keaton</a>, and now <a href=\"https://www.nytimes.com/2025/10/14/arts/music/dangelo-dead.html\">the  news that D&#8217;Angelo had passed</a>. I&#8217;m writing this listening to <a href=\"https://open.spotify.com/album/2lO9yuuIDgBpSJzxTh3ai8\">Voodoo</a>, one of the great albums of all time. That CD in my beater car in Houston was on constant rotation, the richness of the tracks— it&#8217;s an album you have to listen to in its entirety, it takes you on a journey, the way the tracks blend in to each other. Not ideal for the atomized world of songs being stand-alone.</p>\n\n\n\n<p>D&#8217;Angelo was obviously a star, but one amazing thing about his bands is he brought so many people with him, so many amazing jazz musicians, including Roy Hargrove, Robert Glasper (<a href=\"https://khspva.houstonisd.org/\">HSPVA</a>!), Chris Dave (HSPVA!), Kenny Garrett, Pino Palladino, Questlove&#8230; May his memory be a blessing.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 15 Oct 2025 03:49:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Open Channels FM: Why Focus Matters When Building a Successful WordPress Plugin Business\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=110790\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://openchannels.fm/why-focus-matters-when-building-a-successful-wordpress-plugin-business/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:160:\"Learn the importance of focus in scaling a WordPress plugin, advocating for prioritizing core products over numerous side projects to achieve long-term success.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 14 Oct 2025 11:38:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"Open Channels FM: How Great Storytelling Builds Brand Loyalty and Differentiates Products\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=111053\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://openchannels.fm/how-great-storytelling-builds-brand-loyalty-and-differentiates-products/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:166:\"In this episode, Rae and Adam dig into why storytelling is key for brands to shine in WordPress, sharing tips on connection, differentiation, and authentic messaging.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 14 Oct 2025 08:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"Matt: Nanochat &amp;amp; MCP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150223\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ma.tt/2025/10/nanochat-mcp/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1156:\"<p>Probably the most interesting thing on the internet today is <a href=\"https://x.com/karpathy/status/1977755427569111362\">Andrej Karpathy&#8217;s nanochat</a>, &#8220;a minimal, from scratch, full-stack training/inference pipeline of a simple ChatGPT clone in a single, dependency-minimal codebase.&#8221; 8,000 lines of beautiful code, <a href=\"https://simonwillison.net/2025/Oct/13/nanochat/\">as Simon Willison notes</a>. If you want to understand how LLMs work, <a href=\"https://github.com/karpathy/nanochat\">study this</a>. Andrej is a code poet.</p>\n\n\n\n<p>In hacking news, Wired has <a href=\"https://www.wired.com/story/satellites-are-leaking-the-worlds-secrets-calls-texts-military-and-corporate-data/\">an amazing article on intercepting geostationary satellite signals</a>.</p>\n\n\n\n<p>On Friday, we turned on something cool: <a href=\"https://wordpress.com/blog/2025/10/07/mcp/\">every WordPress.com site now supports MCP</a>. Right now this is read-only access to your site, because the S in MCP stands for Security, but <a href=\"https://developer.wordpress.com/docs/mcp/prompt-examples/\">you can already start to do some cool stuff with it</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 14 Oct 2025 06:07:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Matt: Last Ball\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150219\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ma.tt/2025/10/last-ball/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:319:\"<p>If you appreciate golf at all, <a href=\"https://www.espn.com/golf/story/_/id/26902640/down-last-ball-how-tiger-avoided-disaster-won-2000-us-open-15\">the story of how Tiger Woods won the U.S. Open at Pebble Beach without knowing he was down to his last golf ball because of arcane rules is pretty interesting</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 13 Oct 2025 06:36:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"Gutenberg Times: Gutenberg Changelog #122 – Gutenberg 21.8 and WordPress 6.9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://gutenbergtimes.com/?post_type=podcast&p=42245\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://gutenbergtimes.com/podcast/gutenberg-changelog-122-gutenberg-21-8-and-wordpress-6-9/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:67394:\"<p>In episode 122 of the GT Changelog podcast, host Birgit Pauli-Haack is joined by Beth Soderberg, CEO of bethink Studio, to discuss the latest updates in Gutenberg 21.8 and WordPress 6.9. The conversation kicks off with reminiscing about past WordCamp experiences and transitions into a deep dive on block themes, evolving design tools, and the challenges of adopting new workflows. Beth shares practical insights from her agency work, highlighting the benefits of section and block styles, synced patterns, and strategies for cleaning up legacy code as Gutenberg advances.</p>\n\n\n\n<p>The episode covers new features like section styles, the highly anticipated accordion block, and improvements to template management, aimed at making theme and site building more flexible for users and developers. They also talk about experimental features such as PHP-only blocks, block bindings, and upcoming blocks like breadcrumbs and table of contents, which promise to streamline site navigation and content organization.</p>\n\n\n\n<p>Birgit and Beth underscore the importance of continuous testing and learning, encouraging listeners—especially those hesitant to adopt block themes—to experiment, seek support, and embrace gradual change. The episode wraps with practical advice, recent security updates, and a look at promising innovations coming to the WordPress ecosystem.</p>\n\n\n\n<p><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-122-gutenberg-21-8-and-wordpress-6-9/#shownotes\">Show Notes</a> / <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-122-gutenberg-21-8-and-wordpress-6-9/#transcript\">Transcript</a></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Editor: <a href=\"https://www.linkedin.com/in/sandy-reed/\">Sandy Reed</a></li>\n\n\n\n<li>Logo: <a href=\"https://markuraine.com/\">Mark Uraine</a></li>\n\n\n\n<li>Production: <a href=\"https://icodeforapurpose.com\">Birgit Pauli-Haack</a></li>\n</ul>\n\n\n\n<p class=\"has-larger-font-size\" id=\"shownotes\"><strong>Show Notes</strong></p>\n\n\n\n<h2 class=\"wp-block-heading\">Special Guest: Beth Soderberg</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://bethink.studio/\">Bethink Studio</a></li>\n\n\n\n<li><a href=\"https://profiles.wordpress.org/bethsoderberg/\">WordPress.org Profile + Slack </a></li>\n\n\n\n<li><strong>Talks by Beth Soderberg</strong>\n<ul class=\"wp-block-list\">\n<li><a href=\"https://wordpress.tv/2025/07/25/my-process-for-building-a-custom-wordpress-theme-in-2025/\">My Process for Building a Custom WordPress Theme in 2025</a></li>\n\n\n\n<li><a href=\"https://wordpress.tv/2020/04/16/bill-ericksonellen-bauer-beth-soderberg-case-studies-how-to-prepare-your-theme-for-gutenberg/\">Bill Erickson,Ellen Bauer, Beth Soderberg: Case Studies &#8211; How to Prepare your Theme for Gutenberg</a></li>\n\n\n\n<li><a href=\"https://wordpress.tv/?s=beth%20soderberg&amp;sort=newest\">And more</a></li>\n</ul>\n</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Calls for Testing WordPress 6.9 </h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/test/2025/10/03/help-test-changes-to-template-management/\">Template management</a> </li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2025/10/04/call-for-testing-ability-to-hide-blocks/\">Ability to Hide Blocks</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2025/10/06/call-for-testing-accordion-block/\">Accordion Block</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Community Contributions</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://gutenbergtimes.com/blocks-galore-test-template-management-woo-product-collections-and-more-weekend-edition-343/#blocks-galore-with-telex\">Block Galore</a> by designers and developers using Automattic’s Telex </li>\n\n\n\n<li><a href=\"https://gutenbergtimes.com/block-commenting-fun-with-telex-from-classic-to-block-theme-weekend-edition-341/#building-blocks-with-telex\">Moar Blocks</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">What&#8217;s Released</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://wordpress.org/news/2025/09/wordpress-6-8-3-release/\">WordPress 6.8.3</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/10/08/whats-new-in-gutenberg-21-8-08-october/\">What’s new in Gutenberg 21.8? (8 October)</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">New Blocks still in the works</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><img alt=\"🟣\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f7e3.png\" style=\"height: 1em;\" /> <a href=\"https://github.com/WordPress/gutenberg/pull/71588\">Time to Read</a> (m) </li>\n\n\n\n<li><img alt=\"🟣\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f7e3.png\" style=\"height: 1em;\" /> <a href=\"https://href.li/?https://github.com/WordPress/gutenberg/pull/64119\">Accordion Block</a> (m) </li>\n\n\n\n<li><img alt=\"🟣\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f7e3.png\" style=\"height: 1em;\" /> <a href=\"https://github.com/WordPress/gutenberg/pull/71793\">Breadcrumbs Block</a> (m)</li>\n\n\n\n<li><img alt=\"🟣\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f7e3.png\" style=\"height: 1em;\" /> <a href=\"https://github.com/WordPress/gutenberg/pull/70720\">Terms Query block</a> (m) </li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/71618\">Dialog Block </a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/71227\">Icon Block</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/71904\">Stretchy Text</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/69789\">Tabs Block</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/issues/42229\">Table of Contents block</a></li>\n</ul>\n\n\n\n<p><img alt=\"🟣\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f7e3.png\" style=\"height: 1em;\" /> = already merged into trunk, as experiments. </p>\n\n\n\n<p class=\"has-large-font-size\">Stay in Touch</p>\n\n\n\n<div class=\"wp-block-group\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<ul class=\"wp-block-list\">\n<li>Did you like this episode? <a href=\"https://lovethepodcast.com/gutenbergchangelog\"><strong>Please write us a review </strong></a></li>\n\n\n\n<li>Ping us on X (formerly known as Twitter) or send DMs with questions. <a href=\"https://twitter.com/gutenbergtimes\">@gutenbergtimes </a>and <a href=\"https://twitter.com/bph\">@bph</a>.</li>\n\n\n\n<li><em>If you have questions or suggestions, or news you want us to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. </em></li>\n\n\n\n<li><em>Please write us a review on iTunes! <a href=\"https://gutenbergtimes.com/itunes/\">(Click here to learn how)</a></em></li>\n</ul>\n</div></div>\n\n\n\n<p class=\"has-large-font-size\" id=\"transcript\"><strong>Transcript</strong></p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Hello and welcome to our 122nd episode of the Gutenberg Changelog. In today&#8217;s episode, we will talk about Gutenberg 21.8 and WordPress 6.9, what we already know about it. And I&#8217;m your host, Birgit Pauli-Haack, curator at Gutenberg Times, co contributor on the Word Open Source project, and I work as a developer advocate for Automattic. I&#8217;m thrilled that I finally have Beth Soderberg join me on the show. Beth is the CEO of Bethink Studio, a special web design and development agency in Alexandria, Virginia, in the U.S. Beth, welcome to the show. How are you doing?</p>\n\n\n\n<p><em>Beth Soderberg:</em> Thank you. Welcome. Welcome to my morning. I&#8217;m doing great. Good to see you.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. So I tried to recollect how we actually met or we met over the last few years, and I think it was the first time we met at the WordCamp New York in 2019.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I think that&#8217;s right. Ish. I definitely have eaten tacos late at night at WordCamp New York. Okay, so that tracks.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah.</p>\n\n\n\n<p><em>Beth Soderberg:</em> And I definitely met you sometime before the pandemic, so I&#8217;m not sure exactly, but that sounds about right. And then I know we had lunch at WordCamp us when it was in San Diego.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Oh, okay. Nice. Oh, right. We had this.</p>\n\n\n\n<p><em>Beth Soderberg: </em>There was.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>There was a group of women kind of coming together.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, yeah, I saw a table of women. And if I see a table of women at a conference like that, I&#8217;m going to sit down at it. And you did exactly the same thing.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Nice. So.</p>\n\n\n\n<p><em>Beth Soderberg: </em>But that&#8217;s the first time I saw you after the pandemic, for sure.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah. And in between, I think we did together the WP Blog Talk virtual conference that was organized by Automattic, but there were a lot of community members in there talking about the Gutenberg and the stage of it and all that.</p>\n\n\n\n<p><em>Beth Soderberg: </em>That was when I realized that I don&#8217;t like presenting at virtual conferences in front of audiences that you can&#8217;t see.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, it&#8217;s interesting.</p>\n\n\n\n<p><em>Beth Soderberg:</em> I&#8217;m good with Zoom, because you can get some feedback. But the speaking into the void was. I don&#8217;t know. It could have also been that I wasn&#8217;t speaking to anyone in real life at the time, so it felt extra weird.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah, no. I get it. The pre-recording and then just be there for the live part of it. But we had a great live discussion there.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, I. It was fun. And we actually did the presentation live. I think that could be why later things were recorded, because it was a really weird experience. It was very strange because you knew you were live. You had no idea if even your audio was working, but you just kind of had to keep talking. And, yeah, it&#8217;s the least feedback I&#8217;ve ever had from anything I&#8217;ve ever spoken at. And I think that not even being sure that the technology was working part. Like, even that level of feedback wasn&#8217;t there. It was fun. And hopefully next time I do something like that, it will be recorded in advance.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. But it was a. It was a good place talk because it was kind of together with Ellen Bauer, and you had 15 minutes, Ellen had 15 minutes. And I think Bill Erickson was there as well.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>There were three of us.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And every one of you kind of took a different take on the block themes. Yeah. And that was really interesting to kind of. Well, we started out in 2020 with that. Yeah. Now it&#8217;s five years later, and we finally connected again at WordCamp. Us, because I made it there again.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I know. I was excited to see you. And I think. Yeah, I mean, doing that talk was interesting. I think there&#8217;s still some divergence around how people are building and how people are utilizing the tools. That set of like 15-minute talks was a really good microcosm of that because each one of us had been actively building with all of the new tools and had a slightly bigger, different approach. I still think there&#8217;s some divergence there, but we&#8217;re starting to see some patterns of, like, actual best practices with the new tools, which I think is really exciting. And also it&#8217;s fun to sort of invent on the fly. Like, okay, how should this work as the people who really are using it with clients right away, what is the standard we want to set? What does and doesn&#8217;t work? And I think that was still in a time period where we were learning so much about what you could do, what the restrictions were. I know in a lot of what we&#8217;re going through today, there&#8217;s like little tiny changes that end up being so impactful. Right. Like, my favorite thing I hated from that time period was it could have been a little earlier, I don&#8217;t remember. But originally you couldn&#8217;t set text colors on lists.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Oh, yeah, yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Stuff like that. Where it&#8217;s so small, but when it&#8217;s missing, it&#8217;s a big problem.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So, yeah, I think that a lot of work has been put into having consistent design tools for each block that you can control through the theme JSON file and then make it really a unique experience or unique design for your clients. Yeah, that&#8217;s definitely something there where you don&#8217;t, oh, I can&#8217;t do the fonts. Yeah, well, I guess I need to do a variation of it. So there was a lot of coding done to kind of get around those restrictions. How do you feel about kind of ripping out all this additional around coding now that certain things are in core and that are available? Does that kind of trip you up a bit?</p>\n\n\n\n<p><em>Beth Soderberg: </em>I feel great about it and there&#8217;s not that much I need to rip out. Some of that is because of how I&#8217;ve built things over time. Some of that is because things like the tab block, which I am so excited about, I know it&#8217;s not ready and all that, but I have a few sites where I have random solutions for that, but I&#8217;ve got them compartmentalized. So pulling them out and putting in something new that makes more sense is going to be easy.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Because I know, you know, like, especially something like the tabs, they don&#8217;t appear that often. And the other thing with stuff like that, you can just search the database for the machine name of block to find where you&#8217;re using it. I do that a lot and sometimes I don&#8217;t know. I ripped Jetpack out of a site recently because it was only being used for slideshows in like six blog posts. There was no need for it. And it might have been more than six, but still this is a major publishing website that has thousands of posts. They didn&#8217;t need Jetpack sitting there doing this like a very minor task. And so that&#8217;s one of my tactics for sure. When I&#8217;m going to rip something out. People forget that you can search easily. Not even in the database. You can use the WordPress search. Search.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Right. For the posts. Yes. Yeah, that&#8217;s what I do. Yeah. Kind of. You can kind of put the blog name in there and then see which post uses what block, especially the third party blocks. When you find out, okay, I have now three query blocks and core blocks and why am I doing this to me?</p>\n\n\n\n<p><em>Beth Soderberg: </em>Right.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg:</em> And I&#8217;ve always been pretty conservative about what I&#8217;ll add.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>So I think that&#8217;s part of why it&#8217;s not super daunting to me. Because if I can make it work with the tools that exist, I will.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I&#8217;m not going to over engineer it just because I could. And that makes it easier to clean up long term.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So I think the last big feature that was introduced to theme development was the section styles. Style variation in one and then the section styles, the smaller things and block styles, now that you can edit them in the global styles. How much do you use about that? Is that something that comes up quite a bit in your work?</p>\n\n\n\n<p><em>Beth Soderberg: </em>I use them a lot. Especially when you&#8217;re dealing with semantics, I want to give people the ability to have something look the way they want it to look, but also be semantically correct. So especially with things like headings. Right. Having tooling that&#8217;s easy for an end user to understand to say this should be an H2, but I would like it to look like an H4 without making it an H4 is a game changer. It improves SEO, it improves accessibility, it keeps everything cleaner. And so that kind of tooling, I think when used strategically can really help. When used randomly, you&#8217;re just going to confuse people. But you know.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Well, aren&#8217;t we in the business of confusing people?</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, sometimes. Right.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>All right. Yeah, no, it&#8217;s interesting too. So are you using also side styles variations or just the section styles or block styles?</p>\n\n\n\n<p><em>Beth Soderberg: </em>Heavily using block styles. Okay, not so much the whole site variations yet. Yeah, there hasn&#8217;t. It&#8217;s again, it&#8217;s like you want to use the right tool for the right use case and yeah, normally you don&#8217;t.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Want to change how the site looks.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah. There&#8217;s only. You kind of need like a site within a site to make that required. And the only thing like that I&#8217;ve been building lately is a voter guide that&#8217;s like within a site but the voter guide has all the same styling as the rest of the site. Because it&#8217;s supposed to match.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, right. Right. Yeah. Yeah. I&#8217;ve always felt that the style variations are more for theme product developers that want to give more options to modify the theme. For agencies, I didn&#8217;t see that there are a whole lot of use cases for. For them. I might be wrong, but. Yeah, but you&#8217;re kind of confirming a little bit my bias here.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, I. I don&#8217;t know. I look at anything that&#8217;s coming in that&#8217;s new. I look at it in terms of strategic utility and there&#8217;s a bunch of stuff that is super cool but it&#8217;s just not necessary for my clients. Right. Like it&#8217;s not the use case for that but for somebody else that could really help. And I&#8217;ve had a few where you end up building this random micro site within the site because some weird reason why they need it. And like that&#8217;s really what you would use that for. It doesn&#8217;t happen all that often.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So yeah. Do you apply section styles to your patterns? Yeah, so that. And you give them design choices and they don&#8217;t have to spend time with kind of reorganize their design just because they want to have a pair of a pink background or a yellow background or something like that.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah. I also, I restrict color palettes, of course, because we don&#8217;t want anything looking like, you know, we&#8217;re in the. We&#8217;re in some sort of sci fi. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: Geocities. </em>I&#8217;m dating myself now.</p>\n\n\n\n<p><em>Beth Soderberg: </em>It&#8217;s okay. I told the checker at the grocery store the other day about how I worked at Blockbuster in high school and how that dated me, but it was a good job because you could I had to walk around to put the movies back. So I also use a lot of synced and partially synced blocks to achieve design consistency. So paired together. Because that I have found is really good for editorial teams where you can give them a style guide. And usually I make a page on the inside of the site that&#8217;s just privately published so that they can see like, okay, we have these patterns to work from. And, you know, this is the human part. You have a discussion about how, yes, you can do all these things, but you should use these things that we&#8217;ve all agreed upon that follow the style guide.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. Well, it also makes for production much, much faster when you don&#8217;t have to make those design decisions. They&#8217;re already there and then.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Exactly. And you don&#8217;t have to train people. I mean, the number one thing I see real clients, real site administrators doing weirdly with formatting is inconsistent vertical spacing.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Okay. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>The tooling is there to make it consistent, but people don&#8217;t. Even if you train them, they&#8217;re like, wait a minute, do I pick it at the fourth hash? Or like, which setting is it again? And does that look. And like as much as I can look at spacing on anything and know if it&#8217;s wrong, many people cannot.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Oh, no, no. Yeah. That&#8217;s a skill.</p>\n\n\n\n<p><em>Beth Soderberg: </em>It&#8217;s a skill.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>And many people really. And I found that like syncing those patterns that way and getting. Locking down some of that basic stuff that like, you don&#8217;t want your end user to be thinking about how much space they need below something.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Like that&#8217;s not what they should be ever actively thinking about. So that&#8217;s how I have approached that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. Yeah. So far. Yeah. Makes sense. Have you taken a survey of how often your clients actually use the spacer block? Because I found that WordPress.com that&#8217;s one of the top five blocks used, I.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Have not, but now I&#8217;m curious and I. Some of them, I mean you definitely have some, some where it&#8217;s used more than it should be. But I think that we&#8217;ve avoided some of that and some of it is what we&#8217;ve been able to do recently. Right. A few years ago you had to use it if you were going to get any consistency at all across things. But I think sometimes the patterns and the pattern syncing, that type of thing has dramatically reduced the need to use the spacer block, which is great because the speaker, the spacer block is so annoying on mobile.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, that&#8217;s one thing. It&#8217;s also, you cannot rip it out when, when you redesign the site or something like that, it&#8217;s going to be the. In your content.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, yeah. So I mean, I haven&#8217;t seen similar dislike as it sounds of the spacer block, but when you shrink a screen down suddenly you get wildly different vertical spacing on mobile. And for the average person there is not a straightforward way to make it not do that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>You have to know how to write a workaround for yourself to make it work and that&#8217;s not great.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So. Yeah, well, yeah, it&#8217;s good to know. So before we head into our usual sections, is there anything else that you would like to tell people who have not yet done the jump into block themes, why they should do it?</p>\n\n\n\n<p><em>Beth Soderberg: </em>I think, I think that it is, it&#8217;s a scary jump, and I have always been an early adopter of the new tooling, and so I look at something like that and it freaks me out a little bit. And then I&#8217;m like, well, why not? And I just push myself through and I know that I have the liberty of doing that because I&#8217;ve been working independently for almost 10 years. So I am in a lot of ways in control of what is and is not allowed in my environment. I&#8217;ve talked to a few folks who have. They understand how it&#8217;s working and they, they personally buy in, but their employer does not.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Okay. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>And so for those folks, I think building up your skill set with your personal site or a personal project so that you can advocate for different things internally. It&#8217;s very hard to advocate for something that you haven&#8217;t done and that you don&#8217;t have hands-on experience with. But you know, the ability to spin up a little like MVP demo of, hey, this is how this would solve a problem that we have systemically is really how you sort of gain permission in those sorts of environments. There&#8217;s some really good resources out there on learning how to do this. I think that they are much harder to find than they used to be. When I was first learning how to code, it was much easier to find like beginner entry level stuff, to like level yourself up. And now I think fewer people are creating it and I think it&#8217;s harder to find just because of how it&#8217;s labeled. Everything starts to look the same because it&#8217;s all named the same. But I think giving yourself the challenge to &#8211; even if you don&#8217;t understand everything, listening to a podcast like this, listening to a talk that you&#8217;re finding online, having it playing in the background like it does, seep in to how you think about it. And what will happen is that later you&#8217;ll encounter the same subject again and you&#8217;ll be like, oh, wait, that&#8217;s what they were talking about. And that&#8217;s how you start to connect the dots when you&#8217;re learning anything new. And I think the idea that you&#8217;re going to get somebody who has been building themes the classic way, building themes that are heavily reliant on advanced custom fields, something like that, to just magically one day pick up a whole new set of tools with a whole different way of thinking and be completely comfortable from the get is like ludicrous. That&#8217;s not going to happen.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>But, you know, giving yourself the ability to slowly absorb it, because it is a different way of thinking, it&#8217;s a completely different way of thinking about how to structure the theme. And for me, that has been the hardest part to learn. Once I figured it out, it was great. But of course, it&#8217;s always the hardest thing to figure out a new way of thinking. When you say it like that, it&#8217;s so obvious. But I think people really get down on themselves about it. And I think really just paying attention, reaching out to folks, you know, when you have questions, not being shy about it. What I&#8217;ve figured out over the course of the last, I guess we&#8217;re almost at eight years of Gutenberg. Yeah, Gutenberg is a month older than my eldest child. So it&#8217;s very easy for me to keep track of how old it is. But we are in a time period where what I have noticed as an early adopter, when I talk to the other early adopters, everybody is making it up. Everybody is inventing their process, everybody is inventing the “ right way.” We&#8217;re starting to congeal on some common things. But it has been a time of innovation. And so being a little bit afraid to stick your toe in. That is so reasonable. And at the same time, when you think about it that way, it becomes less scary to fail in air quotes. Right. Because ultimately, how many light bulbs did Edison make before one worked? Like, it&#8217;s just, you know, you have to experiment in order to figure out how something works. And I think it is challenging to be mid-career and have to go back to that beginning.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>You know, Yeah, I feel a certain.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Confidence that all of a sudden is going away.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, yeah. So. So I. I just think people need to be a little less hard on themselves, push themselves a little, be okay with failing and talk to people, talk to people. Just keep going, Just keep swimming, as the fish say in Finding Nemo.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. All right, so you&#8217;ve listened here to a very experienced theme developer and yeah, it&#8217;s never going to be easy. You need to start now. What is it, the Chinese proverb to the best time to plant a tree was 20 years ago. The second best time is now. So it&#8217;s kind of exactly for that. Yeah. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Announcements</h3>\n\n\n\n<p>So, okay, so we have a few announcements. Now we&#8217;re going a little bit into the Gutenberg change log message here. We have a few announcements and they&#8217;re all calls for testing because we get new stuff and. And the testing team is really on top of things. Last week a call for testing was made for the new template management features that are coming to Core, which. have you checked it out, Beth, on what&#8217;s going to come with that? We talked about it here two weeks ago with Anne Katzeff and it&#8217;s the tool where you can now have multiple templates with the same slug and of the theme hierarchy and then activate and deactivate the ones that you want to use or not use. So it kind of puts a new layer in there and gets the user a little bit more in control on how the template management actually works and figure that out in there. Because template management is something WordPress users have never done before because it was always a developer designer kind of scope and there was no user interface for it. And now it&#8217;s here and the confusion is there, but it&#8217;s also something that can be learned and can be helped with.</p>\n\n\n\n<p><em>Beth Soderberg:</em> I think it&#8217;s also going to be great for launching changes to live sites where. And you know how to launch code for Gutenberg is a whole other conversation. But the best practice is to keep your live site database as your database of record. Right. And some of what I see with the new template management changes are enabling you to more easily respect that without having weird, momentary blips of your content looking bizarre while you&#8217;re changing something over on a live site. So I think it&#8217;s going to be, again, another adjustment in how we think about how we work. But ultimately we&#8217;ll offer more granular tooling that will allow for the elimination of some of these use cases that haven&#8217;t always ended up being really strange, where you&#8217;re like, yeah, should we put up a maintenance message while we&#8217;re doing this? Because everything is going to look bizarre for the next 20 minutes. That kind of stuff. I think it&#8217;s going to be good.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>It&#8217;s really good. Yeah. Yeah. And the first version is going to be not perfect and probably have some bugs, but that&#8217;s why the call for testing is there. So I leave the link in the show notes for you so you can start testing and share your experience with it and also share what still confuses you or what didn&#8217;t work or where you thought it would work, but it didn&#8217;t. It&#8217;s definitely something &#8211; conversation needs to happen. And if you are not sure what to do, come into the W in the WordPress Slack into the Outreach channel and there are a lot of people there that will help you figure that out. So if you don&#8217;t know if it&#8217;s a bug or you don&#8217;t, you&#8217;re not doing it right. I know that&#8217;s often kind of that with new things. Did I get this right or is it not working? Most people, and I&#8217;m one of them, I default to okay, I&#8217;m not doing this right. What&#8217;s happening? And there are two more console testing. </p>\n\n\n\n<p>One is on the ability to hide blocks, which is kind of the first iteration of a blocks visibility kind of plugin idea that you can hide and show blocks conditionally. Right now it&#8217;s only on and off or hide and show. So you could have a block in the editor, but you hide it on the front end. But because you&#8217;re still working on it or you don&#8217;t want to, you want to put it in there so your editor knows about it, but it&#8217;s not going to be pushed to the show version until a certain date or until a certain sale happens or something like that. The instructions for the call for testing are really good and they also show you with little videos how it&#8217;s supposed to work to kind of offset my am I doing this right or not? Idea. And the other one that I wanted to point out in this podcast is the accordion block calls for testing. That seems to be really settled. Came in 20.5, I think, and had some iterations, especially for those of you who started styling it. You need to double check your references because the name changes in between for the panel and for the items and all that. So call for testing for accordion block and what you can do with it. Have you experimented with the accordion block?</p>\n\n\n\n<p><em>Beth Soderberg: </em>Mm, I&#8217;m really excited about it. This is one of the ones that I&#8217;ve been dreaming of for years. It&#8217;s one of the ones where I had an external plugin where like, the only reason I was using the external plugin was because I needed accordions. The detail block is sort of an approximation, but it&#8217;s not the same semantically speaking. So I&#8217;m excited about this one. This one and Tabs are my two that have been a thorn in my side for years.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, I&#8217;m also. Well, we can talk about the other blocks that are supposedly come or at least been worked on for Core, even if they don&#8217;t make it into 6.9 at a later date. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Community Contributions</h3>\n\n\n\n<p>There&#8217;s this new AI feature out there, it&#8217;s called Telex, which is automatic block building AI. And there are a few designers and developers that have actually done some great experimentations with that. One is Tammy Lister. She has started a challenge, kind of the blocktober, meaning every day in October she will build a new block with Telex. And I&#8217;ll of course share the site in the show notes. She started out with a kind of reaching back into history of computers and started out with an esky Tetris game. And that&#8217;s when my afternoon, uploaded my afternoon was shot because I got addicted to Tetris again. Yeah. Did you do any experimentations with that?</p>\n\n\n\n<p><em>Beth Soderberg: </em>Nope. That one, I mean, I know about it, I know about Tammy&#8217;s blocktober. I&#8217;m paying attention, but I don&#8217;t have time to just play with it right now.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah, I. I feel the same way. It&#8217;s kind of letting other people do that. I. I look at what other people do. Yeah. And there&#8217;s Marco Ivanovich. He&#8217;s a designer at Automattic. He has some animated icon blocks. They were kind of sparkling and all that. And then he also created a post-it note block where you can put post-its on your site with an image and with a background gradient background. So pretty cool to look at. </p>\n\n\n\n<p>And then there was Jeff Paul from Ten Up. He actually also created a game of Pong Hung block that&#8217;s kind of the tennis kind of back and forth where you need to up. It was just handy as an easy, medium and hard. Yeah, that was another afternoon. I tried to figure it out. Yeah. Juan Margarito, he created a mermaid diagram which is actually a markdown diagram. And then you put the. The diagram code in markdown and then it kind of creates a. A diagram with errors back and forth. Yeah, it&#8217;s kind of a flow diagram if you want to. So that was really interesting to see. Yeah. Anyway, so I just. Yeah, check it out. If you want to play around with it. It&#8217;s telex.automattic.com automatic with double T. The second T. Yeah.</p>\n\n\n\n<h3 class=\"wp-block-heading\">What’s Released &#8211; WordPress 6.8.3</h3>\n\n\n\n<p>Okay. So now we come to the heart of the show, which is what&#8217;s released. And before we head into Gutenberg 20.8, I wanted to let everybody know WordPress 6. 8.3 is out. It&#8217;s a security issue. No, it&#8217;s a security release fixing two security issues. And if you haven&#8217;t updated yet, please do we wait. Go and update. The two issues were mentioned in the release post. One was data exposure issues and the other one issue and the other one was a cross scripting vulnerability for the nav menus which has been fixed and you are in a secure environment again. But don&#8217;t forget to update. Yeah. Any thoughts?</p>\n\n\n\n<p><em>Beth Soderberg: </em>Always update. I&#8217;m. I&#8217;m of the. I&#8217;m of the camp. I always update on the security releases right away and then major releases. I always wait and see what happens.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>How long do you wait? How long do you wait?</p>\n\n\n\n<p><em>Beth Soderberg: </em>I usually wait until a point release has come out.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Okay.</p>\n\n\n\n<p><em>Beth Soderberg:</em> That&#8217;s usually the trigger but sometimes it&#8217;s really stable and we&#8217;re like, well there. I guess there&#8217;s no point release and it&#8217;s been three weeks.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I do the same thing with updating like my iPhone. Yeah, I don&#8217;t. I&#8217;m. As much as I am interested in technology, I am also somebody who just recently started using mobile deposit for checks. I&#8217;m skeptical.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Well, I think that makes that an early above to decide where to early adopt and where to be cautious.</p>\n\n\n\n<p><em>Beth Soderberg:</em> That&#8217;s true. Yeah. My risk tolerance is very high for certain things and very low for other things.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>And if it changes my work environment that I need to retrain my muscle memory. I&#8217;m opposed to any change, but I recently had to change my Mac updated and they fixed a bug. That&#8217;s the problem with bug fixes. Yeah. If you, if you have for years known about a workaround and the muscle memory is in. You hate that bug fix that fixes that once and for all. So kind of. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Anyway, that&#8217;s a whole other conversation. Moving on.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Thank you. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Gutenberg 21.8</h3>\n\n\n\n<p>So Gutenberg 21.8 is the second last before 6.9 beta. There&#8217;s one more coming, that&#8217;s a 21.9, of course, and that&#8217;s coming on October 17th. So we are recording this on October 8th and next week we have the last Gutenberg release before 6.9 beta comes. Which means bug fixes, yes. New features, no. From that point on forward to get into Core. Gutenberg 21.8 had 118 PRs by 47 contributors and five people were first time contributors. Congratulations, you got your merge done. That&#8217;s fantastic. Because I can see that the first one is always a little tricky getting it past the reviewers. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Enhancements</h3>\n\n\n\n<p>For Gutenberg, we start with the enhancements to the block content. Comments. Block comments is a feature that creates a commenting method for each block in your editor so you and others can add comments to your blocks and have an editorial kind of process going. It&#8217;s a a lot of PRs made it into that. But the first one that I wanted to point out is a discussion field with trackbacks and comment status aggregated for the post page Quick Edit. So you know, in the Quick edit, are there commenting places? Quick Edit is not the quick edit in the WP admin. It&#8217;s a quick edit in the design. But that&#8217;s actually not the commenting. The block commenting thing.</p>\n\n\n\n<p><em>Beth Soderberg:</em> Yeah, this is hard to contextualize even looking at the PR, right? Yeah, the PR. I think ultimately it&#8217;s unifying. It&#8217;s again, it&#8217;s one of those things that&#8217;s unifying design across components to make things more consistent no matter where you find them.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So when you have the new design view, what was missing that you were able to manage trackbacks and comments. So it&#8217;s not the feature that I just said. It&#8217;s just getting on par with the previous WP admin kind of thing. Especially for pages. The posts haven&#8217;t been included yet in these new designs, but for pages, definitely. And if there&#8217;s a post experiment in Gutenberg where you can have the post view also in the new design view, as the site editor. And that&#8217;s where this actually comes to pass. So that is kind of labeled wrong in that changelog, but that&#8217;s okay. We can handle that. Do you want to do the next one?</p>\n\n\n\n<p><em>Beth Soderberg: </em>Sure. So displaying a message when there is no related block, which is the most logical thing you could do with commentary that has no source attached to it anymore.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Anymore.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Anymore, anymore. Right. So again, it&#8217;s giving context to something so that your actual conversations make sense. And basically what it&#8217;s doing is just adding a little message that says, hey, your original block was deleted so that somebody reading through it understands and also gives you the ability to&#8230;part of why I like this one is because you&#8217;re going to end up with people who in collaborating with each other are going to remove things. And you want to have a record of the conversation for editorial purposes, but understanding what has happened is a key part of creating that record.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So yeah, definitely you want to have a record of the decision making process for certain things. Yeah. The other one that I wanted to point out is that it now shows the dates of the comments in a more human readable part, like 30 minutes ago or two hours ago or three days ago. So you get a little bit more relation to the timestamps of that. I think there was an option to do this, but I&#8217;m not quite sure that you can switch it on and off. But if not. No, it&#8217;s not. It&#8217;s the first. It&#8217;s the first iteration and there are no options.</p>\n\n\n\n<p><em>Beth Soderberg:</em> I think that&#8217;s coming later.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, yeah, but it&#8217;s. It&#8217;s known that there will be something like that needed.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yep. And then the highlighting of the related block. Again, a lot of these changes are improving context indicators and so, you know, this just gives you a clearer sense of what you&#8217;re connecting to and which thing you&#8217;re actually talking about with the comments.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So I&#8217;m just going to look through. If we missed something new, we can now go right into the block library section and there&#8217;s a ton of PRs that actually work on the accordion blocks. That&#8217;s also in the bug fix sections. But I think the most prominent stuff is more like the term description block with the context support. So that if it&#8217;s in a template or in an archive template that the term description block is more. You can use it in patterns like you can do post title and query title for that. Yeah, the term description block is something that&#8217;s a little bit of a… I have seen people that are quite adamant that they need the block editor in the category description section for editing the description because I wanted to make it more there. Design it a little bit or make it a little bit more versatile. That&#8217;s quite interesting because you also can now create a page with all the features that you want on that for a particular category and then just have a query loop on that category displayed on it. So you get around that need to have the term description be a block editor or something like that.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah. I had never thought about that before because theoretically you always could do the latter. Right?</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>But you had to have a certain level of technical skill and knowledge to do that. The idea of adding block support to that description opens up possibilities for folks who are not as technical to make modifications in that presentation of the. The term pages. I don&#8217;t know. I could go either way there.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I could also create massive. I can see this going very wrong.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. I think that&#8217;s why nobody touched it for now.</p>\n\n\n\n<p><em>Beth Soderberg: </em>That&#8217;s a new concept to me. But I don&#8217;t know. My gut says no.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. So. And then we get a new block. It&#8217;s the time to read block. And now it has been in the Guternberg plugin for ages. Similar to the table of content block. But they were to get it into core. There were always kind of missing things or quirkinesses that weren&#8217;t dealt with. And the time to read had massive accessibility objections because it only had one time that it takes to read a block. Not everybody has that reading skill or is on that level like a lot of people are. English as a second language. They don&#8217;t. They don&#8217;t read so fast or dyslexia is pretty. Yeah. It&#8217;s out there. And they don&#8217;t read that fast. And so it kind of makes them feel bad about not reading in that 15 minutes kind of thing. What they&#8217;re doing now is kind of offering a range option. It says it takes one to five minutes or something like that. And which I feel is kind of even for someone who is fast reading but tired is a good indicator. Yeah. That&#8217;s how long it&#8217;s going to actually take. And then they added also a word count to it.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, I like that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. When there are word count plugins out there. Word count blocks, plugins out there say that 15 times fast. But I think having a core block that actually offers it option is really cool.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. I&#8217;m sorry I didn&#8217;t bold that, but I wanted to talk about it.</p>\n\n\n\n<p><em>Beth Soderberg: </em>No, I agree. I think it&#8217;s. It&#8217;s a kinder way to deal with the problem because you&#8217;re giving people enough information to very quickly self assess without shaming them.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. So the next one is part of the Data Views section actually. It&#8217;s the data forms package. And there&#8217;s now support for certain form elements validation in the data forms package. So if you use that as a plugin or your settings pages. You now get help from the packages that drive that. I think that&#8217;s a. Yeah, it&#8217;s an enhancement for extensibility, for sure.</p>\n\n\n\n<p><em>Beth Soderberg:</em> In the block editor section, block multi selection, disabling transforms and inspector controls.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. That&#8217;s an interesting one. So when you select multiple blocks, you still get the. Sometimes the options that you can transform them. And for paragraphs, a series of paragraphs. I like it. Because then you have. You can transform them to list views. But if you have a mixture of selected blocks, you don&#8217;t need transforms or inspectors back the controls. You just probably want to move it or move the selection. Yeah. So I think it&#8217;s a good way to not confuse people.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Right. And that&#8217;s a good example of a tiny change from an end user perspective that probably won&#8217;t be noticed, but will reduce friction for people. All right. In global styling, adding a reset button to our background controls panel. Hooray.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Hooray. You don&#8217;t have to unselect stuff. Yeah. Just click on things and you make it all go away. It&#8217;s pretty cool. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg:</em> And then making the additional CSS UI less prominent, which is great because the less random CSS everywhere, the better.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yes. And. Well, it&#8217;s. I totally agree with that. And that&#8217;s also the. The justification why they want to put it some. So they&#8217;re going to hide it. Again, it was hidden on the left hand side of the global styles or styles panel. You always could edit it on the right hand side when the styles panel where sooner or later we probably need to decide if we want to use the left hand side or the right hand side for the styles features. But it now is going to be in the ellipse menu in the header of the styles section. So it says add additional CSS as a menu item on top. So. So you are not going to be. Well, it was there and then it wasn&#8217;t there. So where is it kind of thing situation. It ended up in the ellipse menu on top of the screen.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Block bindings. I love block bindings.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. There&#8217;s an experimental feature there.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>To support block attributes from the server side. I haven&#8217;t completely read through it. I&#8217;m not quite sure I understand that. So I would need to go back to the developers and say what&#8217;s the use case and why you&#8217;re doing it kind of thing.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>I think. Did you get something?</p>\n\n\n\n<p><em>Beth Soderberg:</em> I would have to clarify, but my understanding of it is the big thing with block bindings is like which things are supported and which things aren&#8217;t supported and how that is communicated is improved from doing this.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. Doing it service sort of the nugget.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Of truth there. But I think anything like that. I know it&#8217;s experimental but making block bindings easier and more accessible for people to use anything that helps. That is a good thing.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. I think there are two areas where they come from. One is to make block bindings available for more than 14 blocks which has been the case until now. That&#8217;s one thing. But also to increase extensibility and use have not only blocks use the block bindings but also whole features use the block bindings for external things like the remote block plugin by WordPress VIP USO. Yeah. They also use block bindings to identify the data that comes in and put it into the block editor. But I think it&#8217;s hard to bring the server side and the client side together with the same information. And this one will have the server side be the moment of truth. No, the source of truth for block bindings. Yeah, it&#8217;s definitely a late edition. I&#8217;m not sure it&#8217;s going to make it to 6.9. I&#8217;m skeptical though. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah. Right. Right. Mode Try adding content roles to navigation blocks is the name of the PR which I think is delightfully named and I. Even the way that this is written is pretty great. I wanted to see how far we can go with just adding content roles to nav link in some menu blocks given the improvements to content only logic we&#8217;ve had. And then it references another pr. The next sentence is I think it&#8217;s working better now. Whoever this contributor is, I love your writing. Tell the machines.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Oh, that&#8217;s.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Fun times. But I think it&#8217;ll.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Isabelle Bryson. Yeah, she&#8217;s been on the podcast before and she&#8217;s actually worked also on the grid layouts and yeah, she works for Automattic on the team. And the other I think the tri part is okay. We experiment with things. So that&#8217;s when it says try and then there&#8217;s also add is kind of definitely need to fix this or add this feature or fix means fix this bug. Yeah. So they have these prefixes on their PRs and the try thing is. Yeah, let&#8217;s try it out and see what happens. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah. But this one, it looks cool. People should check it out. Components. The text area component. Adding a default resize vertical rule just to make things more make sense visually so that you can move stuff around the way you need to.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. And you can control the vertical size of things. That&#8217;s always a good thing. And then the other component PR is actually adding storybook examples for the fields package. So there&#8217;s more documentation there for the plugin developers who want to use it. Also of course, for the core developers who are going to use the Fields.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Package for their work patterns, we have a change to the block inspector adding a content tab for section blocks that displays content only descendant blocks. So similar to the existing styles tab, but for content.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. And it&#8217;s up until now it lists the blocks that can be edited in a section pattern or in a content only block. But that&#8217;s all part of the write mode, and we will see how which part of it actually will come into 6.9. But I think it&#8217;s very helpful for content creators who use a pattern to just see the pieces that you can edit and not be confused with any styling of that, even if it&#8217;s only the section styles. And from the PR before and after, you can see that the little drop water drop that&#8217;s in the block toolbar actually gives you a way to browse through the styles for this particular section. So it&#8217;s not taking anything away, it&#8217;s just kind of making it clear where the things the information is going to be for you. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I think for anyone who might be confused about what we&#8217;re talking about, look at the pr. The screenshots will help you.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah. It&#8217;s a little bit. Sometimes it&#8217;s a little bit hard on the podcast to make things come to life on a. In a visual component.</p>\n\n\n\n<p><em>Beth Soderberg: </em>The screenshots make it make sense if you&#8217;re confused by what we just said.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> And the PR we&#8217;re talking about is 71714. The next one is an easy one, but it&#8217;s definitely something to talk about for Black Friday and all the WooCommerce stuff. There is now a WordPress gift icon available for content creators and developers. So you can use that. It comes from a WooCommerce team, but they contributed to Core so anybody can use it. </p>\n\n\n\n<h3 class=\"wp-block-heading\">New API</h3>\n\n\n\n<p>The next thing I want to point out was the block API has now the block visibility, control support and the ui. That&#8217;s the part where the underlying architecture for the hide and show of blocks I think it is. And that also is the foundation for when you. Later on we will have the conditional Hide and seek. No hide and show. Yeah. When you want to say okay, I want it for logged in users or not. I want it for people who come from Twitter or not. These kinds of conditionals, they&#8217;re not yet in there. For that you still need the block visibility plugin by Nick Diego. So I think we have one more. No. Yeah, there&#8217;s an accordion block also in write mode. We hide the add button in write mode so you can add an additional accordion block in write mode. But I&#8217;m not quite sure that&#8217;s particularly helpful for a content creator. But time will tell.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, that could go either way.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, it&#8217;s a 5050 kind of thing. You do it right for 50 people and the others are going to hate you for that. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Bug Fix</h3>\n\n\n\n<p>And then one bug fix I wanted to point out there is a bug in the pattern override. Some users might have found it is that editing was allowed on non-enabled override blocks which kind of defeated the purpose, but it&#8217;s now fixed. So there&#8217;s another experiment. I don&#8217;t know how that comes about, but the PR definitely has some interesting conversations. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Experiments</h3>\n\n\n\n<p>There is allow registering PHP only blocks. What do you say for that?</p>\n\n\n\n<p><em>Beth Soderberg: </em>I say I think this is gonna be, this is gonna be so much bigger than it sounds.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yes.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Because basically what you&#8217;re doing is you&#8217;re enabling developers to create blocks using only PHP. So you&#8217;re opening up the can of worms about who knows PHP and who knows JavaScript and are we gatekeeping by moving everything to JavaScript and blah blah.</p>\n\n\n\n<p>But then you&#8217;re also changing the structure in a way that might make things less portable between projects. So I don&#8217;t know.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Well, it&#8217;s definitely an experiment.</p>\n\n\n\n<p><em>Beth Soderberg: </em>That&#8217;s true. I think, you know, and I. One of the things I have noticed, there is a developer on my team that I have been mentoring for years and really started learning WordPress specifically post Gutenberg. And what&#8217;s fascinating about watching her is that she struggles with some of the traditional ways of doing things, but can do them the new way. Right. So for somebody like that this might be terrible, you know, and I. It just becomes a context thing about what you know and how you&#8217;ve been progressing with different skills along the way if you&#8217;ve completely forgotten PHP or you know, various things. So I, I don&#8217;t know, I think this, this one is going to be a much bigger deal than I think.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, I think so too. And there will be restrictions to that and I think the documentation will show that because it actually uses something the server side render component that actually was not considered best practice to use until now and the registration of PHP only blocks will actually use the server render component. So I think there is also something a little bit of a movement in the core contributing ranks about that. And it definitely needs some more. Yeah. Experimenting with it and exploration and. But it&#8217;s in there. One listened and maybe there&#8217;s something that can be pushed to the finish line outside the experiments. All the developers out there who were waiting for something like this go have at it.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Oh. Interesting to see what people do.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, me too. And I added a. The label needs developer documentation and a project manager on the team also removed it because it&#8217;s experimental. So the developers that created it have some leeway in backwards compatibility. And it&#8217;s experimental. It means it&#8217;s not documented. You cannot build on it. You need to be part of the experiment spirit about it to use it and not rely on it. That it&#8217;s going to be working like that for the foreseeable future. So yeah. It&#8217;s also that caveat on it. Just wanted to point it out.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I just saw that that&#8217;s important because you&#8217;re going to have somebody who goes off and builds a whole new thing on it and then in two weeks it&#8217;ll break.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. Which. Yeah. Any plugin developer that built plugins for Gutenberg has been doing kind of living through that for multiple years now. Yeah. So. But that&#8217;s 21.8 release with quite a few new features and the final release will be today on October 10th. </p>\n\n\n\n<h3 class=\"wp-block-heading\">What’s in Active Development or Discussed</h3>\n\n\n\n<p>And now we are coming to the section where we talk a little bit about what&#8217;s in development and discuss. And there are new blocks in the works and we know this because Matthias has. Matthias Ventura has published that discussion about new blocks that were previously thought about plug into territory. And now quite a few theme developers think that they are held back with their designs if there are not more additional blocks in core because then now they can style it in their themes and make it available on templates and all that. So Justin Tadlock also did an opinion piece on the Gutenberg Times for it about four weeks ago. I can link it again in the show notes. But we are getting new blocks and the ones that have been merged they&#8217;re not entirely out of experiments yet. Time to read. And we talked about it because it just was merged. We also talked about the accordion block that was merged a while ago and still in experiments. But there are two. Oh, we also talked about the terms query block that has been merged but we haven&#8217;t talked about the breadcrumbs block. And I&#8217;m really excited about that because it felt such a need in the template area that people are getting so confused where am I? And I have a better map and I have breadcrumbs and all that. Yeah, it&#8217;s such a useful tool and I&#8217;m looking forward to get that tested. And yeah, watch out on the test team. They&#8217;re putting some more calls for testing together to get this all in the hands of people who want to help with making it better.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I&#8217;m excited about the breadcrumbs block too. That&#8217;s another one where I&#8217;ve had to do sort of weird things to make things work over time and it&#8217;s going to be nice to not have to do the weird things.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. I was using Justin Tadock&#8217;s breadcrumbs block that he developed and he had some thoughts in this VR on how broad or restricted this new. This first version is going to be. And I think we all going to like it because depending on the context you can get additional. The breadcrumbs will change. And I really like that.</p>\n\n\n\n<p><em>Beth Soderberg:</em> Yeah, I&#8217;ve. I&#8217;ve used his plugin too. I forget which one it was. There&#8217;s a few independent plugins for breadcrumbs and my team has run into some weird edge cases of what they will do depending on your content structure. So I think that&#8217;s part of why the scope of the breadcrumbs block being limited at first makes so much sense, because the complexity of what you&#8217;re actually trying to do from a templating level, depending on where you are in a site and how your site is structured can get incredibly complex. I don&#8217;t remember which plugin it was, but we had a site. It may have been the Voter Guide. The Voter Guide within the site that completely killed everything. Like something about the logic of where we were just. And we had to use a different plugin just for that one site to make it work.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg:</em> I might have even re. Ended up doing something sort of manual instead. I don&#8217;t remember. But those plugins have been incredibly useful, but are also prone to edge case weirdness. Basically generating navigation on the fly. And if you don&#8217;t know where you are within the structure of the site from a structural standpoint, or if someone has made some odd decisions about where they&#8217;re putting things or how their hierarchy works, you&#8217;re going to end up with a really confusing breadcrumb.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, yeah. And sometimes you don&#8217;t have the controls to actually make changes. It&#8217;s just all this black box kind of mystery mute kind of thing again. Yeah, yeah. And I. While we&#8217;re running a little bit out of time or short on time, I just wanted to mention there&#8217;s also a dialogue block in the works. There&#8217;s an icon block in the works. My favorite one is the stretchy text. It sounds so weird, but it actually makes sense. It&#8217;s text that stretches over a certain container and it&#8217;s flexible depending on how the container works. So you could do this for hero sections, all that. And then here&#8217;s your bestest favorite. The tabs block is in the works. And then also my favorite is a table of contents block. Because I have these long posts all the time and I want to do the table of contents block. But it had some weird issues. That&#8217;s why it&#8217;s not in Core yet. And they&#8217;re trying to figure that out how that all can be done. It&#8217;s now attempted to be a dynamic one and allow usage outside of the post or page that is actually referring to. But for instance, in a template, you could put it in a single post template in the sidebar and you will always have a table of content for your posts. So I think that&#8217;s a really good use case for pages, when you have landing pages or tutorial pages or documentation pages that you don&#8217;t have to fiddle with it while you&#8217;re creating the content. And it&#8217;s just there in the template.</p>\n\n\n\n<p><em>Beth Soderberg: </em>This is one where my weird workaround for it. There&#8217;s one of the SEO plugins has a table of contents block built into it. I forget which one offhand, but I&#8217;ve used that before to get this type of functionality.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Because it. Sometimes you really just need it.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, absolutely. Yeah. Yeah. </p>\n\n\n\n<p>So that&#8217;s it. That is the Gutenberg changelog 122. Thank you so much for being with me on this, Beth. And it was great to chat with you and talk about block themes and all these good things. Block style stuff. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg:</em> Thanks for having me. It was fun.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. Dear listeners, as always, the show notes will be published on the <a href=\"http://gutenbergtimes.com/podcast\">gutenbergtimes.com/podcast</a>. This is 122. I already said that. But if you have questions or suggestions or news you want us to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a> that&#8217;s <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a> and I forgot a question for you, Beth. And that is if people want to get in touch with you, what is a good place to do that?</p>\n\n\n\n<p><em>Beth Soderberg: </em>You can find me in the WordPress slack under my name, Beth Soderberg. And then you can find me at work at our website, which is Bethink.studio or bethinkstudio.com. but you know, it&#8217;s really fun when you can get the non.coms to work with your name.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So. Yes, all right. So I&#8217;ll list of course, all those contact information, more in the show notes.</p>\n\n\n\n<p>And thank you all for listening. Thank you for being here and see you when I&#8217;ll see you back. Well, in two weeks. Goodbye, and have a good time. </p>\n\n\n\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 12 Oct 2025 10:58:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Matt: In Canada\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150205\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ma.tt/2025/10/in-canada/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:731:\"<p>I&#8217;ve been trying to find time in my calendar to attend more WordCamps as I love meeting <a href=\"https://ma.tt/2025/09/wordpresser/\">WordPressers</a> all over the world. The stars aligned, and I&#8217;ll be swinging by <a href=\"https://canada.wordcamp.org/2025/\">WordCamp Canada</a> next week. They&#8217;ve put together an amazing program, including open web pioneer and inventor Dave Winer, so I&#8217;m looking forward to checking out the sessions. I wish I could go to every WordCamp, like I used to! I&#8217;ve been recording videos and messages for those I can&#8217;t physically attend. Ottawa is also great as the only other commercial board I&#8217;m on is <a href=\"https://fieldeffect.com/\">Field Effect</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 11 Oct 2025 15:35:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"Matt: Twitter Hacked\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150193\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"https://ma.tt/2025/10/twitter-hacked/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:662:\"<p>Sorry everybody, my @photomatt on Twitter has been hacked, I&#8217;m trying to regain account access, but it is not currently in my control. <strong>Update: </strong>Thank you to the fine teams at X/Twitter and <a href=\"https://x.com/nikitabier\">Nikita Bier</a>, my account has been recovered. Just for future reference, I will never promote cryptocurrencies or similar investments. If you see anything from me or WordPress claiming that, be highly skeptical. Invest in open source, public stocks, and great companies like Automattic. <img alt=\"🙂\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f642.png\" style=\"height: 1em;\" /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 11 Oct 2025 00:34:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"Gutenberg Times: Mega Menus in core, WordPress 6.9 calls for testing, going from Elementor to Site Editor — Weekend Edition 344\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=42168\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:134:\"https://gutenbergtimes.com/mega-menus-in-core-wordpress-6-9-calls-for-testing-going-from-elementor-to-site-editor-weekend-edition-344/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:23251:\"<p>Howdy,</p>\n\n\n\n<p>After meeting so many people at WordCamp Gdynia, on the plane and then on the train, I caught a nasty cold and struggled all week. I call this stage mushbrain, and everything becomes much harder, especially reading comprehension suffers. I am over it now, though. It also wasn&#8217;t the first time that I sounded horsey on a podcast episode. </p>\n\n\n\n<p>It&#8217;s the time of year now here in Munich when the days get shorter and the weather is cold, drissly and overcast. A time when snow would brighten the sights, with its whiteness covering partly the darkgray, dark brown background. </p>\n\n\n\n<p>Enjoy again  this weekend edition  and stay healthy. </p>\n\n\n\n<p>Yours, <img alt=\"💕\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f495.png\" style=\"height: 1em;\" /><br /><em>Birgit</em></p>\n\n\n<section class=\"wp-block-newsletterglue-group\" style=\"padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;\">\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<nav class=\"wp-block-table-of-contents\"><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/mega-menus-in-core-wordpress-6-9-calls-for-testing-going-from-elementor-to-site-editor-weekend-edition-344/#0-word-press-release-information\">Developing Gutenberg and WordPress</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/mega-menus-in-core-wordpress-6-9-calls-for-testing-going-from-elementor-to-site-editor-weekend-edition-344/#help-testing-new-features-for-wordpress-6-9\">Help testing new features for WordPress 6.9</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/mega-menus-in-core-wordpress-6-9-calls-for-testing-going-from-elementor-to-site-editor-weekend-edition-344/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/mega-menus-in-core-wordpress-6-9-calls-for-testing-going-from-elementor-to-site-editor-weekend-edition-344/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/mega-menus-in-core-wordpress-6-9-calls-for-testing-going-from-elementor-to-site-editor-weekend-edition-344/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/mega-menus-in-core-wordpress-6-9-calls-for-testing-going-from-elementor-to-site-editor-weekend-edition-344/#what-s-new-in-and-around-playground\">What&#8217;s new in and around Playground</a></li></ol></li></ol></nav>\n</div></div>\n</section>\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\"></div>\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p>Gutenberg 21.8 is now available and release lead <strong>Carlos Bravo</strong> hightlighed in his release post <a href=\"https://make.wordpress.org/core/2025/10/08/whats-new-in-gutenberg-21-8-08-october/\"><strong>What’s new in Gutenberg 21.8? (8 October)</strong></a></p>\n\n\n\n<ol class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2025/10/08/whats-new-in-gutenberg-21-8-08-october/#block-visibility-support-ui\">Block Visibility Control Support and UI</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/10/08/whats-new-in-gutenberg-21-8-08-october/#block-comments-improvements\">Block Comments Improvements</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/10/08/whats-new-in-gutenberg-21-8-08-october/#accordion-time-to-read\">Accordion and Time To Read Blocks</a></li>\n</ol>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>This week <strong>Gutenberg Changelog 122</strong> recording, <strong>Beth Soderberg</strong>, lead developer at <a href=\"https://bethink.studio/\">Bethink.studio</a> and I chatted about the release and other WordPress topics around Block themes and on going change. The episode arrive at your favorite podcast app over the weekend. </p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p><img alt=\"🎙\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f399.png\" style=\"height: 1em;\" /> The latest episode is <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-123-wordpress-6-9-and-gutenberg-21-9/\">Gutenberg Changelog #123 – WordPress 6.9 and Gutenberg 21.9</a> with Isabel Brison, core contributor. </p>\n\n\n\n<figure class=\"wp-block-image size-full is-style-no-vertical-margin\"><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-123-wordpress-6-9-and-gutenberg-21-9/\"><img alt=\"\" class=\"wp-image-42384\" height=\"185\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/Screenshot-2025-10-23-at-17.20.50.png?resize=652%2C185&#038;ssl=1\" width=\"652\" /></a></figure>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-rich is-provider-pocket-casts wp-block-embed-pocket-casts\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div></div></div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>It was <strong>JuanMa Garrido</strong>&#8216;s turn to write the monthly roundup post <a href=\"https://developer.wordpress.org/news/2025/10/whats-new-for-developers-october-2025/\"><strong>What’s new for developers? (October 2025)</strong></a> on the WordPress Developer Blog. The 21.6, 21.7, and 21.8 Gutenberg releases add features for developers. The Command Palette now works throughout the admin, the new Terms Query block makes taxonomy layouts easier, and Block Visibility controls allow for conditional display. Notes (that&#8217;s how we call Block Comments now) improve team collaboration, while content-only editing maintains design integrity during client handoffs.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"help-testing-new-features-for-wordpress-6-9\">Help testing new features for WordPress 6.9</h3>\n\n\n\n<p>Release test co-leads <strong>Krupa Nanda</strong> and <strong>Jonathan Bossenger</strong>, published several calls for testing in preparation in WordPress of the 6.9 release. Each of the post has a detailed description of the feature, and instructions on how to test is with specific scenarios. It&#8217;s much easier to follow along with any of the calls for testing, to also learn what&#8217;s new in the next release. </p>\n\n\n\n<p><a href=\"https://make.wordpress.org/test/2025/10/03/help-test-changes-to-template-management/\"><strong>Help test changes to template management</strong></a> is probably the most elaborate call for testing, as template management received a completely new feature, and it needs to be working for many different use cases, and has consquences on existing sites.</p>\n\n\n\n<p><a href=\"https://make.wordpress.org/test/2025/10/04/call-for-testing-ability-to-hide-blocks/\"><strong>Call for Testing: Ability to Hide Blocks</strong></a> for this feature it&#8217;s the bare minimum of a new feature, that will be in future releases see some refinement and extensiblity. </p>\n\n\n\n<p><a href=\"https://make.wordpress.org/test/2025/10/06/call-for-testing-accordion-block/\"><strong>Call for Testing: Accordion Block</strong></a> lets you dive into a whole new block, many users asked for an several plugins are already available for. Now it will come to core. </p>\n\n\n\n<p>Your time spent on testing the new features for WordPress 6.9, has a lot of impact, as the bugs found now, make the release the best it can be for millions of other users. </p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p><strong>Lesley Sim</strong> informed us that <a href=\"https://wordpress.org/plugins/eventkoi-lite/\"><strong>EventKoi Lite</strong></a> is now available from the WordPress Plugin Repository. I mentioned the premium version before, Event Koi is modern, WordPress events calendar. Create single or multi-day events and display month, week, or list views via blocks (or shortcodes).</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Mike McAlister </strong>announced a new product: <strong>OlliePro Extensions</strong> on Bluesky. He mentions: Animations, advanced grid + column controls, keyboard shortcuts, and more. Watch the vidoe <a href=\"https://www.youtube.com/watch?v=qq2DLc43pTk\"><strong>Introducing Ollie Pro Extensions &#8211; Supercharge Your WordPress Block Editor</strong></a></p>\n\n\n\n<p>All controls are seamlessly integrated with the Core editor sitebar sections. <strong>Mark Howells-Mead</strong> <a href=\"https://wordpress.slack.com/archives/C015GUFFC00/p1760046957248569\">commented</a> in the WordPress Slack #outreach channel: &#8221; I’m very impressed with how he’s been able to integrate the little add-ons many of us are integrating to our own projects, but in such a seamless way by extending core controls.&#8221;  McAlister shared an <a href=\"https://gist.github.com/mikemcalister/937664ea19e87d61add7fc9902f10ac9\">example Gist on GitHub</a>.</p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>David McCan</strong> took a deep dive into the world of Block plugins. In this blog post   <a href=\"https://dynamicwp.co/performance-of-third-party-blocks-and-core-compared/\"><strong>Performance of Third Party Blocks and Core Compared</strong></a> he tries to answer the questions many site builders and owners have: &#8220;Can you add the features Gutenberg is missing yet still be performant like core?&#8221;. McCan tested ten third-party Gutenberg block plugins with WordPress core, specifically focusing on performance.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Matt Medeiros</strong>, WPMinute, took the <em>Mega Menu Designer</em>, also made  by Mike McAlister, out for the spin. He shared his thoughts in the Video <a href=\"https://www.youtube.com/watch?v=7NYskePLDM0#feedback\"><strong>How to Build Mega Menus with WordPress Blocks</strong></a>. He provides a detailed walkthrough calls it &#8220;Perfect for anyone looking to enhance their website&#8217;s navigation experience.&#8221; As reported earlier <a href=\"https://wordpress.org/plugins/ollie-menu-designer/\">the plugin is available for free</a> in the WordPress plugin repository. </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<p><strong>Rae Morey</strong>, publisher or The Repository, reported <strong><a href=\"https://www.therepository.email/ollies-menu-designer-flagged-for-core-with-automattic-developers-set-to-help-shepherd-it?utm_source=mailpoet&amp;utm_medium=email&amp;utm_source_platform=mailpoet&amp;utm_campaign=issue-276\">Ollie&#8217;s Menu Designer Flagged for Core, With Automattic Developers Set to Help Shepherd It</a></strong>. Automattic&#8217;s Anne McCarthy says developers are preparing to review Ollie&#8217;s Menu Designer for inclusion in the Gutenberg plugin, marking the start of a collaborative push to bring the plugin&#8217;s features into WordPress. This follows WordPress co-founder Matt Mullenweg&#8217;s suggestion that the menu functionality should be part of core. Details and links in Moery&#8217;s article. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p>This episode of <em>Greyd Conversations</em> show, <strong><a href=\"https://www.youtube.com/watch?v=cRM4FjR_UbE\">Switching to FSE from a pagebuilder</a>, </strong>covers the story of <em>Buro Staal</em>, a smal dutch agency, which switched from Elementor to Full site editing cold turkey. Greyd&#8217;s host <strong>Sandra Kurze</strong> and agency owner <strong>Rosanne van Staalduinen</strong> shared why and how her agency switched and the lessons learned along the way. </p>\n\n\n\n<p>The biggest hurdles were limited functionality of navigation block, not able to create Mega Menus, and the need for controls for mobile sites and responsiveness. So they augmented their tech stack with Kadence Blocks and Ollie Pro theme. </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n<section class=\"wp-block-newsletterglue-callout undefined not-color-set\" style=\"border-color: #f9f9e5; border-radius: 22px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f9f9e5;\">\n<p><strong> <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" rel=\"noreferrer noopener\" target=\"_blank\">&#8220;Keeping up with Gutenberg &#8211; Index 2025&#8221;</a> </strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. The previous years are also available: <strong><strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">2020</a> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/\">2021</a></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/\">2022</a></strong></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023\">2023</a></strong> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2024/\"><strong>2024</strong></a></p>\n</section>\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor</h2>\n\n\n\n<p><strong>Ryan Welcher</strong> published another recipe from his Blockdevelopment Cook Book on YouTube.  <strong><a href=\"https://www.youtube.com/watch?v=dJ4gUrxTgjM\">How To Make A Simple Fade In Effect Fast</a></strong>. &#8220;In this recipe, we’re adding a little flair by loading custom JavaScript and CSS for the Cover and Image blocks to create a smooth fade-in effect as they scroll into view. To keep things efficient, we’ll only enqueue these files when the blocks are actually on the page.&#8221; </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<h3 class=\"wp-block-heading\" id=\"what-s-new-in-and-around-playground\">What&#8217;s new in and around Playground</h3>\n\n\n\n<p><strong>Nick Diego</strong> announces that <a href=\"https://wordpress.com/blog/2025/10/08/introducing-blueprints-in-wordpress-studio-1-6-0/\"><strong>WordPress Studio version 1.6.0</strong></a> now supports Blueprints, which are lightweight JSON files that predefine site configurations for quick and consistent setup. Instead of starting with empty sites or using large snapshots, teams can create portable recipes specifying WordPress versions, plugins, and settings. Studio offers three featured blueprints for quick starts, development, and commerce, while users can also upload custom blueprints. The feature integrates into the standard site creation flow and helps streamline workflows for solo developers and teams alike.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><a href=\"https://wordpress.github.io/wordpress-playground/\"><strong>Playground documentation</strong></a> now has Ask AI button, to get help finding and understanding feature sets and APIs.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://wordpress.github.io/wordpress-playground/\"><img alt=\"\" class=\"wp-image-42203\" height=\"339\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/Screenshot-2025-10-09-at-18.50.23.png?resize=652%2C339&#038;ssl=1\" width=\"652\" /></a></figure>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Ajit Bohra</strong> of Lubus <a href=\"https://x.com/ajitbohra/status/1975920964266258538\">shared on X</a> &#8220;The Visual BluePrint Builder for Playground is shaping up nicely. All the latest updates are in, and it’s feeling solid. Stable version coming soon, but you can already check it out and start building visually.&#8221; A blueprint builder with blocks, how nice.  You can test it via <a href=\"https://playground.wordpress.net/?blueprint-url=https%3A%2F%2Fraw.githubusercontent.com%2FlubusIN%2Fvisual-blueprint-builder%2Fplayground%2F_playground%2Fblueprint-github.json\">this Playground link</a>. The code is available on <a href=\"https://github.com/lubusIN/visual-blueprint-builder\">GitHub</a>. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Jamie Marsland</strong> also tries to make it easier to create blueprints for Playground sites and open up the WordPress in a browser tool for a broader audience. Details in his post <a href=\"https://www.pootlepress.com/2025/10/introducing-pootle-playground-my-experimental-wordpress-blueprint-builder/\" rel=\"noreferrer noopener\" target=\"_blank\"><strong>Introducing Pootle Playground — My Experimental WordPress Blueprint Builder</strong></a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Adam Zielinski</strong> created an <a href=\"https://playground.wordpress.net/php-playground.html\"><strong>online PHP code editor</strong></a> using Playground. It allows developers to test PHP snippets quickly in their browser. The tool supports WordPress functions, enables switching between PHP and WordPress versions, and allows sharing code configurations through links. Built with WordPress Playground, it runs entirely client-side with network access and popular PHP extensions included. He&#8217;s currently experimenting with adding CLI and file browser capabilities to support composer packages and frameworks like Laravel or Symfony.</p>\n\n\n<section class=\"wp-block-newsletterglue-callout undefined not-color-set\" style=\"border-color: #eeeeee; border-radius: 26px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f3efe9;\">\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. </p>\n\n\n\n<p>Now also available via <a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href=\"mailto:pauli@gutenbergtimes.com\">Email me </a>with your experience</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n</section>\n\n\n<p class=\"has-text-align-center has-small-font-size\"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, <br />send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n<section class=\"wp-block-newsletterglue-group\" style=\"padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;\">\n<p>Featured Image: Free colorful building blocks image by <a href=\"https://www.rawpixel.com/image/5906195/photo-image-public-domain-free-game\">Rawpixel </a></p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n<form action=\"https://gutenbergtimes.com/feed/\" autocomplete=\"on\" class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\" style=\"margin-bottom: 25px;\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input autocomplete=\"email\" class=\"ngl-form-input-text\" id=\"ngl_email\" name=\"ngl_email\" required=\"required\" style=\"border-radius: 21px;\" type=\"email\" /></div></div><button class=\"ngl-form-button\" style=\"background-color: #005075; border-color: #005075; border-width: 1px; border-style: solid; color: #ffffff; border-radius: 21px;\" type=\"submit\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too, and won&#8217;t give your email address to anyone <br />except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"><svg fill=\"none\" height=\"24\" stroke=\"#fff\" stroke-width=\"2\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><polyline points=\"20 6 9 17 4 12\"></polyline></svg></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input id=\"ngl_list_id\" name=\"ngl_list_id\" type=\"hidden\" value=\"26f81bd8ae\" /><input id=\"ngl_double_optin\" name=\"ngl_double_optin\" type=\"hidden\" value=\"yes\" /></form>\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n</section>\n\n\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 10 Oct 2025 23:35:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Matt: Jeremy Kranz and Sentinel\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150173\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ma.tt/2025/10/jeremy-kranz/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2487:\"<p>I&#8217;d like to introduce you to <a href=\"https://www.linkedin.com/in/jeremykranz/\">Jeremy Kranz</a>. With his career as an investor at <a href=\"https://www.intelcapital.com/\">Intel Capital</a>, then <a href=\"https://en.wikipedia.org/wiki/GIC_(sovereign_wealth_fund)\">GIC</a>, which is the sovereign wealth fund of Singapore rumored to manage over $700B, to now running his own fund <a href=\"https://www.sentinelglobal.xyz/\">Sentinel Global</a>, he has had a front-row seat to investments in industry changing companies such as ByteDance (which became TikTok), Alibaba, Uber, DoorDash, Zoom, DJI (which changed the drone industry and argubly modern warfare), and many more I&#8217;m probably not even aware of.</p>\n\n\n\n<p>When I first met Jeremy in 2014, I was amazed that a late-stage financial investor could understand Open Source so well, and he immediately grokked what <a href=\"https://automattic.com/\">Automattic</a> was doing in a way that I think has little parallel in the world. (Today, it reminds me of Joseph Jacks at <a href=\"https://oss.capital/\">OSS Capital</a>.) <a href=\"https://www.insightpartners.com/team/deven-parekh/\">Deven Perekh of Insight Partners</a> led Automattic&#8217;s 1.16B valuation Series C round, making us one of only forty &#8220;unicorns&#8221; (private companies valued over a billion dollars) at the time, and one of the reasons they beat out others as the lead of the round was that GIC/Jeremy was a LP of Insight so they could directly co-invest. GIC is so intensely private <a href=\"https://ma.tt/2014/05/new-funding-for-automattic/\">I couldn&#8217;t even mention them in the announcement at the time</a> even though they were the catalyst for the round.  Since then, Jeremy has become a close friend and advisor, and he even took me to <a href=\"https://www.nugs.net/live-download-of-dead-and-company-dos-equis-pavilion-dallas-tx-10-14-2021-mp3-flac-or-online-music-streaming/26749.html\">my first Grateful Dead concert</a>.</p>\n\n\n\n<p>Eleven years later, this is his first podcast! Jeremy shares incredible <a href=\"https://www.investopedia.com/terms/a/alpha.asp\">alpha</a> around China, AI and its adoption in the enterprise, how asset allocation is evolving, and at the end, a beautiful tie together of the Grateful Dead and Open Source.</p>\n\n\n\n<figure class=\"wp-block-embed alignwide is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 10 Oct 2025 19:30:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Matt: Kathy Sierra\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150166\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ma.tt/2025/10/kathy-sierra/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:774:\"<p>I was reminded today of the profound marketing influence of <a href=\"https://en.wikipedia.org/wiki/Kathy_Sierra\">Kathy Sierra</a>, who was a pretty prolific blogger and speaker back in the day. I would summarize her thesis as such: <strong>Your best marketing and communication should talk about how you make your users awesome, not how you&#8217;re awesome</strong>. If you&#8217;d like to check out some of her talks, <a href=\"https://href.li/?https://wordpress.tv/2008/10/31/wordcamp-sf-2008-kathy-sierra-kicking-ass-and-creating-passionate-users/\">she spoke at WordCamp in 2008</a>, <a href=\"https://vimeo.com/81625882?fl=pl&amp;fe=ti\">at Business of Software in 2013</a>, and at <a href=\"https://www.youtube.com/watch?v=iBtcGwHPMKM\">Mind the Product in 2015</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 10 Oct 2025 01:22:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Mon, 03 Nov 2025 09:55:22 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:13:\"last-modified\";s:29:\"Mon, 03 Nov 2025 09:45:19 GMT\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:2:\"br\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";i:1727736620;s:21:\"cache_expiration_time\";i:1762206869;s:23:\"__cache_expiration_time\";i:1762206869;}", "off");
INSERT INTO `wp2n_options` VALUES("190", "_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1762206870", "off");
INSERT INTO `wp2n_options` VALUES("191", "_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1762163670", "off");
INSERT INTO `wp2n_options` VALUES("192", "_transient_timeout_dash_v2_88ae138922fe95674369b1cb3d215a2b", "1762206870", "off");
INSERT INTO `wp2n_options` VALUES("193", "_transient_dash_v2_88ae138922fe95674369b1cb3d215a2b", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2025/10/wordpress-6-9-beta-2/\'>WordPress 6.9 Beta 2</a></li><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2025/09/wordpress-6-8-3-release/\'>WordPress 6.8.3 Release</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://ma.tt/2025/11/chop-carry/\'>Matt: Chop Wood, Carry Water</a></li><li><a class=\'rsswidget\' href=\'https://ma.tt/2025/11/creed-update/\'>Matt: Creed Update</a></li><li><a class=\'rsswidget\' href=\'https://ma.tt/2025/10/wayback/\'>Matt: Wayback Machine Joint</a></li></ul></div>", "off");
INSERT INTO `wp2n_options` VALUES("195", "widget_akismet_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp2n_options` VALUES("196", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1762174502", "off");
INSERT INTO `wp2n_options` VALUES("197", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "O:8:\"stdClass\":100:{s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";i:7619;}s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";i:4934;}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";i:2801;}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";i:2767;}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";i:2149;}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";i:2121;}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";i:2084;}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";i:1963;}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";i:1684;}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";i:1652;}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";i:1621;}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";i:1559;}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";i:1516;}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";i:1515;}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";i:1498;}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";i:1361;}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";i:1346;}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";i:1316;}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";i:1276;}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";i:1179;}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";i:1162;}s:7:\"payment\";a:3:{s:4:\"name\";s:7:\"payment\";s:4:\"slug\";s:7:\"payment\";s:5:\"count\";i:1070;}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";i:1067;}s:5:\"block\";a:3:{s:4:\"name\";s:5:\"block\";s:4:\"slug\";s:5:\"block\";s:5:\"count\";i:1067;}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";i:1065;}s:9:\"gutenberg\";a:3:{s:4:\"name\";s:9:\"gutenberg\";s:4:\"slug\";s:9:\"gutenberg\";s:5:\"count\";i:1051;}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";i:1050;}s:9:\"elementor\";a:3:{s:4:\"name\";s:9:\"elementor\";s:4:\"slug\";s:9:\"elementor\";s:5:\"count\";i:1013;}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";i:1009;}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";i:972;}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";i:949;}s:15:\"payment-gateway\";a:3:{s:4:\"name\";s:15:\"payment gateway\";s:4:\"slug\";s:15:\"payment-gateway\";s:5:\"count\";i:940;}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";i:935;}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";i:926;}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";i:914;}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";i:892;}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";i:868;}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";i:817;}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";i:786;}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";i:784;}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";i:771;}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";i:770;}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";i:763;}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";i:756;}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";i:721;}s:2:\"ai\";a:3:{s:4:\"name\";s:2:\"AI\";s:4:\"slug\";s:2:\"ai\";s:5:\"count\";i:721;}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";i:713;}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"ajax\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";i:705;}s:11:\"performance\";a:3:{s:4:\"name\";s:11:\"performance\";s:4:\"slug\";s:11:\"performance\";s:5:\"count\";i:704;}s:8:\"shipping\";a:3:{s:4:\"name\";s:8:\"shipping\";s:4:\"slug\";s:8:\"shipping\";s:5:\"count\";i:688;}s:4:\"chat\";a:3:{s:4:\"name\";s:4:\"chat\";s:4:\"slug\";s:4:\"chat\";s:5:\"count\";i:687;}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";i:684;}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";i:676;}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";i:665;}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";i:659;}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";i:646;}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";i:645;}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";i:641;}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"css\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";i:636;}s:14:\"contact-form-7\";a:3:{s:4:\"name\";s:14:\"contact form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"count\";i:633;}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";i:624;}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";i:617;}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";i:614;}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";i:611;}s:5:\"forms\";a:3:{s:4:\"name\";s:5:\"forms\";s:4:\"slug\";s:5:\"forms\";s:5:\"count\";i:611;}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";i:610;}s:6:\"blocks\";a:3:{s:4:\"name\";s:6:\"blocks\";s:4:\"slug\";s:6:\"blocks\";s:5:\"count\";i:605;}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";i:592;}s:5:\"popup\";a:3:{s:4:\"name\";s:5:\"popup\";s:4:\"slug\";s:5:\"popup\";s:5:\"count\";i:581;}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";i:580;}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";i:580;}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";i:579;}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";i:572;}s:8:\"payments\";a:3:{s:4:\"name\";s:8:\"payments\";s:4:\"slug\";s:8:\"payments\";s:5:\"count\";i:572;}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";i:570;}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";i:557;}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";i:539;}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";i:532;}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";i:530;}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";i:527;}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";i:520;}s:8:\"checkout\";a:3:{s:4:\"name\";s:8:\"checkout\";s:4:\"slug\";s:8:\"checkout\";s:5:\"count\";i:517;}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";i:511;}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";i:508;}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";i:505;}s:7:\"gateway\";a:3:{s:4:\"name\";s:7:\"gateway\";s:4:\"slug\";s:7:\"gateway\";s:5:\"count\";i:482;}s:8:\"redirect\";a:3:{s:4:\"name\";s:8:\"redirect\";s:4:\"slug\";s:8:\"redirect\";s:5:\"count\";i:478;}s:6:\"import\";a:3:{s:4:\"name\";s:6:\"import\";s:4:\"slug\";s:6:\"import\";s:5:\"count\";i:476;}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";i:472;}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";i:471;}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";i:465;}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";i:459;}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";i:458;}s:5:\"cache\";a:3:{s:4:\"name\";s:5:\"cache\";s:4:\"slug\";s:5:\"cache\";s:5:\"count\";i:449;}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"news\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";i:442;}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";i:430;}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";i:427;}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";i:423;}s:8:\"products\";a:3:{s:4:\"name\";s:8:\"products\";s:4:\"slug\";s:8:\"products\";s:5:\"count\";i:422;}s:13:\"gravity-forms\";a:3:{s:4:\"name\";s:13:\"gravity forms\";s:4:\"slug\";s:13:\"gravity-forms\";s:5:\"count\";i:420;}}", "off");
INSERT INTO `wp2n_options` VALUES("200", "finished_updating_comment_type", "1", "auto");
INSERT INTO `wp2n_options` VALUES("218", "elementor_pro_license_key", "*********", "auto");
INSERT INTO `wp2n_options` VALUES("219", "_elementor_pro_license_v2_data", "a:2:{s:7:\"timeout\";i:1762224311;s:5:\"value\";s:71:\"{\"success\":true,\"license\":\"valid\",\"expires\":\"01.01.2030\",\"features\":[]}\";}", "auto");
INSERT INTO `wp2n_options` VALUES("220", "ai1wm_secret_key", "a4KISWMnpz7X", "auto");
INSERT INTO `wp2n_options` VALUES("221", "wpcf7", "a:2:{s:7:\"version\";s:5:\"6.1.3\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1762164677;s:7:\"version\";s:5:\"6.1.3\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "auto");
INSERT INTO `wp2n_options` VALUES("222", "elementor_active_kit", "8", "auto");
INSERT INTO `wp2n_options` VALUES("223", "elementor_font_display", "swap", "auto");
INSERT INTO `wp2n_options` VALUES("227", "eael_setup_wizard", "init", "auto");
INSERT INTO `wp2n_options` VALUES("228", "eael_save_settings", "a:70:{s:9:\"post-grid\";i:1;s:13:\"post-timeline\";i:1;s:10:\"fancy-text\";i:1;s:12:\"creative-btn\";i:1;s:10:\"count-down\";i:1;s:12:\"team-members\";i:1;s:12:\"testimonials\";i:1;s:8:\"info-box\";i:1;s:8:\"flip-box\";i:1;s:14:\"call-to-action\";i:1;s:11:\"dual-header\";i:1;s:11:\"price-table\";i:1;s:12:\"twitter-feed\";i:1;s:13:\"facebook-feed\";i:1;s:19:\"advanced-data-table\";i:1;s:10:\"data-table\";i:1;s:14:\"filter-gallery\";i:1;s:15:\"image-accordion\";i:1;s:14:\"content-ticker\";i:1;s:7:\"tooltip\";i:1;s:13:\"adv-accordion\";i:1;s:8:\"adv-tabs\";i:1;s:12:\"progress-bar\";i:1;s:12:\"feature-list\";i:1;s:12:\"product-grid\";i:1;s:16:\"woo-product-list\";i:1;s:17:\"woo-product-price\";i:1;s:18:\"woo-product-rating\";i:1;s:11:\"breadcrumbs\";i:1;s:12:\"code-snippet\";i:1;s:18:\"woo-product-images\";i:1;s:15:\"woo-add-to-cart\";i:1;s:14:\"contact-form-7\";i:1;s:7:\"weforms\";i:1;s:10:\"ninja-form\";i:1;s:9:\"formstack\";i:1;s:12:\"gravity-form\";i:1;s:12:\"caldera-form\";i:1;s:7:\"wpforms\";i:1;s:10:\"fluentform\";i:1;s:8:\"typeform\";i:1;s:24:\"betterdocs-category-grid\";i:1;s:23:\"betterdocs-category-box\";i:1;s:22:\"betterdocs-search-form\";i:1;s:12:\"sticky-video\";i:1;s:14:\"event-calendar\";i:1;s:10:\"embedpress\";i:1;s:12:\"woo-checkout\";i:1;s:8:\"woo-cart\";i:1;s:14:\"login-register\";i:1;s:11:\"career-page\";i:1;s:19:\"woo-product-compare\";i:1;s:20:\"woo-product-carousel\";i:1;s:11:\"simple-menu\";i:1;s:19:\"woo-product-gallery\";i:1;s:18:\"interactive-circle\";i:1;s:14:\"better-payment\";i:1;s:11:\"nft-gallery\";i:1;s:16:\"business-reviews\";i:1;s:8:\"svg-draw\";i:1;s:9:\"promotion\";i:1;s:9:\"custom-js\";i:1;s:16:\"reading-progress\";i:1;s:16:\"table-of-content\";i:1;s:15:\"post-duplicator\";i:1;s:13:\"scroll-to-top\";i:1;s:12:\"wrapper-link\";i:1;s:20:\"special-hover-effect\";i:1;s:19:\"liquid-glass-effect\";i:1;s:13:\"image-masking\";i:1;}", "auto");
INSERT INTO `wp2n_options` VALUES("229", "_transient_timeout_jetpack_file_data_15.1.1", "1764670284", "off");
INSERT INTO `wp2n_options` VALUES("230", "_transient_jetpack_file_data_15.1.1", "a:1:{s:32:\"3fd340ad52927afb3bbb9e98575eccfd\";a:15:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:24:\"requires_user_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";s:12:\"plan_classes\";s:0:\"\";}}", "off");
INSERT INTO `wp2n_options` VALUES("231", "jetpack_available_modules", "a:1:{s:6:\"15.1.1\";a:43:{s:18:\"account-protection\";s:4:\"14.5\";s:5:\"blaze\";s:4:\"12.3\";s:6:\"blocks\";s:8:\"13.9-a.8\";s:8:\"carousel\";s:3:\"1.5\";s:13:\"comment-likes\";s:3:\"5.1\";s:8:\"comments\";s:3:\"1.4\";s:12:\"contact-form\";s:3:\"1.3\";s:9:\"copy-post\";s:3:\"7.0\";s:20:\"custom-content-types\";s:3:\"3.1\";s:12:\"google-fonts\";s:6:\"10.8.0\";s:19:\"gravatar-hovercards\";s:3:\"1.1\";s:15:\"infinite-scroll\";s:3:\"2.0\";s:8:\"json-api\";s:3:\"1.9\";s:5:\"latex\";s:3:\"1.1\";s:5:\"likes\";s:3:\"2.2\";s:8:\"markdown\";s:3:\"2.8\";s:7:\"monitor\";s:3:\"2.6\";s:5:\"notes\";s:3:\"1.9\";s:10:\"photon-cdn\";s:3:\"6.6\";s:6:\"photon\";s:3:\"2.0\";s:13:\"post-by-email\";s:3:\"2.0\";s:9:\"post-list\";s:4:\"11.3\";s:7:\"protect\";s:3:\"3.4\";s:9:\"publicize\";s:3:\"2.0\";s:13:\"related-posts\";s:3:\"2.9\";s:6:\"search\";s:3:\"5.0\";s:9:\"seo-tools\";s:3:\"4.4\";s:10:\"sharedaddy\";s:3:\"1.1\";s:10:\"shortcodes\";s:3:\"1.1\";s:10:\"shortlinks\";s:3:\"1.1\";s:8:\"sitemaps\";s:3:\"3.9\";s:3:\"sso\";s:3:\"2.6\";s:5:\"stats\";s:3:\"1.1\";s:13:\"subscriptions\";s:3:\"1.2\";s:13:\"tiled-gallery\";s:3:\"2.1\";s:10:\"vaultpress\";s:5:\"0:1.2\";s:18:\"verification-tools\";s:3:\"3.0\";s:10:\"videopress\";s:3:\"2.5\";s:3:\"waf\";s:4:\"10.9\";s:17:\"widget-visibility\";s:3:\"2.4\";s:7:\"widgets\";s:3:\"1.2\";s:21:\"woocommerce-analytics\";s:3:\"8.4\";s:7:\"wordads\";s:5:\"4.5.0\";}}", "auto");
INSERT INTO `wp2n_options` VALUES("232", "jetpack_activated", "1", "auto");
INSERT INTO `wp2n_options` VALUES("235", "jetpack_activation_source", "a:2:{i:0;s:7:\"unknown\";i:1;N;}", "auto");
INSERT INTO `wp2n_options` VALUES("236", "jetpack_sync_settings_disable", "0", "on");
INSERT INTO `wp2n_options` VALUES("237", "woocommerce_analytics_proxy_speed_module_version", "1.0.0", "auto");
INSERT INTO `wp2n_options` VALUES("238", "jetpack_options", "a:3:{s:7:\"version\";s:17:\"15.1.1:1762164686\";s:11:\"old_version\";s:17:\"15.1.1:1762164686\";s:14:\"last_heartbeat\";i:1762164733;}", "auto");
INSERT INTO `wp2n_options` VALUES("239", "fs_active_plugins", "O:8:\"stdClass\":3:{s:7:\"plugins\";a:1:{s:31:\"royal-elementor-addons/freemius\";O:8:\"stdClass\":4:{s:7:\"version\";s:6:\"2.12.0\";s:4:\"type\";s:6:\"plugin\";s:9:\"timestamp\";i:1762164686;s:11:\"plugin_path\";s:37:\"royal-elementor-addons/wpr-addons.php\";}}s:7:\"abspath\";s:27:\"/home/nfubmbpl/public_html/\";s:6:\"newest\";O:8:\"stdClass\":5:{s:11:\"plugin_path\";s:37:\"royal-elementor-addons/wpr-addons.php\";s:8:\"sdk_path\";s:31:\"royal-elementor-addons/freemius\";s:7:\"version\";s:6:\"2.12.0\";s:13:\"in_activation\";b:0;s:9:\"timestamp\";i:1762164686;}}", "auto");
INSERT INTO `wp2n_options` VALUES("240", "fs_debug_mode", "", "auto");
INSERT INTO `wp2n_options` VALUES("241", "fs_accounts", "a:6:{s:21:\"id_slug_type_path_map\";a:1:{i:8416;a:3:{s:4:\"slug\";s:10:\"wpr-addons\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:37:\"royal-elementor-addons/wpr-addons.php\";}}s:11:\"plugin_data\";a:1:{s:10:\"wpr-addons\";a:16:{s:19:\"last_load_timestamp\";i:1762164688;s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:37:\"royal-elementor-addons/wpr-addons.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1762164687;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:1;s:16:\"sdk_last_version\";N;s:11:\"sdk_version\";s:6:\"2.12.0\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";N;s:14:\"plugin_version\";s:8:\"1.7.1036\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";N;s:4:\"host\";s:18:\"dotmanfreightt.com\";s:9:\"server_ip\";s:11:\"54.37.90.54\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1762164687;s:7:\"version\";s:8:\"1.7.1036\";}s:15:\"prev_is_premium\";b:0;}}s:13:\"file_slug_map\";a:1:{s:37:\"royal-elementor-addons/wpr-addons.php\";s:10:\"wpr-addons\";}s:7:\"plugins\";a:1:{s:10:\"wpr-addons\";O:9:\"FS_Plugin\":24:{s:2:\"id\";s:4:\"8416\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:0;s:10:\"public_key\";s:32:\"pk_a0b21b234a7c9581a555b9ee9f28a\";s:10:\"secret_key\";N;s:16:\"parent_plugin_id\";N;s:5:\"title\";s:22:\"Royal Elementor Addons\";s:4:\"slug\";s:10:\"wpr-addons\";s:12:\"premium_slug\";s:14:\"wpr-addons-pro\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";s:8:\"selected\";s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:37:\"royal-elementor-addons/wpr-addons.php\";s:7:\"version\";s:8:\"1.7.1036\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:17:\"opt_in_moderation\";N;}}s:12:\"gc_timestamp\";a:0:{}s:10:\"theme_data\";a:0:{}}", "auto");
INSERT INTO `wp2n_options` VALUES("242", "fs_api_cache", "a:0:{}", "off");
INSERT INTO `wp2n_options` VALUES("247", "royal_elementor_addons_activation_time", "1762164694", "auto");
INSERT INTO `wp2n_options` VALUES("248", "royal_elementor_addons_activation_time_for_sale", "1762164694", "auto");
INSERT INTO `wp2n_options` VALUES("251", "uae_lite_is_activated", "yes", "auto");
INSERT INTO `wp2n_options` VALUES("253", "wordfence_ls_version", "1.1.15", "auto");
INSERT INTO `wp2n_options` VALUES("254", "elementor_cpt_support", "a:3:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:13:\"wpr_templates\";}", "auto");
INSERT INTO `wp2n_options` VALUES("255", "elementor_landing_pages_activation", "0", "auto");
INSERT INTO `wp2n_options` VALUES("257", "elementor_checklist", "{\"last_opened_timestamp\":null,\"first_closed_checklist_in_editor\":false,\"is_popup_minimized\":false,\"steps\":{\"add_logo\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"set_fonts_and_colors\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"create_pages\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"assign_homepage\":{\"is_marked_completed\":false,\"is_immutable_completed\":false}},\"should_open_in_editor\":false}", "auto");
INSERT INTO `wp2n_options` VALUES("260", "elementor_version", "3.32.5", "auto");
INSERT INTO `wp2n_options` VALUES("261", "elementor_install_history", "a:1:{s:6:\"3.15.1\";i:1762164719;}", "auto");
INSERT INTO `wp2n_options` VALUES("262", "elementor_pro_version", "3.15.1", "auto");
INSERT INTO `wp2n_options` VALUES("264", "widget_elementor-library", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp2n_options` VALUES("265", "eael_version", "6.4.0", "auto");
INSERT INTO `wp2n_options` VALUES("267", "wfls_last_role_change", "1762164725", "off");
INSERT INTO `wp2n_options` VALUES("268", "wordfence_version", "8.1.0", "auto");
INSERT INTO `wp2n_options` VALUES("269", "wordfence_case", "1", "auto");
INSERT INTO `wp2n_options` VALUES("270", "elementor_events_db_version", "1.0.0", "off");
INSERT INTO `wp2n_options` VALUES("271", "_transient_googlesitekit_verification_meta_tags", "a:0:{}", "on");
INSERT INTO `wp2n_options` VALUES("272", "_site_transient_timeout_fs_garbage_collection", "1762251128", "off");
INSERT INTO `wp2n_options` VALUES("273", "_site_transient_fs_garbage_collection", "1", "off");
INSERT INTO `wp2n_options` VALUES("274", "_hfe_db_version", "2.6.1", "auto");
INSERT INTO `wp2n_options` VALUES("275", "_transient_jetpack_autoloader_plugin_paths", "a:1:{i:0;s:25:\"{{WP_PLUGIN_DIR}}/jetpack\";}", "on");
INSERT INTO `wp2n_options` VALUES("277", "jetpack_sync_https_history_home_url", "a:1:{i:0;s:5:\"https\";}", "auto");
INSERT INTO `wp2n_options` VALUES("278", "jetpack_sync_https_history_site_url", "a:1:{i:0;s:5:\"https\";}", "auto");
INSERT INTO `wp2n_options` VALUES("281", "_elementor_pro_installed_time", "1762164736", "auto");
INSERT INTO `wp2n_options` VALUES("284", "do_activate", "0", "auto");
INSERT INTO `wp2n_options` VALUES("285", "_transient_timeout_jetpack_https_test", "1762251170", "off");
INSERT INTO `wp2n_options` VALUES("286", "_transient_jetpack_https_test", "1", "off");
INSERT INTO `wp2n_options` VALUES("287", "_transient_timeout_jetpack_https_test_message", "1762251170", "off");
INSERT INTO `wp2n_options` VALUES("288", "_transient_jetpack_https_test_message", "", "off");
INSERT INTO `wp2n_options` VALUES("289", "jetpack_waf_needs_update", "", "auto");
INSERT INTO `wp2n_options` VALUES("290", "astra_sites_recent_import_log_file", "/home/nfubmbpl/public_html/wp-content/uploads/astra-sites/import-03-Nov-2025-10-12-51-3a4c8914b05e44b4f38d06a4dba14143.log", "off");
INSERT INTO `wp2n_options` VALUES("291", "_site_transient_timeout_astra-sites-import-check", "1762769571", "off");
INSERT INTO `wp2n_options` VALUES("292", "_site_transient_astra-sites-import-check", "true", "off");
INSERT INTO `wp2n_options` VALUES("294", "astra-sites-last-export-checksums-latest", "oQdj4Gm!P*xp", "off");
INSERT INTO `wp2n_options` VALUES("295", "_transient_timeout_astra-sites-cron-test-ok", "1762168375", "off");
INSERT INTO `wp2n_options` VALUES("296", "_transient_astra-sites-cron-test-ok", "1", "off");
INSERT INTO `wp2n_options` VALUES("297", "astra-sites-batch-status-string", "All processes are complete", "off");
INSERT INTO `wp2n_options` VALUES("298", "astra-blocks-batch-status-string", "Complete storing data for page 4", "off");
INSERT INTO `wp2n_options` VALUES("299", "astra-sites-fresh-site", "no", "off");
INSERT INTO `wp2n_options` VALUES("300", "essential-addons-for-elementor-lite_notices", "a:3:{s:21:\"ea8th_birthday_notice\";a:4:{s:5:\"start\";i:1762164781;s:10:\"recurrence\";b:0;s:7:\"refresh\";s:5:\"6.4.0\";s:6:\"expire\";i:1754258400;}s:7:\"version\";s:5:\"1.1.0\";s:6:\"review\";a:3:{s:5:\"start\";i:1762769589;s:10:\"recurrence\";i:30;s:7:\"refresh\";s:5:\"6.4.0\";}}", "off");
INSERT INTO `wp2n_options` VALUES("301", "hfe_onboarding_triggered", "yes", "auto");
INSERT INTO `wp2n_options` VALUES("302", "hfe_plugin_previous_version", "2.6.1", "auto");
INSERT INTO `wp2n_options` VALUES("303", "hfe_plugin_version", "2.6.1", "auto");
INSERT INTO `wp2n_options` VALUES("304", "ai_builder_recent_import_log_file", "/home/nfubmbpl/public_html/wp-content/uploads/ai-builder/import-03-Nov-2025-10-13-13-3a4c8914b05e44b4f38d06a4dba14143.log", "off");
INSERT INTO `wp2n_options` VALUES("305", "googlesitekit_db_version", "1.163.0", "auto");
INSERT INTO `wp2n_options` VALUES("308", "wordfence_installed", "1", "auto");
INSERT INTO `wp2n_options` VALUES("312", "elementor_submissions_db_version", "5", "auto");
INSERT INTO `wp2n_options` VALUES("317", "uae_analytics_installed_time", "1762164858", "off");
INSERT INTO `wp2n_options` VALUES("318", "bsf_analytics_installed_time", "1762164858", "off");
INSERT INTO `wp2n_options` VALUES("319", "ast-block-templates-version", "2.4.10", "auto");
INSERT INTO `wp2n_options` VALUES("327", "_transient_timeout_zip_ai_auth_token", "1762251266", "off");
INSERT INTO `wp2n_options` VALUES("328", "_transient_zip_ai_auth_token", "", "off");
INSERT INTO `wp2n_options` VALUES("329", "elementskit-lite__banner_last_check", "1762164866", "auto");
INSERT INTO `wp2n_options` VALUES("330", "_transient_timeout_hfe_rollback_versions_2.6.1", "1762769667", "off");
INSERT INTO `wp2n_options` VALUES("331", "elementskit-lite__banner_data", "O:8:\"stdClass\":10:{s:8:\"10020931\";O:8:\"stdClass\":7:{s:2:\"id\";i:10020931;s:5:\"title\";s:29:\"Wpmet Halloween Own page 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1760486400;s:3:\"end\";i:1762128000;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:29:\"https://wpmet.com/wpnoticeh78\";s:11:\"button_text\";s:16:\"Save $2,936 Now!\";s:11:\"notice_body\";s:475:\"<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Wpmet’s Halloween Sale is live<em data-start=\"1852\" data-end=\"1881\">!</em></strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><strong>Save up to $2,936 on the All-in-One WordPress Plugin Bundle (78% OFF) </strong>Or <strong>enjoy up to 35% OFF</strong> on your favorite single plugins — <em data-start=\"794\" data-end=\"830\">ElementsKit, GutenKit, ShopEngine,</em> and more!!</p>\";s:12:\"notice_image\";s:64:\"https://api.wpmet.com/auth/wp-content/uploads/2025/10/78-Off.jpg\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10020929\";O:8:\"stdClass\":7:{s:2:\"id\";i:10020929;s:5:\"title\";s:30:\"Wpmet Halloween Dashboard 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1760486400;s:3:\"end\";i:1762128000;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:29:\"https://wpmet.com/wpnoticeh78\";s:11:\"button_text\";s:16:\"Save $2,936 Now!\";s:11:\"notice_body\";s:432:\"<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Wpmet’s Halloween Sale is live!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><strong>Save up to $2,936 on the All-in-One WordPress Plugin Bundle (78% OFF) </strong>Or <strong>enjoy up to 35% OFF</strong> on your favorite single plugins — <em data-start=\"794\" data-end=\"830\">ElementsKit, GutenKit, ShopEngine,</em> and more!!</p>\";s:12:\"notice_image\";s:64:\"https://api.wpmet.com/auth/wp-content/uploads/2025/10/78-Off.jpg\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10019444\";O:8:\"stdClass\":7:{s:2:\"id\";i:10019444;s:5:\"title\";s:27:\"Wpmet Birthday 2025 ownpage\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1753920000;s:3:\"end\";i:1755561600;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:26:\"https://wpmet.com/notice51\";s:11:\"button_text\";s:20:\"Claim Your Discount!\";s:11:\"notice_body\";s:589:\"<h3><strong style=\"color: #; text-transform: sentencecase; font-size: 14px;\"><span style=\"color: #e60073;\">Wpmet Birthday Sale!!</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, PopupKit, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10018928\";O:8:\"stdClass\":7:{s:2:\"id\";i:10018928;s:5:\"title\";s:29:\"Wpmet Birthday 2025 dashboard\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1753920000;s:3:\"end\";i:1755561600;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:26:\"https://wpmet.com/notice50\";s:11:\"button_text\";s:20:\"Claim Your Discount!\";s:11:\"notice_body\";s:589:\"<h3><strong style=\"color: #; text-transform: sentencecase; font-size: 14px;\"><span style=\"color: #e60073;\">Wpmet Birthday Sale!!</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, PopupKit, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10018688\";O:8:\"stdClass\":7:{s:2:\"id\";i:10018688;s:5:\"title\";s:42:\"Wpmet 4th of July Flash Sale 2025 Ownpages\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1751328000;s:3:\"end\";i:1752019200;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:26:\"https://wpmet.com/notice35\";s:11:\"button_text\";s:20:\"Claim Your Discount!\";s:11:\"notice_body\";s:585:\"<h3><strong style=\"color: #; text-transform: uppercase; font-size: 14px;\"><span style=\"color: #e60073;\">Happy 4th of July super Sale!!</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10018687\";O:8:\"stdClass\":7:{s:2:\"id\";i:10018687;s:5:\"title\";s:43:\"Wpmet 4th of July Flash Sale 2025 Dashboard\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1751328000;s:3:\"end\";i:1752019200;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:26:\"https://wpmet.com/notice35\";s:11:\"button_text\";s:20:\"Claim Your Discount!\";s:11:\"notice_body\";s:585:\"<h3><strong style=\"color: #; text-transform: uppercase; font-size: 14px;\"><span style=\"color: #e60073;\">Happy 4th of July super Sale!!</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10018221\";O:8:\"stdClass\":7:{s:2:\"id\";i:10018221;s:5:\"title\";s:43:\"WordPress Birthday Flash Sale 2025 Own Page\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1748304000;s:3:\"end\";i:1748649600;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:32:\"www.wpmet.com/banner//wpbirthday\";s:11:\"button_text\";s:29:\"Claim Your Birthday Discount!\";s:11:\"notice_body\";s:590:\"<h3><strong style=\"color: #; text-transform: uppercase; font-size: 14px;\"><span style=\"color: #e60073;\">WordPress Birthday Deals from Wpmet</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10018220\";O:8:\"stdClass\":7:{s:2:\"id\";i:10018220;s:5:\"title\";s:44:\"WordPress Birthday Flash Sale 2025 Dashboard\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1748304000;s:3:\"end\";i:1748649600;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:32:\"www.wpmet.com/banner//wpbirthday\";s:11:\"button_text\";s:29:\"Claim Your Birthday Discount!\";s:11:\"notice_body\";s:590:\"<h3><strong style=\"color: #; text-transform: uppercase; font-size: 14px;\"><span style=\"color: #e60073;\">WordPress Birthday Deals from Wpmet</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10017503\";O:8:\"stdClass\":7:{s:2:\"id\";i:10017503;s:5:\"title\";s:33:\"Wpmet Summer Notice ownpages 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1746662400;s:3:\"end\";i:1748131200;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:32:\"www.wpmet.com/banner/summer-sale\";s:11:\"button_text\";s:24:\"Claim Your Discount Now!\";s:11:\"notice_body\";s:582:\"<h3><strong style=\"color: #; text-transform: uppercase; font-size: 14px;\"><span style=\"color: #e60073;\">pre Summer sales from Wpmet</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10017501\";O:8:\"stdClass\":7:{s:2:\"id\";i:10017501;s:5:\"title\";s:34:\"Wpmet Summer Notice Dashboard 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1746662400;s:3:\"end\";i:1748131200;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:32:\"www.wpmet.com/banner/summer-sale\";s:11:\"button_text\";s:24:\"Claim Your Discount Now!\";s:11:\"notice_body\";s:582:\"<h3><strong style=\"color: #; text-transform: uppercase; font-size: 14px;\"><span style=\"color: #e60073;\">pre Summer sales from Wpmet</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}}", "auto");
INSERT INTO `wp2n_options` VALUES("332", "nps-survey-header-footer-elementor", "a:6:{s:13:\"dismiss_count\";i:0;s:19:\"dismiss_permanently\";b:0;s:12:\"dismiss_step\";s:0:\"\";s:12:\"dismiss_time\";s:0:\"\";s:16:\"dismiss_timespan\";N;s:17:\"first_render_time\";i:1762164868;}", "auto");
INSERT INTO `wp2n_options` VALUES("333", "_transient_hfe_rollback_versions_2.6.1", "a:10:{i:0;s:5:\"2.6.0\";i:1;s:5:\"2.5.2\";i:2;s:5:\"2.5.1\";i:3;s:5:\"2.5.0\";i:4;s:5:\"2.4.9\";i:5;s:5:\"2.4.8\";i:6;s:5:\"2.4.7\";i:7;s:5:\"2.4.6\";i:8;s:5:\"2.4.5\";i:9;s:5:\"2.4.4\";}", "off");
INSERT INTO `wp2n_options` VALUES("334", "googlesitekit_has_connected_admins", "0", "auto");
INSERT INTO `wp2n_options` VALUES("335", "elementskit-lite_install_date", "2025-11-03 10:14:38", "auto");
INSERT INTO `wp2n_options` VALUES("336", "_elementor_installed_time", "1762164878", "auto");
INSERT INTO `wp2n_options` VALUES("337", "elementor_connect_site_key", "8a81d23f2eadb244d49cce08541b11b4", "auto");
INSERT INTO `wp2n_options` VALUES("338", "elementor_remote_info_feed_data", "a:3:{i:0;a:5:{s:5:\"title\";s:76:\"Introducing Elementor 3.32: Transitions, Transform, Size Variables, and More\";s:7:\"excerpt\";s:250:\"Elementor 3.32 is here, accelerating Editor V4 Alpha with transform controls and layered transitions, system-wide Size Variables and streamlined class management. This release empowers you to build more consistent, dynamic, and professional websites.\";s:7:\"created\";i:1759243152;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:138:\"https://elementor.com/blog/elementor-332-v4-transform-transitions/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:70:\"Introducing Elementor 3.31: New Editor V4 Variables, Filters, and More\";s:7:\"excerpt\";s:294:\"Elementor 3.31 is here, pushing Editor V4 forward with powerful design system enhancements and modern visual styling tools. From Variables and Filters to smarter editing workflows and semantic markup, this version makes it easier than ever to design beautiful, performant, and accessible sites.\";s:7:\"created\";i:1755094220;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-331-v4-alpha-variables-filters/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:67:\"What Is an MCP? The AI Breakthrough Web Creators Shouldn’t Ignore\";s:7:\"excerpt\";s:143:\"Discover how Model Context Protocol (MCP) is shaping AI-tool interaction and redefining how pro web creators build, manage, and scale websites.\";s:7:\"created\";i:1754310811;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:130:\"https://elementor.com/blog/mcp-explained-for-web-creators/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}", "off");
INSERT INTO `wp2n_options` VALUES("339", "_transient_timeout_elementor_remote_info_api_data_3.32.5", "1762208079", "off");
INSERT INTO `wp2n_options` VALUES("340", "_transient_elementor_remote_info_api_data_3.32.5", "a:4:{s:9:\"timestamp\";s:10:\"1762163290\";s:14:\"upgrade_notice\";a:3:{s:7:\"version\";s:5:\"2.0.0\";s:7:\"message\";s:0:\"\";s:11:\"update_link\";s:0:\"\";}s:11:\"pro_widgets\";a:82:{i:0;a:4:{s:4:\"name\";s:6:\"search\";s:5:\"title\";s:6:\"Search\";s:4:\"icon\";s:17:\"eicon-site-search\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:1;a:4:{s:4:\"name\";s:5:\"posts\";s:5:\"title\";s:5:\"Posts\";s:4:\"icon\";s:15:\"eicon-post-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:2;a:4:{s:4:\"name\";s:9:\"portfolio\";s:5:\"title\";s:9:\"Portfolio\";s:4:\"icon\";s:18:\"eicon-gallery-grid\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:3;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-2\";s:5:\"title\";s:7:\"Classic\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:4;a:4:{s:4:\"name\";s:9:\"mega-menu\";s:5:\"title\";s:4:\"Menu\";s:4:\"icon\";s:15:\"eicon-mega-menu\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:5;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-3\";s:5:\"title\";s:8:\"Showcase\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:6;a:4:{s:4:\"name\";s:4:\"form\";s:5:\"title\";s:4:\"Form\";s:4:\"icon\";s:21:\"eicon-form-horizontal\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:7;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-4\";s:5:\"title\";s:5:\"Links\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:8;a:4:{s:4:\"name\";s:9:\"loop-grid\";s:5:\"title\";s:9:\"Loop Grid\";s:4:\"icon\";s:18:\"eicon-loop-builder\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:9;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-5\";s:5:\"title\";s:8:\"Services\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:10;a:4:{s:4:\"name\";s:13:\"loop-carousel\";s:5:\"title\";s:13:\"Loop Carousel\";s:4:\"icon\";s:19:\"eicon-carousel-loop\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:11;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-6\";s:5:\"title\";s:9:\"Portfolio\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:12;a:4:{s:4:\"name\";s:7:\"gallery\";s:5:\"title\";s:7:\"Gallery\";s:4:\"icon\";s:23:\"eicon-gallery-justified\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:13;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-7\";s:5:\"title\";s:13:\"Business Card\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:14;a:4:{s:4:\"name\";s:17:\"animated-headline\";s:5:\"title\";s:17:\"Animated Headline\";s:4:\"icon\";s:23:\"eicon-animated-headline\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:15;a:4:{s:4:\"name\";s:10:\"price-list\";s:5:\"title\";s:10:\"Price List\";s:4:\"icon\";s:16:\"eicon-price-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:16;a:4:{s:4:\"name\";s:11:\"price-table\";s:5:\"title\";s:11:\"Price Table\";s:4:\"icon\";s:17:\"eicon-price-table\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:17;a:4:{s:4:\"name\";s:8:\"flip-box\";s:5:\"title\";s:8:\"Flip Box\";s:4:\"icon\";s:14:\"eicon-flip-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:18;a:4:{s:4:\"name\";s:14:\"call-to-action\";s:5:\"title\";s:14:\"Call to Action\";s:4:\"icon\";s:20:\"eicon-image-rollover\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:19;a:4:{s:4:\"name\";s:14:\"media-carousel\";s:5:\"title\";s:14:\"Media Carousel\";s:4:\"icon\";s:20:\"eicon-media-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:20;a:4:{s:4:\"name\";s:15:\"nested-carousel\";s:5:\"title\";s:8:\"Carousel\";s:4:\"icon\";s:21:\"eicon-nested-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:21;a:4:{s:4:\"name\";s:10:\"off-canvas\";s:5:\"title\";s:10:\"Off-Canvas\";s:4:\"icon\";s:16:\"eicon-off-canvas\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:22;a:4:{s:4:\"name\";s:9:\"countdown\";s:5:\"title\";s:9:\"Countdown\";s:4:\"icon\";s:15:\"eicon-countdown\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:23;a:4:{s:4:\"name\";s:13:\"share-buttons\";s:5:\"title\";s:13:\"Share Buttons\";s:4:\"icon\";s:11:\"eicon-share\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:24;a:4:{s:4:\"name\";s:10:\"blockquote\";s:5:\"title\";s:10:\"Blockquote\";s:4:\"icon\";s:16:\"eicon-blockquote\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:25;a:4:{s:4:\"name\";s:6:\"lottie\";s:5:\"title\";s:6:\"Lottie\";s:4:\"icon\";s:12:\"eicon-lottie\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:26;a:4:{s:4:\"name\";s:7:\"hotspot\";s:5:\"title\";s:7:\"Hotspot\";s:4:\"icon\";s:19:\"eicon-image-hotspot\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:27;a:4:{s:4:\"name\";s:13:\"paypal-button\";s:5:\"title\";s:13:\"PayPal Button\";s:4:\"icon\";s:19:\"eicon-paypal-button\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:28;a:4:{s:4:\"name\";s:14:\"code-highlight\";s:5:\"title\";s:14:\"Code Highlight\";s:4:\"icon\";s:20:\"eicon-code-highlight\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:29;a:4:{s:4:\"name\";s:14:\"video-playlist\";s:5:\"title\";s:14:\"Video Playlist\";s:4:\"icon\";s:20:\"eicon-video-playlist\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:30;a:4:{s:4:\"name\";s:8:\"template\";s:5:\"title\";s:8:\"Template\";s:4:\"icon\";s:19:\"eicon-document-file\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:31;a:4:{s:4:\"name\";s:13:\"stripe-button\";s:5:\"title\";s:13:\"Stripe Button\";s:4:\"icon\";s:19:\"eicon-stripe-button\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:32;a:4:{s:4:\"name\";s:16:\"progress-tracker\";s:5:\"title\";s:16:\"Progress Tracker\";s:4:\"icon\";s:22:\"eicon-progress-tracker\";s:10:\"categories\";s:40:\"[\"pro-elements\",\"theme-elements-single\"]\";}i:33;a:4:{s:4:\"name\";s:8:\"nav-menu\";s:5:\"title\";s:8:\"Nav Menu\";s:4:\"icon\";s:14:\"eicon-nav-menu\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:34;a:4:{s:4:\"name\";s:17:\"table-of-contents\";s:5:\"title\";s:17:\"Table of Contents\";s:4:\"icon\";s:23:\"eicon-table-of-contents\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:35;a:4:{s:4:\"name\";s:5:\"login\";s:5:\"title\";s:5:\"Login\";s:4:\"icon\";s:15:\"eicon-lock-user\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:36;a:4:{s:4:\"name\";s:6:\"slides\";s:5:\"title\";s:6:\"Slides\";s:4:\"icon\";s:12:\"eicon-slides\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:37;a:4:{s:4:\"name\";s:20:\"testimonial-carousel\";s:5:\"title\";s:20:\"Testimonial Carousel\";s:4:\"icon\";s:26:\"eicon-testimonial-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:38;a:4:{s:4:\"name\";s:7:\"reviews\";s:5:\"title\";s:7:\"Reviews\";s:4:\"icon\";s:12:\"eicon-review\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:39;a:4:{s:4:\"name\";s:15:\"facebook-button\";s:5:\"title\";s:15:\"Facebook Button\";s:4:\"icon\";s:23:\"eicon-facebook-like-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:40;a:4:{s:4:\"name\";s:17:\"facebook-comments\";s:5:\"title\";s:17:\"Facebook Comments\";s:4:\"icon\";s:23:\"eicon-facebook-comments\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:41;a:4:{s:4:\"name\";s:14:\"facebook-embed\";s:5:\"title\";s:14:\"Facebook Embed\";s:4:\"icon\";s:14:\"eicon-fb-embed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:42;a:4:{s:4:\"name\";s:13:\"facebook-page\";s:5:\"title\";s:13:\"Facebook Page\";s:4:\"icon\";s:13:\"eicon-fb-feed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:43;a:4:{s:4:\"name\";s:15:\"theme-site-logo\";s:5:\"title\";s:9:\"Site Logo\";s:4:\"icon\";s:15:\"eicon-site-logo\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:44;a:4:{s:4:\"name\";s:16:\"theme-site-title\";s:5:\"title\";s:10:\"Site Title\";s:4:\"icon\";s:16:\"eicon-site-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:45;a:4:{s:4:\"name\";s:16:\"theme-page-title\";s:5:\"title\";s:10:\"Page Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:46;a:4:{s:4:\"name\";s:16:\"theme-post-title\";s:5:\"title\";s:10:\"Post Title\";s:4:\"icon\";s:16:\"eicon-post-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:47;a:4:{s:4:\"name\";s:18:\"theme-post-excerpt\";s:5:\"title\";s:12:\"Post Excerpt\";s:4:\"icon\";s:18:\"eicon-post-excerpt\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:48;a:4:{s:4:\"name\";s:25:\"theme-post-featured-image\";s:5:\"title\";s:14:\"Featured Image\";s:4:\"icon\";s:20:\"eicon-featured-image\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:49;a:4:{s:4:\"name\";s:19:\"theme-archive-title\";s:5:\"title\";s:13:\"Archive Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:50;a:4:{s:4:\"name\";s:13:\"archive-posts\";s:5:\"title\";s:13:\"Archive Posts\";s:4:\"icon\";s:19:\"eicon-archive-posts\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:51;a:4:{s:4:\"name\";s:10:\"author-box\";s:5:\"title\";s:10:\"Author Box\";s:4:\"icon\";s:12:\"eicon-person\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:52;a:4:{s:4:\"name\";s:13:\"post-comments\";s:5:\"title\";s:13:\"Post Comments\";s:4:\"icon\";s:14:\"eicon-comments\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:53;a:4:{s:4:\"name\";s:15:\"post-navigation\";s:5:\"title\";s:15:\"Post Navigation\";s:4:\"icon\";s:21:\"eicon-post-navigation\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:54;a:4:{s:4:\"name\";s:9:\"post-info\";s:5:\"title\";s:9:\"Post Info\";s:4:\"icon\";s:15:\"eicon-post-info\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:55;a:4:{s:4:\"name\";s:7:\"sitemap\";s:5:\"title\";s:7:\"Sitemap\";s:4:\"icon\";s:13:\"eicon-sitemap\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:56;a:4:{s:4:\"name\";s:11:\"breadcrumbs\";s:5:\"title\";s:11:\"Breadcrumbs\";s:4:\"icon\";s:11:\"eicon-yoast\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:57;a:4:{s:4:\"name\";s:21:\"woocommerce-menu-cart\";s:5:\"title\";s:9:\"Menu Cart\";s:4:\"icon\";s:10:\"eicon-cart\";s:10:\"categories\";s:41:\"[\"theme-elements\",\"woocommerce-elements\"]\";}i:58;a:4:{s:4:\"name\";s:19:\"wc-archive-products\";s:5:\"title\";s:16:\"Archive Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:59;a:4:{s:4:\"name\";s:31:\"woocommerce-archive-description\";s:5:\"title\";s:19:\"Archive Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:60;a:4:{s:4:\"name\";s:20:\"woocommerce-products\";s:5:\"title\";s:8:\"Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:61;a:4:{s:4:\"name\";s:22:\"woocommerce-breadcrumb\";s:5:\"title\";s:23:\"WooCommerce Breadcrumbs\";s:4:\"icon\";s:25:\"eicon-product-breadcrumbs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:62;a:4:{s:4:\"name\";s:14:\"wc-add-to-cart\";s:5:\"title\";s:18:\"Custom Add To Cart\";s:4:\"icon\";s:17:\"eicon-woocommerce\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:63;a:4:{s:4:\"name\";s:11:\"wc-elements\";s:5:\"title\";s:17:\"WooCommerce Pages\";s:4:\"icon\";s:19:\"eicon-product-pages\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:64;a:4:{s:4:\"name\";s:13:\"wc-categories\";s:5:\"title\";s:18:\"Product Categories\";s:4:\"icon\";s:24:\"eicon-product-categories\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:65;a:4:{s:4:\"name\";s:25:\"woocommerce-product-title\";s:5:\"title\";s:13:\"Product Title\";s:4:\"icon\";s:19:\"eicon-product-title\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:66;a:4:{s:4:\"name\";s:26:\"woocommerce-product-images\";s:5:\"title\";s:14:\"Product Images\";s:4:\"icon\";s:20:\"eicon-product-images\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:67;a:4:{s:4:\"name\";s:25:\"woocommerce-product-price\";s:5:\"title\";s:13:\"Product Price\";s:4:\"icon\";s:19:\"eicon-product-price\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:68;a:4:{s:4:\"name\";s:31:\"woocommerce-product-add-to-cart\";s:5:\"title\";s:11:\"Add To Cart\";s:4:\"icon\";s:25:\"eicon-product-add-to-cart\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:69;a:4:{s:4:\"name\";s:26:\"woocommerce-product-rating\";s:5:\"title\";s:14:\"Product Rating\";s:4:\"icon\";s:20:\"eicon-product-rating\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:70;a:4:{s:4:\"name\";s:25:\"woocommerce-product-stock\";s:5:\"title\";s:13:\"Product Stock\";s:4:\"icon\";s:19:\"eicon-product-stock\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:71;a:4:{s:4:\"name\";s:24:\"woocommerce-product-meta\";s:5:\"title\";s:12:\"Product Meta\";s:4:\"icon\";s:18:\"eicon-product-meta\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:72;a:4:{s:4:\"name\";s:37:\"woocommerce-product-short-description\";s:5:\"title\";s:17:\"Short Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:73;a:4:{s:4:\"name\";s:29:\"woocommerce-product-data-tabs\";s:5:\"title\";s:17:\"Product Data Tabs\";s:4:\"icon\";s:18:\"eicon-product-tabs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:74;a:4:{s:4:\"name\";s:42:\"woocommerce-product-additional-information\";s:5:\"title\";s:22:\"Additional Information\";s:4:\"icon\";s:19:\" eicon-product-info\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:75;a:4:{s:4:\"name\";s:27:\"woocommerce-product-related\";s:5:\"title\";s:15:\"Product Related\";s:4:\"icon\";s:21:\"eicon-product-related\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:76;a:4:{s:4:\"name\";s:26:\"woocommerce-product-upsell\";s:5:\"title\";s:7:\"Upsells\";s:4:\"icon\";s:20:\"eicon-product-upsell\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:77;a:4:{s:4:\"name\";s:25:\"woocommerce-checkout-page\";s:5:\"title\";s:8:\"Checkout\";s:4:\"icon\";s:14:\"eicon-checkout\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:78;a:4:{s:4:\"name\";s:16:\"woocommerce-cart\";s:5:\"title\";s:4:\"Cart\";s:4:\"icon\";s:14:\"eicon-woo-cart\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:79;a:4:{s:4:\"name\";s:22:\"woocommerce-my-account\";s:5:\"title\";s:10:\"My Account\";s:4:\"icon\";s:16:\"eicon-my-account\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:80;a:4:{s:4:\"name\";s:28:\"woocommerce-purchase-summary\";s:5:\"title\";s:16:\"Purchase Summary\";s:4:\"icon\";s:22:\"eicon-purchase-summary\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:81;a:4:{s:4:\"name\";s:19:\"woocommerce-notices\";s:5:\"title\";s:19:\"WooCommerce Notices\";s:4:\"icon\";s:25:\"eicon-woocommerce-notices\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}}s:17:\"canary_deployment\";a:2:{s:11:\"plugin_info\";a:11:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:5:\"3.6.0\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.0.zip\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:5:\"icons\";a:3:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.png?rev=1427768\";s:2:\"1x\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";s:3:\"svg\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=1475479\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=1475479\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"6.8.3\";s:12:\"requires_php\";s:3:\"5.6\";}s:10:\"conditions\";a:0:{}}}", "off");
INSERT INTO `wp2n_options` VALUES("341", "wordfenceActivated", "1", "auto");
INSERT INTO `wp2n_options` VALUES("342", "wf_plugin_act_error", "", "auto");
INSERT INTO `wp2n_options` VALUES("348", "elementor_fonts_manager_font_types", "a:0:{}", "auto");
INSERT INTO `wp2n_options` VALUES("349", "elementor_fonts_manager_fonts", "a:0:{}", "auto");
INSERT INTO `wp2n_options` VALUES("350", "elementor_custom_icon_sets_config", "a:0:{}", "auto");
INSERT INTO `wp2n_options` VALUES("351", "elementor_log", "a:1:{s:32:\"02e08dcc4b7d7756d623c31e522e77b9\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-11-03 10:15:35\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:75:\"trim(): Passing null to parameter #1 ($string) of type string is deprecated\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:7;s:14:\"\0*\0times_dates\";a:7:{i:0;s:19:\"2025-11-03 10:15:35\";i:1;s:19:\"2025-11-03 10:32:23\";i:2;s:19:\"2025-11-03 10:33:25\";i:3;s:19:\"2025-11-03 10:35:18\";i:4;s:19:\"2025-11-03 10:37:12\";i:5;s:19:\"2025-11-03 10:38:41\";i:6;s:19:\"2025-11-03 12:57:30\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:75:\"trim(): Passing null to parameter #1 ($string) of type string is deprecated\";s:4:\"file\";s:89:\"/home/nfubmbpl/public_html/wp-content/plugins/elementor-pro/modules/custom-css/module.php\";s:4:\"line\";i:76;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:89:\"/home/nfubmbpl/public_html/wp-content/plugins/elementor-pro/modules/custom-css/module.php\";s:7:\"\0*\0line\";i:76;}}", "off");
INSERT INTO `wp2n_options` VALUES("355", "astra-sites-batch-is-complete", "yes", "off");
INSERT INTO `wp2n_options` VALUES("356", "astra-sites-last-export-checksums", "oQdj4Gm!P*xp", "off");
INSERT INTO `wp2n_options` VALUES("357", "elementor_pro_theme_builder_conditions", "a:0:{}", "auto");
INSERT INTO `wp2n_options` VALUES("358", "eael_editor_updated_at", "1762165227", "auto");
INSERT INTO `wp2n_options` VALUES("361", "_elementor_notifications_data", "a:2:{s:7:\"timeout\";i:1762169427;s:5:\"value\";s:15038:\"[{\"id\":\"transform-3.32\",\"title\":\"Design with depth using Transform\",\"description\":\"Move, scale, rotate, and skew any element with ease. Transform controls add depth, stacked effects, and seamless States for hover, focus, and active micro-interactions.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-transform.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"size-variable-3.32\",\"title\":\"Consistency with Size Variables\",\"description\":\"Define reusable values for properties like spacing or typography, then update them once to scale changes instantly across your site.\",\"topic\":\"Elementor Pro 3.32\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-size-variables.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"size-variable-3.32\",\"title\":\"Consistency with Size Variables\",\"description\":\"Define reusable values for properties like spacing or typography, then update them once to scale changes instantly across your site.\",\"topic\":\"Elementor Pro 3.32\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-size-variables.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-size-variable\\/\"},{\"id\":\"transitions-3.32\",\"title\":\"Smooth interactions with Transitions\",\"description\":\"Bring polish to every interaction. Transitions let you animate style changes smoothly between states. In Pro, layer multiple transitions by property for refined, modern micro-animations.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-transition.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"variables-3.31\",\"title\":\"Scalable design with Variables\",\"description\":\"Define once, reuse everywhere. Color & Font Variables help you build consistent, scalable design systems that update globally and are perfect for large sites or teams.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-variables.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"filters-3.31\",\"title\":\"Visual effects with Filters and Backdrop Filters\",\"description\":\"Apply multiple Filters like blur, brightness, and contrast. Stack, reorder, and preview in real time without writing a line of code.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-filters.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"ally-assistant\",\"title\":\"New! Fix accessibility issues with Ally Assistant\",\"description\":\"Scan any page for accessibility issues and fix them in one click. From color contrast to missing alt text, Ally Assistant provides guided steps or AI-powered fixes to make your site more inclusive.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-assistant.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Scan for free\",\"ctaLink\":\"http:\\/\\/go.elementor.com\\/acc-assistant-launch-whats-new\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"classes-3.31\",\"title\":\"Smarter Class Manager tools\",\"description\":\"Quickly locate and manage Global Classes with usage counts, a new locator panel, and full class search. Perfect for scaling and refactoring complex design systems.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-classes.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"send-notification-august\",\"title\":\"All Your Assets, One Library\",\"description\":\"Save time and skip the re-uploads - now you can pull images straight from your WordPress Media Library into Send. Faster, simpler, and built for WordPress.\",\"topic\":\"Send: Email & SMS built for WooCommerce\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/aug_send.png\",\"chipTags\":[\"Cart abandonment\"],\"cta\":\"Upload Your Assets\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/ML_WN\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"send-app\\/send-app.php\"}]]},{\"id\":\"attributes-3.31\",\"title\":\"Add semantic HTML with Attributes\",\"description\":\"Add custom HTML attributes like aria-*, data-*, and role to any element. Structure your markup for better accessibility, performance, and compliance.\",\"topic\":\"Elementor Pro 3.31\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-attributes.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"attributes-3.31\",\"title\":\"Add semantic HTML with Attributes\",\"description\":\"Add custom HTML attributes like aria-*, data-*, and role to any element. Structure your markup for better accessibility, performance, and compliance.\",\"topic\":\"Elementor Pro 3.31\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-attributes.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-attributes\\/\"},{\"id\":\"classes-3.30\",\"title\":\"Better class control\",\"description\":\"Get popovers with your class name, breakpoint, state and possible conflicts. Plus, the exact class names you define are now reflected in the code, making debugging and working with external tools easier!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/classes-3.30.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.30-cloud-websites\\/\"},{\"id\":\"youtube-3.30\",\"title\":\"YouTube Element\",\"description\":\"The new YouTube Element is purpose-built to support V4 capabilities with faster rendering, better performance, and familiar controls like autoplay, loop, mute, and aspect ratio.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/youtube-3.30.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"host-google-cloud\",\"title\":\"Deliver fast, secure websites at scale - free migration included!\",\"description\":\"Host your site on Elementor\\u2019s infrastructure - built for speed, security, and scale. Powered by Google Cloud, with free migration and 24\\/7 expert support.\",\"topic\":\"Host\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/host-google-cloud.png\",\"chipTags\":[\"Cloud Hosting\"],\"link\":\"https:\\/\\/go.elementor.com\\/elementor-host-google-cloud\",\"readMoreText\":\"Read More\"},{\"id\":\"cloud-templates-3.29\",\"title\":\"Your Templates, available everywhere\",\"description\":\"Store sections, containers, and full pages in the cloud\\u2014making them accessible across all your Pro-connected sites. Style once, reuse anywhere!\",\"topic\":\"Elementor Pro 3.29\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-templates.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-cloud-templates-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"cloud-templates-3.29\",\"title\":\"Your Templates, available everywhere\",\"description\":\"Store sections, containers, and full pages in the cloud\\u2014making them accessible across all your Pro-connected sites. Style once, reuse anywhere!\",\"topic\":\"Elementor Pro 3.29\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-templates.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-cloud-templates\\/\"},{\"id\":\"migration-host\",\"title\":\"Move to Better Cloud Hosting, Painlessly\",\"description\":\"Migrate your Elementor website for free to a home that\\u2019s perfect for it, in minutes, with a combination of\\u2028advanced automation and free expert support\",\"topic\":\"Host\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/migration-host.png\",\"chipTags\":[\"Cloud Hosting\"],\"link\":\"https:\\/\\/go.elementor.com\\/hosting-free-migration\",\"readMoreText\":\"Learn More\",\"cta\":\"Migrate for free\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/hosting-free-migration\"},{\"id\":\"ai-isolate-object\",\"title\":\"Sharper product images, instantly\",\"description\":\"Remove distractions and reframe your shots with the new Isolate Object tool powered by Elementor AI \\u2014 perfect for a polished, uniform Woo storefront.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/isolate-object-ai.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"introduction_meta\",\"meta\":\"ai_get_started\"}]],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\"},{\"id\":\"ai-isolate-object\",\"title\":\"Sharper product images, instantly\",\"description\":\"Remove distractions and reframe your shots with the new Isolate Object tool powered by Elementor AI \\u2014 perfect for a polished, uniform Woo storefront.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/isolate-object-ai.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Start Free Trial\",\"link\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\",\"readMoreText\":\"Learn More\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\"},{\"id\":\"hello-biz-contact\",\"title\":\"New Contact Widget, Visual Layout Presets & more\",\"description\":\"Hello Biz just got an update! Explore the new Contact Widget, Visual Layout Presets, Form Submissions integration, and fresh new kits.\",\"topic\":\"Hello Biz\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/hello-biz-contact.png\",\"chipTags\":[\"New Features\"],\"link\":\"https:\\/\\/go.elementor.com\\/hello-biz-updates\",\"readMoreText\":\"Learn More\"},{\"id\":\"ai-site-planner-colors\",\"title\":\"Style Your Wireframe, Speed Up Your Store Build\",\"description\":\"Site Planner now lets you style your wireframe with fonts and colors - instantly visualizing your site\\u2019s look and feel. Plus, it predesigns pages for WooCommerce like Cart and Checkout, so you can dive straight into customizations\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/site-planner-colors.png\",\"chipTags\":[\"New Feature\"],\"link\":\"http:\\/\\/www.elementor.com\\/ai-site-planner\",\"readMoreText\":\"Learn More\"},{\"id\":\"ally-notification\",\"title\":\"Just released! Ally - a new plugin for web accessibility & usability\",\"description\":\"Ally simplifies the complexities of making your website more accessible. With new regulations here and coming, making your website more usable and inclusive is no longer just an option, but a must.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-notification.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get it free\",\"ctaLink\":\"https:\\/\\/wordpress.org\\/plugins\\/pojo-accessibility\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"ai-site-planner\",\"title\":\"Instant Sitemaps & Wireframes\",\"description\":\"Get your website plan in minutes with AI Site Planner. Describe your desired site and AI will generate a sitemap, brief and wireframe populated with initial content, ready for you to customize.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/aI-site-planner.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/ai-notification-site-planner\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"image-optimizer-3.19\",\"title\":\"Effortlessly optimize images for a stunning, high-speed website with the Image Optimizer plugin.\",\"description\":\"Image Optimizer perfectly balances between image quality and performance to boost your website.  Resize, compress, and convert images to WebP, for faster loading times and and better user experience.\",\"topic\":\"Image Optimizer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/image-optimizer-3.19.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get the Image Optimizer\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/io-notification-wp-dash-learn-more\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"image-optimization\\/image-optimization.php\"}]]},{\"id\":\"5-star-rating-prompt\",\"title\":\"Love the New Features? Let Us Know with 5 Stars!\",\"description\":\"Help spread the word by telling the world what you love about Elementor.\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/5-star-rating-prompt.png\",\"cta\":\"Leave a Review\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/wp-dash-notification-five-stars\\/\"},{\"id\":\"site-mailer-introducing\",\"title\":\"Introducing Site Mailer\",\"description\":\"Keep your WordPress emails out of the spam folder with improved deliverability and an easy setup\\u2014no need for an SMTP plugin or complicated configurations.\",\"topic\":\"Site Mailer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/Site-mailer.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/sm-wp-dash-whatsnew\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"site-mailer\\/site-mailer.php\"}]]}]\";}", "off");
INSERT INTO `wp2n_options` VALUES("362", "_transient_timeout_elementor_unread_notifications_1", "1762169427", "off");
INSERT INTO `wp2n_options` VALUES("363", "_transient_elementor_unread_notifications_1", "a:23:{i:0;s:14:\"transform-3.32\";i:1;s:18:\"size-variable-3.32\";i:2;s:16:\"transitions-3.32\";i:3;s:14:\"variables-3.31\";i:4;s:12:\"filters-3.31\";i:5;s:14:\"ally-assistant\";i:6;s:12:\"classes-3.31\";i:7;s:24:\"send-notification-august\";i:8;s:15:\"attributes-3.31\";i:9;s:12:\"classes-3.30\";i:10;s:19:\"cloud-websites-3.30\";i:11;s:12:\"youtube-3.30\";i:12;s:17:\"host-google-cloud\";i:13;s:20:\"cloud-templates-3.29\";i:14;s:14:\"migration-host\";i:15;s:17:\"ai-isolate-object\";i:16;s:17:\"hello-biz-contact\";i:17;s:22:\"ai-site-planner-colors\";i:18;s:17:\"ally-notification\";i:19;s:15:\"ai-site-planner\";i:20;s:20:\"image-optimizer-3.19\";i:21;s:20:\"5-star-rating-prompt\";i:22;s:23:\"site-mailer-introducing\";}", "off");
INSERT INTO `wp2n_options` VALUES("364", "_elementor_settings_update_time", "1762166085", "auto");
INSERT INTO `wp2n_options` VALUES("365", "elementor_disable_color_schemes", "", "auto");
INSERT INTO `wp2n_options` VALUES("366", "elementor_disable_typography_schemes", "", "auto");
INSERT INTO `wp2n_options` VALUES("367", "elementor_allow_tracking_last_update", "1762166086", "auto");
INSERT INTO `wp2n_options` VALUES("368", "elementor_allow_tracking", "no", "auto");
INSERT INTO `wp2n_options` VALUES("369", "elementor_google_maps_api_key", "", "auto");
INSERT INTO `wp2n_options` VALUES("370", "elementor_pro_recaptcha_site_key", "", "auto");
INSERT INTO `wp2n_options` VALUES("371", "elementor_pro_recaptcha_secret_key", "", "auto");
INSERT INTO `wp2n_options` VALUES("372", "elementor_pro_recaptcha_v3_site_key", "", "auto");
INSERT INTO `wp2n_options` VALUES("373", "elementor_pro_recaptcha_v3_secret_key", "", "auto");
INSERT INTO `wp2n_options` VALUES("374", "elementor_pro_recaptcha_v3_threshold", "0.5", "auto");
INSERT INTO `wp2n_options` VALUES("375", "elementor_pro_facebook_app_id", "", "auto");
INSERT INTO `wp2n_options` VALUES("376", "elementor_pro_mailchimp_api_key", "", "auto");
INSERT INTO `wp2n_options` VALUES("377", "elementor_validate_api_data", "", "auto");
INSERT INTO `wp2n_options` VALUES("378", "elementor_pro_drip_api_token", "", "auto");
INSERT INTO `wp2n_options` VALUES("379", "elementor_pro_activecampaign_api_key", "", "auto");
INSERT INTO `wp2n_options` VALUES("380", "elementor_pro_activecampaign_api_url", "", "auto");
INSERT INTO `wp2n_options` VALUES("381", "elementor_pro_getresponse_api_key", "", "auto");
INSERT INTO `wp2n_options` VALUES("382", "elementor_pro_convertkit_api_key", "", "auto");
INSERT INTO `wp2n_options` VALUES("383", "elementor_pro_mailerlite_api_key", "", "auto");
INSERT INTO `wp2n_options` VALUES("384", "elementor_typekit-kit-id", "", "auto");
INSERT INTO `wp2n_options` VALUES("386", "elementor_pro_stripe_test_secret_key", "", "auto");
INSERT INTO `wp2n_options` VALUES("387", "elementor_validate_stripe_api_test_secret_key_button", "", "auto");
INSERT INTO `wp2n_options` VALUES("388", "elementor_pro_stripe_live_secret_key", "", "auto");
INSERT INTO `wp2n_options` VALUES("389", "elementor_validate_stripe_api_live_secret_key_button", "", "auto");
INSERT INTO `wp2n_options` VALUES("390", "elementor_stripe_legal_disclaimer", "", "auto");
INSERT INTO `wp2n_options` VALUES("391", "elementor_editor_break_lines", "1", "auto");
INSERT INTO `wp2n_options` VALUES("392", "elementor_unfiltered_files_upload", "", "auto");
INSERT INTO `wp2n_options` VALUES("393", "elementor_google_font", "1", "auto");
INSERT INTO `wp2n_options` VALUES("394", "elementor_load_fa4_shim", "", "auto");
INSERT INTO `wp2n_options` VALUES("395", "elementor_meta_generator_tag", "", "auto");
INSERT INTO `wp2n_options` VALUES("396", "elementor_css_print_method", "external", "auto");
INSERT INTO `wp2n_options` VALUES("397", "elementor_optimized_image_loading", "1", "auto");
INSERT INTO `wp2n_options` VALUES("398", "elementor_optimized_gutenberg_loading", "1", "auto");
INSERT INTO `wp2n_options` VALUES("399", "elementor_lazy_load_background_images", "1", "auto");
INSERT INTO `wp2n_options` VALUES("400", "elementor_local_google_fonts", "0", "auto");
INSERT INTO `wp2n_options` VALUES("401", "elementor_element_cache_ttl", "24", "auto");
INSERT INTO `wp2n_options` VALUES("402", "elementor_experiment-import-export-customization", "default", "auto");
INSERT INTO `wp2n_options` VALUES("403", "elementor_experiment-container", "active", "auto");
INSERT INTO `wp2n_options` VALUES("404", "elementor_experiment-nested-elements", "active", "auto");
INSERT INTO `wp2n_options` VALUES("405", "elementor_experiment-mega-menu", "active", "auto");
INSERT INTO `wp2n_options` VALUES("406", "elementor_experiment-loop", "default", "auto");
INSERT INTO `wp2n_options` VALUES("407", "elementor_experiment-taxonomy-filter", "default", "auto");
INSERT INTO `wp2n_options` VALUES("408", "elementor_experiment-e_font_icon_svg", "default", "auto");
INSERT INTO `wp2n_options` VALUES("409", "elementor_experiment-additional_custom_breakpoints", "active", "auto");
INSERT INTO `wp2n_options` VALUES("410", "elementor_experiment-e_optimized_markup", "default", "auto");
INSERT INTO `wp2n_options` VALUES("411", "elementor_experiment-theme_builder_v2", "default", "auto");
INSERT INTO `wp2n_options` VALUES("412", "elementor_experiment-page-transitions", "active", "auto");
INSERT INTO `wp2n_options` VALUES("413", "elementor_experiment-notes", "default", "auto");
INSERT INTO `wp2n_options` VALUES("414", "elementor_experiment-form-submissions", "active", "auto");
INSERT INTO `wp2n_options` VALUES("415", "elementor_experiment-e_scroll_snap", "default", "auto");
INSERT INTO `wp2n_options` VALUES("419", "elementor_font_awesome_pro_kit_id", "", "auto");
INSERT INTO `wp2n_options` VALUES("422", "_site_transient_ai1wm_last_check_for_updates", "1762166212", "off");
INSERT INTO `wp2n_options` VALUES("423", "ai1wm_updater", "a:0:{}", "auto");
INSERT INTO `wp2n_options` VALUES("424", "_elementor_pro_api_requests_lock", "a:1:{s:11:\"get_version\";i:1762173855;}", "auto");
INSERT INTO `wp2n_options` VALUES("427", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1762173858;s:7:\"checked\";a:4:{s:5:\"astra\";s:7:\"4.11.13\";s:16:\"twentytwentyfive\";s:3:\"1.3\";s:16:\"twentytwentyfour\";s:3:\"1.3\";s:17:\"twentytwentythree\";s:3:\"1.6\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:4:{s:5:\"astra\";a:6:{s:5:\"theme\";s:5:\"astra\";s:11:\"new_version\";s:7:\"4.11.13\";s:3:\"url\";s:35:\"https://wordpress.org/themes/astra/\";s:7:\"package\";s:55:\"https://downloads.wordpress.org/theme/astra.4.11.13.zip\";s:8:\"requires\";s:3:\"5.3\";s:12:\"requires_php\";s:3:\"5.3\";}s:16:\"twentytwentyfive\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfive\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfive/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfive.1.3.zip\";s:8:\"requires\";s:3:\"6.7\";s:12:\"requires_php\";s:3:\"7.2\";}s:16:\"twentytwentyfour\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfour\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfour/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfour.1.3.zip\";s:8:\"requires\";s:3:\"6.4\";s:12:\"requires_php\";s:3:\"7.0\";}s:17:\"twentytwentythree\";a:6:{s:5:\"theme\";s:17:\"twentytwentythree\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:47:\"https://wordpress.org/themes/twentytwentythree/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/twentytwentythree.1.6.zip\";s:8:\"requires\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}}s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp2n_options` VALUES("431", "current_theme", "Astra", "auto");
INSERT INTO `wp2n_options` VALUES("432", "theme_mods_astra", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;}", "on");
INSERT INTO `wp2n_options` VALUES("433", "theme_switched", "", "auto");
INSERT INTO `wp2n_options` VALUES("434", "hfe_is_theme_supported", "1", "auto");
INSERT INTO `wp2n_options` VALUES("437", "astra-settings", "a:2:{s:18:\"theme-auto-version\";s:7:\"4.11.13\";s:22:\"is_theme_queue_running\";b:0;}", "auto");
INSERT INTO `wp2n_options` VALUES("438", "astra_analytics_installed_time", "1762166267", "off");
INSERT INTO `wp2n_options` VALUES("439", "_transient_timeout_wfRegistrationToken", "1762260441", "off");
INSERT INTO `wp2n_options` VALUES("440", "_transient_wfRegistrationToken", "CVB1z-imvSnBp2_VHVlnM8wSK5lb6ie1SI8wPvjtZE0", "off");
INSERT INTO `wp2n_options` VALUES("444", "_site_transient_timeout_available_translations", "1762177132", "off");
INSERT INTO `wp2n_options` VALUES("445", "_site_transient_available_translations", "a:131:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:6:\"6.0.11\";s:7:\"updated\";s:19:\"2022-09-29 20:43:49\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.0.11/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:3:\"arg\";a:8:{s:8:\"language\";s:3:\"arg\";s:7:\"version\";s:8:\"6.2-beta\";s:7:\"updated\";s:19:\"2022-09-22 16:46:56\";s:12:\"english_name\";s:9:\"Aragonese\";s:11:\"native_name\";s:9:\"Aragonés\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.2-beta/arg.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"an\";i:2;s:3:\"arg\";i:3;s:3:\"arg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continar\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2024-02-13 12:49:38\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.7/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"متابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.27\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.27/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-07-10 08:09:09\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2024-01-19 08:58:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.7/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.28\";s:7:\"updated\";s:19:\"2024-12-26 00:37:42\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.28/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-06-26 09:35:39\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-01 16:41:58\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:28:\"চালিয়ে যান\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-02-22 20:45:53\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-29 09:22:47\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-09-09 08:25:54\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-05 08:42:11\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-23 11:26:14\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-07-28 10:25:03\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-23 12:02:03\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-02 01:30:58\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-02 01:30:03\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.8.3/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-07-28 10:25:24\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/6.8.3/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2022-07-16 12:13:09\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.8/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-22 13:46:55\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-07-29 13:22:09\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-08-19 23:02:24\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-05-22 11:56:25\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-08 12:55:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-21 17:41:39\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-08-19 08:40:47\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2024-10-16 21:04:12\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-09 03:23:24\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-02 11:18:01\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2023-10-16 16:00:04\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.7/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-04-21 13:32:10\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:6:\"5.8.12\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.8.12/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.18\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.18/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.23\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.23/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-09-30 21:17:40\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-01 22:54:47\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-02 21:15:15\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-08 01:26:01\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-06 09:50:37\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.5/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-07-05 12:26:55\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-02-14 17:29:08\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-02 18:18:37\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-01 04:49:09\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-09-25 05:20:17\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"6.5.7\";s:7:\"updated\";s:19:\"2024-02-01 23:56:53\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.7/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-01 15:38:59\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.27\";s:7:\"updated\";s:19:\"2023-04-30 13:56:46\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.27/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"fy\";a:8:{s:8:\"language\";s:2:\"fy\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2025-10-21 16:35:04\";s:12:\"english_name\";s:7:\"Frisian\";s:11:\"native_name\";s:5:\"Frysk\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.8/fy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fy\";i:2;s:3:\"fry\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Trochgean\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-29 21:50:08\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-08-29 04:27:18\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ચાલુ રાખો\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.34\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.34/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2024-05-04 18:39:24\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2025-02-06 05:17:11\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.7/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"जारी रखें\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-18 08:52:05\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-02-22 17:37:32\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.8/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-18 06:36:37\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-23 03:46:40\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.28\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.28/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-14 17:47:58\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-03 12:44:05\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"次へ\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.28\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.28/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-04-14 08:02:58\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-07-05 11:40:39\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.8/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2024-07-18 02:49:24\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.23\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.23/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-29 19:46:21\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರಿಸು\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-01 23:59:20\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-02 21:16:37\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.8.3/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:3:\"kir\";a:8:{s:8:\"language\";s:3:\"kir\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-15 12:39:47\";s:12:\"english_name\";s:6:\"Kyrgyz\";s:11:\"native_name\";s:16:\"Кыргызча\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.8.3/kir.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ky\";i:2;s:3:\"kir\";i:3;s:3:\"kir\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Улантуу\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-09-27 20:51:17\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-07-15 19:11:43\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:6:\"6.0.11\";s:7:\"updated\";s:19:\"2022-10-01 09:23:52\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.0.11/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-02 08:29:40\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"6.5.7\";s:7:\"updated\";s:19:\"2024-06-20 17:22:06\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.7/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-08-26 17:30:52\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:6:\"5.5.17\";s:7:\"updated\";s:19:\"2022-03-11 13:52:22\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.17/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.2.39\";s:7:\"updated\";s:19:\"2017-12-26 11:57:10\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.39/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-09 19:23:11\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-14 15:29:10\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-01 07:26:29\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-15 13:45:15\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-30 13:15:15\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.8.3/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-18 10:59:16\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.8.27\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.27/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:15:\"Panjabi (India)\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-03 22:11:25\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.3.35\";s:7:\"updated\";s:19:\"2015-12-02 21:41:29\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.35/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-10 08:00:47\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-10 08:01:51\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.8.3/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-27 23:52:28\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2023-08-21 12:15:00\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.7/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-27 09:09:11\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-09-30 19:16:19\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:3:\"snd\";a:8:{s:8:\"language\";s:3:\"snd\";s:7:\"version\";s:6:\"5.4.18\";s:7:\"updated\";s:19:\"2020-07-07 01:53:37\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.4.18/snd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:3:\"snd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-13 06:23:32\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-04-24 16:58:02\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.8.3/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-29 11:19:02\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-04-18 09:38:51\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-23 11:49:16\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-15 10:44:57\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-06-28 12:50:48\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:5:\"ta_LK\";a:8:{s:8:\"language\";s:5:\"ta_LK\";s:7:\"version\";s:6:\"4.2.39\";s:7:\"updated\";s:19:\"2015-12-03 01:07:44\";s:12:\"english_name\";s:17:\"Tamil (Sri Lanka)\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.39/ta_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"தொடர்க\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:6:\"5.8.12\";s:7:\"updated\";s:19:\"2022-06-08 04:30:30\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.8.12/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-10 17:38:55\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-23 11:58:31\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-10 20:06:35\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"6.8\";s:7:\"updated\";s:19:\"2025-04-18 21:10:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.8/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:6:\"5.4.18\";s:7:\"updated\";s:19:\"2020-04-09 11:17:33\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.4.18/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-28 12:02:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-09-01 09:12:13\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-01 08:48:55\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-27 07:52:03\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2022-07-15 15:25:03\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:12:\"香港中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}}", "off");
INSERT INTO `wp2n_options` VALUES("446", "WPLANG", "", "auto");
INSERT INTO `wp2n_options` VALUES("447", "new_admin_email", "3brandsdigital@gmail.com", "auto");
INSERT INTO `wp2n_options` VALUES("448", "st-elementor-builder-flag", "", "auto");
INSERT INTO `wp2n_options` VALUES("449", "st-beaver-builder-flag", "", "auto");
INSERT INTO `wp2n_options` VALUES("450", "bsf_analytics_optin", "no", "auto");
INSERT INTO `wp2n_options` VALUES("451", "_transient_is_multi_author", "0", "on");
INSERT INTO `wp2n_options` VALUES("456", "astra_partials_config_cache", "a:2:{s:8:\"settings\";a:1806:{s:46:\"section-header-builder-layout-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[cloned-component-track]\";a:4:{s:7:\"default\";a:12:{s:13:\"header-button\";i:2;s:13:\"footer-button\";i:2;s:11:\"header-html\";i:2;s:11:\"footer-html\";i:2;s:11:\"header-menu\";i:2;s:13:\"header-widget\";i:4;s:13:\"footer-widget\";i:4;s:19:\"header-social-icons\";i:1;s:19:\"footer-social-icons\";i:1;s:14:\"header-divider\";i:0;s:14:\"footer-divider\";i:0;s:13:\"removed-items\";a:0:{}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[builder-header]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[header-desktop-items]\";a:4:{s:7:\"default\";a:4:{s:5:\"popup\";a:1:{s:13:\"popup_content\";a:1:{i:0;s:11:\"mobile-menu\";}}s:5:\"above\";a:5:{s:10:\"above_left\";a:0:{}s:17:\"above_left_center\";a:0:{}s:12:\"above_center\";a:0:{}s:18:\"above_right_center\";a:0:{}s:11:\"above_right\";a:0:{}}s:7:\"primary\";a:5:{s:12:\"primary_left\";a:1:{i:0;s:4:\"logo\";}s:19:\"primary_left_center\";a:0:{}s:14:\"primary_center\";a:0:{}s:20:\"primary_right_center\";a:0:{}s:13:\"primary_right\";a:1:{i:0;s:6:\"menu-1\";}}s:5:\"below\";a:5:{s:10:\"below_left\";a:0:{}s:17:\"below_left_center\";a:0:{}s:12:\"below_center\";a:0:{}s:18:\"below_right_center\";a:0:{}s:11:\"below_right\";a:0:{}}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[header-preset-style]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[header-desktop-draggable-items]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[header-mobile-items]\";a:4:{s:7:\"default\";a:4:{s:5:\"popup\";a:1:{s:13:\"popup_content\";a:1:{i:0;s:11:\"mobile-menu\";}}s:5:\"above\";a:3:{s:10:\"above_left\";a:0:{}s:12:\"above_center\";a:0:{}s:11:\"above_right\";a:0:{}}s:7:\"primary\";a:3:{s:12:\"primary_left\";a:1:{i:0;s:4:\"logo\";}s:14:\"primary_center\";a:0:{}s:13:\"primary_right\";a:1:{i:0;s:14:\"mobile-trigger\";}}s:5:\"below\";a:3:{s:10:\"below_left\";a:0:{}s:12:\"below_center\";a:0:{}s:11:\"below_right\";a:0:{}}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[header-mobile-draggable-items]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[header-mobile-popup-items]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[header-transparent-link-heading]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[header-transparant-link]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[hb-header-main-layout-width]\";a:4:{s:7:\"default\";s:7:\"content\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[section-header-builder-layout-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:40:\"astra-settings[header-builder-pro-items]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[button-preset-style]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[theme-button-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[theme-button-bg-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[theme-button-border-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[theme-button-border-group-border-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:56:\"astra-settings[theme-button-border-group-border-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:28:\"astra-settings[button-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[button-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:31:\"astra-settings[button-bg-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[button-bg-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[theme-button-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";i:14;s:5:\"right\";i:28;s:6:\"bottom\";i:14;s:4:\"left\";i:28;}s:6:\"mobile\";a:4:{s:3:\"top\";i:12;s:5:\"right\";i:24;s:6:\"bottom\";i:12;s:4:\"left\";i:24;}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:53:\"astra-settings[theme-button-border-group-border-size]\";a:4:{s:7:\"default\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[button-radius-fields]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:45:\"astra-settings[secondary-button-preset-style]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:50:\"astra-settings[secondary-theme-button-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[secondary-theme-button-bg-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[secondary-theme-button-border-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:64:\"astra-settings[secondary-theme-button-border-group-border-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:66:\"astra-settings[secondary-theme-button-border-group-border-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:38:\"astra-settings[secondary-button-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[secondary-button-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[secondary-button-bg-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[secondary-button-bg-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[secondary-theme-button-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:13;s:5:\"right\";i:30;s:6:\"bottom\";i:13;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";i:12;s:5:\"right\";i:28;s:6:\"bottom\";i:12;s:4:\"left\";i:28;}s:6:\"mobile\";a:4:{s:3:\"top\";i:10;s:5:\"right\";i:24;s:6:\"bottom\";i:10;s:4:\"left\";i:24;}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:63:\"astra-settings[secondary-theme-button-border-group-border-size]\";a:4:{s:7:\"default\";a:4:{s:3:\"top\";i:2;s:5:\"right\";i:2;s:6:\"bottom\";i:2;s:4:\"left\";i:2;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[secondary-button-radius-fields]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:34:\"section-secondary-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[site-content-width]\";a:4:{s:7:\"default\";i:1200;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[narrow-container-max-width]\";a:4:{s:7:\"default\";i:750;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[different-retina-logo]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[ast-header-retina-logo]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:11:\"esc_url_raw\";}s:37:\"astra-settings[different-mobile-logo]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[mobile-header-logo]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";s:11:\"esc_url_raw\";}s:33:\"astra-settings[use-logo-svg-icon]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:29:\"astra-settings[logo-svg-icon]\";a:4:{s:7:\"default\";a:2:{s:4:\"type\";s:0:\"\";s:5:\"value\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:22:\"sanitize_logo_svg_icon\";}}s:39:\"astra-settings[logo-svg-site-title-gap]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:1:\"5\";s:6:\"tablet\";s:1:\"5\";s:6:\"mobile\";s:1:\"5\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[ast-header-responsive-logo-width]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[display-site-title-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[display-site-tagline-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:0;s:6:\"tablet\";i:0;s:6:\"mobile\";i:0;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[logo-title-inline]\";a:4:{s:7:\"default\";i:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[site-identity-title-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[header-color-site-title]\";a:4:{s:7:\"default\";s:25:\"var(--ast-global-color-2)\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[logo-svg-icon-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[logo-svg-icon-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[logo-svg-icon-hover-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[header-color-h-site-title]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[header-color-site-tagline]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[site-icon-link]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:26:\"astra-settings[blog-width]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[blog-max-width]\";a:4:{s:7:\"default\";i:1200;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[blog-post-content]\";a:4:{s:7:\"default\";s:7:\"excerpt\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:28:\"astra-settings[blog-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:27:\"astra-settings[blog-layout]\";a:4:{s:7:\"default\";s:13:\"blog-layout-4\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[blog-post-per-page]\";a:4:{s:7:\"default\";i:10;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[archive-post-content-structure-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[blog-post-structure]\";a:4:{s:7:\"default\";a:5:{i:0;s:5:\"image\";i:1;s:8:\"category\";i:2;s:5:\"title\";i:3;s:10:\"title-meta\";i:4;s:7:\"excerpt\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[blog-meta-date-type]\";a:4:{s:7:\"default\";s:9:\"published\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[blog-meta-date-format]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[blog-image-ratio-type]\";a:4:{s:7:\"default\";s:10:\"predefined\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[blog-image-ratio-pre-scale]\";a:4:{s:7:\"default\";s:4:\"16/9\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[blog-image-custom-scale-width]\";a:4:{s:7:\"default\";i:16;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:23:\"sanitize_number_n_blank\";}}s:46:\"astra-settings[blog-image-custom-scale-height]\";a:4:{s:7:\"default\";i:9;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:51:\"astra-settings[blog-custom-image-scale-description]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[blog-hover-effect]\";a:4:{s:7:\"default\";s:7:\"zoom-in\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:31:\"astra-settings[blog-image-size]\";a:4:{s:7:\"default\";s:5:\"large\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[blog-post-color-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[post-card-featured-overlay]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[post-card-border-radius]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:6;s:5:\"right\";i:6;s:6:\"bottom\";i:6;s:4:\"left\";i:6;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[blog-category-style]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[blog-tag-style]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[blog-post-meta-divider-type]\";a:4:{s:7:\"default\";s:1:\"/\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[blog-meta-category-style]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[blog-meta-tag-style]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:29:\"section-blog-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:25:\"astra-settings[blog-meta]\";a:4:{s:7:\"default\";a:2:{i:0;s:6:\"author\";i:1;s:4:\"date\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[blog-single-width]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[blog-single-max-width]\";a:4:{s:7:\"default\";i:1200;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[single-content-images-shadow]\";a:4:{s:7:\"default\";b:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:51:\"astra-settings[section-blog-single-spacing-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[single-post-outside-spacing]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:42:\"astra-settings[single-post-inside-spacing]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:36:\"section-blog-single-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[site-sidebar-layout]\";a:4:{s:7:\"default\";s:10:\"no-sidebar\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[site-sidebar-style]\";a:4:{s:7:\"default\";s:7:\"unboxed\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[site-sidebar-width]\";a:4:{s:7:\"default\";i:30;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[site-sidebar-width-description]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";s:0:\"\";}s:35:\"astra-settings[site-sticky-sidebar]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:37:\"a